/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Remove;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.ProxyInterfaceResolver;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.core.ivm.BaseEjbProxyHandler;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InterceptedMarker;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.portable.InjectionTargetImpl;

public class CdiEjbBean<T>
extends BaseEjbBean<T>
implements InterceptedMarker {
    private final Map<Integer, Object> dependentSFSBToBeRemoved = new ConcurrentHashMap<Integer, Object>();
    private final BeanContext beanContext;
    private final boolean isDependentAndStateful;
    private BeanContext.BusinessLocalBeanHome homeLocalBean;
    private BeanContext.BusinessLocalHome home;

    public CdiEjbBean(BeanContext beanContext, WebBeansContext webBeansContext, AnnotatedType<T> at) {
        this(beanContext, webBeansContext, beanContext.getManagedClass(), at, new EjbInjectionTargetFactory<T>(at, webBeansContext));
        ((EjbInjectionTargetImpl)((Object)EjbInjectionTargetImpl.class.cast(this.getInjectionTarget()))).setCdiEjbBean(this);
    }

    public CdiEjbBean(BeanContext beanContext, WebBeansContext webBeansContext, Class beanClass, AnnotatedType<T> at, InjectionTargetFactoryImpl<T> factory) {
        super(webBeansContext, CdiEjbBean.toSessionType(beanContext.getComponentType()), at, new EJBBeanAttributesImpl(beanContext, BeanAttributesBuilder.forContext((WebBeansContext)webBeansContext).newBeanAttibutes(at).build()), beanClass, factory);
        this.beanContext = beanContext;
        beanContext.set(Bean.class, this);
        this.passivatingId = beanContext.getDeploymentID() + this.getReturnType().getName();
        this.isDependentAndStateful = this.getScope().equals(Dependent.class) && BeanType.STATEFUL.equals((Object)beanContext.getComponentType());
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    private static SessionBeanType toSessionType(BeanType beanType) {
        switch (beanType) {
            case SINGLETON: {
                return SessionBeanType.SINGLETON;
            }
            case MESSAGE_DRIVEN: 
            case STATELESS: 
            case MANAGED: {
                return SessionBeanType.STATELESS;
            }
            case STATEFUL: {
                return SessionBeanType.STATEFUL;
            }
        }
        throw new IllegalStateException("Unknown Session BeanType " + (Object)((Object)beanType));
    }

    public String getEjbName() {
        return this.beanContext.getEjbName();
    }

    public boolean needsBeanLocalViewAddedToTypes() {
        return this.beanContext.isLocalbean() && this.beanContext.getBeanClass().getAnnotation(Typed.class) == null;
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        ArrayList classes = new ArrayList();
        for (Type t : this.getTypes()) {
            if (!Class.class.isInstance(t)) continue;
            classes.add((Class<?>)Class.class.cast(t));
        }
        return classes;
    }

    public void destroyComponentInstance(T instance) {
        if (this.getScope() == null || Dependent.class == this.getScope()) {
            this.destroyStatefulSessionBeanInstance(instance, null);
        } else {
            this.destroyScopedStateful(instance, null);
        }
    }

    protected void destroyStatefulSessionBeanInstance(T proxyInstance, Object unused) {
        block7: {
            if (proxyInstance instanceof BeanContext.Removable) {
                try {
                    ((BeanContext.Removable)proxyInstance).$$remove();
                }
                catch (NoSuchEJBException noSuchEJBException) {
                }
                catch (UndeclaredThrowableException nsoe) {
                    if (!(nsoe.getCause() instanceof NoSuchObjectException)) {
                        throw nsoe;
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchObjectException) break block7;
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new OpenEJBRuntimeException(e);
                }
            }
        }
    }

    public List<Method> getRemoveMethods() {
        if (this.beanContext.isLocalbean()) {
            return this.findRemove(this.beanContext.getBeanClass(), this.beanContext.getBeanClass());
        }
        return this.findRemove(this.beanContext.getBeanClass(), this.beanContext.getBusinessLocalInterface());
    }

    private List<Method> findRemove(Class<?> beanClass, Class<?> beanInterface) {
        Method[] methods;
        ArrayList<Method> toReturn = new ArrayList<Method>();
        for (Method method : methods = beanClass.getMethods()) {
            Remove annotation = method.getAnnotation(Remove.class);
            if (annotation == null) continue;
            try {
                Method interfaceMethod = beanInterface.getMethod(method.getName(), method.getParameterTypes());
                toReturn.add(interfaceMethod);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createEjb(CreationalContext<T> creationalContext) {
        CurrentCreationalContext currentCreationalContext = this.beanContext.get(CurrentCreationalContext.class);
        CreationalContext existing = currentCreationalContext.get();
        currentCreationalContext.set(creationalContext);
        try {
            Object instance = this.homeLocalBean != null ? this.homeLocalBean.create() : this.home.create();
            if (this.isDependentAndStateful) {
                ((CreationalContextImpl)CreationalContextImpl.class.cast(creationalContext)).addDependent((Contextual)this, instance);
            }
            Object object = instance;
            return (T)object;
        }
        finally {
            currentCreationalContext.set(existing);
        }
    }

    private void destroyScopedStateful(T instance, CreationalContext<T> cc) {
        try {
            instance.hashCode();
        }
        catch (NoSuchEJBException e) {
            InvocationHandler handler = null;
            if (LocalBeanProxyFactory.isProxy(instance.getClass())) {
                handler = LocalBeanProxyFactory.getInvocationHandler(instance);
            } else if (ProxyManager.isProxyClass(instance.getClass())) {
                handler = ProxyManager.getInvocationHandler(instance);
            }
            if (BaseEjbProxyHandler.class.isInstance(handler) && !((BaseEjbProxyHandler)BaseEjbProxyHandler.class.cast(handler)).isValid()) {
                return;
            }
            this.logger.log(Level.FINE, "The stateful instance " + instance + " can't be removed since it was invalidated", e);
            return;
        }
        Object ejbInstance = this.dependentSFSBToBeRemoved.remove(System.identityHashCode(instance));
        if (ejbInstance != null) {
            this.destroyStatefulSessionBeanInstance(ejbInstance, cc);
        } else {
            this.destroyStatefulSessionBeanInstance(instance, cc);
        }
    }

    public void storeStatefulInstance(Object proxy, T instance) {
        this.dependentSFSBToBeRemoved.put(System.identityHashCode(proxy), instance);
    }

    public void initInternals() {
        List<Class> classes = this.beanContext.getBusinessLocalInterfaces();
        boolean noLocalInterface = classes.isEmpty();
        if (noLocalInterface && this.beanContext.isLocalbean()) {
            this.homeLocalBean = this.beanContext.getBusinessLocalBeanHome();
            this.home = null;
        } else if (!noLocalInterface) {
            Class mainInterface = classes.get(0);
            List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.beanContext.getBeanClass(), mainInterface, classes);
            this.home = this.beanContext.getBusinessLocalHome(interfaces, mainInterface);
            this.homeLocalBean = null;
        }
    }

    public static class EjbInjectionTargetImpl<T>
    extends InjectionTargetImpl<T> {
        private CdiEjbBean<T> bean;
        private InjectionTarget<T> delegate;

        public EjbInjectionTargetImpl(AnnotatedType<T> annotatedType, Set<InjectionPoint> points, WebBeansContext webBeansContext) {
            super(annotatedType, points, webBeansContext, Collections.emptyList(), Collections.emptyList());
        }

        public EjbInjectionTargetImpl(EjbInjectionTargetImpl<T> original, InjectionTarget<T> delegate) {
            super(original.annotatedType, original.getInjectionPoints(), original.webBeansContext, Collections.emptyList(), Collections.emptyList());
            this.delegate = delegate;
        }

        public void setCdiEjbBean(CdiEjbBean<T> bean) {
            this.bean = bean;
        }

        public T produce(CreationalContext<T> creationalContext) {
            if (this.delegate == null) {
                return this.bean.createEjb(creationalContext);
            }
            return (T)this.delegate.produce(creationalContext);
        }

        public void dispose(T instance) {
            if (this.delegate == null) {
                this.bean.destroyComponentInstance(instance);
            } else {
                this.delegate.dispose(instance);
            }
        }

        public Set<InjectionPoint> getInjectionPoints() {
            if (this.delegate == null) {
                return super.getInjectionPoints();
            }
            return this.delegate.getInjectionPoints();
        }

        public void inject(T instance, CreationalContext<T> ctx) {
            if (this.delegate == null) {
                super.inject(instance, ctx);
            } else {
                this.delegate.inject(instance, ctx);
            }
        }

        public void postConstruct(T instance) {
            if (this.delegate == null) {
                super.postConstruct(instance);
            } else {
                this.delegate.postConstruct(instance);
            }
        }

        public void preDestroy(T instance) {
            if (this.delegate == null) {
                super.preDestroy(instance);
            } else {
                this.delegate.preDestroy(instance);
            }
        }

        public T createNewPojo(CreationalContext<T> creationalContext) {
            return (T)super.newInstance((CreationalContextImpl)CreationalContextImpl.class.cast(creationalContext));
        }
    }

    public static class EjbInjectionTargetFactory<T>
    extends InjectionTargetFactoryImpl<T> {
        public EjbInjectionTargetFactory(AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
            super(annotatedType, webBeansContext);
        }

        public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
            EjbInjectionTargetImpl injectionTarget = new EjbInjectionTargetImpl(this.getAnnotatedType(), this.createInjectionPoints(bean), this.getWebBeansContext());
            InjectionTarget it = this.getWebBeansContext().getWebBeansUtil().fireProcessInjectionTargetEvent(injectionTarget, this.getAnnotatedType()).getInjectionTarget();
            if (!EjbInjectionTargetImpl.class.isInstance(it)) {
                return new EjbInjectionTargetImpl(injectionTarget, it);
            }
            return it;
        }

        protected Set<InjectionPoint> createInjectionPoints(Bean<T> bean) {
            HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
            for (InjectionPoint injectionPoint : this.getWebBeansContext().getInjectionPointFactory().buildInjectionPoints(bean, this.getAnnotatedType())) {
                injectionPoints.add(injectionPoint);
            }
            return injectionPoints;
        }

        protected List<AnnotatedMethod<?>> getPostConstructMethods() {
            return Collections.emptyList();
        }

        protected List<AnnotatedMethod<?>> getPreDestroyMethods() {
            return Collections.emptyList();
        }
    }

    private static class EJBBeanAttributesImpl<T>
    extends BeanAttributesImpl<T> {
        private final BeanContext beanContext;
        private final Set<Type> ejbTypes;

        public EJBBeanAttributesImpl(BeanContext bc, BeanAttributesImpl<T> beanAttributes) {
            super(beanAttributes, false);
            this.beanContext = bc;
            this.ejbTypes = new HashSet<Type>();
            this.initTypes();
        }

        public Set<Type> getTypes() {
            return this.ejbTypes;
        }

        public void initTypes() {
            List<Class> cl;
            if (this.beanContext.isLocalbean()) {
                EJBBeanAttributesImpl.addApiTypes(this.ejbTypes, this.beanContext.getBeanClass());
            }
            if (this.beanContext.getProxyClass() != null) {
                EJBBeanAttributesImpl.addApiTypes(this.ejbTypes, this.beanContext.getProxyClass());
            }
            if ((cl = this.beanContext.getBusinessLocalInterfaces()) != null && !cl.isEmpty()) {
                for (Class c : cl) {
                    this.ejbTypes.add(c);
                }
            }
            if (!this.ejbTypes.contains(Serializable.class)) {
                this.ejbTypes.add((Type)((Object)Serializable.class));
            }
            this.ejbTypes.add((Type)((Object)Object.class));
        }

        private static void addApiTypes(Collection<Type> clazzes, Class<?> beanClass) {
            Typed typed = beanClass.getAnnotation(Typed.class);
            if (typed == null || typed.value().length == 0) {
                for (Class<?> current = beanClass; current != null && !Object.class.equals(current); current = current.getSuperclass()) {
                    clazzes.add(current);
                }
            } else {
                Collections.addAll(clazzes, typed.value());
            }
        }
    }
}

