/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.realm;

import java.lang.annotation.Annotation;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomee.catalina.realm.event.DigestAuthenticationEvent;
import org.apache.tomee.catalina.realm.event.FindSecurityConstraintsEvent;
import org.apache.tomee.catalina.realm.event.GssAuthenticationEvent;
import org.apache.tomee.catalina.realm.event.SslAuthenticationEvent;
import org.apache.tomee.catalina.realm.event.UserPasswordAuthenticationEvent;
import org.apache.webbeans.config.WebBeansContext;
import org.ietf.jgss.GSSContext;

public class CdiEventRealm
extends RealmBase {
    public Principal authenticate(String username, String credentials) {
        BeanManager beanManager = this.beanManager();
        if (beanManager == null) {
            return null;
        }
        UserPasswordAuthenticationEvent event = new UserPasswordAuthenticationEvent(username, credentials);
        beanManager.fireEvent((Object)event, new Annotation[0]);
        return event.getPrincipal();
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        BeanManager beanManager = this.beanManager();
        if (beanManager == null) {
            return null;
        }
        DigestAuthenticationEvent event = new DigestAuthenticationEvent(username, digest, nonce, nc, cnonce, qop, realm, md5a2);
        beanManager.fireEvent((Object)event, new Annotation[0]);
        return event.getPrincipal();
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        BeanManager beanManager = this.beanManager();
        if (beanManager == null) {
            return null;
        }
        GssAuthenticationEvent event = new GssAuthenticationEvent(gssContext, storeCreds);
        beanManager.fireEvent((Object)event, new Annotation[0]);
        return event.getPrincipal();
    }

    public Principal authenticate(X509Certificate[] certs) {
        BeanManager beanManager = this.beanManager();
        if (beanManager == null) {
            return null;
        }
        SslAuthenticationEvent event = new SslAuthenticationEvent(certs);
        beanManager.fireEvent((Object)event, new Annotation[0]);
        return event.getPrincipal();
    }

    public void backgroundProcess() {
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        SecurityConstraint[] sc = super.findSecurityConstraints(request, context);
        BeanManager beanManager = this.beanManager();
        if (beanManager == null) {
            return sc;
        }
        FindSecurityConstraintsEvent event = new FindSecurityConstraintsEvent((ServletRequest)request.getRequest(), context.getPath());
        beanManager.fireEvent((Object)event, new Annotation[0]);
        if (!event.getRoles().isEmpty()) {
            SecurityConstraint s = new SecurityConstraint();
            SecurityCollection collection = new SecurityCollection();
            collection.addPattern("/*");
            collection.addMethod(request.getMethod());
            s.addCollection(collection);
            if (event.getUserConstraint() != null) {
                s.setUserConstraint(event.getUserConstraint());
            }
            for (String r : event.getRoles()) {
                s.addAuthRole(r);
            }
            return new SecurityConstraint[]{s};
        }
        return sc;
    }

    protected String getName() {
        return "CdiEventRealm";
    }

    protected String getPassword(String username) {
        throw new UnsupportedOperationException();
    }

    protected Principal getPrincipal(String username) {
        throw new UnsupportedOperationException();
    }

    private BeanManager beanManager() {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        if (webBeansContext == null) {
            return null;
        }
        return webBeansContext.getBeanManagerImpl();
    }
}

