/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.validation.Schema;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentMarshaller;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXBDataBase {
    protected JAXBContext context;
    protected Schema schema;
    protected Collection<Attachment> attachments;
    protected Integer mtomThreshold;

    protected JAXBDataBase(JAXBContext ctx) {
        this.context = ctx;
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public void setJAXBContext(JAXBContext jc) {
        this.context = jc;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public JAXBContext getJAXBContext() {
        return this.context;
    }

    public Collection<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    protected AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return new JAXBAttachmentUnmarshaller(this.attachments);
    }

    protected AttachmentMarshaller getAttachmentMarshaller() {
        return new JAXBAttachmentMarshaller(this.attachments, this.mtomThreshold);
    }

    public void setProperty(String prop, Object value) {
    }

    protected Annotation[] getJAXBAnnotation(MessagePartInfo mpi) {
        CopyOnWriteArrayList<Annotation> annoList = new CopyOnWriteArrayList<Annotation>();
        if (mpi != null && mpi.getProperty("parameter.annotations") != null) {
            Annotation[] anns;
            for (Annotation ann : anns = (Annotation[])mpi.getProperty("parameter.annotations")) {
                if (!(ann instanceof XmlList) && !(ann instanceof XmlAttachmentRef) && !(ann instanceof XmlJavaTypeAdapter)) continue;
                annoList.add(ann);
            }
        }
        if (annoList.size() == 0 && mpi != null && mpi.getMessageInfo() != null && this.isOutputMessage(mpi.getMessageInfo()) && mpi.getMessageInfo().getOperation() != null && mpi.getMessageInfo().getOperation().getProperty("method.return.annotations") != null) {
            Annotation[] anns;
            OperationInfo op = mpi.getMessageInfo().getOperation();
            for (Annotation ann : anns = (Annotation[])op.getProperty("method.return.annotations")) {
                if (!(ann instanceof XmlList) && !(ann instanceof XmlAttachmentRef) && !(ann instanceof XmlJavaTypeAdapter)) continue;
                annoList.add(ann);
            }
        }
        return annoList.toArray(new Annotation[0]);
    }

    protected boolean isOutputMessage(AbstractMessageContainer messageContainer) {
        if (messageContainer instanceof MessageInfo) {
            return MessageInfo.Type.OUTPUT.equals((Object)((MessageInfo)messageContainer).getType());
        }
        return false;
    }

    public Integer getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setMtomThreshold(Integer threshold) {
        this.mtomThreshold = threshold;
    }

    protected final boolean honorJAXBAnnotations(MessagePartInfo part) {
        if (part == null) {
            return false;
        }
        if (!part.isElement()) {
            return true;
        }
        Boolean b = (Boolean)part.getProperty("honor.jaxb.annotations");
        return b == null ? false : b;
    }
}

