/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConnectionManager
implements ConnectionManager,
ConnectionEventListener {
    private static final long serialVersionUID = -7662970495944876239L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleConnectionManager.class);

    public Object allocateConnection(ManagedConnectionFactory connectionFactory, ConnectionRequestInfo info) throws ResourceException {
        Subject subject = null;
        ManagedConnection connection = connectionFactory.createManagedConnection(subject, info);
        connection.addConnectionEventListener((ConnectionEventListener)this);
        return connection.getConnection(subject, info);
    }

    public void connectionClosed(ConnectionEvent event) {
        try {
            ((ManagedConnection)event.getSource()).cleanup();
        }
        catch (ResourceException e) {
            LOG.warn("Error occured during the cleanup of a managed connection: ", (Throwable)e);
        }
        try {
            ((ManagedConnection)event.getSource()).destroy();
        }
        catch (ResourceException e) {
            LOG.warn("Error occured during the destruction of a managed connection: ", (Throwable)e);
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        LOG.warn("Managed connection experiened an error: ", (Throwable)event.getException());
        try {
            ((ManagedConnection)event.getSource()).cleanup();
        }
        catch (ResourceException e) {
            LOG.warn("Error occured during the cleanup of a managed connection: ", (Throwable)e);
        }
        try {
            ((ManagedConnection)event.getSource()).destroy();
        }
        catch (ResourceException e) {
            LOG.warn("Error occured during the destruction of a managed connection: ", (Throwable)e);
        }
    }
}

