/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SP13Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public UsernameTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        Element polEl;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        UsernameToken usernameToken = new UsernameToken(consts);
        usernameToken.setOptional(PolicyConstants.isOptional((Element)element));
        usernameToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (attribute != null) {
            usernameToken.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((polEl = PolicyConstants.findPolicyElement((Element)element)) == null && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:UsernameToken/wsp:Policy must have a value");
        }
        if (polEl != null) {
            usernameToken.setPolicy(polEl);
            NodeList children = polEl.getChildNodes();
            if (children != null) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof Element)) continue;
                    QName qname = new QName(child.getNamespaceURI(), child.getLocalName());
                    if ("WssUsernameToken10".equals(qname.getLocalPart())) {
                        usernameToken.setUseUTProfile10(true);
                        continue;
                    }
                    if ("WssUsernameToken11".equals(qname.getLocalPart())) {
                        usernameToken.setUseUTProfile11(true);
                        continue;
                    }
                    if (SP12Constants.NO_PASSWORD.equals(qname)) {
                        usernameToken.setNoPassword(true);
                        continue;
                    }
                    if (SP12Constants.HASH_PASSWORD.equals(qname)) {
                        usernameToken.setHashPassword(true);
                        continue;
                    }
                    if (SP12Constants.REQUIRE_DERIVED_KEYS.equals(qname)) {
                        usernameToken.setDerivedKeys(true);
                        continue;
                    }
                    if (SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS.equals(qname)) {
                        usernameToken.setExplicitDerivedKeys(true);
                        continue;
                    }
                    if (SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS.equals(qname)) {
                        usernameToken.setImpliedDerivedKeys(true);
                        continue;
                    }
                    if (SP13Constants.USERNAME_TOKEN_CREATED.equals(qname)) {
                        usernameToken.setRequireCreated(true);
                        continue;
                    }
                    if (!SP13Constants.USERNAME_TOKEN_NONCE.equals(qname)) continue;
                    usernameToken.setRequireNonce(true);
                }
            }
        }
        return usernameToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.USERNAME_TOKEN, SP12Constants.USERNAME_TOKEN};
    }
}

