/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.io.InputStream;
import java.util.Properties;
import org.apache.openejb.loader.IO;

public enum TomcatVersion {
    v3,
    v40,
    v41,
    v50,
    v55,
    v6,
    v7,
    UNKNOWN;

    private String serverNumber;
    private String serverBuilt;
    private static TomcatVersion version;

    public String getServerNumber() {
        return this.serverNumber;
    }

    public String getServerBuilt() {
        return this.serverBuilt;
    }

    public boolean isTheVersion() {
        return TomcatVersion.get() == this;
    }

    public static boolean hasAnnotationProcessingSupport() {
        switch (TomcatVersion.get()) {
            case v40: 
            case v41: 
            case v50: 
            case v55: {
                return false;
            }
        }
        return true;
    }

    public static TomcatVersion get() {
        if (version != null) {
            return version;
        }
        try {
            String serverNumber = System.getProperty("tomcat.version");
            String serverBuilt = System.getProperty("tomcat.built");
            if (serverNumber == null) {
                String serverInfo;
                ClassLoader classLoader = TomcatVersion.class.getClassLoader();
                Properties properties = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
                serverNumber = properties.getProperty("server.number");
                if (serverNumber == null && (serverInfo = properties.getProperty("server.info")) != null) {
                    int slash = serverInfo.indexOf(47);
                    serverNumber = serverInfo.substring(slash + 1);
                }
                serverBuilt = properties.getProperty("server.built");
            }
            version = serverNumber.startsWith("3") ? v3 : (serverNumber.startsWith("4.0") ? v40 : (serverNumber.startsWith("4.1") ? v41 : (serverNumber.startsWith("5.0") ? v50 : (serverNumber.startsWith("5.5") ? v55 : (serverNumber.startsWith("6.") ? v6 : (serverNumber.startsWith("7.") ? v7 : UNKNOWN))))));
            TomcatVersion.version.serverNumber = serverNumber;
            TomcatVersion.version.serverBuilt = serverBuilt;
            return version;
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }
}

