/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;

public class LegacyAnnotationProcessor {
    protected Context context;

    public LegacyAnnotationProcessor(Context context) {
        this.context = context;
    }

    public void postConstruct(Object instance) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            AccessibleObject postConstruct = null;
            for (Method method : methods) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PostConstruct annotation");
                }
                postConstruct = method;
            }
            if (postConstruct == null) continue;
            boolean accessibility = postConstruct.isAccessible();
            ((Method)postConstruct).setAccessible(true);
            ((Method)postConstruct).invoke(instance, new Object[0]);
            ((Method)postConstruct).setAccessible(accessibility);
        }
    }

    public void preDestroy(Object instance) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            AccessibleObject preDestroy = null;
            for (Method method : methods) {
                if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                if (preDestroy != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PreDestroy annotation");
                }
                preDestroy = method;
            }
            if (preDestroy == null) continue;
            boolean accessibility = preDestroy.isAccessible();
            ((Method)preDestroy).setAccessible(true);
            ((Method)preDestroy).invoke(instance, new Object[0]);
            ((Method)preDestroy).setAccessible(accessibility);
        }
    }

    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Resource annotation;
                if (field.isAnnotationPresent(Resource.class)) {
                    annotation = field.getAnnotation(Resource.class);
                    LegacyAnnotationProcessor.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                }
                if (field.isAnnotationPresent(EJB.class)) {
                    annotation = field.getAnnotation(EJB.class);
                    LegacyAnnotationProcessor.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                }
                if (field.isAnnotationPresent(WebServiceRef.class)) {
                    annotation = field.getAnnotation(WebServiceRef.class);
                    LegacyAnnotationProcessor.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                }
                if (field.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = field.getAnnotation(PersistenceContext.class);
                    LegacyAnnotationProcessor.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
                }
                if (!field.isAnnotationPresent(PersistenceUnit.class)) continue;
                annotation = field.getAnnotation(PersistenceUnit.class);
                LegacyAnnotationProcessor.lookupFieldResource(this.context, instance, field, annotation.name(), clazz);
            }
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Resource annotation;
                if (method.isAnnotationPresent(Resource.class)) {
                    annotation = method.getAnnotation(Resource.class);
                    LegacyAnnotationProcessor.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                }
                if (method.isAnnotationPresent(EJB.class)) {
                    annotation = method.getAnnotation(EJB.class);
                    LegacyAnnotationProcessor.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                }
                if (method.isAnnotationPresent(WebServiceRef.class)) {
                    annotation = method.getAnnotation(WebServiceRef.class);
                    LegacyAnnotationProcessor.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                }
                if (method.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = method.getAnnotation(PersistenceContext.class);
                    LegacyAnnotationProcessor.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
                }
                if (!method.isAnnotationPresent(PersistenceUnit.class)) continue;
                annotation = method.getAnnotation(PersistenceUnit.class);
                LegacyAnnotationProcessor.lookupMethodResource(this.context, instance, method, annotation.name(), clazz);
            }
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name, Class<?> clazz) throws NamingException, IllegalAccessException {
        Object lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(clazz.getName() + "/" + field.getName());
        boolean accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(clazz.getName() + "/" + method.getName().substring(3));
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }
}

