/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshaller;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class XMLBinder {
    SAXUnmarshaller saxUnmarshaller;
    XMLContext context;
    XMLMarshaller marshaller;
    XMLUnmarshaller unmarshaller;
    DocumentPreservationPolicy documentPreservationPolicy;
    DOMReader reader;

    public XMLBinder(XMLContext context) {
        this.context = new XMLContext(context.getXMLContextState());
        this.marshaller = this.context.createMarshaller();
        this.unmarshaller = this.context.createUnmarshaller();
        this.saxUnmarshaller = new SAXUnmarshaller(this.unmarshaller, null);
        this.documentPreservationPolicy = new XMLBinderPolicy();
        this.reader = new DOMReader(this.unmarshaller);
    }

    public Object unmarshal(Node node) {
        this.validateNode(node);
        this.reader.setDocPresPolicy(this.documentPreservationPolicy);
        Object toReturn = this.saxUnmarshaller.unmarshal(this.reader, node);
        return toReturn;
    }

    private void validateNode(Node node) {
        if (this.getSchema() != null) {
            Validator validator = this.getSchema().newValidator();
            validator.setErrorHandler(this.getErrorHandler());
            try {
                validator.validate(new DOMSource(node));
            }
            catch (Exception e) {
                throw XMLMarshalException.validateException(e);
            }
        }
    }

    public XMLRoot unmarshal(Node node, Class javaClass) {
        this.validateNode(node);
        this.reader.setDocPresPolicy(this.documentPreservationPolicy);
        return this.buildXMLRootFromObject(this.saxUnmarshaller.unmarshal(this.reader, node, javaClass));
    }

    public void updateXML(Object obj) {
        Node associatedNode;
        if (obj instanceof XMLRoot) {
            obj = ((XMLRoot)obj).getObject();
        }
        if ((associatedNode = this.documentPreservationPolicy.getNodeForObject(obj)) == null) {
            return;
        }
        this.updateXML(obj, associatedNode);
    }

    public void marshal(Object obj, Node node) {
        XMLDescriptor desc = null;
        boolean isXMLRoot = obj instanceof XMLRoot;
        if (isXMLRoot) {
            Object o = ((XMLRoot)obj).getObject();
            desc = (XMLDescriptor)this.context.getSession(o).getDescriptor(o);
        } else {
            desc = (XMLDescriptor)this.context.getSession(obj).getDescriptor(obj);
        }
        DOMRecord domRecord = null;
        if (!isXMLRoot) {
            domRecord = new DOMRecord(desc.getDefaultRootElement(), desc.getNamespaceResolver());
            domRecord.setDocPresPolicy(this.getDocumentPreservationPolicy());
        }
        Document n = this.marshaller.objectToXML(obj, node, desc, domRecord, isXMLRoot, this.getDocumentPreservationPolicy());
        this.validateNode(n);
        DOMResult result = new DOMResult(node);
        XMLTransformer transformer = this.marshaller.getTransformer();
        if (isXMLRoot) {
            String oldEncoding = transformer.getEncoding();
            String oldVersion = transformer.getVersion();
            if (((XMLRoot)obj).getEncoding() != null) {
                transformer.setEncoding(((XMLRoot)obj).getEncoding());
            }
            if (((XMLRoot)obj).getXMLVersion() != null) {
                transformer.setVersion(((XMLRoot)obj).getXMLVersion());
            }
            transformer.transform((Node)n, (Result)result);
            if (oldEncoding != null) {
                transformer.setEncoding(oldEncoding);
            }
            if (oldVersion != null) {
                transformer.setVersion(oldVersion);
            }
        } else {
            transformer.transform((Node)n, (Result)result);
        }
    }

    public void updateXML(Object obj, Node associatedNode) {
        if (obj instanceof XMLRoot) {
            obj = ((XMLRoot)obj).getObject();
        }
        Node objNode = this.getXMLNode(obj);
        AbstractSession session = this.context.getSession(obj);
        if (objNode == associatedNode) {
            DOMRecord root = new DOMRecord((Element)associatedNode);
            root.setMarshaller(this.marshaller);
            root.setDocPresPolicy(this.documentPreservationPolicy);
            XMLDescriptor rootDescriptor = (XMLDescriptor)session.getDescriptor(obj);
            ((XMLObjectBuilder)rootDescriptor.getObjectBuilder()).buildIntoNestedRow(root, obj, session);
        }
    }

    public Node getXMLNode(Object object) {
        return this.documentPreservationPolicy.getNodeForObject(object);
    }

    public Object getObject(Node node) {
        return this.documentPreservationPolicy.getObjectForNode(node);
    }

    public void updateObject(Node node) {
        Object cachedObject;
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        if ((cachedObject = this.documentPreservationPolicy.getObjectForNode(node)) == null) {
            throw XMLMarshalException.objectNotFoundInCache(node.getNodeName());
        }
        this.unmarshal(node);
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy() {
        return this.documentPreservationPolicy;
    }

    public XMLMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(XMLMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setSchema(Schema aSchema) {
        this.unmarshaller.setSchema(aSchema);
        this.saxUnmarshaller.setSchema(aSchema);
    }

    public Schema getSchema() {
        return this.unmarshaller.getSchema();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.unmarshaller.setErrorHandler(errorHandler);
        this.saxUnmarshaller.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.unmarshaller.getErrorHandler();
    }

    private XMLRoot buildXMLRootFromObject(Object obj) {
        if (obj instanceof XMLRoot) {
            return (XMLRoot)obj;
        }
        XMLRoot xmlRoot = new XMLRoot();
        xmlRoot.setObject(obj);
        AbstractSession sess = this.unmarshaller.getXMLContext().getSession(obj);
        XMLDescriptor desc = (XMLDescriptor)sess.getClassDescriptor(obj);
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return xmlRoot;
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = desc.getNamespaceResolver().resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        xmlRoot.setLocalName(rootName);
        xmlRoot.setNamespaceURI(rootNamespaceUri);
        return xmlRoot;
    }
}

