/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.server.cxf.CxfEndpoint;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;

public abstract class CxfWsContainer
implements HttpListener {
    protected final Bus bus;
    protected final PortData port;
    protected AbstractHTTPDestination destination;
    protected CxfEndpoint endpoint;
    protected HTTPTransportFactory httpTransportFactory;
    protected final ServiceConfiguration serviceConfiguration;
    private ObjectName jmxName;

    public CxfWsContainer(Bus bus, HTTPTransportFactory httpTransportFactory, PortData port, ServiceConfiguration config) {
        this.bus = bus;
        this.port = port;
        this.serviceConfiguration = config;
        this.httpTransportFactory = httpTransportFactory;
    }

    public void start() {
        this.endpoint = this.createEndpoint();
        this.endpoint.publish("http://" + this.getFakeUrl() + ":80");
        this.destination = (AbstractHTTPDestination)this.endpoint.getServer().getDestination();
        this.jmxName = this.registerMBean();
    }

    public CxfEndpoint getEndpoint() {
        return this.endpoint;
    }

    protected String getFakeUrl() {
        return "" + this.endpoint.hashCode();
    }

    protected abstract CxfEndpoint createEndpoint();

    protected abstract ObjectName registerMBean();

    protected abstract void setWsldUrl(String var1);

    public void destroy() {
        this.unregisterMBean();
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
    }

    private void unregisterMBean() {
        LocalMBeanServer.unregisterSilently((ObjectName)this.jmxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            this.destination.invoke(null, request.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }
}

