/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

public class AttachmentDataSource
implements DataSource {
    private final String ct;
    private CachedOutputStream cache;
    private InputStream ins;
    private DelegatingInputStream delegate;
    private String name;

    public AttachmentDataSource(String ctParam, InputStream inParam) throws IOException {
        this.ct = ctParam;
        this.ins = inParam;
    }

    public boolean isCached() {
        return this.cache != null;
    }

    /*
     * Loose catch block
     */
    public void cache(Message message) throws IOException {
        block11: {
            if (this.cache == null && this.ins != null) {
                block9: {
                    this.cache = new CachedOutputStream();
                    AttachmentUtil.setStreamedAttachmentProperties(message, this.cache);
                    IOUtils.copy(this.ins, this.cache);
                    this.cache.lockOutputStream();
                    if (this.delegate == null) break block9;
                    this.delegate.setInputStream(this.cache.getInputStream());
                }
                Object var4_2 = null;
                try {
                    this.ins.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ins = null;
                {
                    break block11;
                    catch (CacheSizeExceededException cee) {
                        this.cache.close();
                        this.cache = null;
                        throw cee;
                    }
                    catch (IOException cee) {
                        this.cache.close();
                        this.cache = null;
                        throw cee;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    try {
                        this.ins.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.ins = null;
                    throw throwable;
                }
            }
        }
    }

    public void hold(Message message) throws IOException {
        this.cache(message);
        this.cache.holdTempFile();
    }

    public void release() {
        if (this.cache != null) {
            this.cache.releaseTempFileHold();
        }
    }

    public String getContentType() {
        return this.ct;
    }

    public InputStream getInputStream() {
        try {
            if (this.cache != null) {
                return this.cache.getInputStream();
            }
            if (this.delegate == null) {
                this.delegate = new DelegatingInputStream(this.ins);
            }
            return this.delegate;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

