/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.Container;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.core.mdb.MdbContainer;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ActivationConfigPropertyOverride
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, ActivationConfigPropertyOverride.class);

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        Properties system = new Properties();
        system.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        system.putAll((Map<?, ?>)appModule.getProperties());
        system.putAll((Map<?, ?>)System.getProperties());
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            Properties module = new Properties();
            module.putAll((Map<?, ?>)openejbJar.getProperties());
            module.putAll((Map<?, ?>)system);
            Map deployments = openejbJar.getDeploymentsByEjbName();
            for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
                String ejbName = bean.getEjbName();
                EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(ejbName);
                if (!(bean instanceof MessageDrivenBean)) continue;
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)module);
                properties.putAll((Map<?, ?>)ejbDeployment.getProperties());
                MessageDrivenBean mdb = (MessageDrivenBean)bean;
                Properties overrides = new Properties();
                MdbContainer mdbContainer = this.getMdbContainer(ejbDeployment.getContainerId());
                if (mdbContainer != null) {
                    overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, "mdb.container." + mdbContainer.getContainerID() + ".activation", "EnterpriseBean"));
                    overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(mdbContainer.getProperties(), "activation", "EnterpriseBean"));
                }
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, "mdb.activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, mdb.getMessagingType() + ".activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, ejbName + ".activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, ejbDeployment.getDeploymentId() + ".activation", "EnterpriseBean"));
                if (overrides.size() == 0) continue;
                if (mdb.getActivationConfig() == null) {
                    mdb.setActivationConfig(new ActivationConfig());
                }
                List activationConfigList = mdb.getActivationConfig().getActivationConfigProperty();
                for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                    String property = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    ActivationConfigProperty activationConfigProperty = this.findActivationProperty(activationConfigList, property.toString());
                    if (activationConfigProperty != null) {
                        logger.info(String.format("Found %s bean with activation-config property %s=%s to override", ejbName, activationConfigProperty.getActivationConfigPropertyName(), activationConfigProperty.getActivationConfigPropertyValue()));
                        logger.info(String.format("Overriding %s bean activation-config property.%s=%s", ejbName, property, value));
                        activationConfigProperty.setActivationConfigPropertyValue(entry.getValue().toString());
                        continue;
                    }
                    logger.info(String.format("Adding %s bean activation-config property %s=%s", ejbName, property, value));
                    activationConfigProperty = new ActivationConfigProperty();
                    activationConfigProperty.setActivationConfigPropertyName(property.toString());
                    activationConfigProperty.setActivationConfigPropertyValue(value.toString());
                    activationConfigList.add(activationConfigProperty);
                }
            }
        }
        return appModule;
    }

    private MdbContainer getMdbContainer(String containerId) {
        ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
        if (containerId == null || containerId.length() == 0) {
            Container[] containers;
            for (Container container : containers = containerSystem.containers()) {
                if (!MdbContainer.class.isInstance(container)) continue;
                return (MdbContainer)MdbContainer.class.cast(container);
            }
            return null;
        }
        Container container = containerSystem.getContainer(containerId);
        if (MdbContainer.class.isInstance(container)) {
            return (MdbContainer)MdbContainer.class.cast(container);
        }
        return null;
    }

    private ActivationConfigProperty findActivationProperty(List<ActivationConfigProperty> activationConfigList, String nameOfProperty) {
        for (ActivationConfigProperty activationProp : activationConfigList) {
            if (!activationProp.getActivationConfigPropertyName().equals(nameOfProperty)) continue;
            return activationProp;
        }
        return null;
    }
}

