/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xreflection;

import java.lang.reflect.Method;
import java.net.InetAddress;

final class ReflectionProperty
implements Comparable<ReflectionProperty> {
    private final String clazz;
    private final String propertyName;
    private final Class<?> propertyType;
    private final Method setMethod;
    private final Method getMethod;

    ReflectionProperty(String clazz, String propertyName, Class<?> propertyType, Method setMethod, Method getMethod) {
        this.clazz = clazz;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.setMethod = setMethod;
        this.getMethod = getMethod;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean hasSetPropertySetter() {
        return this.hasSetter() && "setProperty".equals(this.setMethod.getName());
    }

    public boolean hasGetPropertyGetter() {
        return this.hasGetter() && "getProperty".equals(this.getMethod.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectionProperty property1 = (ReflectionProperty)o;
        if (!this.clazz.equals(property1.clazz)) {
            return false;
        }
        return this.propertyName.equals(property1.propertyName);
    }

    public int hashCode() {
        int result = this.clazz.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        return result;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public String getConversion(String valueVarName) {
        if (this.getPropertyType() == String.class) {
            return valueVarName;
        }
        if (this.getPropertyType() == Boolean.TYPE) {
            return "Boolean.valueOf(" + valueVarName + ")";
        }
        if (this.getPropertyType() == Long.TYPE) {
            return "Long.valueOf(" + valueVarName + ")";
        }
        if (this.getPropertyType() == Integer.TYPE) {
            return "Integer.valueOf(" + valueVarName + ")";
        }
        if (this.getPropertyType() == InetAddress.class) {
            return "getInetAddress(" + valueVarName + ")";
        }
        throw new IllegalStateException("Unexpected Type:" + this.getPropertyType());
    }

    public boolean hasSetter() {
        return this.setMethod != null;
    }

    public boolean hasGetter() {
        return this.getMethod != null;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public String toString() {
        return "ReflectionProperty{name='" + this.propertyName + '\'' + ", type=" + this.propertyType + '}';
    }

    @Override
    public int compareTo(ReflectionProperty o) {
        int result = this.clazz.compareTo(o.clazz);
        if (result == 0) {
            result = this.propertyName.compareTo(o.propertyName);
        }
        return result;
    }
}

