/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.LogManager;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.CertificateCreateRule;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Catalina {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean await = false;
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    protected boolean useNaming = true;
    protected boolean loaded = false;
    private static final Log log = LogFactory.getLog(Catalina.class);

    public Catalina() {
        this.setSecurityProtection();
        ExceptionUtils.preload();
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public void setAwait(boolean b) {
        this.await = b;
    }

    public boolean isAwait() {
        return this.await;
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (String arg : args) {
            if (isConfig) {
                this.configFile = arg;
                isConfig = false;
                continue;
            }
            if (arg.equals("-config")) {
                isConfig = true;
                continue;
            }
            if (arg.equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (arg.equals("-help")) {
                this.usage();
                return false;
            }
            if (arg.equals("start") || arg.equals("configtest") || arg.equals("stop")) continue;
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(Bootstrap.getCatalinaBase(), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> objectAttrs = new ArrayList<String>();
        objectAttrs.add("className");
        fakeAttributes.put(Object.class, objectAttrs);
        ArrayList<String> contextAttrs = new ArrayList<String>();
        contextAttrs.add("source");
        fakeAttributes.put(StandardContext.class, contextAttrs);
        digester.setFakeAttributes(fakeAttributes);
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", new SetAllPropertiesRule(new String[]{"executor", "sslImplementationName"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig", "addSslHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", new CertificateCreateRule());
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", new SetAllPropertiesRule(new String[]{"type"}));
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/Certificate", "addCertificate", "org.apache.tomcat.util.net.SSLHostConfigCertificate");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "setOpenSslConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "addCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector/UpgradeProtocol", null, "className");
        digester.addSetProperties("Server/Service/Connector/UpgradeProtocol");
        digester.addSetNext("Server/Service/Connector/UpgradeProtocol", "addUpgradeProtocol", "org.apache.coyote.UpgradeProtocol");
        digester.addRuleSet(new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet(new EngineRuleSet("Server/Service/"));
        digester.addRuleSet(new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/"));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Host/Cluster/");
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(this.parentClassLoader));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Cluster/");
        long t2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Digester for server.xml created " + (t2 - t1));
        }
        return digester;
    }

    private void addClusterRuleSet(Digester digester, String prefix) {
        block3: {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName("org.apache.catalina.ha.ClusterRuleSet");
                constructor = clazz.getConstructor(String.class);
                RuleSet ruleSet = (RuleSet)constructor.newInstance(prefix);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("catalina.noCluster", e.getClass().getName() + ": " + e.getMessage()), e);
                }
                if (!log.isInfoEnabled()) break block3;
                log.info(sm.getString("catalina.noCluster", e.getClass().getName() + ": " + e.getMessage()));
            }
        }
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] arguments) {
        Throwable throwable;
        Server s;
        if (arguments != null) {
            this.arguments(arguments);
        }
        if ((s = this.getServer()) == null) {
            Digester digester = this.createStopDigester();
            File file = this.configFile();
            try {
                throwable = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    InputSource is = new InputSource(file.toURI().toURL().toString());
                    is.setByteStream(fis);
                    digester.push(this);
                    digester.parse(is);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            catch (Exception e) {
                log.error("Catalina.stop: ", e);
                System.exit(1);
            }
        } else {
            try {
                s.stop();
                s.destroy();
            }
            catch (LifecycleException e) {
                log.error("Catalina.stop: ", e);
            }
            return;
        }
        s = this.getServer();
        if (s.getPort() > 0) {
            try (Socket socket = new Socket(s.getAddress(), s.getPort());){
                throwable = null;
                try (OutputStream stream = socket.getOutputStream();){
                    String shutdown = s.getShutdown();
                    for (int i = 0; i < shutdown.length(); ++i) {
                        stream.write(shutdown.charAt(i));
                    }
                    stream.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (ConnectException ce) {
                log.error(sm.getString("catalina.stopServer.connectException", s.getAddress(), String.valueOf(s.getPort())));
                log.error("Catalina.stop: ", ce);
                System.exit(1);
            }
            catch (IOException e) {
                log.error("Catalina.stop: ", e);
                System.exit(1);
            }
        } else {
            log.error(sm.getString("catalina.stopServer"));
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        long t1 = System.nanoTime();
        this.initDirs();
        this.initNaming();
        Digester digester = this.createStartDigester();
        InputSource inputSource = null;
        InputStream inputStream = null;
        File file = null;
        try {
            block39: {
                block38: {
                    block37: {
                        try {
                            file = this.configFile();
                            inputStream = new FileInputStream(file);
                            inputSource = new InputSource(file.toURI().toURL().toString());
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block37;
                            log.debug(sm.getString("catalina.configFail", file), e);
                        }
                    }
                    if (inputStream == null) {
                        try {
                            inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                            inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block38;
                            log.debug(sm.getString("catalina.configFail", this.getConfigFile()), e);
                        }
                    }
                }
                if (inputStream == null) {
                    try {
                        inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                        inputSource = new InputSource(this.getClass().getClassLoader().getResource("server-embed.xml").toString());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block39;
                        log.debug(sm.getString("catalina.configFail", "server-embed.xml"), e);
                    }
                }
            }
            if (inputStream == null || inputSource == null) {
                if (file == null) {
                    log.warn(sm.getString("catalina.configFail", this.getConfigFile() + "] or [server-embed.xml]"));
                } else {
                    log.warn(sm.getString("catalina.configFail", file.getAbsolutePath()));
                    if (file.exists() && !file.canRead()) {
                        log.warn("Permissions incorrect, read permission is not allowed on the file.");
                    }
                }
                return;
            }
            try {
                inputSource.setByteStream(inputStream);
                digester.push(this);
                digester.parse(inputSource);
            }
            catch (SAXParseException spe) {
                log.warn("Catalina.start using " + this.getConfigFile() + ": " + spe.getMessage());
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (Exception e) {
                block41: {
                    log.warn("Catalina.start using " + this.getConfigFile() + ": ", e);
                    if (inputStream == null) break block41;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.getServer().setCatalina(this);
        this.getServer().setCatalinaHome(Bootstrap.getCatalinaHomeFile());
        this.getServer().setCatalinaBase(Bootstrap.getCatalinaBaseFile());
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException e) {
            if (Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) {
                throw new Error(e);
            }
            log.error("Catalina.start", e);
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Initialization processed in " + (t2 - t1) / 1000000L + " ms");
        }
    }

    public void load(String[] args) {
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void start() {
        if (this.getServer() == null) {
            this.load();
        }
        if (this.getServer() == null) {
            log.fatal("Cannot start server. Server instance is not configured.");
            return;
        }
        long t1 = System.nanoTime();
        try {
            this.getServer().start();
        }
        catch (LifecycleException e) {
            log.fatal(sm.getString("catalina.serverStartFail"), e);
            try {
                this.getServer().destroy();
            }
            catch (LifecycleException e1) {
                log.debug("destroy() failed for failed Server ", e1);
            }
            return;
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Server startup in " + (t2 - t1) / 1000000L + " ms");
        }
        if (this.useShutdownHook) {
            if (this.shutdownHook == null) {
                this.shutdownHook = new CatalinaShutdownHook();
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof ClassLoaderLogManager) {
                ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
            }
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        try {
            Server s = this.getServer();
            LifecycleState state = s.getState();
            if (LifecycleState.STOPPING_PREP.compareTo(state) > 0 || LifecycleState.DESTROYED.compareTo(state) < 0) {
                s.stop();
                s.destroy();
            }
        }
        catch (LifecycleException e) {
            log.error("Catalina.stop", e);
        }
    }

    public void await() {
        this.getServer().await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -nonaming ]  { -help | start | stop }");
    }

    @Deprecated
    protected void initDirs() {
    }

    protected void initStreams() {
        System.setOut(new SystemLogHandler(System.out));
        System.setErr(new SystemLogHandler(System.err));
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info(sm.getString("catalina.noNaming"));
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            String value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = value + ":" + oldValue;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            if (log.isDebugEnabled()) {
                log.debug("Setting naming prefix=" + value);
            }
            if ((value = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else {
                log.debug("INITIAL_CONTEXT_FACTORY already set " + value);
            }
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Catalina.this.getServer() != null) {
                    Catalina.this.stop();
                }
            }
            catch (Throwable ex) {
                ExceptionUtils.handleThrowable(ex);
                log.error(sm.getString("catalina.shutdownHookFail"), ex);
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }
}

