/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.core.ApplicationContext;

public class ApplicationContextFacade
implements ServletContext {
    private final ApplicationContext context;

    public ApplicationContextFacade(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public ServletContext getContext(String uripath) {
        ServletContext theContext = this.context.getContext(uripath);
        if (theContext instanceof ApplicationContext) {
            theContext = ((ApplicationContext)theContext).getFacade();
        }
        return theContext;
    }

    @Override
    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    @Override
    public void log(String msg) {
        this.context.log(msg);
    }

    @Override
    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    @Override
    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    @Override
    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    @Override
    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    @Override
    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.context.getAttributeNames();
    }

    @Override
    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }

    @Override
    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    @Override
    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    @Override
    public String getContextPath() {
        return this.context.getContextPath();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.context.addFilter(filterName, className);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.context.addFilter(filterName, filter);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.context.addFilter(filterName, filterClass);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        return this.context.createFilter(c);
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        return this.context.getFilterRegistration(filterName);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.context.addServlet(servletName, className);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.context.addServlet(servletName, servlet);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.context.addServlet(servletName, servletClass);
    }

    @Override
    public ServletRegistration.Dynamic addJspFile(String jspName, String jspFile) {
        return this.context.addJspFile(jspName, jspFile);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        return this.context.createServlet(c);
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        return this.context.getServletRegistration(servletName);
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        return this.context.setInitParameter(name, value);
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        this.context.addListener(listenerClass);
    }

    @Override
    public void addListener(String className) {
        this.context.addListener(className);
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        this.context.addListener(t);
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
        return this.context.createListener(c);
    }

    @Override
    public void declareRoles(String ... roleNames) {
        this.context.declareRoles(roleNames);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    @Override
    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }

    @Override
    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.context.setSessionTimeout(sessionTimeout);
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
        this.context.setRequestCharacterEncoding(encoding);
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
        this.context.setResponseCharacterEncoding(encoding);
    }
}

