/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import jakarta.servlet.ServletRequest;
import org.apache.tomcat.util.descriptor.web.FilterMap;

public class FilterUtil {
    private FilterUtil() {
    }

    public static boolean matchFiltersURL(FilterMap filterMap, String requestPath) {
        String[] testPaths;
        if (filterMap.getMatchAllUrlPatterns()) {
            return true;
        }
        if (requestPath == null) {
            return false;
        }
        for (String testPath : testPaths = filterMap.getURLPatterns()) {
            if (!FilterUtil.matchFiltersURL(testPath, requestPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFiltersURL(String testPath, String requestPath) {
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            if (testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
                if (requestPath.length() == testPath.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(testPath.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                return testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return false;
    }

    public static String getRequestPath(ServletRequest request) {
        String result = null;
        Object attribute = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (attribute != null) {
            result = attribute.toString();
        }
        return result;
    }
}

