/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.InnerClass;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class InnerClasses
extends Attribute
implements Iterable<InnerClass> {
    private static final InnerClass[] EMPTY_INNER_CLASSE_ARRAY = new InnerClass[0];
    private InnerClass[] innerClasses;

    public InnerClasses(InnerClasses c) {
        this(c.getNameIndex(), c.getLength(), c.getInnerClasses(), c.getConstantPool());
    }

    InnerClasses(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.innerClasses = new InnerClass[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.innerClasses[i] = new InnerClass(input);
        }
    }

    public InnerClasses(int name_index, int length, InnerClass[] innerClasses, ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.innerClasses = innerClasses != null ? innerClasses : EMPTY_INNER_CLASSE_ARRAY;
    }

    @Override
    public void accept(Visitor v) {
        v.visitInnerClasses(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        InnerClasses c = (InnerClasses)this.clone();
        c.innerClasses = new InnerClass[this.innerClasses.length];
        Arrays.setAll(c.innerClasses, i -> this.innerClasses[i].copy());
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.innerClasses.length);
        for (InnerClass inner_class : this.innerClasses) {
            inner_class.dump(file);
        }
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public Iterator<InnerClass> iterator() {
        return Stream.of(this.innerClasses).iterator();
    }

    public void setInnerClasses(InnerClass[] innerClasses) {
        this.innerClasses = innerClasses != null ? innerClasses : EMPTY_INNER_CLASSE_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("InnerClasses(");
        buf.append(this.innerClasses.length);
        buf.append("):\n");
        for (InnerClass inner_class : this.innerClasses) {
            buf.append(inner_class.toString(super.getConstantPool())).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

