/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11Processor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;

public class Http11NioProtocol
extends AbstractHttp11Protocol<NioChannel> {
    private static final Log log = LogFactory.getLog(Http11NioProtocol.class);

    public Http11NioProtocol() {
        this(new NioEndpoint());
    }

    public Http11NioProtocol(NioEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    public void setSelectorTimeout(long timeout) {
        ((NioEndpoint)this.getEndpoint()).setSelectorTimeout(timeout);
    }

    public long getSelectorTimeout() {
        return ((NioEndpoint)this.getEndpoint()).getSelectorTimeout();
    }

    public void setPollerThreadPriority(int threadPriority) {
        ((NioEndpoint)this.getEndpoint()).setPollerThreadPriority(threadPriority);
    }

    public int getPollerThreadPriority() {
        return ((NioEndpoint)this.getEndpoint()).getPollerThreadPriority();
    }

    @Override
    protected Processor createProcessor() {
        return new Http11Processor(this, this.adapter);
    }

    @Override
    protected String getNamePrefix() {
        if (this.isSSLEnabled()) {
            return "https-" + this.getSslImplementationShortName() + "-nio";
        }
        return "http-nio";
    }
}

