/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.res.StringManager;

public class ResponseFacade
implements HttpServletResponse {
    protected static final StringManager sm = StringManager.getManager(ResponseFacade.class);
    protected Response response = null;

    public ResponseFacade(Response response) {
        this.response = response;
    }

    public void clear() {
        this.response = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void finish() {
        this.checkFacade();
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        this.checkFacade();
        return this.response.isSuspended();
    }

    public long getContentWritten() {
        this.checkFacade();
        return this.response.getContentWritten();
    }

    @Override
    public String getCharacterEncoding() {
        this.checkFacade();
        return this.response.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return this.response.getOutputStream();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return this.response.getWriter();
    }

    @Override
    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    @Override
    public void setContentLengthLong(long length) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLengthLong(length);
    }

    @Override
    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentType(type);
    }

    @Override
    public void setBufferSize(int size) {
        this.checkCommitted("coyoteResponse.setBufferSize.ise");
        this.response.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        this.checkFacade();
        return this.response.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.response.setAppCommitted(true);
        this.response.flushBuffer();
    }

    @Override
    public void resetBuffer() {
        this.checkCommitted("coyoteResponse.resetBuffer.ise");
        this.response.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        this.checkFacade();
        return this.response.isAppCommitted();
    }

    @Override
    public void reset() {
        this.checkCommitted("coyoteResponse.reset.ise");
        this.response.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        this.checkFacade();
        return this.response.getLocale();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        this.checkFacade();
        return this.response.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        this.checkFacade();
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        this.checkFacade();
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.checkCommitted("coyoteResponse.sendError.ise");
        this.response.setAppCommitted(true);
        this.response.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.checkCommitted("coyoteResponse.sendError.ise");
        this.response.setAppCommitted(true);
        this.response.sendError(sc);
    }

    @Override
    public void sendRedirect(String location, int sc, boolean clearBuffer) throws IOException {
        this.checkCommitted("coyoteResponse.sendRedirect.ise");
        this.response.setAppCommitted(true);
        this.response.sendRedirect(location, sc, clearBuffer);
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    @Override
    public String getContentType() {
        this.checkFacade();
        return this.response.getContentType();
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.checkFacade();
        this.response.setCharacterEncoding(encoding);
    }

    @Override
    public void setCharacterEncoding(Charset charset) {
        this.checkFacade();
        this.response.setCharacterEncoding(charset);
    }

    @Override
    public int getStatus() {
        this.checkFacade();
        return this.response.getStatus();
    }

    @Override
    public String getHeader(String name) {
        this.checkFacade();
        return this.response.getHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        this.checkFacade();
        return this.response.getHeaderNames();
    }

    @Override
    public Collection<String> getHeaders(String name) {
        this.checkFacade();
        return this.response.getHeaders(name);
    }

    @Override
    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.checkFacade();
        this.response.setTrailerFields(supplier);
    }

    @Override
    public Supplier<Map<String, String>> getTrailerFields() {
        this.checkFacade();
        return this.response.getTrailerFields();
    }

    private void checkFacade() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
    }

    private void checkCommitted(String messageKey) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString(messageKey));
        }
    }
}

