/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.openssl;

import java.lang.foreign.MemorySegment;
import org.apache.tomcat.util.openssl.openssl_h;

public class openssl_h_Macros {
    public static long SSL_CTX_set_max_proto_version(MemorySegment sslCtx, long version) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_MAX_PROTO_VERSION(), version, MemorySegment.NULL);
    }

    public static long SSL_CTX_set_min_proto_version(MemorySegment sslCtx, long version) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_MIN_PROTO_VERSION(), version, MemorySegment.NULL);
    }

    public static long SSL_CTX_sess_get_cache_size(MemorySegment sslCtx) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_GET_SESS_CACHE_SIZE(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_sess_set_cache_size(MemorySegment sslCtx, long cacheSize) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_SESS_CACHE_SIZE(), cacheSize, MemorySegment.NULL);
    }

    public static long SSL_CTX_get_session_cache_mode(MemorySegment sslCtx) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_GET_SESS_CACHE_MODE(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_set_session_cache_mode(MemorySegment sslCtx, long cacheMode) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_SESS_CACHE_MODE(), cacheMode, MemorySegment.NULL);
    }

    public static long SSL_CTX_add0_chain_cert(MemorySegment sslCtx, MemorySegment x509) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_CHAIN_CERT(), 0L, x509);
    }

    public static long SSL_CTX_set_tlsext_ticket_keys(MemorySegment sslCtx, MemorySegment keys, long keyLength) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TLSEXT_TICKET_KEYS(), keyLength, keys);
    }

    public static long BIO_read_filename(MemorySegment bio, MemorySegment name) {
        return openssl_h.BIO_ctrl(bio, openssl_h.BIO_C_SET_FILENAME(), openssl_h.BIO_CLOSE() | openssl_h.BIO_FP_READ(), name);
    }

    public static long SSL_CTX_set_tmp_dh(MemorySegment sslCtx, MemorySegment dh2) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TMP_DH(), 0L, dh2);
    }

    public static long SSL_CTX_set_tmp_ecdh(MemorySegment sslCtx, MemorySegment ecdh) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TMP_ECDH(), 0L, ecdh);
    }

    public static void OPENSSL_free(MemorySegment segment) {
        openssl_h.CRYPTO_free(segment, MemorySegment.NULL, 0);
    }

    public static long BIO_reset(MemorySegment bio) {
        return openssl_h.BIO_ctrl(bio, openssl_h.BIO_CTRL_RESET(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_set1_groups(MemorySegment sslCtx, MemorySegment groupsList, int listLength) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_GROUPS(), listLength, groupsList);
    }

    public static long X509_LOOKUP_add_dir(MemorySegment x509Lookup, MemorySegment name, long type) {
        return openssl_h.X509_LOOKUP_ctrl(x509Lookup, openssl_h.X509_L_ADD_DIR(), name, openssl_h.X509_FILETYPE_PEM(), MemorySegment.NULL);
    }

    public static long X509_LOOKUP_load_file(MemorySegment x509Lookup, MemorySegment name, long type) {
        return openssl_h.X509_LOOKUP_ctrl(x509Lookup, openssl_h.X509_L_FILE_LOAD(), name, openssl_h.X509_FILETYPE_PEM(), MemorySegment.NULL);
    }
}

