/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.openssl;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import org.apache.tomcat.util.openssl.openssl_h;

public class openssl_h_Macros {
    public static long SSL_CTX_set_max_proto_version(MemorySegment sslCtx, long version) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_MAX_PROTO_VERSION(), version, MemorySegment.NULL);
    }

    public static long SSL_CTX_set_min_proto_version(MemorySegment sslCtx, long version) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_MIN_PROTO_VERSION(), version, MemorySegment.NULL);
    }

    public static long SSL_CTX_sess_get_cache_size(MemorySegment sslCtx) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_GET_SESS_CACHE_SIZE(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_sess_set_cache_size(MemorySegment sslCtx, long cacheSize) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_SESS_CACHE_SIZE(), cacheSize, MemorySegment.NULL);
    }

    public static long SSL_CTX_get_session_cache_mode(MemorySegment sslCtx) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_GET_SESS_CACHE_MODE(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_set_session_cache_mode(MemorySegment sslCtx, long cacheMode) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_SESS_CACHE_MODE(), cacheMode, MemorySegment.NULL);
    }

    public static long SSL_CTX_add0_chain_cert(MemorySegment sslCtx, MemorySegment x509) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_CHAIN_CERT(), 0L, x509);
    }

    public static long SSL_CTX_set_tlsext_ticket_keys(MemorySegment sslCtx, MemorySegment keys, long keyLength) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TLSEXT_TICKET_KEYS(), keyLength, keys);
    }

    public static long BIO_read_filename(MemorySegment bio, MemorySegment name) {
        return openssl_h.BIO_ctrl(bio, openssl_h.BIO_C_SET_FILENAME(), openssl_h.BIO_CLOSE() | openssl_h.BIO_FP_READ(), name);
    }

    public static long SSL_CTX_set_tmp_dh(MemorySegment sslCtx, MemorySegment dh) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TMP_DH(), 0L, dh);
    }

    public static long SSL_CTX_set_tmp_ecdh(MemorySegment sslCtx, MemorySegment ecdh) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TMP_ECDH(), 0L, ecdh);
    }

    public static void OPENSSL_free(MemorySegment segment) {
        openssl_h.CRYPTO_free(segment, MemorySegment.NULL, 0);
    }

    public static long BIO_reset(MemorySegment bio) {
        return openssl_h.BIO_ctrl(bio, openssl_h.BIO_CTRL_RESET(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_set1_groups(MemorySegment sslCtx, MemorySegment groupsList, int listLength) {
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_GROUPS(), listLength, groupsList);
    }

    public static long X509_LOOKUP_add_dir(MemorySegment x509Lookup, MemorySegment name, long type) {
        return openssl_h.X509_LOOKUP_ctrl(x509Lookup, openssl_h.X509_L_ADD_DIR(), name, openssl_h.X509_FILETYPE_PEM(), MemorySegment.NULL);
    }

    public static long X509_LOOKUP_load_file(MemorySegment x509Lookup, MemorySegment name, long type) {
        return openssl_h.X509_LOOKUP_ctrl(x509Lookup, openssl_h.X509_L_FILE_LOAD(), name, openssl_h.X509_FILETYPE_PEM(), MemorySegment.NULL);
    }

    public static void X509_free(MemorySegment a) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("X509_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            mh$.invokeExact(a);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment d2i_X509(MemorySegment a, MemorySegment in, long len) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, ValueLayout.JAVA_LONG);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("d2i_X509"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(a, in, len);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int i2d_X509(MemorySegment a, MemorySegment out) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("i2d_X509"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(a, out);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment PEM_read_bio_X509_AUX(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("PEM_read_bio_X509_AUX"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(out, x, cb, u);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    @Deprecated
    public static MemorySegment PEM_read_bio_ECPKParameters(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("PEM_read_bio_ECPKParameters"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(out, x, cb, u);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    @Deprecated
    public static MemorySegment PEM_read_bio_DHparams(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("PEM_read_bio_DHparams"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(out, x, cb, u);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment PEM_read_bio_PrivateKey(MemorySegment out, MemorySegment x, MemorySegment cb, MemorySegment u) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("PEM_read_bio_PrivateKey"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(out, x, cb, u);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static void PKCS12_free(MemorySegment a) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("PKCS12_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            mh$.invokeExact(a);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static void OCSP_BASICRESP_free(MemorySegment a) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("OCSP_BASICRESP_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            mh$.invokeExact(a);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static void OCSP_RESPONSE_free(MemorySegment a) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("OCSP_RESPONSE_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            mh$.invokeExact(a);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment d2i_OCSP_RESPONSE(MemorySegment a, MemorySegment in, long len) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_POINTER, ValueLayout.JAVA_LONG);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("d2i_OCSP_RESPONSE"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(a, in, len);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static void OCSP_CERTID_free(MemorySegment a) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("OCSP_CERTID_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            mh$.invokeExact(a);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment OCSP_REQUEST_new() {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_POINTER, new MemoryLayout[0]);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("OCSP_REQUEST_new"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static void OCSP_REQUEST_free(MemorySegment a) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("OCSP_REQUEST_free"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            mh$.invokeExact(a);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int i2d_OCSP_REQUEST(MemorySegment a, MemorySegment out) {
        class Holder {
            static final FunctionDescriptor DESC = FunctionDescriptor.of(ValueLayout.JAVA_INT, openssl_h.C_POINTER, openssl_h.C_POINTER);
            static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("i2d_OCSP_REQUEST"), DESC, new Linker.Option[0]);

            Holder() {
            }
        }
        MethodHandle mh$ = Holder.MH;
        try {
            return mh$.invokeExact(a, out);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }
}

