/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tomcat.util.IntrospectionUtils;

public class ServiceBindingPropertySource
implements IntrospectionUtils.PropertySource {
    private static final String SERVICE_BINDING_ROOT_ENV_VAR = "SERVICE_BINDING_ROOT";

    @Override
    public String getProperty(String key) {
        String[] parts;
        String serviceBindingRoot = System.getenv(SERVICE_BINDING_ROOT_ENV_VAR);
        if (serviceBindingRoot == null) {
            return null;
        }
        boolean chomp = false;
        if (key.startsWith("chomp:")) {
            chomp = true;
            key = key.substring(6);
        }
        if ((parts = key.split("\\.")).length != 2) {
            return null;
        }
        Path path = Paths.get(serviceBindingRoot, parts[0], parts[1]);
        if (!path.toFile().exists()) {
            return null;
        }
        try {
            byte[] bytes = Files.readAllBytes(path);
            int length = bytes.length;
            if (chomp) {
                byte c;
                if (length > 1 && bytes[length - 2] == 13 && bytes[length - 2] == 10) {
                    length -= 2;
                } else if (length > 0 && ((c = bytes[length - 1]) == 13 || c == 10)) {
                    --length;
                }
            }
            return new String(bytes, 0, length);
        }
        catch (IOException e) {
            return null;
        }
    }
}

