/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.panama;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Cleaner;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLX509Certificate;
import org.apache.tomcat.util.openssl.openssl_h;
import org.apache.tomcat.util.openssl.openssl_h_Compatibility;
import org.apache.tomcat.util.openssl.openssl_h_Macros;
import org.apache.tomcat.util.res.StringManager;

public final class OpenSSLEngine
extends SSLEngine
implements SSLUtil.ProtocolInfo {
    private static final Log log = LogFactory.getLog(OpenSSLEngine.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = new Certificate[0];
    public static final Set<String> AVAILABLE_CIPHER_SUITES;
    public static final Set<String> IMPLEMENTED_PROTOCOLS_SET;
    private static final MethodHandle openSSLCallbackInfoHandle;
    private static final MethodHandle openSSLCallbackVerifyHandle;
    private static final FunctionDescriptor openSSLCallbackInfoFunctionDescriptor;
    private static final FunctionDescriptor openSSLCallbackVerifyFunctionDescriptor;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    static final int VERIFY_DEPTH = 10;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 2329;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final ConcurrentHashMap<Long, EngineState> states;
    private final EngineState state;
    private final Arena engineArena;
    private final Cleaner.Cleanable cleanable;
    private MemorySegment bufSegment = null;
    private Accepted accepted = Accepted.NOT;
    private boolean handshakeFinished;
    private int currentHandshake;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String version;
    private volatile String cipher;
    private volatile String applicationProtocol;
    private volatile Certificate[] peerCerts;
    private volatile ClientAuthMode clientAuth = ClientAuthMode.NONE;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private boolean sendHandshakeError = false;
    private final boolean clientMode;
    private final String fallbackApplicationProtocol;
    private final OpenSSLSessionContext sessionContext;
    private final boolean alpn;
    private final boolean initialized;
    private final boolean certificateVerificationOptionalNoCA;
    private String selectedProtocol = null;
    private final OpenSSLSession session;
    private static final int OPTIONAL_NO_CA = 3;
    private static final int ASN1_SEQUENCE = 48;
    private static final int ASN1_OID = 6;
    private static final int ASN1_STRING = 134;
    private static final byte[] OCSP_OID;

    private static EngineState getState(MemorySegment ssl) {
        return states.get(ssl.address());
    }

    OpenSSLEngine(Cleaner cleaner, MemorySegment sslCtx, String fallbackApplicationProtocol, boolean clientMode, OpenSSLSessionContext sessionContext, boolean alpn, boolean initialized, int certificateVerificationDepth, boolean certificateVerificationOptionalNoCA, boolean noOcspCheck) {
        if (sslCtx == null) {
            throw new IllegalArgumentException(sm.getString("engine.noSSLContext"));
        }
        this.engineArena = Arena.ofAuto();
        this.bufSegment = this.engineArena.allocate(18713L);
        this.session = new OpenSSLSession();
        MemorySegment ssl = openssl_h.SSL_new(sslCtx);
        MemorySegment openSSLCallbackInfo = Linker.nativeLinker().upcallStub(openSSLCallbackInfoHandle, openSSLCallbackInfoFunctionDescriptor, this.engineArena, new Linker.Option[0]);
        openssl_h.SSL_set_info_callback(ssl, openSSLCallbackInfo);
        if (clientMode) {
            openssl_h.SSL_set_connect_state(ssl);
        } else {
            openssl_h.SSL_set_accept_state(ssl);
        }
        openssl_h.SSL_set_verify_result(ssl, openssl_h.X509_V_OK());
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment internalBIOPointer = localArena.allocate(ValueLayout.ADDRESS);
            MemorySegment networkBIOPointer = localArena.allocate(ValueLayout.ADDRESS);
            openssl_h.BIO_new_bio_pair(internalBIOPointer, 0L, networkBIOPointer, 0L);
            MemorySegment internalBIO = internalBIOPointer.get(ValueLayout.ADDRESS, 0L);
            MemorySegment networkBIO = networkBIOPointer.get(ValueLayout.ADDRESS, 0L);
            openssl_h.SSL_set_bio(ssl, internalBIO, internalBIO);
            this.state = new EngineState(ssl, networkBIO, certificateVerificationDepth, noOcspCheck);
        }
        this.fallbackApplicationProtocol = fallbackApplicationProtocol;
        this.clientMode = clientMode;
        this.sessionContext = sessionContext;
        this.alpn = alpn;
        this.initialized = initialized;
        this.certificateVerificationOptionalNoCA = certificateVerificationOptionalNoCA;
        this.cleanable = cleaner.register(this, this.state);
    }

    @Override
    public String getNegotiatedProtocol() {
        return this.selectedProtocol;
    }

    public synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.cleanable.clean();
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
            this.bufSegment = null;
        }
    }

    private int writePlaintextData(MemorySegment ssl, ByteBuffer src) throws SSLException {
        int sslWrote;
        MemorySegment srcSegment;
        this.clearLastError();
        int pos = src.position();
        int len = Math.min(src.remaining(), 16384);
        MemorySegment memorySegment = srcSegment = src.isDirect() ? MemorySegment.ofBuffer(src) : this.bufSegment;
        if (!src.isDirect()) {
            MemorySegment.copy(src.array(), pos, this.bufSegment, ValueLayout.JAVA_BYTE, 0L, len);
        }
        if ((sslWrote = openssl_h.SSL_write(ssl, srcSegment, len)) > 0) {
            src.position(pos + sslWrote);
            return sslWrote;
        }
        this.checkLastError();
        return 0;
    }

    private int writeEncryptedData(MemorySegment networkBIO, ByteBuffer src) throws SSLException {
        int netWrote;
        MemorySegment srcSegment;
        this.clearLastError();
        int pos = src.position();
        int len = src.remaining();
        MemorySegment memorySegment = srcSegment = src.isDirect() ? MemorySegment.ofBuffer(src) : this.bufSegment;
        if (!src.isDirect()) {
            MemorySegment.copy(src.array(), pos, this.bufSegment, ValueLayout.JAVA_BYTE, 0L, len);
        }
        if ((netWrote = openssl_h.BIO_write(networkBIO, srcSegment, len)) > 0) {
            src.position(pos + netWrote);
            return netWrote;
        }
        this.checkLastError();
        return 0;
    }

    private int readPlaintextData(MemorySegment ssl, ByteBuffer dst) throws SSLException {
        this.clearLastError();
        int pos = dst.position();
        int len = Math.min(dst.remaining(), 18713);
        MemorySegment dstSegment = dst.isDirect() ? MemorySegment.ofBuffer(dst) : this.bufSegment;
        int sslRead = openssl_h.SSL_read(ssl, dstSegment, len);
        if (sslRead > 0) {
            if (!dst.isDirect()) {
                MemorySegment.copy(dstSegment, ValueLayout.JAVA_BYTE, 0L, dst.array(), pos, sslRead);
            }
            dst.position(pos + sslRead);
            return sslRead;
        }
        this.checkLastError();
        return 0;
    }

    private int readEncryptedData(MemorySegment networkBIO, ByteBuffer dst, int pending) throws SSLException {
        this.clearLastError();
        int pos = dst.position();
        MemorySegment dstSegment = dst.isDirect() ? MemorySegment.ofBuffer(dst) : this.bufSegment;
        int bioRead = openssl_h.BIO_read(networkBIO, dstSegment, pending);
        if (bioRead > 0) {
            if (!dst.isDirect()) {
                MemorySegment.copy(dstSegment, ValueLayout.JAVA_BYTE, 0L, dst.array(), pos, bioRead);
            }
            dst.position(pos + bioRead);
            return bioRead;
        }
        this.checkLastError();
        return 0;
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (this.destroyed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (srcs == null || dst == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (offset >= srcs.length || offset + length > srcs.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(offset), Integer.toString(length), Integer.toString(srcs.length)}));
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == Accepted.NOT) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }
        int bytesProduced = 0;
        int pendingNet = (int)openssl_h.BIO_ctrl_pending(this.state.networkBIO);
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
            }
            try {
                bytesProduced = this.readEncryptedData(this.state.networkBIO, dst, pendingNet);
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), 0, bytesProduced);
        }
        int bytesConsumed = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            while (src.hasRemaining()) {
                int bytesWritten = 0;
                try {
                    bytesWritten = this.writePlaintextData(this.state.ssl, src);
                    bytesConsumed += bytesWritten;
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                if (bytesWritten == 0) {
                    throw new IllegalStateException(sm.getString("engine.failedToWriteBytes"));
                }
                pendingNet = (int)openssl_h.BIO_ctrl_pending(this.state.networkBIO);
                if (pendingNet <= 0) continue;
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesProduced);
                }
                try {
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced += this.readEncryptedData(this.state.networkBIO, dst, pendingNet));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        if (this.destroyed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (src == null || dsts == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (offset >= dsts.length || offset + length > dsts.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(offset), Integer.toString(length), Integer.toString(dsts.length)}));
        }
        int capacity = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer dst = dsts[i];
            if (dst == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            capacity += dst.remaining();
        }
        if (this.accepted == Accepted.NOT) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        }
        int len = src.remaining();
        if (len > 18713) {
            this.isInboundDone = true;
            this.isOutboundDone = true;
            this.engineClosed = true;
            this.shutdown();
            throw new SSLException(sm.getString("engine.oversizedPacket"));
        }
        int written = 0;
        try {
            written = this.writeEncryptedData(this.state.networkBIO, src);
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
        int pendingApp = this.pendingReadableBytesInSSL();
        if (!this.handshakeFinished) {
            pendingApp = 0;
        }
        int bytesProduced = 0;
        int idx = offset;
        if (capacity == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), written, 0);
        }
        while (pendingApp > 0) {
            if (idx == endOffset) {
                throw new IllegalStateException(sm.getString("engine.invalidDestinationBuffersState"));
            }
            while (idx < endOffset) {
                int bytesRead;
                ByteBuffer dst = dsts[idx];
                if (!dst.hasRemaining()) {
                    ++idx;
                    continue;
                }
                if (pendingApp <= 0) break;
                try {
                    bytesRead = this.readPlaintextData(this.state.ssl, dst);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                if (bytesRead == 0) {
                    throw new IllegalStateException(sm.getString("engine.failedToReadAvailableBytes"));
                }
                bytesProduced += bytesRead;
                pendingApp -= bytesRead;
                capacity -= bytesRead;
                if (dst.hasRemaining()) continue;
                ++idx;
            }
            if (capacity == 0) break;
            if (pendingApp != 0) continue;
            pendingApp = this.pendingReadableBytesInSSL();
        }
        if (!this.receivedShutdown && (openssl_h.SSL_get_shutdown(this.state.ssl) & openssl_h.SSL_RECEIVED_SHUTDOWN()) == openssl_h.SSL_RECEIVED_SHUTDOWN()) {
            this.receivedShutdown = true;
            this.closeOutbound();
            this.closeInbound();
        }
        if (bytesProduced == 0 && (written == 0 || written > 0 && !src.hasRemaining() && this.handshakeFinished)) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), written, 0);
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), written, bytesProduced);
    }

    private int pendingReadableBytesInSSL() throws SSLException {
        this.clearLastError();
        int lastPrimingReadResult = openssl_h.SSL_read(this.state.ssl, MemorySegment.NULL, 0);
        if (lastPrimingReadResult <= 0) {
            this.checkLastError();
        }
        int pendingReadableBytesInSSL = openssl_h.SSL_pending(this.state.ssl);
        if ("TLSv1".equals(this.version) && lastPrimingReadResult == 0 && pendingReadableBytesInSSL == 0) {
            lastPrimingReadResult = openssl_h.SSL_read(this.state.ssl, MemorySegment.NULL, 0);
            if (lastPrimingReadResult <= 0) {
                this.checkLastError();
            }
            pendingReadableBytesInSSL = openssl_h.SSL_pending(this.state.ssl);
        }
        return pendingReadableBytesInSSL;
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.accepted != Accepted.NOT && !this.receivedShutdown) {
            throw new SSLException(sm.getString("engine.inboundClose"));
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != Accepted.NOT && !this.destroyed) {
            int mode = openssl_h.SSL_get_shutdown(this.state.ssl);
            if ((mode & openssl_h.SSL_SENT_SHUTDOWN()) != openssl_h.SSL_SENT_SHUTDOWN()) {
                openssl_h.SSL_shutdown(this.state.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        Set<String> availableCipherSuites = AVAILABLE_CIPHER_SUITES;
        return availableCipherSuites.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        if (this.destroyed) {
            return new String[0];
        }
        String[] enabled = OpenSSLLibrary.getCiphers(this.state.ssl);
        if (enabled == null) {
            return new String[0];
        }
        for (int i = 0; i < enabled.length; ++i) {
            String mapped = OpenSSLCipherConfigurationParser.openSSLToJsse(enabled[i]);
            if (mapped == null) continue;
            enabled[i] = mapped;
        }
        return enabled;
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] cipherSuites) {
        if (this.initialized) {
            return;
        }
        if (cipherSuites == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullCipherSuite"));
        }
        if (this.destroyed) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String cipherSuite : cipherSuites) {
            if (cipherSuite == null) break;
            String converted = OpenSSLCipherConfigurationParser.jsseToOpenSSL(cipherSuite);
            if (!AVAILABLE_CIPHER_SUITES.contains(cipherSuite)) {
                log.debug((Object)sm.getString("engine.unsupportedCipher", new Object[]{cipherSuite, converted}));
            }
            if (converted != null) {
                cipherSuite = converted;
            }
            buf.append(cipherSuite);
            buf.append(':');
        }
        if (buf.length() == 0) {
            throw new IllegalArgumentException(sm.getString("engine.emptyCipherSuite"));
        }
        buf.setLength(buf.length() - 1);
        String cipherSuiteSpec = buf.toString();
        try (Arena localArena = Arena.ofConfined();){
            openssl_h.SSL_set_cipher_list(this.state.ssl, localArena.allocateFrom(cipherSuiteSpec));
        }
        catch (Exception e) {
            throw new IllegalStateException(sm.getString("engine.failedCipherSuite", new Object[]{cipherSuiteSpec}), e);
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return IMPLEMENTED_PROTOCOLS_SET.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        int size;
        if (this.destroyed) {
            return new String[0];
        }
        ArrayList<String> enabled = new ArrayList<String>();
        enabled.add("SSLv2Hello");
        long opts = openssl_h.SSL_get_options(this.state.ssl);
        if ((opts & openssl_h.SSL_OP_NO_TLSv1()) == 0L) {
            enabled.add("TLSv1");
        }
        if ((opts & openssl_h.SSL_OP_NO_TLSv1_1()) == 0L) {
            enabled.add("TLSv1.1");
        }
        if ((opts & openssl_h.SSL_OP_NO_TLSv1_2()) == 0L) {
            enabled.add("TLSv1.2");
        }
        if ((opts & openssl_h.SSL_OP_NO_TLSv1_3()) == 0L) {
            enabled.add("TLSv1.3");
        }
        if ((opts & (long)openssl_h.SSL_OP_NO_SSLv2()) == 0L) {
            enabled.add("SSLv2");
        }
        if ((opts & openssl_h.SSL_OP_NO_SSLv3()) == 0L) {
            enabled.add("SSLv3");
        }
        if ((size = enabled.size()) == 0) {
            return new String[0];
        }
        return enabled.toArray(new String[size]);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (this.initialized) {
            return;
        }
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        if (this.destroyed) {
            return;
        }
        boolean sslv2 = false;
        boolean sslv3 = false;
        boolean tlsv1 = false;
        boolean tlsv1_1 = false;
        boolean tlsv1_2 = false;
        boolean tlsv1_3 = false;
        for (String p : protocols) {
            if (!IMPLEMENTED_PROTOCOLS_SET.contains(p)) {
                throw new IllegalArgumentException(sm.getString("engine.unsupportedProtocol", new Object[]{p}));
            }
            if (p.equals("SSLv2")) {
                sslv2 = true;
                continue;
            }
            if (p.equals("SSLv3")) {
                sslv3 = true;
                continue;
            }
            if (p.equals("TLSv1")) {
                tlsv1 = true;
                continue;
            }
            if (p.equals("TLSv1.1")) {
                tlsv1_1 = true;
                continue;
            }
            if (p.equals("TLSv1.2")) {
                tlsv1_2 = true;
                continue;
            }
            if (!p.equals("TLSv1.3")) continue;
            tlsv1_3 = true;
        }
        openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_ALL());
        if (!sslv2) {
            openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_SSLv2());
        }
        if (!sslv3) {
            openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_SSLv3());
        }
        if (!tlsv1) {
            openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1());
        }
        if (!tlsv1_1) {
            openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1_1());
        }
        if (!tlsv1_2) {
            openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1_2());
        }
        if (!tlsv1_3) {
            openssl_h.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1_3());
        }
    }

    @Override
    public SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.engineClosed || this.destroyed) {
            throw new SSLException(sm.getString("engine.engineClosed"));
        }
        switch (this.accepted.ordinal()) {
            case 0: {
                this.handshake();
                this.accepted = Accepted.EXPLICIT;
                break;
            }
            case 1: {
                this.accepted = Accepted.EXPLICIT;
                break;
            }
            case 2: {
                this.renegotiate();
            }
        }
    }

    private byte[] getPeerCertificate() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment x509 = OpenSSLContext.OPENSSL_3 ? openssl_h.SSL_get1_peer_certificate(this.state.ssl) : openssl_h_Compatibility.SSL_get_peer_certificate(this.state.ssl);
            MemorySegment bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            int length = openssl_h.i2d_X509(x509, bufPointer);
            if (length <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
            byte[] certificate = buf.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
            openssl_h.X509_free(x509);
            openssl_h_Macros.OPENSSL_free(buf);
            byte[] byArray = certificate;
            return byArray;
        }
    }

    private byte[][] getPeerCertChain() {
        MemorySegment sk = openssl_h.SSL_get_peer_cert_chain(this.state.ssl);
        int len = openssl_h.OPENSSL_sk_num(sk);
        if (len <= 0) {
            return null;
        }
        byte[][] certificateChain = new byte[len][];
        try (Arena localArena = Arena.ofConfined();){
            for (int i = 0; i < len; ++i) {
                MemorySegment bufPointer;
                MemorySegment x509 = openssl_h.OPENSSL_sk_value(sk, i);
                int length = openssl_h.i2d_X509(x509, bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL));
                if (length < 0) {
                    certificateChain[i] = new byte[0];
                    continue;
                }
                MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
                byte[] certificate = buf.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
                certificateChain[i] = certificate;
                openssl_h_Macros.OPENSSL_free(buf);
            }
            byte[][] byArrayArray = certificateChain;
            return byArrayArray;
        }
    }

    private String getProtocolNegotiated() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment lenAddress = localArena.allocate(ValueLayout.JAVA_INT);
            MemorySegment protocolPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            openssl_h.SSL_get0_alpn_selected(this.state.ssl, protocolPointer, lenAddress);
            if (MemorySegment.NULL.equals(protocolPointer)) {
                String string = null;
                return string;
            }
            int length = lenAddress.get(ValueLayout.JAVA_INT, 0L);
            if (length == 0) {
                String string = null;
                return string;
            }
            MemorySegment protocolAddress = protocolPointer.get(ValueLayout.ADDRESS, 0L);
            byte[] name = protocolAddress.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Protocol negotiated [" + new String(name) + "]"));
            }
            String string = new String(name);
            return string;
        }
    }

    private void beginHandshakeImplicitly() throws SSLException {
        this.handshake();
        this.accepted = Accepted.IMPLICIT;
    }

    private void handshake() throws SSLException {
        this.currentHandshake = this.state.handshakeCount;
        this.clearLastError();
        int code = openssl_h.SSL_do_handshake(this.state.ssl);
        if (code <= 0) {
            this.checkLastError();
        } else {
            if (this.alpn) {
                this.selectedProtocol = this.getProtocolNegotiated();
            }
            this.session.lastAccessedTime = System.currentTimeMillis();
            this.handshakeFinished = true;
        }
    }

    private synchronized void renegotiate() throws SSLException {
        int code;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start renegotiate");
        }
        this.clearLastError();
        if (openssl_h.SSL_get_version(this.state.ssl).getString(0L).equals("TLSv1.3")) {
            this.state.phaState = PHAState.START;
            code = openssl_h.SSL_verify_client_post_handshake(this.state.ssl);
        } else {
            code = openssl_h.SSL_renegotiate(this.state.ssl);
        }
        if (code <= 0) {
            this.checkLastError();
        }
        this.handshakeFinished = false;
        this.peerCerts = null;
        this.currentHandshake = this.state.handshakeCount;
        int code2 = openssl_h.SSL_do_handshake(this.state.ssl);
        if (code2 <= 0) {
            this.checkLastError();
        }
    }

    private void checkLastError() throws SSLException {
        String sslError = this.getLastError();
        if (sslError != null) {
            if (!this.handshakeFinished) {
                this.sendHandshakeError = true;
            } else {
                throw new SSLException(sslError);
            }
        }
    }

    private void clearLastError() {
        this.getLastError();
    }

    private String getLastError() {
        String sslError = null;
        long error = openssl_h.ERR_get_error();
        if (error != (long)openssl_h.SSL_ERROR_NONE()) {
            try (Arena localArena = Arena.ofConfined();){
                do {
                    MemorySegment buf = localArena.allocate(ValueLayout.JAVA_BYTE, 128L);
                    openssl_h.ERR_error_string(error, buf);
                    String err = buf.getString(0L);
                    if (sslError == null) {
                        sslError = err;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("engine.openSSLError", new Object[]{Long.toString(error), err}));
                } while ((error = openssl_h.ERR_get_error()) != (long)openssl_h.SSL_ERROR_NONE());
            }
        }
        return sslError;
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == Accepted.NOT || this.destroyed) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (!this.handshakeFinished) {
            if (this.sendHandshakeError || openssl_h.BIO_ctrl_pending(this.state.networkBIO) != 0L) {
                if (this.sendHandshakeError) {
                    this.sendHandshakeError = false;
                    ++this.currentHandshake;
                }
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.state.handshakeCount != this.currentHandshake && openssl_h.SSL_renegotiate_pending(this.state.ssl) == 0 && this.state.phaState != PHAState.START) {
                if (this.alpn) {
                    this.selectedProtocol = this.getProtocolNegotiated();
                }
                this.session.lastAccessedTime = System.currentTimeMillis();
                this.version = openssl_h.SSL_get_version(this.state.ssl).getString(0L);
                this.handshakeFinished = true;
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (openssl_h.BIO_ctrl_pending(this.state.networkBIO) != 0L) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        if (clientMode != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.REQUIRE : ClientAuthMode.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuthMode.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.OPTIONAL : ClientAuthMode.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuthMode.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuthMode mode) {
        if (this.clientMode) {
            return;
        }
        OpenSSLEngine openSSLEngine = this;
        synchronized (openSSLEngine) {
            if (this.clientAuth == mode) {
                return;
            }
            this.state.certificateVerifyMode = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> openssl_h.SSL_VERIFY_NONE();
                case 2 -> openssl_h.SSL_VERIFY_FAIL_IF_NO_PEER_CERT();
                case 1 -> this.certificateVerificationOptionalNoCA ? 3 : openssl_h.SSL_VERIFY_PEER();
            };
            MemorySegment openSSLCallbackVerify = Linker.nativeLinker().upcallStub(openSSLCallbackVerifyHandle, openSSLCallbackVerifyFunctionDescriptor, this.engineArena, new Linker.Option[0]);
            int value = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> openssl_h.SSL_VERIFY_NONE();
                case 2 -> openssl_h.SSL_VERIFY_PEER() | openssl_h.SSL_VERIFY_FAIL_IF_NO_PEER_CERT();
                case 1 -> openssl_h.SSL_VERIFY_PEER();
            };
            openssl_h.SSL_set_verify(this.state.ssl, value, openSSLCallbackVerify);
            this.clientAuth = mode;
        }
    }

    public static void openSSLCallbackInfo(MemorySegment ssl, int where, int ret) {
        EngineState state = OpenSSLEngine.getState(ssl);
        if (state == null) {
            log.warn((Object)sm.getString("engine.noSSL", new Object[]{ssl.address()}));
            return;
        }
        if (0 != (where & openssl_h.SSL_CB_HANDSHAKE_DONE())) {
            ++state.handshakeCount;
        }
    }

    public static int openSSLCallbackVerify(int preverify_ok, MemorySegment x509ctx) {
        boolean verifyErrorIsOptional;
        MemorySegment ssl = openssl_h.X509_STORE_CTX_get_ex_data(x509ctx, openssl_h.SSL_get_ex_data_X509_STORE_CTX_idx());
        EngineState state = OpenSSLEngine.getState(ssl);
        if (state == null) {
            log.warn((Object)sm.getString("engine.noSSL", new Object[]{ssl.address()}));
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Verification in engine with mode [" + state.certificateVerifyMode + "] for " + String.valueOf(state.ssl)));
        }
        int ok = preverify_ok;
        int errnum = openssl_h.X509_STORE_CTX_get_error(x509ctx);
        int errdepth = openssl_h.X509_STORE_CTX_get_error_depth(x509ctx);
        state.phaState = PHAState.COMPLETE;
        if (state.certificateVerifyMode == -1 || state.certificateVerifyMode == openssl_h.SSL_VERIFY_NONE()) {
            return 1;
        }
        boolean bl = verifyErrorIsOptional = errnum == openssl_h.X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT() || errnum == openssl_h.X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN() || errnum == openssl_h.X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY() || errnum == openssl_h.X509_V_ERR_CERT_UNTRUSTED() || errnum == openssl_h.X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE();
        if (verifyErrorIsOptional && state.certificateVerifyMode == 3) {
            ok = 1;
            openssl_h.SSL_set_verify_result(state.ssl, openssl_h.X509_V_OK());
        }
        if (ok == 0 && errnum == openssl_h.X509_V_ERR_CRL_HAS_EXPIRED()) {
            openssl_h.X509_STORE_CTX_set_error(x509ctx, -1);
        }
        if (!state.noOcspCheck && ok > 0) {
            if (verifyErrorIsOptional) {
                if (state.certificateVerifyMode != 3) {
                    openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_APPLICATION_VERIFICATION());
                    errnum = openssl_h.X509_V_ERR_APPLICATION_VERIFICATION();
                    ok = 0;
                }
            } else {
                int ocspResponse = OpenSSLEngine.processOCSP(x509ctx);
                if (ocspResponse == openssl_h.V_OCSP_CERTSTATUS_REVOKED()) {
                    ok = 0;
                    errnum = openssl_h.X509_STORE_CTX_get_error(x509ctx);
                } else if (ocspResponse == openssl_h.V_OCSP_CERTSTATUS_UNKNOWN() && (errnum = openssl_h.X509_STORE_CTX_get_error(x509ctx)) <= 0) {
                    ok = 0;
                }
            }
        }
        if (errdepth > state.certificateVerificationDepth) {
            ok = 0;
        }
        return ok;
    }

    static int processOCSP(MemorySegment x509ctx) {
        int ocspResponse;
        block16: {
            ocspResponse = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
            MemorySegment x509 = openssl_h.X509_STORE_CTX_get_current_cert(x509ctx);
            if (!MemorySegment.NULL.equals(x509)) {
                if (openssl_h.X509_check_issued(x509, x509) == openssl_h.X509_V_OK()) {
                    openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_OK());
                } else {
                    int nid;
                    MemorySegment issuer = openssl_h.X509_STORE_CTX_get0_current_issuer(x509ctx);
                    if (!MemorySegment.NULL.equals(issuer) && (nid = openssl_h.X509_get_ext_by_NID(x509, openssl_h.NID_info_access(), -1)) >= 0) {
                        try (Arena localArenal = Arena.ofConfined();){
                            MemorySegment ext = openssl_h.X509_get_ext(x509, nid);
                            MemorySegment os = openssl_h.X509_EXTENSION_get_data(ext);
                            int length = openssl_h.ASN1_STRING_length(os);
                            MemorySegment data = openssl_h.ASN1_STRING_get0_data(os);
                            byte[] asn1String = data.reinterpret(length, localArenal, null).toArray(ValueLayout.JAVA_BYTE);
                            Asn1Parser parser = new Asn1Parser(asn1String);
                            ArrayList<String> urls = new ArrayList<String>();
                            try {
                                OpenSSLEngine.parseOCSPURLs(parser, urls);
                            }
                            catch (Exception e) {
                                log.error((Object)sm.getString("engine.ocspParseError"), (Throwable)e);
                            }
                            if (urls.isEmpty()) break block16;
                            for (String urlString : urls) {
                                try {
                                    URL url = new URI(urlString).toURL();
                                    ocspResponse = OpenSSLEngine.processOCSPRequest(url, issuer, x509, x509ctx, localArenal);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("OCSP response for URL: " + urlString + " was " + ocspResponse));
                                    }
                                }
                                catch (MalformedURLException | URISyntaxException e) {
                                    log.warn((Object)sm.getString("engine.invalidOCSPURL", new Object[]{urlString}));
                                }
                                if (ocspResponse == openssl_h.V_OCSP_CERTSTATUS_UNKNOWN()) continue;
                                break;
                            }
                        }
                    }
                }
            }
        }
        return ocspResponse;
    }

    private static void parseOCSPURLs(Asn1Parser parser, ArrayList<String> urls) {
        while (!parser.eof()) {
            int tag = parser.peekTag();
            if (tag == 48) {
                parser.parseTag(48);
                parser.parseFullLength();
                continue;
            }
            if (tag == 6) {
                parser.parseTag(6);
                int oidLen = parser.parseLength();
                byte[] oid = new byte[oidLen];
                parser.parseBytes(oid);
                if (Arrays.compareUnsigned(oid, 0, OCSP_OID.length, OCSP_OID, 0, OCSP_OID.length) != 0) continue;
                parser.parseTag(134);
                int urlLen = parser.parseLength();
                byte[] url = new byte[urlLen];
                parser.parseBytes(url);
                urls.add(new String(url));
                continue;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int processOCSPRequest(URL url, MemorySegment issuer, MemorySegment x509, MemorySegment x509ctx, Arena localArena) {
        MemorySegment ocspRequest = MemorySegment.NULL;
        MemorySegment ocspResponse = MemorySegment.NULL;
        MemorySegment id = MemorySegment.NULL;
        MemorySegment ocspOneReq = MemorySegment.NULL;
        HttpURLConnection connection = null;
        MemorySegment basicResponse = MemorySegment.NULL;
        MemorySegment certId = MemorySegment.NULL;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ocspRequest = openssl_h.OCSP_REQUEST_new();
            if (MemorySegment.NULL.equals(ocspRequest)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            id = openssl_h.OCSP_cert_to_id(MemorySegment.NULL, x509, issuer);
            if (MemorySegment.NULL.equals(id)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            ocspOneReq = openssl_h.OCSP_request_add0_id(ocspRequest, id);
            if (MemorySegment.NULL.equals(ocspOneReq)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            int requestLength = openssl_h.i2d_OCSP_REQUEST(ocspRequest, bufPointer);
            if (requestLength <= 0) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
            byte[] ocspRequestData = buf.reinterpret(requestLength, localArena, null).toArray(ValueLayout.JAVA_BYTE);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setFixedLengthStreamingMode(requestLength);
            connection.setRequestProperty("Content-Type", "application/ocsp-request");
            connection.connect();
            connection.getOutputStream().write(ocspRequestData);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            InputStream is = connection.getInputStream();
            int read = 0;
            byte[] responseBuf = new byte[1024];
            while ((read = is.read(responseBuf)) > 0) {
                baos.write(responseBuf, 0, read);
            }
            byte[] responseData = baos.toByteArray();
            MemorySegment nativeResponseData = localArena.allocateFrom(ValueLayout.JAVA_BYTE, responseData);
            MemorySegment nativeResponseDataPointer = localArena.allocateFrom(ValueLayout.ADDRESS, nativeResponseData);
            ocspResponse = openssl_h.d2i_OCSP_RESPONSE(MemorySegment.NULL, nativeResponseDataPointer, responseData.length);
            if (MemorySegment.NULL.equals(ocspResponse)) return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
            if (openssl_h.OCSP_response_status(ocspResponse) != openssl_h.OCSP_RESPONSE_STATUS_SUCCESSFUL()) return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
            basicResponse = openssl_h.OCSP_response_get1_basic(ocspResponse);
            certId = openssl_h.OCSP_cert_to_id(MemorySegment.NULL, x509, issuer);
            if (MemorySegment.NULL.equals(certId)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment singleResponse = openssl_h.OCSP_resp_get0(basicResponse, openssl_h.OCSP_resp_find(basicResponse, certId, -1));
            int n = openssl_h.OCSP_single_get0_status(singleResponse, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
            return n;
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("engine.ocspRequestError", new Object[]{url.toString()}), (Throwable)e);
            return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
        }
        finally {
            if (MemorySegment.NULL.equals(ocspResponse)) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_APPLICATION_VERIFICATION());
            }
            openssl_h.OCSP_CERTID_free(certId);
            openssl_h.OCSP_BASICRESP_free(basicResponse);
            openssl_h.OCSP_RESPONSE_free(ocspResponse);
            openssl_h.OCSP_REQUEST_free(ocspRequest);
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        if (!b) {
            String msg = sm.getString("engine.noRestrictSessionCreation");
            throw new UnsupportedOperationException(msg);
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return true;
    }

    static {
        openSSLCallbackInfoFunctionDescriptor = FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
        openSSLCallbackVerifyFunctionDescriptor = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            openSSLCallbackInfoHandle = lookup.findStatic(OpenSSLEngine.class, "openSSLCallbackInfo", MethodType.methodType(Void.TYPE, MemorySegment.class, Integer.TYPE, Integer.TYPE));
            openSSLCallbackVerifyHandle = lookup.findStatic(OpenSSLEngine.class, "openSSLCallbackVerify", MethodType.methodType(Integer.TYPE, Integer.TYPE, MemorySegment.class));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        LinkedHashSet<String> availableCipherSuites = new LinkedHashSet<String>(128);
        availableCipherSuites.addAll(OpenSSLLibrary.findCiphers("ALL"));
        AVAILABLE_CIPHER_SUITES = Collections.unmodifiableSet(availableCipherSuites);
        HashSet<String> protocols = new HashSet<String>();
        protocols.add("SSLv2Hello");
        protocols.add("SSLv2");
        protocols.add("SSLv3");
        protocols.add("TLSv1");
        protocols.add("TLSv1.1");
        protocols.add("TLSv1.2");
        protocols.add("TLSv1.3");
        IMPLEMENTED_PROTOCOLS_SET = Collections.unmodifiableSet(protocols);
        states = new ConcurrentHashMap();
        OCSP_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1};
    }

    private static class EngineState
    implements Runnable {
        private final Arena stateArena = Arena.ofShared();
        private final MemorySegment ssl;
        private final MemorySegment networkBIO;
        private final int certificateVerificationDepth;
        private final boolean noOcspCheck;
        private PHAState phaState = PHAState.NONE;
        private int certificateVerifyMode = 0;
        private int handshakeCount = 0;

        private EngineState(MemorySegment ssl, MemorySegment networkBIO, int certificateVerificationDepth, boolean noOcspCheck) {
            states.put(ssl.address(), this);
            this.certificateVerificationDepth = certificateVerificationDepth;
            this.noOcspCheck = noOcspCheck;
            this.ssl = ssl.reinterpret(ValueLayout.ADDRESS.byteSize(), this.stateArena, new Consumer<MemorySegment>(this){

                @Override
                public void accept(MemorySegment t) {
                    openssl_h.SSL_free(t);
                }
            });
            this.networkBIO = networkBIO.reinterpret(ValueLayout.ADDRESS.byteSize(), this.stateArena, new Consumer<MemorySegment>(this){

                @Override
                public void accept(MemorySegment t) {
                    openssl_h.BIO_free(t);
                }
            });
        }

        @Override
        public void run() {
            states.remove(this.ssl.address());
            this.stateArena.close();
        }
    }

    private static enum Accepted {
        NOT,
        IMPLICIT,
        EXPLICIT;

    }

    static enum ClientAuthMode {
        NONE,
        OPTIONAL,
        REQUIRE;

    }

    private class OpenSSLSession
    implements SSLSession {
        private Map<String, Object> values;
        private long lastAccessedTime = -1L;

        private OpenSSLSession() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getId() {
            byte[] id = null;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                block13: {
                    if (OpenSSLEngine.this.destroyed) break block13;
                    try (Arena localArena = Arena.ofConfined();){
                        MemorySegment lenPointer = localArena.allocate(ValueLayout.JAVA_INT);
                        MemorySegment session = openssl_h.SSL_get_session(OpenSSLEngine.this.state.ssl);
                        if (MemorySegment.NULL.equals(session)) {
                            byte[] byArray = new byte[]{};
                            return byArray;
                        }
                        MemorySegment sessionId = openssl_h.SSL_SESSION_get_id(session, lenPointer);
                        int len = lenPointer.get(ValueLayout.JAVA_INT, 0L);
                        id = len == 0 ? new byte[]{} : sessionId.reinterpret(len, localArena, null).toArray(ValueLayout.JAVA_BYTE);
                    }
                }
                return id;
            }
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return OpenSSLEngine.this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCreationTime() {
            long creationTime = 0L;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                MemorySegment session;
                if (!OpenSSLEngine.this.destroyed && !MemorySegment.NULL.equals(session = openssl_h.SSL_get_session(OpenSSLEngine.this.state.ssl))) {
                    creationTime = openssl_h.SSL_SESSION_get_time(session);
                }
            }
            return creationTime * 1000L;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime > 0L ? this.lastAccessedTime : this.getCreationTime();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void putValue(String name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (value == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullValue"));
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                values = this.values = new HashMap<String, Object>(2);
            }
            Object old = values.put(name, value);
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
            }
            this.notifyUnbound(old, name);
        }

        @Override
        public Object getValue(String name) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(name);
        }

        @Override
        public void removeValue(String name) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                return;
            }
            Object old = values.remove(name);
            this.notifyUnbound(old, name);
        }

        @Override
        public String[] getValueNames() {
            Map<String, Object> values = this.values;
            if (values == null || values.isEmpty()) {
                return new String[0];
            }
            return values.keySet().toArray(new String[0]);
        }

        private void notifyUnbound(Object value, String name) {
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            Certificate[] c = OpenSSLEngine.this.peerCerts;
            if (c == null) {
                Certificate[] certificates;
                byte[] clientCert;
                byte[][] chain;
                OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
                synchronized (openSSLEngine) {
                    if (OpenSSLEngine.this.destroyed || openssl_h.SSL_in_init(OpenSSLEngine.this.state.ssl) != 0) {
                        throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                    }
                    chain = OpenSSLEngine.this.getPeerCertChain();
                    clientCert = !OpenSSLEngine.this.clientMode ? OpenSSLEngine.this.getPeerCertificate() : null;
                }
                if (chain == null && clientCert == null) {
                    return null;
                }
                int len = 0;
                if (chain != null) {
                    len += chain.length;
                }
                int i = 0;
                if (clientCert != null) {
                    certificates = new Certificate[++len];
                    certificates[i++] = new OpenSSLX509Certificate(clientCert);
                } else {
                    certificates = new Certificate[len];
                }
                if (chain != null) {
                    int a = 0;
                    while (i < certificates.length) {
                        certificates[i] = new OpenSSLX509Certificate(chain[a++]);
                        ++i;
                    }
                }
                OpenSSLEngine.this.peerCerts = certificates;
                c = certificates;
            }
            return c;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return EMPTY_CERTIFICATES;
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] peer = this.getPeerCertificates();
            if (peer == null || peer.length == 0) {
                return null;
            }
            return this.principal(peer);
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] local = this.getLocalCertificates();
            if (local == null || local.length == 0) {
                return null;
            }
            return this.principal(local);
        }

        private Principal principal(Certificate[] certs) {
            return ((X509Certificate)certs[0]).getIssuerX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCipherSuite() {
            if (OpenSSLEngine.this.cipher == null) {
                String ciphers;
                OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
                synchronized (openSSLEngine) {
                    if (!OpenSSLEngine.this.handshakeFinished) {
                        return OpenSSLEngine.INVALID_CIPHER;
                    }
                    if (OpenSSLEngine.this.destroyed) {
                        return OpenSSLEngine.INVALID_CIPHER;
                    }
                    ciphers = openssl_h.SSL_CIPHER_get_name(openssl_h.SSL_get_current_cipher(OpenSSLEngine.this.state.ssl)).getString(0L);
                }
                String c = OpenSSLCipherConfigurationParser.openSSLToJsse(ciphers);
                if (c != null) {
                    OpenSSLEngine.this.cipher = c;
                }
            }
            return OpenSSLEngine.this.cipher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProtocol() {
            String applicationProtocol = OpenSSLEngine.this.applicationProtocol;
            if (applicationProtocol == null) {
                applicationProtocol = OpenSSLEngine.this.fallbackApplicationProtocol;
                if (applicationProtocol != null) {
                    OpenSSLEngine.this.applicationProtocol = applicationProtocol.replace(':', '_');
                } else {
                    applicationProtocol = "";
                    OpenSSLEngine.this.applicationProtocol = "";
                }
            }
            String version = null;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                if (!OpenSSLEngine.this.destroyed) {
                    version = openssl_h.SSL_get_version(OpenSSLEngine.this.state.ssl).getString(0L);
                }
            }
            if (applicationProtocol.isEmpty()) {
                return version;
            }
            return version + ":" + applicationProtocol;
        }

        @Override
        public String getPeerHost() {
            return null;
        }

        @Override
        public int getPeerPort() {
            return 0;
        }

        @Override
        public int getPacketBufferSize() {
            return 18713;
        }

        @Override
        public int getApplicationBufferSize() {
            return 16384;
        }
    }

    private static enum PHAState {
        NONE,
        START,
        COMPLETE;

    }
}

