/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tomcat.util.IntrospectionUtils;

public class ServiceBindingPropertySource
implements IntrospectionUtils.PropertySource {
    private static final String SERVICE_BINDING_ROOT_ENV_VAR = "SERVICE_BINDING_ROOT";

    public String getProperty(String key) {
        String serviceBindingRoot = System.getenv(SERVICE_BINDING_ROOT_ENV_VAR);
        if (serviceBindingRoot == null) {
            return null;
        }
        String[] parts = key.split("\\.");
        if (parts.length != 2) {
            return null;
        }
        Path path = Paths.get(serviceBindingRoot, parts[0], parts[1]);
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return null;
        }
    }
}

