/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.manager.StatusTransformer;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class StatusManagerServlet
extends HttpServlet
implements NotificationListener {
    private static final long serialVersionUID = 1L;
    protected MBeanServer mBeanServer = null;
    protected final List<ObjectName> threadPools = Collections.synchronizedList(new ArrayList());
    protected final List<ObjectName> requestProcessors = Collections.synchronizedList(new ArrayList());
    protected final List<ObjectName> globalRequestProcessors = Collections.synchronizedList(new ArrayList());
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.manager");

    @Override
    public void init() throws ServletException {
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        try {
            String onStr = "*:type=ThreadPool,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.threadPools.add(oi.getObjectName());
            }
            onStr = "*:type=GlobalRequestProcessor,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.globalRequestProcessors.add(oi.getObjectName());
            }
            onStr = "*:type=RequestProcessor,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.requestProcessors.add(oi.getObjectName());
            }
            onStr = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(onStr);
            this.mBeanServer.addNotificationListener(objectName, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        String onStr = "JMImplementation:type=MBeanServerDelegate";
        try {
            ObjectName objectName = new ObjectName(onStr);
            this.mBeanServer.removeNotificationListener(objectName, this, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager", request.getLocales());
        int mode = 0;
        if (request.getParameter("XML") != null && request.getParameter("XML").equals("true")) {
            mode = 1;
        }
        StatusTransformer.setContentType(response, mode);
        PrintWriter writer = response.getWriter();
        boolean completeStatus = false;
        if (request.getPathInfo() != null && request.getPathInfo().equals("/all")) {
            completeStatus = true;
        }
        Object[] args = new Object[]{this.getServletContext().getContextPath()};
        StatusTransformer.writeHeader(writer, args, mode);
        args = new Object[]{this.getServletContext().getContextPath(), completeStatus ? smClient.getString("statusServlet.complete") : smClient.getString("statusServlet.title")};
        StatusTransformer.writeBody(writer, args, mode);
        args = new Object[9];
        args[0] = smClient.getString("htmlManagerServlet.manager");
        args[1] = response.encodeURL(this.getServletContext().getContextPath() + "/html/list");
        args[2] = smClient.getString("htmlManagerServlet.list");
        args[3] = this.getServletContext().getContextPath() + "/" + smClient.getString("htmlManagerServlet.helpHtmlManagerFile");
        args[4] = smClient.getString("htmlManagerServlet.helpHtmlManager");
        args[5] = this.getServletContext().getContextPath() + "/" + smClient.getString("htmlManagerServlet.helpManagerFile");
        args[6] = smClient.getString("htmlManagerServlet.helpManager");
        if (completeStatus) {
            args[7] = response.encodeURL(this.getServletContext().getContextPath() + "/status");
            args[8] = smClient.getString("statusServlet.title");
        } else {
            args[7] = response.encodeURL(this.getServletContext().getContextPath() + "/status/all");
            args[8] = smClient.getString("statusServlet.complete");
        }
        StatusTransformer.writeManager(writer, args, mode);
        args = new Object[]{smClient.getString("htmlManagerServlet.serverTitle"), smClient.getString("htmlManagerServlet.serverVersion"), smClient.getString("htmlManagerServlet.serverJVMVersion"), smClient.getString("htmlManagerServlet.serverJVMVendor"), smClient.getString("htmlManagerServlet.serverOSName"), smClient.getString("htmlManagerServlet.serverOSVersion"), smClient.getString("htmlManagerServlet.serverOSArch"), smClient.getString("htmlManagerServlet.serverHostname"), smClient.getString("htmlManagerServlet.serverIPAddress")};
        StatusTransformer.writePageHeading(writer, args, mode);
        args = new Object[8];
        args[0] = ServerInfo.getServerInfo();
        args[1] = System.getProperty("java.runtime.version");
        args[2] = System.getProperty("java.vm.vendor");
        args[3] = System.getProperty("os.name");
        args[4] = System.getProperty("os.version");
        args[5] = System.getProperty("os.arch");
        try {
            InetAddress address = InetAddress.getLocalHost();
            args[6] = address.getHostName();
            args[7] = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            args[6] = "-";
            args[7] = "-";
        }
        StatusTransformer.writeServerInfo(writer, args, mode);
        try {
            args = new Object[]{smClient.getString("htmlManagerServlet.jvmFreeMemory"), smClient.getString("htmlManagerServlet.jvmTotalMemory"), smClient.getString("htmlManagerServlet.jvmMaxMemory"), smClient.getString("htmlManagerServlet.jvmTableTitleMemoryPool"), smClient.getString("htmlManagerServlet.jvmTableTitleType"), smClient.getString("htmlManagerServlet.jvmTableTitleInitial"), smClient.getString("htmlManagerServlet.jvmTableTitleTotal"), smClient.getString("htmlManagerServlet.jvmTableTitleMaximum"), smClient.getString("htmlManagerServlet.jvmTableTitleUsed")};
            StatusTransformer.writeVMState(writer, mode, args);
            for (ObjectName objectName : this.threadPools) {
                String name = objectName.getKeyProperty("name");
                args = new Object[]{smClient.getString("htmlManagerServlet.connectorStateMaxThreads"), smClient.getString("htmlManagerServlet.connectorStateThreadCount"), smClient.getString("htmlManagerServlet.connectorStateThreadBusy"), smClient.getString("htmlManagerServlet.connectorStateAliveSocketCount"), smClient.getString("htmlManagerServlet.connectorStateMaxProcessingTime"), smClient.getString("htmlManagerServlet.connectorStateProcessingTime"), smClient.getString("htmlManagerServlet.connectorStateRequestCount"), smClient.getString("htmlManagerServlet.connectorStateErrorCount"), smClient.getString("htmlManagerServlet.connectorStateBytesReceived"), smClient.getString("htmlManagerServlet.connectorStateBytesSent"), smClient.getString("htmlManagerServlet.connectorStateTableTitleStage"), smClient.getString("htmlManagerServlet.connectorStateTableTitleTime"), smClient.getString("htmlManagerServlet.connectorStateTableTitleBSent"), smClient.getString("htmlManagerServlet.connectorStateTableTitleBRecv"), smClient.getString("htmlManagerServlet.connectorStateTableTitleClientForw"), smClient.getString("htmlManagerServlet.connectorStateTableTitleClientAct"), smClient.getString("htmlManagerServlet.connectorStateTableTitleVHost"), smClient.getString("htmlManagerServlet.connectorStateTableTitleRequest"), smClient.getString("htmlManagerServlet.connectorStateHint")};
                StatusTransformer.writeConnectorState(writer, objectName, name, this.mBeanServer, this.globalRequestProcessors, this.requestProcessors, mode, args);
            }
            if (request.getPathInfo() != null && request.getPathInfo().equals("/all")) {
                StatusTransformer.writeDetailedState(writer, this.mBeanServer, mode);
            }
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        StatusTransformer.writeFooter(writer, mode);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            String type;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                String type2 = objectName.getKeyProperty("type");
                if (type2 != null) {
                    if (type2.equals("ThreadPool")) {
                        this.threadPools.add(objectName);
                    } else if (type2.equals("GlobalRequestProcessor")) {
                        this.globalRequestProcessors.add(objectName);
                    } else if (type2.equals("RequestProcessor")) {
                        this.requestProcessors.add(objectName);
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered") && (type = objectName.getKeyProperty("type")) != null) {
                if (type.equals("ThreadPool")) {
                    this.threadPools.remove(objectName);
                } else if (type.equals("GlobalRequestProcessor")) {
                    this.globalRequestProcessors.remove(objectName);
                } else if (type.equals("RequestProcessor")) {
                    this.requestProcessors.remove(objectName);
                }
            }
        }
    }
}

