/**
 * @author Jorge Bay Gondra
 */
import * as t from '../../process/traversal.cjs';
import * as ts from '../../process/traversal-strategy.cjs';
import Bytecode from '../../process/bytecode.cjs';
import * as g from '../graph.cjs';
import * as utils from '../../utils.cjs';
export declare const valueKey = "@value";
export declare const typeKey = "@type";
export type SerializedValue = {
    [typeKey]: string;
    [valueKey]: any;
};
/**
 * @abstract
 */
export declare class TypeSerializer<T = any> {
    reader: any;
    writer: any;
    serialize(value: T): T | SerializedValue;
    deserialize<TObject extends SerializedValue>(value: TObject): T;
    canBeUsedFor?(value: unknown): boolean;
}
export declare class NumberSerializer extends TypeSerializer<number> {
    serialize(item: number): number | {
        "@type": string;
        "@value": string;
    };
    deserialize(obj: SerializedValue): number;
    canBeUsedFor(value: unknown): boolean;
}
export declare class DateSerializer extends TypeSerializer<Date> {
    serialize(item: Date): {
        "@type": string;
        "@value": number;
    };
    deserialize(obj: SerializedValue): Date;
    canBeUsedFor(value: unknown): boolean;
}
export declare class LongSerializer extends TypeSerializer<utils.Long> {
    serialize(item: utils.Long): {
        "@type": string;
        "@value": string | number;
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class BytecodeSerializer extends TypeSerializer<Bytecode> {
    serialize(item: Bytecode): SerializedValue;
    _serializeInstructions(instructions: any[]): any[] | null;
    canBeUsedFor(value: unknown): boolean;
}
export declare class PSerializer extends TypeSerializer<t.P> {
    /** @param {P} item */
    serialize(item: t.P): SerializedValue;
    canBeUsedFor(value: unknown): boolean;
}
export declare class TextPSerializer extends TypeSerializer<t.TextP> {
    /** @param {TextP} item */
    serialize(item: t.TextP): SerializedValue;
    canBeUsedFor(value: unknown): boolean;
}
export declare class LambdaSerializer extends TypeSerializer<() => unknown[]> {
    /** @param {Function} item */
    serialize(item: () => any[]): {
        "@type": string;
        "@value": {
            arguments: number;
            language: any;
            script: any;
        };
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class EnumSerializer extends TypeSerializer<t.EnumValue> {
    /** @param {EnumValue} item */
    serialize(item: t.EnumValue): {
        "@type": string;
        "@value": string;
    };
    canBeUsedFor(value: unknown): any;
}
export declare class TraverserSerializer extends TypeSerializer<t.Traverser> {
    /** @param {Traverser} item */
    serialize(item: t.Traverser): {
        "@type": string;
        "@value": {
            value: any;
            bulk: any;
        };
    };
    deserialize(obj: SerializedValue): t.Traverser<any>;
    canBeUsedFor(value: unknown): boolean;
}
export declare class TraversalStrategySerializer extends TypeSerializer<ts.TraversalStrategy> {
    /** @param {TraversalStrategy} item */
    serialize(item: ts.TraversalStrategy): {
        "@type": string;
        "@value": any;
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class VertexSerializer extends TypeSerializer<g.Vertex> {
    deserialize(obj: SerializedValue): g.Vertex<any, Record<string, any>, any, any>;
    /** @param {Vertex} item */
    serialize(item: g.Vertex): {
        "@type": string;
        "@value": {
            id: any;
            label: string;
        };
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class VertexPropertySerializer extends TypeSerializer<g.VertexProperty> {
    deserialize(obj: SerializedValue): g.VertexProperty<any, any, any, any>;
}
export declare class PropertySerializer extends TypeSerializer<g.Property> {
    deserialize(obj: SerializedValue): g.Property<any>;
}
export declare class EdgeSerializer extends TypeSerializer<g.Edge> {
    deserialize(obj: SerializedValue): g.Edge<g.Vertex<any, Record<string, any>, any, {
        [x: string]: [g.VertexProperty<string, any, Record<string, any>, any>, ...g.VertexProperty<string, any, Record<string, any>, any>[]];
    }>, any, g.Vertex<any, Record<string, any>, any, {
        [x: string]: [g.VertexProperty<string, any, Record<string, any>, any>, ...g.VertexProperty<string, any, Record<string, any>, any>[]];
    }>, any, any>;
    /** @param {Edge} item */
    serialize(item: g.Edge): {
        "@type": string;
        "@value": {
            id: any;
            label: string;
            outV: any;
            outVLabel: string;
            inV: any;
            inVLabel: string;
        };
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class PathSerializer extends TypeSerializer<g.Path> {
    deserialize(obj: SerializedValue): g.Path;
}
export declare class Path3Serializer extends TypeSerializer<g.Path> {
    deserialize(obj: SerializedValue): g.Path;
}
export declare class TSerializer extends TypeSerializer<t.EnumValue> {
    deserialize(obj: SerializedValue): t.EnumValue;
}
export declare class DirectionSerializer extends TypeSerializer<t.EnumValue> {
    deserialize(obj: SerializedValue): t.EnumValue;
}
declare class ArraySerializer extends TypeSerializer<unknown[]> {
    readonly typeKey: string;
    constructor(typeKey: string);
    deserialize(obj: SerializedValue): any[];
    /** @param {Array} item */
    serialize(item: unknown[]): {
        "@type": string;
        "@value": any[];
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class BulkSetSerializer extends TypeSerializer<unknown> {
    deserialize(obj: SerializedValue): unknown[];
}
export declare class MapSerializer extends TypeSerializer<Map<unknown, unknown>> {
    deserialize(obj: SerializedValue): Map<any, any>;
    /** @param {Map} map */
    serialize(map: Map<unknown, unknown>): {
        "@type": string;
        "@value": unknown[];
    };
    canBeUsedFor(value: unknown): boolean;
}
export declare class ListSerializer extends ArraySerializer {
    constructor();
}
export declare class SetSerializer extends ArraySerializer {
    constructor();
    deserialize(obj: SerializedValue): any;
    serialize(item: unknown[]): {
        "@type": string;
        "@value": any[];
    };
    canBeUsedFor(value: unknown): boolean;
}
export {};
