/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;

public class VertexSerializer
extends SimpleTypeSerializer<Vertex> {
    public VertexSerializer() {
        super(DataType.VERTEX);
    }

    @Override
    protected Vertex readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Object id = context.read(buffer);
        String label = context.readValue(buffer, String.class, false);
        List properties = (List)context.read(buffer);
        DetachedVertex.Builder builder = DetachedVertex.build().setId(id).setLabel(label);
        if (properties != null) {
            for (DetachedVertexProperty vp : properties) {
                builder.addProperty(vp);
            }
        }
        return builder.create();
    }

    @Override
    protected void writeValue(Vertex value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value.id(), buffer);
        context.writeValue(value.label(), buffer, false);
        if (value.properties(new String[0]) == null) {
            context.write(null, buffer);
        } else {
            List asList = IteratorUtils.toList(value.properties(new String[0]));
            context.write(asList, buffer);
        }
    }
}

