/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public abstract class StringLocalStep<S, E>
extends ScalarMapStep<S, E> {
    public StringLocalStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Object item = traverser.get();
        if (null == item) {
            return null;
        }
        if (item instanceof Iterable || item instanceof Iterator || item.getClass().isArray()) {
            ArrayList<E> resList = new ArrayList<E>();
            Iterator iterator = IteratorUtils.asIterator(item);
            while (iterator.hasNext()) {
                Object i = iterator.next();
                if (null == i) {
                    resList.add(null);
                    continue;
                }
                if (i instanceof String) {
                    resList.add(this.applyStringOperation((String)i));
                    continue;
                }
                throw new IllegalArgumentException(String.format("The %s step can only take string or list of strings, encountered %s in list", this.getStepName(), i.getClass()));
            }
            return (E)resList;
        }
        if (item instanceof String) {
            return this.applyStringOperation((String)item);
        }
        throw new IllegalArgumentException(String.format("The %s step can only take string or list of strings, encountered %s", this.getStepName(), item.getClass()));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    protected abstract E applyStringOperation(String var1);

    protected abstract String getStepName();
}

