/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.StringLocalStep;

public final class SplitLocalStep<S, E>
extends StringLocalStep<S, E>
implements TraversalParent {
    private final String separator;

    public SplitLocalStep(Traversal.Admin traversal, String separator) {
        super(traversal);
        this.separator = separator;
    }

    @Override
    protected E applyStringOperation(String item) {
        return (E)Arrays.asList(StringUtils.splitByWholeSeparator((String)item, (String)this.separator));
    }

    @Override
    public String getStepName() {
        return "split(local)";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (null != this.separator ? this.separator.hashCode() : 0);
        return result;
    }
}

