/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphCountStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphStepStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.services.TinkerServiceRegistry;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElementContainer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransaction;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransactionalIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessLimitedStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessLimitedComputerSuite")})
public final class TinkerTransactionGraph
extends AbstractTinkerGraph {
    private static final Configuration EMPTY_CONFIGURATION;
    private final TinkerGraphFeatures features = new TinkerGraphFeatures();
    private final TinkerTransaction transaction = new TinkerTransaction(this);
    protected Map<Object, TinkerElementContainer<TinkerVertex>> vertices = new ConcurrentHashMap<Object, TinkerElementContainer<TinkerVertex>>();
    protected Map<Object, TinkerElementContainer<TinkerEdge>> edges = new ConcurrentHashMap<Object, TinkerElementContainer<TinkerEdge>>();

    private TinkerTransactionGraph(Configuration configuration) {
        this.configuration = configuration;
        this.vertexIdManager = TinkerTransactionGraph.selectIdManager(configuration, "gremlin.tinkergraph.vertexIdManager", Vertex.class);
        this.edgeIdManager = TinkerTransactionGraph.selectIdManager(configuration, "gremlin.tinkergraph.edgeIdManager", Edge.class);
        this.vertexPropertyIdManager = TinkerTransactionGraph.selectIdManager(configuration, "gremlin.tinkergraph.vertexPropertyIdManager", VertexProperty.class);
        this.defaultVertexPropertyCardinality = VertexProperty.Cardinality.valueOf((String)configuration.getString("gremlin.tinkergraph.defaultVertexPropertyCardinality", VertexProperty.Cardinality.single.name()));
        this.allowNullPropertyValues = configuration.getBoolean("gremlin.tinkergraph.allowNullPropertyValues", false);
        this.graphLocation = configuration.getString("gremlin.tinkergraph.graphLocation", null);
        this.graphFormat = configuration.getString("gremlin.tinkergraph.graphFormat", null);
        if (this.graphLocation != null && null == this.graphFormat || null == this.graphLocation && this.graphFormat != null) {
            throw new IllegalStateException(String.format("The %s and %s must both be specified if either is present", "gremlin.tinkergraph.graphLocation", "gremlin.tinkergraph.graphFormat"));
        }
        if (this.graphLocation != null) {
            this.loadGraph();
        }
        this.serviceRegistry = new TinkerServiceRegistry(this);
        configuration.getList(String.class, "gremlin.tinkergraph.service", Collections.emptyList()).forEach(serviceClass -> this.serviceRegistry.registerService(this.instantiate((String)serviceClass)));
    }

    public static TinkerTransactionGraph open() {
        return TinkerTransactionGraph.open(EMPTY_CONFIGURATION);
    }

    public static TinkerTransactionGraph open(Configuration configuration) {
        return new TinkerTransactionGraph(configuration);
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Object idValue = this.vertexIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
        if (null == idValue) {
            idValue = this.vertexIdManager.getNextId(this);
        }
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        this.tx().readWrite();
        long txNumber = this.transaction.getTxNumber();
        TinkerElementContainer newContainer = new TinkerElementContainer(idValue);
        TinkerElementContainer<TinkerVertex> container = this.vertices.putIfAbsent(idValue, newContainer);
        if (container != null && container.get() != null) {
            throw Graph.Exceptions.vertexWithIdAlreadyExists(idValue);
        }
        if (container == null) {
            container = newContainer;
        }
        TinkerVertex vertex = new TinkerVertex(idValue, label, this, txNumber);
        ElementHelper.attachProperties((Vertex)vertex, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])keyValues);
        container.setDraft(vertex, (TinkerTransaction)this.tx());
        return vertex;
    }

    @Override
    public void removeVertex(Object vertexId) {
        if (!this.vertices.containsKey(vertexId)) {
            return;
        }
        TinkerElementContainer<TinkerVertex> container = this.vertices.get(vertexId);
        if (null != container) {
            container.markDeleted((TinkerTransaction)this.tx());
        }
    }

    @Override
    public void touch(TinkerVertex vertex) {
        if (null == vertex || !this.vertices.containsKey(vertex.id())) {
            return;
        }
        TinkerElementContainer<TinkerVertex> container = this.vertices.get(vertex.id());
        if (null != container) {
            this.tx().readWrite();
            container.touch(vertex, (TinkerTransaction)this.tx());
        }
    }

    @Override
    public void touch(TinkerEdge edge) {
        if (null == edge || !this.edges.containsKey(edge.id())) {
            return;
        }
        TinkerElementContainer<TinkerEdge> container = this.edges.get(edge.id());
        if (null != container) {
            this.tx().readWrite();
            container.touch(edge, (TinkerTransaction)this.tx());
        }
    }

    @Override
    public Edge addEdge(TinkerVertex outVertex, TinkerVertex inVertex, String label, Object ... keyValues) {
        ElementHelper.validateLabel((String)label);
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Object idValue = this.edgeIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
        if (null == idValue) {
            idValue = this.edgeIdManager.getNextId(this);
        }
        this.tx().readWrite();
        long txNumber = this.transaction.getTxNumber();
        TinkerElementContainer newContainer = new TinkerElementContainer(idValue);
        TinkerElementContainer<TinkerEdge> container = this.edges.putIfAbsent(idValue, newContainer);
        if (container != null && container.get() != null) {
            throw Graph.Exceptions.vertexWithIdAlreadyExists(idValue);
        }
        if (container == null) {
            container = newContainer;
        }
        TinkerEdge edge = new TinkerEdge(idValue, outVertex, label, inVertex, txNumber);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        container.setDraft(edge, (TinkerTransaction)this.tx());
        this.addOutEdge(outVertex, label, edge);
        this.addInEdge(inVertex, label, edge);
        return edge;
    }

    @Override
    public void removeEdge(Object edgeId) {
        Set<Object> edges;
        if (!this.edges.containsKey(edgeId)) {
            return;
        }
        TinkerElementContainer<TinkerEdge> container = this.edges.get(edgeId);
        if (null == container || container.isDeleted()) {
            return;
        }
        TinkerEdge edge = container.get();
        if (edge == null) {
            return;
        }
        TinkerVertex outVertex = (TinkerVertex)edge.outVertex();
        this.touch(outVertex);
        TinkerVertex inVertex = (TinkerVertex)edge.inVertex();
        this.touch(inVertex);
        if (null != outVertex && null != outVertex.outEdgesId && null != (edges = outVertex.outEdgesId.get(edge.label()))) {
            edges.removeIf(e -> e == edge.id());
        }
        if (null != inVertex && null != inVertex.inEdgesId && null != (edges = inVertex.inEdgesId.get(edge.label()))) {
            edges.removeIf(e -> e == edge.id());
        }
        container.markDeleted((TinkerTransaction)this.tx());
    }

    @Override
    public void clear() {
        super.clear();
        this.vertices.clear();
        this.edges.clear();
    }

    @Override
    public Transaction tx() {
        return this.transaction;
    }

    @Override
    public int getVerticesCount() {
        return (int)this.vertices.entrySet().stream().filter(v -> ((TinkerElementContainer)v.getValue()).get() != null).count();
    }

    @Override
    public boolean hasVertex(Object id) {
        return null != this.vertex(id);
    }

    Map<Object, TinkerElementContainer<TinkerVertex>> getVertices() {
        return this.vertices;
    }

    @Override
    public int getEdgesCount() {
        return (int)this.edges.entrySet().stream().filter(v -> ((TinkerElementContainer)v.getValue()).get() != null).count();
    }

    @Override
    public boolean hasEdge(Object id) {
        return null != this.edge(id);
    }

    Map<Object, TinkerElementContainer<TinkerEdge>> getEdges() {
        return this.edges;
    }

    public TinkerServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public Vertex vertex(Object vertexId) {
        TinkerElementContainer<TinkerVertex> container = this.vertices.get(this.vertexIdManager.convert(vertexId));
        return container == null ? null : (Vertex)container.getWithClone();
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.createElementIterator(Vertex.class, this.vertices, this.vertexIdManager, vertexIds);
    }

    @Override
    public Edge edge(Object edgeId) {
        TinkerElementContainer<TinkerEdge> container = this.edges.get(this.edgeIdManager.convert(edgeId));
        return container == null ? null : (Edge)container.getWithClone();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.createElementIterator(Edge.class, this.edges, this.edgeIdManager, edgeIds);
    }

    private <T extends Element, C extends TinkerElement> Iterator<T> createElementIterator(Class<T> clazz, Map<Object, TinkerElementContainer<C>> elements, AbstractTinkerGraph.IdManager idManager, Object ... ids) {
        this.tx().readWrite();
        if (0 != ids.length) {
            List<Object> idList = Arrays.asList(ids);
            return new TinkerGraphIterator(IteratorUtils.filter(IteratorUtils.map(idList, id -> {
                if (null == id) {
                    return null;
                }
                Object iid = clazz.isAssignableFrom(id.getClass()) ? ((Element)clazz.cast(id)).id() : idManager.convert(id);
                TinkerElementContainer container = (TinkerElementContainer)elements.get(iid);
                return container == null ? null : (Element)container.getWithClone();
            }).iterator(), Objects::nonNull));
        }
        TinkerGraphIterator iterator = new TinkerGraphIterator(elements.values().stream().map(c -> c.getWithClone()).filter(e -> e != null).iterator());
        return TinkerHelper.inComputerMode(this) ? (clazz.equals(Vertex.class) ? IteratorUtils.filter(iterator, t -> this.graphComputerView.legalVertex((Vertex)t)) : IteratorUtils.filter(iterator, t -> this.graphComputerView.legalEdge(t.outVertex(), (Edge)t))) : iterator;
    }

    @Override
    protected void addOutEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Object> edges;
        this.touch(vertex);
        if (null == vertex.outEdgesId) {
            vertex.outEdgesId = new ConcurrentHashMap<String, Set<Object>>();
        }
        if (null == (edges = vertex.outEdgesId.get(label))) {
            edges = ConcurrentHashMap.newKeySet();
            vertex.outEdgesId.put(label, edges);
        }
        edges.add(edge.id());
    }

    @Override
    protected void addInEdge(TinkerVertex vertex, String label, Edge edge) {
        Set<Object> edges;
        this.touch(vertex);
        if (null == vertex.inEdgesId) {
            vertex.inEdgesId = new ConcurrentHashMap<String, Set<Object>>();
        }
        if (null == (edges = vertex.inEdgesId.get(label))) {
            edges = ConcurrentHashMap.newKeySet();
            vertex.inEdgesId.put(label, edges);
        }
        edges.add(edge.id());
    }

    public Graph.Features features() {
        return this.features;
    }

    public <E extends Element> void createIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null == this.vertexIndex) {
                this.vertexIndex = new TinkerTransactionalIndex<TinkerVertex>(this, TinkerVertex.class);
            }
            this.vertexIndex.createKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null == this.edgeIndex) {
                this.edgeIndex = new TinkerTransactionalIndex<TinkerEdge>(this, TinkerEdge.class);
            }
            this.edgeIndex.createKeyIndex(key);
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> void dropIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null != this.vertexIndex) {
                this.vertexIndex.dropKeyIndex(key);
            }
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null != this.edgeIndex) {
                this.edgeIndex.dropKeyIndex(key);
            }
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    @Override
    public <E extends Element> Set<String> getIndexedKeys(Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return null == this.vertexIndex ? Collections.emptySet() : this.vertexIndex.getIndexedKeys();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return null == this.edgeIndex ? Collections.emptySet() : this.edgeIndex.getIndexedKeys();
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(TinkerTransactionGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{TinkerGraphStepStrategy.instance(), TinkerGraphCountStrategy.instance()}));
        EMPTY_CONFIGURATION = new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", TinkerTransactionGraph.class.getName());
            }
        };
    }

    public class TinkerGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        private TinkerGraphGraphFeatures() {
        }

        public boolean supportsConcurrentAccess() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }

        public boolean supportsTransactions() {
            return true;
        }

        public boolean supportsServiceCall() {
            return true;
        }
    }

    public class TinkerGraphFeatures
    implements Graph.Features {
        private final TinkerGraphGraphFeatures graphFeatures;
        private final AbstractTinkerGraph.TinkerGraphEdgeFeatures edgeFeatures;
        private final AbstractTinkerGraph.TinkerGraphVertexFeatures vertexFeatures;

        private TinkerGraphFeatures() {
            this.graphFeatures = new TinkerGraphGraphFeatures();
            this.edgeFeatures = new AbstractTinkerGraph.TinkerGraphEdgeFeatures();
            this.vertexFeatures = new AbstractTinkerGraph.TinkerGraphVertexFeatures();
        }

        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

