/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;

public class TextPlainMessageSerializer
implements MessageTextSerializer<Function<Object, String>> {
    public Function<Object, String> getMapper() {
        return Objects::toString;
    }

    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not produce binary");
    }

    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not produce binary");
    }

    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }

    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }

    public String[] mimeTypesSupported() {
        return new String[]{"text/plain"};
    }

    public String serializeResponseAsString(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        StringBuilder sb = new StringBuilder();
        List data = (List)responseMessage.getResult().getData();
        for (int ix = 0; ix < data.size(); ++ix) {
            sb.append("==>");
            sb.append(data.get(ix));
            if (ix >= data.size() - 1) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String serializeRequestAsString(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not have any need to serialize requests");
    }

    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }

    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }
}

