/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

class CollectionSerializer
extends SimpleTypeSerializer<Collection> {
    public CollectionSerializer(DataType dataType) {
        super(dataType);
    }

    @Override
    protected Collection readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int length = buffer.readInt();
        ArrayList result = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            result.add(context.read(buffer));
        }
        return result;
    }

    @Override
    protected void writeValue(Collection value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(value.size());
        for (Object item : value) {
            context.write(item, buffer);
        }
    }
}

