/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/


//********************************************************************************
//* Do NOT edit this file directly - generated by build/generate.groovy
//********************************************************************************

package gremlingo

import (
	 "errors"
	 "math"
	 "github.com/apache/tinkerpop/gremlin-go/v3/driver"
)

var translationMap = map[string][]func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal{
    "g_V_branchXlabel_eq_person__a_bX_optionXa__ageX_optionXb__langX_optionXb__nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(p["l1"]).Option("a", gremlingo.T__.Values("age")).Option("b", gremlingo.T__.Values("lang")).Option("b", gremlingo.T__.Values("name"))}}, 
    "g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(gremlingo.T__.Label().Is("person").Count()).Option(p["xx1"], gremlingo.T__.Values("age")).Option(p["xx2"], gremlingo.T__.Values("lang")).Option(p["xx2"], gremlingo.T__.Values("name"))}}, 
    "g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX_optionXany__labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(gremlingo.T__.Label().Is("person").Count()).Option(p["xx1"], gremlingo.T__.Values("age")).Option(p["xx2"], gremlingo.T__.Values("lang")).Option(p["xx2"], gremlingo.T__.Values("name")).Option(gremlingo.Pick.Any, gremlingo.T__.Label())}}, 
    "g_V_branchXageX_optionXltX30X__youngX_optionXgtX30X__oldX_optionXnone__on_the_edgeX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Branch(gremlingo.T__.Values("age")).Option(gremlingo.P.Lt(30), gremlingo.T__.Constant("young")).Option(gremlingo.P.Gt(30), gremlingo.T__.Constant("old")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("on the edge"))}}, 
    "g_V_branchXidentityX_optionXhasLabelXsoftwareX__inXcreatedX_name_order_foldX_optionXhasXname_vadasX__ageX_optionXneqX123X__bothE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Branch(gremlingo.T__.Identity()).Option(gremlingo.T__.HasLabel("software"), gremlingo.T__.In("created").Values("name").Order().Fold()).Option(gremlingo.T__.Has("name", "vadas"), gremlingo.T__.Values("age")).Option(gremlingo.P.Neq(123), gremlingo.T__.BothE().Count())}}, 
    "g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Out().Count()).Option(p["xx1"], gremlingo.T__.Values("name")).Option(p["xx2"], gremlingo.T__.Values("age"))}}, 
    "g_V_chooseXlabel_eqXpersonX__outXknowsX__inXcreatedXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(p["pred1"], gremlingo.T__.Out("knows"), gremlingo.T__.In("created")).Values("name")}}, 
    "g_V_chooseXhasLabelXpersonX_and_outXcreatedX__outXknowsX__identityX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.HasLabel("person").And().Out("created"), gremlingo.T__.Out("knows"), gremlingo.T__.Identity()).Values("name")}}, 
    "g_V_chooseXlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label()).Option("blah", gremlingo.T__.Out("knows")).Option("bleep", gremlingo.T__.Out("created")).Option(gremlingo.Pick.None, gremlingo.T__.Identity()).Values("name")}}, 
    "g_V_chooseXoutXknowsX_count_isXgtX0XX__outXknowsXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Out("knows").Count().Is(gremlingo.P.Gt(0)), gremlingo.T__.Out("knows")).Values("name")}}, 
    "g_V_hasLabelXpersonX_asXp1X_chooseXoutEXknowsX__outXknowsXX_asXp2X_selectXp1_p2X_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p1").Choose(gremlingo.T__.OutE("knows"), gremlingo.T__.Out("knows")).As("p2").Select("p1", "p2").By("name")}}, 
    "g_V_hasLabelXpersonX_chooseXageX__optionX27L__constantXyoungXX_optionXnone__constantXoldXX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Choose(gremlingo.T__.Values("age")).Option(p["xx1"], gremlingo.T__.Constant("young")).Option(gremlingo.Pick.None, gremlingo.T__.Constant("old")).GroupCount()}}, 
    "g_injectX1X_chooseXisX1X__constantX10Xfold__foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx2"]).Choose(gremlingo.T__.Is(p["xx2"]), gremlingo.T__.Constant(p["xx1"]).Fold(), gremlingo.T__.Fold())}}, 
    "g_injectX2X_chooseXisX1X__constantX10Xfold__foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx3"]).Choose(gremlingo.T__.Is(p["xx2"]), gremlingo.T__.Constant(p["xx1"]).Fold(), gremlingo.T__.Fold())}}, 
    "g_V_localXpropertiesXlocationX_order_byXvalueX_limitX2XX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Properties("location").Order().By(gremlingo.T.Value, gremlingo.Order.Asc).Range(0, 2)).Value()}}, 
    "g_V_hasXlabel_personX_asXaX_localXoutXcreatedX_asXbXX_selectXa_bX_byXnameX_byXidX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, "person").As("a").Local(gremlingo.T__.Out("created").As("b")).Select("a", "b").By("name").By(gremlingo.T.Id)}}, 
    "g_V_localXoutE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Count())}}, 
    "g_VX1X_localXoutEXknowsX_limitX1XX_inV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Local(gremlingo.T__.OutE("knows").Limit(1)).InV().Values("name")}}, 
    "g_V_localXbothEXcreatedX_limitX1XX_otherV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.BothE("created").Limit(1)).OtherV().Values("name")}}, 
    "g_VX4X_localXbothEX1_createdX_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE("created").Limit(1))}}, 
    "g_VX4X_localXbothEXknows_createdX_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE("knows", "created").Limit(1))}}, 
    "g_VX4X_localXbothE_limitX1XX_otherV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1)).OtherV().Values("name")}}, 
    "g_VX4X_localXbothE_limitX2XX_otherV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(2)).OtherV().Values("name")}}, 
    "g_V_localXinEXknowsX_limitX2XX_outV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.InE("knows").Limit(2)).OutV().Values("name")}}, 
    "g_V_localXmatchXproject__created_person__person_name_nameX_selectXname_projectX_by_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.Match(gremlingo.T__.As("project").In("created").As("person"), gremlingo.T__.As("person").Values("name").As("name"))).Select("name", "project").By().By("name")}}, 
    "g_VX2X_optionalXoutXknowsXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Optional(gremlingo.T__.Out("knows"))}}, 
    "g_VX2X_optionalXinXknowsXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Optional(gremlingo.T__.In("knows"))}}, 
    "g_V_hasLabelXpersonX_optionalXoutXknowsX_optionalXoutXcreatedXXX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Optional(gremlingo.T__.Out("knows").Optional(gremlingo.T__.Out("created"))).Path()}}, 
    "g_V_optionalXout_optionalXoutXX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Optional(gremlingo.T__.Out().Optional(gremlingo.T__.Out())).Path()}}, 
    "g_VX1X_optionalXaddVXdogXX_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Optional(gremlingo.T__.AddV("dog")).Label()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_repeatXoutX_timesX2X_emit_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Emit().Path()}}, 
    "g_V_repeatXoutX_timesX2X_repeatXinX_timesX2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Repeat(gremlingo.T__.In()).Times(2).Values("name")}}, 
    "g_V_repeatXoutE_inVX_timesX2X_path_by_name_by_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.OutE().InV()).Times(2).Path().By("name").By(gremlingo.T.Label)}}, 
    "g_V_repeatXoutX_timesX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2)}}, 
    "g_V_repeatXoutX_timesX2X_emit": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Emit()}}, 
    "g_VX1X_timesX2X_repeatXoutX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Times(2).Repeat(gremlingo.T__.Out()).Values("name")}}, 
    "g_V_emit_timesX2X_repeatXoutX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit().Times(2).Repeat(gremlingo.T__.Out()).Path()}}, 
    "g_V_emit_repeatXoutX_timesX2X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit().Repeat(gremlingo.T__.Out()).Times(2).Path()}}, 
    "g_VX1X_emitXhasXlabel_personXX_repeatXoutX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Emit(gremlingo.T__.Has(gremlingo.T.Label, "person")).Repeat(gremlingo.T__.Out()).Values("name")}}, 
    "g_V_repeatXgroupCountXmX_byXnameX_outX_timesX2X_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.GroupCount("m").By("name").Out()).Times(2).Cap("m")}}, 
    "g_VX1X_repeatXgroupCountXmX_byXloopsX_outX_timesX3X_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.GroupCount("m").By(gremlingo.T__.Loops()).Out()).Times(3).Cap("m")}}, 
    "g_V_repeatXbothX_timesX10X_asXaX_out_asXbX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(10).As("a").Out().As("b").Select("a", "b").Count()}}, 
    "g_VX1X_repeatXoutX_untilXoutE_count_isX0XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Out()).Until(gremlingo.T__.OutE().Count().Is(0)).Values("name")}}, 
    "g_V_repeatXbothX_untilXname_eq_marko_or_loops_gt_1X_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Until(p["pred1"]).GroupCount().By("name")}}, 
    "g_V_hasXname_markoX_repeatXoutE_inV_simplePathX_untilXhasXname_rippleXX_path_byXnameX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Repeat(gremlingo.T__.OutE().InV().SimplePath()).Until(gremlingo.T__.Has("name", "ripple")).Path().By("name").By(gremlingo.T.Label)}}, 
    "g_V_hasXloop_name_loopX_repeatXinX_timesX5X_path_by_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("loops", "name", "loop").Repeat(gremlingo.T__.In()).Times(5).Path().By("name")}}, 
    "g_V_repeatXout_repeatXout_order_byXname_descXX_timesX1XX_timesX1X_limitX1X_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().Repeat(gremlingo.T__.Out().Order().By("name", gremlingo.Order.Desc)).Times(1)).Times(1).Limit(1).Path().By("name")}}, 
    "g_V_repeatXoutXknowsXX_untilXrepeatXoutXcreatedXX_emitXhasXname_lopXXX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out("knows")).Until(gremlingo.T__.Repeat(gremlingo.T__.Out("created")).Emit(gremlingo.T__.Has("name", "lop"))).Path().By("name")}}, 
    "g_V_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Repeat(gremlingo.T__.Out("created")).Until(gremlingo.T__.Has("name", "ripple"))).Emit().Values("lang")}}, 
    "g_V_untilXconstantXtrueXX_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Constant(true)).Repeat(gremlingo.T__.Repeat(gremlingo.T__.Out("created")).Until(gremlingo.T__.Has("name", "ripple"))).Emit().Values("lang")}}, 
    "g_V_emit_repeatXa_outXknows_filterXloops_isX0XX_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit().Repeat("a", gremlingo.T__.Out("knows").Filter(gremlingo.T__.Loops("a").Is(0))).Values("lang")}}, 
    "g_VX3X_repeatXbothX_createdXX_untilXloops_is_40XXemit_repeatXin_knowsXX_emit_loopsXisX1Xdedup_values": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).Repeat(gremlingo.T__.Both("created")).Until(gremlingo.T__.Loops().Is(40)).Emit(gremlingo.T__.Repeat(gremlingo.T__.In("knows")).Emit(gremlingo.T__.Loops().Is(1))).Dedup().Values("name")}}, 
    "g_VX1X_repeatXrepeatXunionXout_uses_out_traversesXX_whereXloops_isX0X_timesX1X_timeX2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Repeat(gremlingo.T__.Union(gremlingo.T__.Out("uses"), gremlingo.T__.Out("traverses")).Where(gremlingo.T__.Loops().Is(0))).Times(1)).Times(2).Values("name")}}, 
    "g_V_repeatXa_outXknows_repeatXb_outXcreatedX_filterXloops_isX0XX_emit_lang": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat("a", gremlingo.T__.Out("knows").Repeat("b", gremlingo.T__.Out("created").Filter(gremlingo.T__.Loops("a").Is(0))).Emit()).Emit().Values("lang")}}, 
    "g_VX6X_repeatXa_bothXcreatedX_simplePathX_emitXrepeatXb_bothXknowsXX_untilXloopsXbX_asXb_whereXloopsXaX_asXbX_hasXname_vadasXX_dedup_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).Repeat("a", gremlingo.T__.Both("created").SimplePath()).Emit(gremlingo.T__.Repeat("b", gremlingo.T__.Both("knows")).Until(gremlingo.T__.Loops("b").As("b").Where(gremlingo.T__.Loops("a").As("b"))).Has("name", "vadas")).Dedup().Values("name")}}, 
    "g_V_unionXout__inX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Out(), gremlingo.T__.In()).Values("name")}}, 
    "g_VX1X_unionXrepeatXoutX_timesX2X__outX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Union(gremlingo.T__.Repeat(gremlingo.T__.Out()).Times(2), gremlingo.T__.Out()).Values("name")}}, 
    "g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label().Is("person"), gremlingo.T__.Union(gremlingo.T__.Out().Values("lang"), gremlingo.T__.Out().Values("name")), gremlingo.T__.In().Label())}}, 
    "g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.Label().Is("person"), gremlingo.T__.Union(gremlingo.T__.Out().Values("lang"), gremlingo.T__.Out().Values("name")), gremlingo.T__.In().Label()).GroupCount()}}, 
    "g_V_unionXrepeatXunionXoutXcreatedX__inXcreatedXX_timesX2X__repeatXunionXinXcreatedX__outXcreatedXX_timesX2XX_label_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Repeat(gremlingo.T__.Union(gremlingo.T__.Out("created"), gremlingo.T__.In("created"))).Times(2), gremlingo.T__.Repeat(gremlingo.T__.Union(gremlingo.T__.In("created"), gremlingo.T__.Out("created"))).Times(2)).Label().GroupCount()}}, 
    "g_VX1_2X_unionXoutE_count__inE_count__outE_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"]).Union(gremlingo.T__.OutE().Count(), gremlingo.T__.InE().Count(), gremlingo.T__.OutE().Values("weight").Sum())}}, 
    "g_VX1_2X_localXunionXoutE_count__inE_count__outE_weight_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"]).Local(gremlingo.T__.Union(gremlingo.T__.OutE().Count(), gremlingo.T__.InE().Count(), gremlingo.T__.OutE().Values("weight").Sum()))}}, 
    "g_VX1_2X_localXunionXcountXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"]).Local(gremlingo.T__.Union(gremlingo.T__.Count()))}}, 
    "g_V_andXhasXage_gt_27X__outE_count_gte_2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().And(gremlingo.T__.Has("age", gremlingo.P.Gt(27)), gremlingo.T__.OutE().Count().Is(gremlingo.P.Gte(2))).Values("name")}}, 
    "g_V_andXoutE__hasXlabel_personX_and_hasXage_gte_32XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().And(gremlingo.T__.OutE(), gremlingo.T__.Has(gremlingo.T.Label, "person").And().Has("age", gremlingo.P.Gte(32))).Values("name")}}, 
    "g_V_asXaX_outXknowsX_and_outXcreatedX_inXcreatedX_asXaX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").And().Out("created").In("created").As("a").Values("name")}}, 
    "g_V_asXaX_andXselectXaX_selectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").And(gremlingo.T__.Select("a"), gremlingo.T__.Select("a"))}}, 
    "g_V_hasXname_markoX_and_hasXname_markoX_and_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").And().Has("name", "marko").And().Has("name", "marko")}}, 
    "g_V_coinX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coin(1.0)}}, 
    "g_V_coinX0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coin(0.0)}}, 
    "g_withStrategiesXSeedStrategyX_V_order_byXnameX_coinX50X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Order().By("name").Coin(0.5)}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_cyclicPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").CyclicPath()}}, 
    "g_VX1X_both_both_cyclicPath_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Both().Both().CyclicPath().By("age")}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_cyclicPath_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").CyclicPath().Path()}}, 
    "g_VX1X_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_cyclicPath_fromXaX_toXbX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").As("b").In("created").As("c").CyclicPath().From("a").To("b").Path()}}, 
    "g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_cyclicPath_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).V().Both().Coalesce(gremlingo.T__.Has("name", "marko").Both(), gremlingo.T__.Constant(0)).CyclicPath().Path()}}, 
    "g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().In().Values("name").Fold().Dedup(gremlingo.Scope.Local).Unfold()}}, 
    "g_V_out_in_valuesXnameX_fold_dedupXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Map(gremlingo.T__.In().Values("name").Fold().Dedup(gremlingo.Scope.Local))}}, 
    "g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().As("x").In().As("y").Select("x", "y").By("name").Fold().Dedup(gremlingo.Scope.Local, "x", "y").Unfold()}}, 
    "g_V_both_dedup_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Dedup().Values("name")}}, 
    "g_V_both_hasXlabel_softwareX_dedup_byXlangX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Has(gremlingo.T.Label, "software").Dedup().By("lang").Values("name")}}, 
    "g_V_both_name_order_byXa_bX_dedup_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties("name").Order().By(p["c1"]).Dedup().Value()}}, 
    "g_V_both_both_name_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Values("name").Dedup()}}, 
    "g_V_both_both_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Dedup()}}, 
    "g_V_both_both_dedup_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Dedup().By(gremlingo.T.Label)}}, 
    "g_V_group_byXlabelX_byXbothE_weight_dedup_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Values("weight").Dedup().Order().By(gremlingo.Order.Asc).Fold())}}, 
    "g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Both().As("b").Dedup("a", "b").By(gremlingo.T.Label).Select("a", "b")}}, 
    "g_V_asXaX_out_asXbX_in_asXcX_dedupXa_bX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").As("a").AddV("person").Property("name", "bob").As("b").AddV("person").Property("name", "carol").As("c").AddE("knows").From("a").To("b").AddE("likes").From("a").To("b").AddE("likes").From("a").To("c")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").In().As("c").Dedup("a", "b").Path().By("name")}}, 
    "g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().As("e").InV().As("v").Select("e").Order().By("weight", gremlingo.Order.Asc).Select("v").Values("name").Dedup()}}, 
    "g_V_both_both_dedup_byXoutE_countX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Dedup().By(gremlingo.T__.OutE().Count()).Values("name")}}, 
    "g_V_groupCount_selectXvaluesX_unfold_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().Select(gremlingo.Column.Values).Unfold().Dedup()}}, 
    "g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Repeat(gremlingo.T__.Both()).Times(3).Emit().Values("name").As("b").Group().By(gremlingo.T__.Select("a")).By(gremlingo.T__.Select("b").Dedup().Order().Fold()).Select(gremlingo.Column.Values).Unfold().Dedup()}}, 
    "g_V_repeatXdedupX_timesX2X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Dedup()).Times(2).Count()}}, 
    "g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Group().By().By(gremlingo.T__.Out().Dedup().Fold()).Unfold().Select(gremlingo.Column.Values).Unfold().Out().Order().By("name").Limit(1).Values("name")}}, 
    "g_V_bothE_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().Count()}}, 
    "g_V_both_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().Count()}}, 
    "g_V_both_properties_properties_dedup_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Properties().Dedup().Count()}}, 
    "g_V_order_byXname_descX_barrier_dedup_age_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", gremlingo.Order.Desc).Barrier().Dedup().By("age").Values("name")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_order_byXname_descX_barrier_dedup_age_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Order().By("name", gremlingo.Order.Desc).Barrier().Dedup().By("age").Values("name")}}, 
    "g_V_both_dedup_age_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Dedup().By("age").Values("name")}}, 
    "g_VX1X_asXaX_both_asXbX_both_asXcX_dedupXa_bX_age_selectXa_b_cX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Both().As("b").Both().As("c").Dedup("a", "b").By("age").Select("a", "b", "c").By("name")}}, 
    "g_VX1X_valuesXageX_dedupXlocalX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Dedup(gremlingo.Scope.Local).Unfold()}}, 
    "g_V_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().As("a").AddV().As("b").AddE("knows").To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_V_outE_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().As("a").AddV().As("b").AddE("knows").To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_V_properties_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "bob").AddV().Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties()}}, 
    "g_E_propertiesXweightX_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties("weight").Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties()}}, 
    "g_V_properties_propertiesXstartTimeX_drop": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "bob").Property(gremlingo.Cardinality.List, "location", "ny", "startTime", 2014, "endTime", 2016).Property(gremlingo.Cardinality.List, "location", "va", "startTime", 2016).AddV().Property("name", "alice").Property(gremlingo.Cardinality.List, "location", "va", "startTime", 2014, "endTime", 2016).Property(gremlingo.Cardinality.List, "location", "ny", "startTime", 2016)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Properties("startTime").Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Properties()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Properties("startTime")}}, 
    "g_V_filterXfalseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(p["pred1"])}}, 
    "g_V_filterXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(p["pred1"])}}, 
    "g_V_filterXlang_eq_javaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(p["pred1"])}}, 
    "g_VX1X_filterXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Filter(p["pred1"])}}, 
    "g_VX2X_filterXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).Filter(p["pred1"])}}, 
    "g_VX1X_out_filterXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Filter(p["pred1"])}}, 
    "g_V_filterXname_startsWith_m_OR_name_startsWith_pX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Filter(p["pred1"])}}, 
    "g_E_filterXfalseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Filter(p["pred1"])}}, 
    "g_E_filterXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Filter(p["pred1"])}}, 
    "g_V_outXcreatedX_hasXname__mapXlengthX_isXgtX3XXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Has("name", gremlingo.T__.Map(p["l1"]).Is(gremlingo.P.Gt(3))).Values("name")}}, 
    "g_VX1X_hasXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name")}}, 
    "g_VX1X_hasXcircumferenceX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("circumference")}}, 
    "g_VX1X_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name", "marko")}}, 
    "g_VX2X_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("name", "marko")}}, 
    "g_V_hasXname_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko")}}, 
    "g_V_hasXname_blahX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "blah")}}, 
    "g_V_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Gt(30))}}, 
    "g_V_hasXage_isXgt_30XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.T__.Is(gremlingo.P.Gt(30)))}}, 
    "g_V_hasXlabel_isXsoftwareXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, gremlingo.T__.Is("software"))}}, 
    "g_VX1X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VX4X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VXv1X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VXv4X_hasXage_gt_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v4"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_VX1X_out_hasXid_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v2"]).Has("age", gremlingo.P.Gt(30))}}, 
    "g_V_hasXblahX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("blah")}}, 
    "g_V_hasXperson_name_markoX_age": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Values("age")}}, 
    "g_VX1X_outE_hasXweight_inside_0_06X_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().Has("weight", gremlingo.P.Gt(0.0).And(gremlingo.P.Lt(0.6))).InV()}}, 
    "g_EX11X_outV_outE_hasXid_10X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).OutV().OutE().Has(gremlingo.T.Id, p["eid10"])}}, 
    "g_EX11X_outV_outE_hasXid_10AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).OutV().OutE().Has(gremlingo.T.Id, p["eid10"])}}, 
    "g_V_hasXlocationX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("location")}}, 
    "g_V_hasXage_withinX27X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Within([]interface{}{27})).Count()}}, 
    "g_V_hasXage_withinX27_nullX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Within([]interface{}{27, nil})).Count()}}, 
    "g_V_hasXage_withinX27_29X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Within([]interface{}{27, 29})).Count()}}, 
    "g_V_hasXage_withoutX27X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Without([]interface{}{27})).Count()}}, 
    "g_V_hasXage_withoutX27_29X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Without([]interface{}{27, 29})).Count()}}, 
    "g_V_hasXperson_age_withinX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", gremlingo.P.Within([]interface{}{}))}}, 
    "g_V_hasXperson_age_withoutX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", gremlingo.P.Without([]interface{}{}))}}, 
    "g_V_hasXname_containingXarkXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Containing("ark"))}}, 
    "g_V_hasXname_startingWithXmarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.StartingWith("mar"))}}, 
    "g_V_hasXname_endingWithXasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.EndingWith("as"))}}, 
    "g_V_hasXperson_name_containingXoX_andXltXmXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", gremlingo.TextP.Containing("o").And(gremlingo.P.Lt("m")))}}, 
    "g_V_hasXname_gtXmX_andXcontainingXoXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.P.Gt("m").And(gremlingo.TextP.Containing("o")))}}, 
    "g_V_hasXname_not_containingXarkXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotContaining("ark"))}}, 
    "g_V_hasXname_not_startingWithXmarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotStartingWith("mar"))}}, 
    "g_V_hasXname_not_endingWithXasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotEndingWith("as"))}}, 
    "g_V_hasXname_regexXrMarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Regex("^mar"))}}, 
    "g_V_hasXname_notRegexXrMarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.NotRegex("^mar"))}}, 
    "g_V_hasXname_regexXTinkerXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("software").Property("name", "Apache TinkerPop\u00A9")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Regex("Tinker")).Values("name")}}, 
    "g_V_hasXname_regexXTinkerUnicodeXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("software").Property("name", "Apache TinkerPop\u00A9")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.TextP.Regex("Tinker.*\u00A9")).Values("name")}}, 
    "g_V_hasXp_neqXvXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("p", gremlingo.P.Neq("v"))}}, 
    "g_V_hasXage_gtX18X_andXltX30XXorXgtx35XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Gt(18).And(gremlingo.P.Lt(30)).Or(gremlingo.P.Gt(35)))}}, 
    "g_V_hasXage_gtX18X_andXltX30XXorXltx35XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", gremlingo.P.Gt(18).And(gremlingo.P.Lt(30)).And(gremlingo.P.Lt(35)))}}, 
    "g_V_hasXk_withinXcXX_valuesXkX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("k", "\u8F49\u6CE8").AddV().Property("k", "\u2726").AddV().Property("k", "\u2660").AddV().Property("k", "A")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("k", gremlingo.P.Within([]interface{}{"\u8F49\u6CE8", "\u2726", "\u2660"})).Values("k")}}, 
    "g_V_hasXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(nil)}}, 
    "g_V_hasXnull_testnullkeyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(nil, "test-null-key")}}, 
    "g_E_hasXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has(nil)}}, 
    "g_V_hasXlabel_personX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, "person")}}, 
    "g_V_hasXlabel_eqXpersonXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, gremlingo.P.Eq("person"))}}, 
    "g_V_hasXlabel_isXpersonXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, gremlingo.T__.Is("person"))}}, 
    "g_V_hasXname_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", nil)}}, 
    "g_V_hasIdXemptyX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["xx1"]).Count()}}, 
    "g_V_hasIdXwithinXemptyXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["xx1"]).Count()}}, 
    "g_V_hasIdXwithoutXemptyXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["xx1"]).Count()}}, 
    "g_V_notXhasIdXwithinXemptyXXX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.HasId(p["xx1"])).Count()}}, 
    "g_V_hasIdXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(nil)}}, 
    "g_V_hasIdXeqXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(gremlingo.P.Eq(nil))}}, 
    "g_V_hasIdX2_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid2"], nil)}}, 
    "g_V_hasIdX2AsString_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid2"], nil)}}, 
    "g_V_hasIdX1AsString_2AsString_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"], p["vid2"], nil)}}, 
    "g_V_hasIdXnull_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(nil, p["vid2"])}}, 
    "g_V_hasIdX1X_hasIdX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"]).HasId(p["vid2"])}}, 
    "g_V_in_hasIdXneqX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().In().HasId(p["xx1"])}}, 
    "g_VX1X_out_hasIdX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"])}}, 
    "g_VX1X_out_hasXid_2_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"], p["vid3"])}}, 
    "g_VX1X_out_hasXid_2AsString_3AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"], p["vid3"])}}, 
    "g_VX1AsStringX_out_hasXid_2AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["vid2"])}}, 
    "g_VX1X_out_hasXid_2_3X_inList": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().HasId(p["xx1"])}}, 
    "g_V_hasXid_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["vid1"], p["vid2"])}}, 
    "g_V_hasXid_1_2X_inList": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasId(p["xx1"])}}, 
    "g_V_both_dedup_properties_hasKeyXageX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().HasKey("age").Value()}}, 
    "g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().HasKey("age").HasValue(gremlingo.P.Gt(30)).Value()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Properties().Dedup().HasKey("age").HasValue(gremlingo.P.Gt(30)).Value()}}, 
    "g_V_bothE_properties_dedup_hasKeyXweightX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().HasKey("weight").Value()}}, 
    "g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().HasKey("weight").HasValue(gremlingo.P.Lt(0.3)).Value()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().BothE().Properties().Dedup().HasKey("weight").HasValue(gremlingo.P.Lt(0.3)).Value()}}, 
    "g_V_properties_hasKeyXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasKey(nil)}}, 
    "g_V_properties_hasKeyXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasKey(nil, nil)}}, 
    "g_V_properties_hasKeyXnull_ageX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasKey(nil, "age").Value()}}, 
    "g_E_properties_hasKeyXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().HasKey(nil)}}, 
    "g_E_properties_hasKeyXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().HasKey(nil, nil)}}, 
    "g_E_properties_hasKeyXnull_weightX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().HasKey(nil, "weight").Value()}}, 
    "g_EX7X_hasLabelXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid7"]).HasLabel("knows")}}, 
    "g_E_hasLabelXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows")}}, 
    "g_E_hasLabelXuses_traversesX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("uses", "traverses")}}, 
    "g_V_hasLabelXperson_software_blahX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person", "software", "blah")}}, 
    "g_V_hasLabelXpersonX_hasLabelXsoftwareX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").HasLabel("software")}}, 
    "g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Has("age", gremlingo.P.Gt(10).Or(gremlingo.P.Gte(11).And(gremlingo.P.Lt(20))).And(gremlingo.P.Lt(29).Or(gremlingo.P.Eq(35)))).Values("name")}}, 
    "g_V_hasLabelXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(nil)}}, 
    "g_V_hasXlabel_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has(gremlingo.T.Label, nil)}}, 
    "g_V_hasLabelXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(nil, nil)}}, 
    "g_V_hasLabelXnull_personX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel(nil, "person")}}, 
    "g_E_hasLabelXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel(nil)}}, 
    "g_E_hasXlabel_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has(gremlingo.T.Label, nil)}}, 
    "g_V_properties_hasLabelXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasLabel(nil)}}, 
    "g_V_hasNotXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasNot("age").Values("name")}}, 
    "g_V_properties_hasValueXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasValue(nil)}}, 
    "g_V_properties_hasValueXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasValue(nil, nil)}}, 
    "g_V_properties_hasValueXnull_joshX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().HasValue(nil, "josh").Value()}}, 
    "g_V_valuesXageX_isX32X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(32)}}, 
    "g_V_valuesXageX_isXlte_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Lte(30))}}, 
    "g_V_valuesXageX_isXgte_29X_isXlt_34X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Is(gremlingo.P.Gte(29)).Is(gremlingo.P.Lt(34))}}, 
    "g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.In("created").Count().Is(1)).Values("name")}}, 
    "g_V_whereXinXcreatedX_count_isXgte_2XX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.In("created").Count().Is(gremlingo.P.Gte(2))).Values("name")}}, 
    "g_V_orXhasXage_gt_27X__outE_count_gte_2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.Has("age", gremlingo.P.Gt(27)), gremlingo.T__.OutE().Count().Is(gremlingo.P.Gte(2))).Values("name")}}, 
    "g_V_orXoutEXknowsX__hasXlabel_softwareX_or_hasXage_gte_35XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.OutE("knows"), gremlingo.T__.Has(gremlingo.T.Label, "software").Or().Has("age", gremlingo.P.Gte(35))).Values("name")}}, 
    "g_V_asXaX_orXselectXaX_selectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Or(gremlingo.T__.Select("a"), gremlingo.T__.Select("a"))}}, 
    "g_VX1X_out_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Limit(2)}}, 
    "g_V_localXoutE_limitX1X_inVX_limitX3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Limit(1)).InV().Limit(3)}}, 
    "g_VX1X_outXknowsX_outEXcreatedX_rangeX0_1X_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").OutE("created").Range(0, 1).InV()}}, 
    "g_VX1X_outXknowsX_outXcreatedX_rangeX0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows").Out("created").Range(0, 1)}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_rangeX1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").Range(1, 3)}}, 
    "g_VX1X_outXcreatedX_inEXcreatedX_rangeX1_3X_outV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").InE("created").Range(1, 3).OutV()}}, 
    "g_V_repeatXbothX_timesX3X_rangeX5_11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(3).Range(5, 11)}}, 
    "g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("b").In().As("c").Select("a", "b", "c").By("name").Limit(gremlingo.Scope.Local, 2)}}, 
    "g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("b").In().As("c").Select("a", "b", "c").By("name").Limit(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Range(gremlingo.Scope.Local, 1, 3)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Range(gremlingo.Scope.Local, 1, 2)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_rangeXlocal_1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Range(gremlingo.Scope.Local, 1, 3)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_rangeXlocal_1_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Range(gremlingo.Scope.Local, 1, 2)}}, 
    "g_V_hasLabelXpersonX_order_byXageX_skipX1X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age").Skip(1).Values("name")}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_rangeXlocal_4_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Range(gremlingo.Scope.Local, 4, 5)}}, 
    "g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").Fold().Order(gremlingo.Scope.Local).Skip(gremlingo.Scope.Local, 2)}}, 
    "g_V_asXaX_in_asXaX_in_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_limitXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("a").In().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Limit(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_in_asXaX_in_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_limitXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In().As("a").In().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Limit(gremlingo.Scope.Local, 2)}}, 
    "g_V_hasLabelXpersonX_order_byXageX_valuesXnameX_skipX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age").Values("name").Skip(1)}}, 
    "g_VX1X_valuesXageX_rangeXlocal_20_30X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Range(gremlingo.Scope.Local, 20, 30)}}, 
    "g_V_mapXin_hasIdX1XX_limitX2X_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.In().HasId(p["vid1"])).Limit(2).Values("name")}}, 
    "g_E_sampleX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Sample(1)}}, 
    "g_E_sampleX2X_byXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Sample(2).By("weight")}}, 
    "g_V_localXoutE_sampleX1X_byXweightXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Sample(1).By("weight"))}}, 
    "g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_sampleX2X_foldXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Values("weight").Order().Sample(2).Fold()).Unfold()}}, 
    "g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_fold_sampleXlocal_5XXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Values("weight").Order().Fold().Sample(gremlingo.Scope.Local, 5)).Unfold()}}, 
    "g_withStrategiesXSeedStrategyX_V_order_byXlabel_descX_sampleX1X_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SeedStrategy(gremlingo.SeedStrategyConfig{Seed: 999999})).V().Order().By(gremlingo.T.Label, gremlingo.Order.Desc).Sample(1).By("age")}}, 
    "g_VX1X_valuesXageX_sampleXlocal_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Sample(gremlingo.Scope.Local, 5)}}, 
    "g_VX1X_outXcreatedX_inXcreatedX_simplePath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").In("created").SimplePath()}}, 
    "g_V_repeatXboth_simplePathX_timesX3X_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both().SimplePath()).Times(3).Path()}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_simplePath_byXlabelX_fromXbX_toXcX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").SimplePath().By(gremlingo.T.Label).From("b").To("c").Path().By("name")}}, 
    "g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_simplePath_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).V().Both().Coalesce(gremlingo.T__.Has("name", "marko").Both(), gremlingo.T__.Constant(0)).SimplePath().Path()}}, 
    "g_V_both_asXaX_both_asXbX_simplePath_path_byXageX__fromXaX_toXbX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().As("a").Both().As("b").SimplePath().Path().By("age").From("a").To("b")}}, 
    "g_V_valuesXnameX_order_tailXglobal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(gremlingo.Scope.Global, 2)}}, 
    "g_V_valuesXnameX_order_tailX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(2)}}, 
    "g_V_valuesXnameX_order_tail": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail()}}, 
    "g_V_valuesXnameX_order_tailX7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().Tail(7)}}, 
    "g_V_repeatXbothX_timesX3X_tailX7X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(3).Tail(7)}}, 
    "g_V_repeatXin_outX_timesX3X_tailX7X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.In().Out()).Times(3).Tail(7).Count()}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select("a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select("a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Tail(gremlingo.Scope.Local, 2)}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Select("a", "b", "c").By("name").Tail(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXlimitXlocal_0XX_tailXlocal_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Limit(gremlingo.Scope.Local, 0)).Tail(gremlingo.Scope.Local, 1)}}, 
    "g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").Out().As("a").Select(gremlingo.Pop.Mixed, "a").By(gremlingo.T__.Unfold().Values("name").Fold()).Tail(gremlingo.Scope.Local, 2)}}, 
    "g_VX1X_valuesXageX_tailXlocal_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Tail(gremlingo.Scope.Local, 50)}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_eqXbXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where("a", gremlingo.P.Eq("b"))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_neqXbXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where("a", gremlingo.P.Neq("b"))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXb_hasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where(gremlingo.T__.As("b").Has("name", "marko"))}}, 
    "g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_outXknowsX_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").As("a").Out().In().Has("age").As("b").Select("a", "b").Where(gremlingo.T__.As("a").Out("knows").As("b"))}}, 
    "g_V_asXaX_outXcreatedX_whereXasXaX_name_isXjoshXX_inXcreatedX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").Where(gremlingo.T__.As("a").Values("name").Is("josh")).In("created").Values("name")}}, 
    "g_withSideEffectXa_josh_peterX_VX1X_outXcreatedX_inXcreatedX_name_whereXwithinXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", p["xx1"]).V(p["vid1"]).Out("created").In("created").Values("name").Where(gremlingo.P.Within([]interface{}{"a"}))}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_neqXbXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").As("b").Where("a", gremlingo.P.Neq("b")).Values("name")}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXasXbX_outXcreatedX_hasXname_rippleXX_valuesXage_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").As("b").Where(gremlingo.T__.As("b").Out("created").Has("name", "ripple")).Values("age", "name")}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXeqXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").Where(gremlingo.P.Eq("a")).Values("name")}}, 
    "g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").In("created").Where(gremlingo.P.Neq("a")).Values("name")}}, 
    "g_VX1X_out_aggregateXxX_out_whereXnotXwithinXaXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Aggregate("x").Out().Where(gremlingo.P.Without([]interface{}{"x"}))}}, 
    "g_withSideEffectXa_g_VX2XX_VX1X_out_whereXneqXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", p["v2"]).V(p["vid1"]).Out().Where(gremlingo.P.Neq("a"))}}, 
    "g_VX1X_repeatXbothEXcreatedX_whereXwithoutXeXX_aggregateXeX_otherVX_emit_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.BothE("created").Where(gremlingo.P.Without([]interface{}{"e"})).Aggregate("e").OtherV()).Emit().Path()}}, 
    "g_V_whereXnotXoutXcreatedXXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Not(gremlingo.T__.Out("created"))).Values("name")}}, 
    "g_V_asXaX_out_asXbX_whereXandXasXaX_outXknowsX_asXbX__orXasXbX_outXcreatedX_hasXname_rippleX__asXbX_inXknowsX_count_isXnotXeqX0XXXXX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Where(gremlingo.T__.And(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.Or(gremlingo.T__.As("b").Out("created").Has("name", "ripple"), gremlingo.T__.As("b").In("knows").Count().Is(gremlingo.P.Neq(0))))).Select("a", "b")}}, 
    "g_V_whereXoutXcreatedX_and_outXknowsX_or_inXknowsXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Out("created").And().Out("knows").Or().In("knows")).Values("name")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_whereXandXasXbX_in__notXasXaX_outXcreatedX_hasXname_rippleXXX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").Where(gremlingo.T__.And(gremlingo.T__.As("b").In(), gremlingo.T__.Not(gremlingo.T__.As("a").Out("created").Has("name", "ripple")))).Select("a", "b")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_bothXknowsX_bothXknowsX_asXdX_whereXc__notXeqXaX_orXeqXdXXXX_selectXa_b_c_dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").In("created").As("c").Both("knows").Both("knows").As("d").Where("c", gremlingo.P.Neq("a").And(gremlingo.P.Neq("d"))).Select("a", "b", "c", "d")}}, 
    "g_V_asXaX_out_asXbX_whereXin_count_isXeqX3XX_or_whereXoutXcreatedX_and_hasXlabel_personXXX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Where(gremlingo.T__.As("b").In().Count().Is(gremlingo.P.Eq(3)).Or().Where(gremlingo.T__.As("b").Out("created").And().As("b").Has(gremlingo.T.Label, "person"))).Select("a", "b")}}, 
    "g_V_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_gtXbXX_byXageX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").In("created").As("b").Where("a", gremlingo.P.Gt("b")).By("age").Select("a", "b").By("name")}}, 
    "g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_whereXa_gtXbX_orXeqXbXXX_byXageX_byXweightX_byXweightX_selectXa_cX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").OutE("created").As("b").InV().As("c").Where("a", gremlingo.P.Gt("b").Or(gremlingo.P.Eq("b"))).By("age").By("weight").By("weight").Select("a", "c").By("name")}}, 
    "g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_inXcreatedX_asXdX_whereXa_ltXbX_orXgtXcXX_andXneqXdXXX_byXageX_byXweightX_byXinXcreatedX_valuesXageX_minX_selectXa_c_dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").OutE("created").As("b").InV().As("c").In("created").As("d").Where("a", gremlingo.P.Lt("b").Or(gremlingo.P.Gt("c")).And(gremlingo.P.Neq("d"))).By("age").By("weight").By(gremlingo.T__.In("created").Values("age").Min()).Select("a", "c", "d").By("name")}}, 
    "g_VX1X_asXaX_out_hasXageX_whereXgtXaXX_byXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out().Has("age").Where(gremlingo.P.Gt("a")).By("age").Values("name")}}, 
    "g_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).As("a").In().Out().As("b").Where("a", gremlingo.P.Eq("b")).By("age").Values("name")}}, 
    "g_withStrategiesXProductiveByStrategyX_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V(p["vid3"]).As("a").In().Out().As("b").Where("a", gremlingo.P.Eq("b")).By("age").Values("name")}}, 
    "g_V_asXnX_whereXorXhasLabelXsoftwareX_hasLabelXpersonXXX_selectXnX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("n").Where(gremlingo.T__.Or(gremlingo.T__.HasLabel("software"), gremlingo.T__.HasLabel("person"))).Select("n").By("name")}}, 
    "g_V_asXnX_whereXorXselectXnX_hasLabelXsoftwareX_selectXnX_hasLabelXpersonXXX_selectXnX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("n").Where(gremlingo.T__.Or(gremlingo.T__.Select("n").HasLabel("software"), gremlingo.T__.Select("n").HasLabel("person"))).Select("n").By("name")}}, 
    "g_V_coworker": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).Aggregate("p").As("p1").Values("name").As("p1n").Select("p").Unfold().Where(gremlingo.P.Neq("p1")).As("p2").Values("name").As("p2n").Select("p2").Out("created").Choose(gremlingo.T__.In("created").Where(gremlingo.P.Eq("p1")), gremlingo.T__.Values("name"), gremlingo.T__.Constant(p["xx1"])).Group().By(gremlingo.T__.Select("p1n")).By(gremlingo.T__.Group().By(gremlingo.T__.Select("p2n")).By(gremlingo.T__.Unfold().Fold().Project("numCoCreated", "coCreated").By(gremlingo.T__.Count(gremlingo.Scope.Local)).By())).Unfold()}}, 
    "g_V_coworker_with_midV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).As("p1").V().HasLabel("person").Where(gremlingo.P.Neq("p1")).Filter(gremlingo.T__.OutE("created")).As("p2").Map(gremlingo.T__.Out("created").Where(gremlingo.T__.In("created").As("p1")).Values("name").Fold()).Group().By(gremlingo.T__.Select("p1").By("name")).By(gremlingo.T__.Group().By(gremlingo.T__.Select("p2").By("name")).By(gremlingo.T__.Project("numCoCreated", "coCreated").By(gremlingo.T__.Count(gremlingo.Scope.Local)).By())).Unfold()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).V().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a", "b"), WritePartition: "a"})).V().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("c"), WritePartition: "a"})).V().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_bothE_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).V().BothE().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_bothE_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("b"), WritePartition: "a"})).V().BothE().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_bothE_dedup_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a", "b"), WritePartition: "a"})).V().BothE().Dedup().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_bothE_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("c"), WritePartition: "a"})).V().BothE().Values("weight")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).V().Both().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("b"), WritePartition: "a"})).V().Both().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_both_dedup_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a", "b"), WritePartition: "a"})).V().Both().Dedup().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("c"), WritePartition: "a"})).V().Both().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).V().Out().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_in_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("b"), WritePartition: "a"})).V().In().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a", "b"), WritePartition: "a"})).V().Out().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("c"), WritePartition: "a"})).V().Out().Values("name")}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_addVXpersonX_propertyXname_aliceX_addXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).AddV("person").Property("name", "alice").AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectXzeroX_addVXpersonX_propertyXname_aliceX_addXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).Inject(0).AddV("person").Property("name", "alice").AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X_mergeV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).Inject(0).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "a").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0XmergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "a").Property("name", "bob")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).Inject(0).MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeVXlabel_person_name_aliceX_optionXonMatch_name_bobX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "bob").Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV_optionXonCreateX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "b").Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "alice").Has("age", 35).Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X__mergeV_optionXonCreateX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("_partition", "b").Property("name", "alice")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.PartitionStrategy(gremlingo.PartitionStrategyConfig{IncludeMetaProperties: false, PartitionKey: "_partition", ReadPartitions: gremlingo.NewSimpleSet("a"), WritePartition: "a"})).Inject(0).MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "alice").Has("age", 35).Has("_partition", "a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_shortestpath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Both().As("v").Project("src", "tgt", "p").By(gremlingo.T__.Select(gremlingo.Pop.First, "v")).By(gremlingo.T__.Select(gremlingo.Pop.Last, "v")).By(gremlingo.T__.Select(gremlingo.Pop.All, "v")).As("triple").Group("x").By(gremlingo.T__.Select("src", "tgt")).By(gremlingo.T__.Select("p").Fold()).Select("tgt").Barrier().Repeat(gremlingo.T__.Both().As("v").Project("src", "tgt", "p").By(gremlingo.T__.Select(gremlingo.Pop.First, "v")).By(gremlingo.T__.Select(gremlingo.Pop.Last, "v")).By(gremlingo.T__.Select(gremlingo.Pop.All, "v")).As("t").Filter(gremlingo.T__.Select(gremlingo.Pop.All, "p").Count(gremlingo.Scope.Local).As("l").Select(gremlingo.Pop.Last, "t").Select(gremlingo.Pop.All, "p").Dedup(gremlingo.Scope.Local).Count(gremlingo.Scope.Local).Where(gremlingo.P.Eq("l"))).Select(gremlingo.Pop.Last, "t").Not(gremlingo.T__.Select(gremlingo.Pop.All, "p").As("p").Count(gremlingo.Scope.Local).As("l").Select(gremlingo.Pop.All, "x").Unfold().Filter(gremlingo.T__.Select(gremlingo.Column.Keys).Where(gremlingo.P.Eq("t")).By(gremlingo.T__.Select("src", "tgt"))).Filter(gremlingo.T__.Select(gremlingo.Column.Values).Unfold().Or(gremlingo.T__.Count(gremlingo.Scope.Local).Where(gremlingo.P.Lt("l")), gremlingo.T__.Where(gremlingo.P.Eq("p"))))).Barrier().Group("x").By(gremlingo.T__.Select("src", "tgt")).By(gremlingo.T__.Select(gremlingo.Pop.All, "p").Fold()).Select("tgt").Barrier()).Cap("x").Select(gremlingo.Column.Values).Unfold().Unfold().Map(gremlingo.T__.Unfold().Values("name").Fold())}}, 
    "g_withStrategiesXReadOnlyStrategyX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V()}}, 
    "g_withStrategiesXReadOnlyStrategyX_V_outXknowsX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V().Out("knows").Values("name")}}, 
    "g_withStrategiesXReadOnlyStrategyX_addVXpersonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).AddV("person")}}, 
    "g_withStrategiesXReadOnlyStrategyX_addVXpersonX_fromXVX1XX_toXVX2XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).AddE("link").From(gremlingo.T__.V(p["vid1"])).To(gremlingo.T__.V(p["vid2"]))}}, 
    "g_withStrategiesXReadOnlyStrategyX_V_addVXpersonX_fromXVX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V().AddE("link").From(gremlingo.T__.V(p["vid1"]))}}, 
    "g_withStrategiesXReadOnlyStrategyX_V_propertyXname_joshX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).V().Property("name", "josh")}}, 
    "g_withStrategiesXReadOnlyStrategyX_E_propertyXweight_0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ReadOnlyStrategy()).E().Property("weight", 0)}}, 
    "g_V_classic_recommendation": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "DARK STAR").As("a").Out("followedBy").Aggregate("stash").In("followedBy").Where(gremlingo.P.Neq("a").And(gremlingo.P.Without([]interface{}{"stash"}))).GroupCount().Unfold().Project("x", "y", "z").By(gremlingo.T__.Select(gremlingo.Column.Keys).Values("name")).By(gremlingo.T__.Select(gremlingo.Column.Keys).Values("performances")).By(gremlingo.T__.Select(gremlingo.Column.Values)).Order().By(gremlingo.T__.Select("z"), gremlingo.Order.Desc).By(gremlingo.T__.Select("y"), gremlingo.Order.Asc).Limit(5).Aggregate(gremlingo.Scope.Local, "m").Select("x")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).InE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).In()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_localXbothE_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1))}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX11X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).E(p["eid11"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX12X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"}))})).E(p["eid12"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid1"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid1"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outXcreatedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid1"]).Out("knows")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outXcreatedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out("created")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outV_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 1.0).HasLabel("knows"), gremlingo.T__.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid8"]).OutV().OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_hasXname_markoXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.In("knows").Has("name", "marko")})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.In().Has("name", "marko")})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_whereXoutXcreatedX_hasXname_lopXXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.In("knows").Where(gremlingo.T__.Out("created").Has("name", "lop"))})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoX_outXcreatedX_hasXname_lopXXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.In().Where(gremlingo.T__.Has("name", "marko").Out("created").Has("name", "lop"))})).V().Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_orXboth_hasXname_markoX_hasXname_markoXXXX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Or(gremlingo.T__.Both().Has("name", "marko"), gremlingo.T__.Has("name", "marko"))})).V().Where(gremlingo.T__.BothE().Count().Is(gremlingo.P.Neq(0))).Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).InE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).In()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_localXbothE_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1))}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX11X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid11"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX12X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid12"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX9X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid9"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_hasXname_withinXripple_josh_markoXXX_V_asXaX_out_in_asXbX_dedupXa_bX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"ripple", "josh", "marko"}))})).V().As("a").Out().In().As("b").Dedup("a", "b").Values("name")}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().Properties("location").Value()}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().Values("location")}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_propertiesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_value_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().As("a").Properties("location").As("b").Select("a").OutE().Properties().Select("b").Value().Dedup()}}, 
    "g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_valuesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().As("a").Values("location").As("b").Select("a").OutE().Properties().Select("b").Dedup()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Neq("stephen")), VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().Properties("location").Value()}}, 
    "g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Vertices: gremlingo.T__.Has("name", gremlingo.P.Neq("stephen")), VertexProperties: gremlingo.T__.Has("startTime", gremlingo.P.Gt(2005))})).V().Values("location")}}, 
    "g_withStrategiesXSubgraphStrategyXedges_hasLabelXusesX_hasXskill_5XXX_V_outE_valueMap_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: true, Edges: gremlingo.T__.HasLabel("uses").Has("skill", 5)})).V().OutE().ValueMap().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).OutE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).InE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Out()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).In()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Both()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).BothE()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_localXbothE_limitX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).V(p["vid4"]).Local(gremlingo.T__.BothE().Limit(1))}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX11X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid11"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX12X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid12"]).BothV()}}, 
    "g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX9X_bothV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.SubgraphStrategy(gremlingo.SubgraphStrategyConfig{CheckAdjacentVertices: false, Vertices: gremlingo.T__.Has("name", gremlingo.P.Within([]interface{}{"josh", "lop", "ripple"})), Edges: gremlingo.T__.Or(gremlingo.T__.Has("weight", 0.4).HasLabel("created"), gremlingo.T__.Has("weight", 1.0).HasLabel("created"))})).E(p["eid9"]).BothV()}}, 
    "g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").AddE("createdBy").To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE()}}, 
    "g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("created").AddE("createdBy").To("a").Property("weight", 2.0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE().Has("weight", 2.0)}}, 
    "g_V_outE_propertyXweight_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Property("weight", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties("weight")}}, 
    "g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").As("a").Select("x").Unfold().AddE("existsWith").To("a").Property("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE("existsWith").Has("time", "now")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("existsWith")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("existsWith").Has("time", "now")}}, 
    "g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").In("created").Where(gremlingo.P.Neq("a")).As("b").AddE("codeveloper").From("a").To("b").Property("year", 2009)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("codeveloper").Has("year", 2009)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).InE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("codeveloper").Has("year", 2009)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("codeveloper")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("codeveloper").Has("year", 2009)}}, 
    "g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").In("created").AddE("createdBy").From("a").Property("year", 2009).Property("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).InE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("createdBy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}}, 
    "g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("b", p["v6"]).V(p["v1"]).AddE("knows").To("b").Property("weight", 0.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).InE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).BothE("knows").Has("weight", 0.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v6"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v6"]).InE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v6"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v6"]).BothE("knows").Has("weight", 0.5)}}, 
    "g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().As("first").Repeat(gremlingo.T__.AddE("next").To(gremlingo.T__.AddV()).InV()).Times(5).AddE("next").To(gremlingo.T__.Select("first"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("next")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).InE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Limit(1).OutE()}}, 
    "g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").As("a").OutE("created").As("b").InV().AddE(gremlingo.T__.Select("b").Label()).To("a")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).InE("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).In("created").Has("name", "lop")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).OutE("created")}}, 
    "g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE(gremlingo.T__.V().OutE().Label().GroupCount().Order(gremlingo.Scope.Local).By(gremlingo.Column.Values, gremlingo.Order.Desc).Select(gremlingo.Column.Keys).Unfold().Limit(1)).From(gremlingo.T__.V().Has("name", "vadas")).To(gremlingo.T__.V().Has("name", "lop"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v2"]).BothE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v2"]).InE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v2"]).OutE("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v2"]).Out("created").Has("name", "lop")}}, 
    "g_addEXknowsX_fromXaX_toXbX_propertyXweight_0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE("knows").From(p["v1"]).To(p["v6"]).Property("weight", p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).Out("knows").Has("name", "peter")}}, 
    "g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).AddE("knows").To(p["v6"]).Property("weight", p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).OutE("knows")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).Out("knows").Has("name", "peter")}}, 
    "g_addEXknowsXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddE("knows").Property("weight", nil).From(gremlingo.T__.V().Has("name", "marko")).To(gremlingo.T__.V().Has("name", "vadas"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("knows", "weight", nil)}}, 
    "g_VX1X_addVXanimalX_propertyXage_selectXaX_byXageXX_propertyXname_puppyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").AddV("animal").Property("age", gremlingo.T__.Select("a").By("age")).Property("name", "puppy")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("animal", "age", 29)}}, 
    "g_V_addVXanimalX_propertyXage_0X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().AddV("animal").Property("age", 0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("animal", "age", 0)}}, 
    "g_addVXpersonX_propertyXname_stephenX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_V_hasLabelXpersonX_propertyXname_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Property(gremlingo.Cardinality.Single, "name", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name")}}, 
    "g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.Single, "name", "stephen").Property(gremlingo.Cardinality.Single, "name", "stephenm")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephenm")}}, 
    "get_g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.Single, "name", "stephen").Property(gremlingo.Cardinality.Single, "name", "stephenm", "since", 2010)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephenm")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephenm").Properties("name").Has("since", 2010)}}, 
    "g_V_hasXname_markoX_propertyXfriendWeight_outEXknowsX_weight_sum__acl_privateX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Property("friendWeight", gremlingo.T__.OutE("knows").Values("weight").Sum(), "acl", "private")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("friendWeight", 1.5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Has("acl", "private")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Count()}}, 
    "g_addVXanimalX_propertyXname_mateoX_propertyXname_gateoX_propertyXname_cateoX_propertyXage_5X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("animal").Property("name", "mateo").Property("name", "gateo").Property("name", "cateo").Property("age", 5)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "mateo").Has("name", "gateo").Has("name", "cateo").Has("age", 5)}}, 
    "g_withSideEffectXa_markoX_addV_propertyXname_selectXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", "marko").AddV().Property("name", gremlingo.T__.Select("a")).Values("name")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko")}}, 
    "g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.Single, "name", "stephen").Property(gremlingo.Cardinality.Single, "name", "stephenm", "since", 2010)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "stephenm")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "stephenm").Properties("name").Has("since", 2010)}}, 
    "g_V_addVXanimalX_propertyXname_valuesXnameXX_propertyXname_an_animalX_propertyXvaluesXnameX_labelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().AddV("animal").Property("name", gremlingo.T__.Values("name")).Property("name", "an animal").Property(gremlingo.T__.Values("name"), gremlingo.T__.Label())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "marko").Has("name", "an animal").Has("marko", "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "vadas").Has("name", "an animal").Has("vadas", "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "lop").Has("name", "an animal").Has("lop", "software")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "josh").Has("name", "an animal").Has("josh", "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "ripple").Has("name", "an animal").Has("ripple", "software")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("animal").Has("name", "peter").Has("name", "an animal").Has("peter", "person")}}, 
    "g_withSideEffectXa_testX_V_hasLabelXsoftwareX_propertyXtemp_selectXaXX_valueMapXname_tempX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", "test").V().HasLabel("software").Property("temp", gremlingo.T__.Select("a")).ValueMap("name", "temp")}}, 
    "g_withSideEffectXa_nameX_addV_propertyXselectXaX_markoX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", "name").AddV().Property(gremlingo.T__.Select("a"), "marko").Values("name")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko")}}, 
    "g_V_asXaX_hasXname_markoX_outXcreatedX_asXbX_addVXselectXaX_labelX_propertyXtest_selectXbX_labelX_valueMap_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Has("name", "marko").Out("created").As("b").AddV(gremlingo.T__.Select("a").Label()).Property("test", gremlingo.T__.Select("b").Label()).ValueMap().With("~tinkerpop.valueMap.tokens")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "test", "software")}}, 
    "g_addVXV_hasXname_markoX_propertiesXnameX_keyX_label": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV(gremlingo.T__.V().Has("name", "marko").Properties("name").Key()).Label()}}, 
    "g_addV_propertyXlabel_personX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.T.Label, "person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person")}}, 
    "g_addV_propertyXmapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property("name", "foo").Property("age", 42)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo")}}, 
    "g_addV_propertyXsingle_mapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV().Property(gremlingo.Cardinality.Single, "name", "foo").Property(gremlingo.Cardinality.Single, "age", 42)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "foo")}}, 
    "g_addV_propertyXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values()}}, 
    "g_addV_propertyXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values()}}, 
    "g_addV_propertyXset_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("foo")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("foo").Values()}}, 
    "g_addV_propertyXset_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("foo")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values()}}, 
    "g_addVXpersonX_propertyXname_joshX_propertyXage_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "josh").Property("age", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", nil)}}, 
    "g_addVXpersonX_propertyXname_markoX_propertyXfriendWeight_null_acl_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("friendWeight", nil, "acl", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("friendWeight", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Has("acl", nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Properties("friendWeight").Count()}}, 
    "g_V_hasXperson_name_aliceX_propertyXsingle_age_unionXage_constantX1XX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "alice").Property(gremlingo.Cardinality.Single, "age", 50)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "alice").Property("age", gremlingo.T__.Union(gremlingo.T__.Values("age"), gremlingo.T__.Constant(1)).Sum())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", 50)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "age", 51)}}, 
    "g_call": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call()}}, 
    "g_callXlistX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list")}}, 
    "g_callXlistX_withXstring_stringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list").With("service", "tinker.search")}}, 
    "g_callXlistX_withXstring_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list").With("service", gremlingo.T__.Constant("tinker.search"))}}, 
    "g_callXlist_mapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list", p["xx1"])}}, 
    "g_callXlist_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list", gremlingo.T__.Project("service").By(gremlingo.T__.Constant("tinker.search")))}}, 
    "g_callXlist_map_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("--list", p["xx1"], gremlingo.T__.Project("service").By(gremlingo.T__.Constant("tinker.search")))}}, 
    "g_callXsearch_mapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).Element()}}, 
    "g_callXsearch_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", gremlingo.T__.Project("search").By(gremlingo.T__.Constant("vada"))).Element()}}, 
    "g_callXsearchX_withXstring_stringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search").With("search", "vada").Element()}}, 
    "g_callXsearchX_withXstring_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search").With("search", gremlingo.T__.Constant("vada")).Element()}}, 
    "g_callXsearch_mapX_withXstring_VertexX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).With("type", "Vertex").Element()}}, 
    "g_callXsearch_mapX_withXstring_EdgeX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).With("type", "Edge").Element()}}, 
    "g_callXsearch_mapX_withXstring_VertexPropertyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Call("tinker.search", p["xx1"]).With("type", "VertexProperty").Element()}}, 
    "g_V_callXdcX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality").Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_whereXcallXdcXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.Call("tinker.degree.centrality").Is(3))}}, 
    "g_V_callXdcX_withXdirection_OUTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality").With("direction", gremlingo.Direction.Out).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_callXdc_mapX_withXdirection_OUTX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality", p["xx1"]).With("direction", gremlingo.Direction.Out).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_callXdc_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality", gremlingo.T__.Project("direction").By(gremlingo.T__.Constant(gremlingo.Direction.Out))).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_callXdc_map_traversalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Call("tinker.degree.centrality", p["xx1"], gremlingo.T__.Project("direction").By(gremlingo.T__.Constant(gremlingo.Direction.Out))).Project("vertex", "degree").By(gremlingo.T__.Select("v")).By()}}, 
    "g_V_coalesceXoutXfooX_outXbarXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coalesce(gremlingo.T__.Out("foo"), gremlingo.T__.Out("bar"))}}, 
    "g_VX1X_coalesceXoutXknowsX_outXcreatedXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Coalesce(gremlingo.T__.Out("knows"), gremlingo.T__.Out("created")).Values("name")}}, 
    "g_VX1X_coalesceXoutXcreatedX_outXknowsXX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Coalesce(gremlingo.T__.Out("created"), gremlingo.T__.Out("knows")).Values("name")}}, 
    "g_V_coalesceXoutXlikesX_outXknowsX_inXcreatedXX_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coalesce(gremlingo.T__.Out("likes"), gremlingo.T__.Out("knows"), gremlingo.T__.Out("created")).GroupCount().By("name")}}, 
    "g_V_coalesceXoutEXknowsX_outEXcreatedXX_otherV_path_byXnameX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Coalesce(gremlingo.T__.OutE("knows"), gremlingo.T__.OutE("created")).OtherV().Path().By("name").By(gremlingo.T.Label)}}, 
    "g_V_outXcreatedX_order_byXnameX_coalesceXname_constantXxXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Order().By("name").Coalesce(gremlingo.T__.Values("name"), gremlingo.T__.Constant("x"))}}, 
    "g_V_connectedComponent_hasXcomponentX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ConnectedComponent().Has("gremlin.connectedComponentVertexProgram.component")}}, 
    "g_V_dedup_connectedComponent_hasXcomponentX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Dedup().ConnectedComponent().Has("gremlin.connectedComponentVertexProgram.component")}}, 
    "g_V_hasLabelXsoftwareX_connectedComponent_project_byXnameX_byXcomponentX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").ConnectedComponent().Project("name", "component").By("name").By("gremlin.connectedComponentVertexProgram.component")}}, 
    "g_V_connectedComponent_withXEDGES_bothEXknowsXX_withXPROPERTY_NAME_clusterX_project_byXnameX_byXclusterX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").ConnectedComponent().With("~tinkerpop.connectedComponent.edges", gremlingo.T__.BothE("knows")).With("~tinkerpop.connectedComponent.propertyName", "cluster").Project("name", "cluster").By("name").By("cluster")}}, 
    "g_V_constantX123X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Constant(123)}}, 
    "g_V_constantXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Constant(nil)}}, 
    "g_V_chooseXhasLabelXpersonX_valuesXnameX_constantXinhumanXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.HasLabel("person"), gremlingo.T__.Values("name"), gremlingo.T__.Constant("inhuman"))}}, 
    "g_V_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Count()}}, 
    "g_V_out_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Count()}}, 
    "g_V_both_both_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Both().Count()}}, 
    "g_V_fold_countXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Count(gremlingo.Scope.Local)}}, 
    "g_V_hasXnoX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("no").Count()}}, 
    "g_V_whereXinXkknowsX_outXcreatedX_count_is_0XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Where(gremlingo.T__.In("knows").Out("created").Count().Is(0)).Values("name")}}, 
    "g_V_repeatXoutX_timesX8X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(8).Count()}}, 
    "g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(5).As("a").Out("writtenBy").As("b").Select("a", "b").Count()}}, 
    "g_V_repeatXoutX_timesX3X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(3).Count()}}, 
    "g_V_order_byXlangX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("lang").Count()}}, 
    "g_E_sampleX1X_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Sample(1).Count()}}, 
    "g_V_sampleX1X_byXageX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sample(1).By("age").Count()}}, 
    "g_V_order_byXnoX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("no").Count()}}, 
    "g_VX1X_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v2"]).Properties().Element().Limit(1)}}, 
    "g_V_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Element()}}, 
    "g_V_propertiesXageX_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("age").Element()}}, 
    "g_EX_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).Properties().Element().Limit(1)}}, 
    "g_E_properties_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().Element()}}, 
    "g_VXv7_properties_properties_element_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v7"]).Properties().Properties().Element().Element().Limit(1)}}, 
    "g_V_properties_properties_element_element": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v7"]).Properties().Properties().Element().Element()}}, 
    "g_V_elementMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap()}}, 
    "g_V_elementMapXname_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap("name", "age")}}, 
    "g_EX11X_elementMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).ElementMap()}}, 
    "g_V_elementMapXname_age_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ElementMap("name", "age", nil)}}, 
    "g_V_asXaX_flatMapXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").FlatMap(gremlingo.T__.Select("a"))}}, 
    "g_V_fold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold()}}, 
    "g_V_fold_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Unfold()}}, 
    "g_V_age_foldX0_plusX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold(0, gremlingo.Operator.Sum)}}, 
    "g_injectXa1_b2X_foldXm_addAllX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"b": 2}).Fold(map[interface{}]interface{}{}, gremlingo.Operator.AddAll)}}, 
    "g_injectXa1_b2_b4X_foldXm_addAllX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"b": 2}, map[interface{}]interface{}{"b": 4}).Fold(map[interface{}]interface{}{}, gremlingo.Operator.AddAll)}}, 
    "g_VX1X_V_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).V().Values("name")}}, 
    "g_V_outXknowsX_V_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("knows").V().Values("name")}}, 
    "g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("artist", "name", "Garcia").In("sungBy").As("song").V().Has("artist", "name", "Willie_Dixon").In("writtenBy").Where(gremlingo.P.Eq("song")).Values("name")}}, 
    "g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").V(p["xx1"]).AddE("uses").From("p")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).OutE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid3"]).InE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).OutE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid5"]).InE("uses")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid6"]).OutE("uses")}}, 
    "g_V_hasLabelXsoftwareX_index_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Index().Unfold()}}, 
    "g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Order().By("name").Index().With("~tinkerpop.index.indexer", 1)}}, 
    "g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Values("name").Fold().Order(gremlingo.Scope.Local).Index().Unfold().Order().By(gremlingo.T__.Tail(gremlingo.Scope.Local, 1))}}, 
    "g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Values("name").Fold().Order(gremlingo.Scope.Local).Index().With("~tinkerpop.index.indexer", 1)}}, 
    "g_VX1X_valuesXageX_index_unfold_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Index().Unfold().Unfold()}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX3XX_hasXname_peterX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.Has("name", "peter").Or().Loops().Is(3)).Has("name", "peter").Path().By("name")}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX2XX_hasXname_peterX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.Has("name", "peter").Or().Loops().Is(2)).Has("name", "peter").Path().By("name")}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_and_loops_isX3XX_hasXname_peterX_path_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.Has("name", "peter").And().Loops().Is(3)).Has("name", "peter").Path().By("name")}}, 
    "g_V_emitXhasXname_markoX_or_loops_isX2XX_repeatXoutX_valuesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Emit(gremlingo.T__.Has("name", "marko").Or().Loops().Is(2)).Repeat(gremlingo.T__.Out()).Values("name")}}, 
    "g_VX1X_mapXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Map(p["l1"])}}, 
    "g_VX1X_outE_label_mapXlengthX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().Label().Map(p["l1"])}}, 
    "g_VX1X_out_mapXnameX_mapXlengthX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Map(p["l1"]).Map(p["l2"])}}, 
    "g_VX1X_out_mapXlambdaXnameXX_mapXlambdaXlengthXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Map(&gremlingo.Lambda{Script:"it.get().value('name')", Language:""}).Map(&gremlingo.Lambda{Script:"it.get().toString().length()", Language:""})}}, 
    "g_withPath_V_asXaX_out_mapXa_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithPath().V().As("a").Out().Map(p["l1"])}}, 
    "g_withPath_V_asXaX_out_out_mapXa_name_it_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithPath().V().As("a").Out().Out().Map(p["l1"])}}, 
    "g_V_mapXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Map(gremlingo.T__.Select("a"))}}, 
    "g_V_mapXconstantXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.Constant(nil))}}, 
    "g_V_valueMap_matchXa_selectXnameX_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Match(gremlingo.T__.As("a").Select("name").As("b"))}}, 
    "g_V_matchXa_out_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out().As("b"))}}, 
    "g_V_matchXa_out_bX_selectXb_idX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out().As("b")).Select("b").By(gremlingo.T.Id)}}, 
    "g_V_matchXa_knows_b__b_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").As("c"))}}, 
    "g_V_matchXb_created_c__a_knows_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("b").Out("created").As("c"), gremlingo.T__.As("a").Out("knows").As("b"))}}, 
    "g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("b").In("created").As("c")).Where("a", gremlingo.P.Neq("c")).Select("a", "c")}}, 
    "g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("d").In("knows").As("a"), gremlingo.T__.As("d").Has("name", "vadas"), gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").As("c"))}}, 
    "g_V_matchXa_created_lop_b__b_0created_29_c__c_whereXrepeatXoutX_timesX2XXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").Has("name", "lop").As("b"), gremlingo.T__.As("b").In("created").Has("age", 29).As("c"), gremlingo.T__.As("c").Where(gremlingo.T__.Repeat(gremlingo.T__.Out()).Times(2)))}}, 
    "g_V_asXaX_out_asXbX_matchXa_out_count_c__b_in_count_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Match(gremlingo.T__.As("a").Out().Count().As("c"), gremlingo.T__.As("b").In().Count().As("c"))}}, 
    "g_V_matchXa__a_out_b__notXa_created_bXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out().As("b"), gremlingo.T__.Not(gremlingo.T__.As("a").Out("created").As("b")))}}, 
    "g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").Has("name", "lop").As("b"), gremlingo.T__.As("b").In("created").Has("age", 29).As("c")).Where(gremlingo.T__.As("c").Repeat(gremlingo.T__.Out()).Times(2)).Select("a", "b", "c")}}, 
    "g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Match(gremlingo.T__.As("a").In("created").As("b"), gremlingo.T__.As("b").In("knows").As("c")).Select("c").Out("created").Values("name")}}, 
    "g_V_matchXa_knows_b__b_created_c__a_created_cX_dedupXa_b_cX_selectXaX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").As("c"), gremlingo.T__.As("a").Out("created").As("c")).Dedup("a", "b", "c").Select("a").By("name")}}, 
    "g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("a").Repeat(gremlingo.T__.Out()).Times(2).As("b")).Select("a", "b")}}, 
    "g_V_notXmatchXa_age_b__a_name_cX_whereXb_eqXcXX_selectXaXX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Not(gremlingo.T__.Match(gremlingo.T__.As("a").Values("age").As("b"), gremlingo.T__.As("a").Values("name").As("c")).Where("b", gremlingo.P.Eq("c")).Select("a")).Values("name")}}, 
    "g_V_matchXa_knows_b__andXa_created_c__b_created_c__andXb_created_count_d__a_knows_count_dXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.And(gremlingo.T__.As("a").Out("created").As("c"), gremlingo.T__.As("b").Out("created").As("c"), gremlingo.T__.And(gremlingo.T__.As("b").Out("created").Count().As("d"), gremlingo.T__.As("a").Out("knows").Count().As("d"))))}}, 
    "g_V_matchXa_whereXa_neqXcXX__a_created_b__orXa_knows_vadas__a_0knows_and_a_hasXlabel_personXX__b_0created_c__b_0created_count_isXgtX1XXX_selectXa_b_cX_byXidX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.Where("a", gremlingo.P.Neq("c")), gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.Or(gremlingo.T__.As("a").Out("knows").Has("name", "vadas"), gremlingo.T__.As("a").In("knows").And().As("a").Has(gremlingo.T.Label, "person")), gremlingo.T__.As("b").In("created").As("c"), gremlingo.T__.As("b").In("created").Count().Is(gremlingo.P.Gt(1))).Select("a", "b", "c").By(gremlingo.T.Id)}}, 
    "g_V_matchXa__a_both_b__b_both_cX_dedupXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Both().As("b"), gremlingo.T__.As("b").Both().As("c")).Dedup("a", "b")}}, 
    "g_V_matchXa_knows_b__b_created_lop__b_matchXb_created_d__d_0created_cX_selectXcX_cX_selectXa_b_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").Out("created").Has("name", "lop"), gremlingo.T__.As("b").Match(gremlingo.T__.As("b").Out("created").As("d"), gremlingo.T__.As("d").In("created").As("c")).Select("c").As("c")).Select("a", "b", "c")}}, 
    "g_V_matchXa_knows_b__a_created_cX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("a").Out("created").As("c"))}}, 
    "g_V_matchXwhereXandXa_created_b__b_0created_count_isXeqX3XXXX__a_both_b__whereXb_inXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.Where(gremlingo.T__.And(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("b").In("created").Count().Is(gremlingo.P.Eq(3)))), gremlingo.T__.As("a").Both().As("b"), gremlingo.T__.Where(gremlingo.T__.As("b").In()))}}, 
    "g_V_matchXa_outEXcreatedX_order_byXweight_descX_limitX1X_inV_b__b_hasXlang_javaXX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").OutE("created").Order().By("weight", gremlingo.Order.Desc).Limit(1).InV().As("b"), gremlingo.T__.As("b").Has("lang", "java")).Select("a", "b").By("name")}}, 
    "g_V_matchXa_both_b__b_both_cX_dedupXa_bX_byXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Both().As("b"), gremlingo.T__.As("b").Both().As("c")).Dedup("a", "b").By(gremlingo.T.Label)}}, 
    "g_V_matchXa_created_b__b_0created_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("created").As("b"), gremlingo.T__.As("b").In("created").As("a"))}}, 
    "g_V_asXaX_out_asXbX_matchXa_out_count_c__orXa_knows_b__b_in_count_c__and__c_isXgtX2XXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Match(gremlingo.T__.As("a").Out().Count().As("c"), gremlingo.T__.Or(gremlingo.T__.As("a").Out("knows").As("b"), gremlingo.T__.As("b").In().Count().As("c").And().As("c").Is(gremlingo.P.Gt(2))))}}, 
    "g_V_matchXa_knows_count_bX_selectXbX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").Count().As("b")).Select("b")}}, 
    "g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").In("sungBy").As("b"), gremlingo.T__.As("a").In("writtenBy").As("c"), gremlingo.T__.As("b").Out("writtenBy").As("d"), gremlingo.T__.As("c").Out("sungBy").As("d"), gremlingo.T__.As("d").Has("name", "Garcia"))}}, 
    "g_V_matchXa_hasXsong_name_sunshineX__a_mapX0followedBy_weight_meanX_b__a_0followedBy_c__c_filterXweight_whereXgteXbXXX_outV_dX_selectXdX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Has("song", "name", "HERE COMES SUNSHINE"), gremlingo.T__.As("a").Map(gremlingo.T__.InE("followedBy").Values("weight").Mean()).As("b"), gremlingo.T__.As("a").InE("followedBy").As("c"), gremlingo.T__.As("c").Filter(gremlingo.T__.Values("weight").Where(gremlingo.P.Gte("b"))).OutV().As("d")).Select("d").By("name")}}, 
    "g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").In("sungBy").As("b"), gremlingo.T__.As("a").In("sungBy").As("c"), gremlingo.T__.As("b").Out("writtenBy").As("d"), gremlingo.T__.As("c").Out("writtenBy").As("e"), gremlingo.T__.As("d").Has("name", "George_Harrison"), gremlingo.T__.As("e").Has("name", "Bob_Marley"))}}, 
    "g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Has("name", "Garcia"), gremlingo.T__.As("a").In("writtenBy").As("b"), gremlingo.T__.As("a").In("sungBy").As("b"))}}, 
    "g_V_hasLabelXsongsX_matchXa_name_b__a_performances_cX_selectXb_cX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Match(gremlingo.T__.As("a").Values("name").As("b"), gremlingo.T__.As("a").Values("performances").As("c")).Select("b", "c").Count()}}, 
    "g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("followedBy").Count().Is(gremlingo.P.Gt(10)).As("b"), gremlingo.T__.As("a").In("followedBy").Count().Is(gremlingo.P.Gt(10)).As("b")).Count()}}, 
    "g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").In("sungBy").As("b"), gremlingo.T__.As("a").In("writtenBy").As("c"), gremlingo.T__.As("b").Out("writtenBy").As("d")).Where(gremlingo.T__.As("c").Out("sungBy").As("d")).Where(gremlingo.T__.As("d").Has("name", "Garcia"))}}, 
    "g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__b_followedBy_c__c_writtenBy_d__whereXd_neqXaXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Has("name", "Garcia"), gremlingo.T__.As("a").In("writtenBy").As("b"), gremlingo.T__.As("b").Out("followedBy").As("c"), gremlingo.T__.As("c").Out("writtenBy").As("d"), gremlingo.T__.Where("d", gremlingo.P.Neq("a")))}}, 
    "g_V_matchXa_outXknowsX_name_bX_identity": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Match(gremlingo.T__.As("a").Out("knows").Values("name").As("b")).Identity()}}, 
    "g_V_outE_mathX0_minus_itX_byXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Math("0-_").By("weight")}}, 
    "g_V_hasXageX_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").ValueMap().Math("_+_").By(gremlingo.T__.Select("age").Unfold())}}, 
    "g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("b").Math("a + b").By("age")}}, 
    "g_withSideEffectXx_100X_V_age_mathX__plus_xX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("x", p["xx1"]).V().Values("age").Math("_ + x")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_mathXb_plus_aX_byXinXcreatedX_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").Math("b + a").By(gremlingo.T__.In("created").Count()).By("age")}}, 
    "g_withSackX1X_injectX1X_repeatXsackXsumX_byXconstantX1XXX_timesX5X_emit_mathXsin__X_byXsackX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1).Inject(1).Repeat(gremlingo.T__.Sack(gremlingo.Operator.Sum).By(gremlingo.T__.Constant(1))).Times(5).Emit().Math("sin _").By(gremlingo.T__.Sack())}}, 
    "g_V_projectXa_b_cX_byXbothE_weight_sumX_byXbothE_countX_byXnameX_order_byXmathXa_div_bX_descX_selectXcX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Project("a", "b", "c").By(gremlingo.T__.BothE().Values("weight").Sum()).By(gremlingo.T__.BothE().Count()).By("name").Order().By(gremlingo.T__.Math("a / b"), gremlingo.Order.Desc).Select("c")}}, 
    "g_V_mathXit_plus_itXbyXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Math("_+_").By("age")}}, 
    "g_V_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Math("_+_").By(gremlingo.T__.Select("age").Unfold())}}, 
    "g_VX1X_outE_asXexpectedWeightX_mathXexpectedWeightPlusOneXbyXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).OutE().As("expectedWeight").Math("expectedWeight + 1").By("weight")}}, 
    "g_V_age_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Max()}}, 
    "g_V_foo_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Max()}}, 
    "g_V_name_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Max()}}, 
    "g_V_age_fold_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Max(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Max()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Unfold().Max()}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Max(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Max()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Unfold().Max()}}, 
    "g_V_foo_fold_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Max(gremlingo.Scope.Local)}}, 
    "g_V_name_fold_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Max(gremlingo.Scope.Local)}}, 
    "g_V_repeatXbothX_timesX5X_age_max": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(5).Values("age").Max()}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_maxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Max())}}, 
    "g_VX1X_valuesXageX_maxXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Max(gremlingo.Scope.Local)}}, 
    "g_V_age_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Mean()}}, 
    "g_V_foo_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Mean()}}, 
    "g_V_age_fold_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Mean(gremlingo.Scope.Local)}}, 
    "g_V_foo_fold_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Mean(gremlingo.Scope.Local)}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Mean())}}, 
    "g_V_aggregateXaX_byXageX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Mean()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Unfold().Mean()}}, 
    "g_V_aggregateXaX_byXfooX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Mean(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Mean()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Unfold().Mean()}}, 
    "g_injectXnull_10_20_nullX_mean": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, p["xx1"], p["xx2"], nil).Mean()}}, 
    "g_injectXlistXnull_10_20_nullXX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Mean(gremlingo.Scope.Local)}}, 
    "g_VX1X_valuesXageX_meanXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Mean(gremlingo.Scope.Local)}}, 
    "g_V_mergeEXlabel_selfX_optionXonMatch_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeEXlabel_selfX_optionXonMatch_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeEXemptyX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, nil).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeEXemptyX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeEXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(map[interface{}]interface{}{})}}, 
    "g_V_mergeEXemptyX_two_exist": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(p["xx1"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeEXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(nil)}}, 
    "g_V_mergeEXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(nil)}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_withSideEffectXa_label_knows_out_marko_in_vadasX_mergeEXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", p["xx1"]).MergeE(gremlingo.T__.Select("a"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko1_in_vadas1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").OutE("knows").Has("weight", 0.5).InV().Has("person", "name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_injectXlabel_knows_out_marko_in_vadasX_mergeE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).MergeE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_mergeEXlabel_knows_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N").InV().Has("name", "vadas")}}, 
    "g_mergeEXlabel_knows_out_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N").OutV().Has("name", "vadas")}}, 
    "g_mergeEXout_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"]).Option(gremlingo.Merge.OnMatch, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N").OutV().Has("name", "vadas")}}, 
    "g_V_hasXperson_name_marko_X_mergeEXlabel_self_out_vadas1_in_vadas1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("self").BothV().Has("name", "vadas")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx2"]).WithSideEffect("m", p["xx3"]).MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx2"]).WithSideEffect("m", p["xx3"]).MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko1_in_vadas1X_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx2"]).WithSideEffect("m", p["xx3"]).MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_aliased_direction": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
    "g_injectXlabel_knows_out_marko_in_vadas_label_self_out_vadas_in_vadasX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx2"]).MergeE()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "vadas").Out("self").Has("person", "name", "vadas")}}, 
    "g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_sideEffectXpropertiesXweightX_dropX_selectXmXX_exists": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx2"]).WithSideEffect("m", p["xx3"]).MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Properties("weight").Drop()).Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "Y")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("created", "N")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight")}}, 
    "g_mergeE_with_outVinV_options_map": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OutV, p["xx2"]).Option(gremlingo.Merge.InV, p["xx3"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_with_outVinV_options_select": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("x").V(p["vid2"]).As("y").MergeE(p["xx1"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("x")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("y"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_with_eid_specified_and_inheritance_1": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E("201")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_with_eid_specified_and_inheritance_2": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E("201")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeE_outV_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeE_inV_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeE_label_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeE_id_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeV_mergeE_combination_new_vertices": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).As("outV").MergeV(p["xx2"]).As("inV").MergeE(p["xx3"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("outV")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("inV"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_mergeV_mergeE_combination_existing_vertices": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).As("outV").MergeV(p["xx2"]).As("inV").MergeE(p["xx3"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("outV")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("inV"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
    "g_V_asXvX_mergeEXxx1X_optionXMerge_onMatch_xx2X_optionXMerge_outV_selectXvXX_optionXMerge_inV_selectXvXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"]).Option(gremlingo.Merge.OutV, gremlingo.T__.Select("v")).Option(gremlingo.Merge.InV, gremlingo.T__.Select("v"))}}, 
    "g_V_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Property("weight", 0)).Constant(map[interface{}]interface{}{}))}}, 
    "g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeE(p["xx1"]).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Property("weight", 0)).Constant(map[interface{}]interface{}{}))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight", 1)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasLabel("knows").Has("weight", 0)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("weight")}}, 
    "g_injectXlist1_list2X_mergeEXlimitXlocal_1XX_optionXonCreate_rangeXlocal_1_2XX_optionXonMatch_tailXlocalXX_to_match": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx1"], p["xx2"]).Fold().MergeE(gremlingo.T__.Limit(gremlingo.Scope.Local, 1)).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Range(gremlingo.Scope.Local, 1, 2)).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Tail(gremlingo.Scope.Local))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Has("created", "N")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").OutE("knows").Has("created", "N").InV().Has("person", "name", "vadas")}}, 
    "g_injectXlist1_list2X_mergeEXlimitXlocal_1XX_optionXonCreate_rangeXlocal_1_2XX_optionXonMatch_tailXlocalXX_to_create": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx1"], p["xx2"]).Fold().MergeE(gremlingo.T__.Limit(gremlingo.Scope.Local, 1)).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Range(gremlingo.Scope.Local, 1, 2)).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Tail(gremlingo.Scope.Local))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().HasNot("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").OutE("knows").HasNot("created").InV().Has("person", "name", "vadas")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "vadas").OutE("self").HasNot("weight").InV().Has("person", "name", "vadas")}}, 
    "g_mergeVXemptyX_optionXonMatch_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnMatch, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}}, 
    "g_V_mergeVXemptyX_optionXonMatch_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnMatch, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}}, 
    "g_mergeVXnullX_optionXonCreate_label_null_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_V_mergeVXnullX_optionXonCreate_label_null_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(p["xx1"])}}, 
    "g_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_V_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_mergeVXnullX_optionXonCreate_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(nil).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeVXnullX_optionXonCreate_emptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(nil).Option(gremlingo.Merge.OnCreate, map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXemptyX_no_existing": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_injectX0X_mergeVXemptyX_no_existing": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXemptyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}}, 
    "g_V_mergeVXemptyX_two_exist": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(map[interface{}]interface{}{})}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "vadas").Has("age", 27)}}, 
    "g_mergeVXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mergeVXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().MergeV(nil)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXlabel_person_name_stephenX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_mergeVXlabel_person_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}}, 
    "g_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx1"]).WithSideEffect("m", p["xx2"]).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx1"]).WithSideEffect("m", p["xx2"]).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Property("name", "vadas", "acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("vadas").Has("acl", "public")}}, 
    "g_injectX0X_mergeVXlabel_person_name_stephenX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}}, 
    "g_injectX0X_mergeVXlabel_person_name_markoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}}, 
    "g_injectX0X_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_injectX0X_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_injectX0X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx1"]).WithSideEffect("m", p["xx2"]).Inject(0).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
    "g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_injectX0X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx1"]).WithSideEffect("m", p["xx2"]).Inject(0).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}}, 
    "g_injectX0X_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(0).MergeV(p["xx1"]).Property("name", "vadas", "acl", "public")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("vadas").Has("acl", "public")}}, 
    "g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeVXidentityX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx2"]).MergeV(gremlingo.T__.Identity())}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx2"]).MergeV()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_mergeVXlabel_person_name_stephenX_propertyXlist_name_steveX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property(gremlingo.Cardinality.List, "name", "stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Property(gremlingo.Cardinality.List, "name", "steve")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("steve")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name").HasValue("stephen")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name")}}, 
    "g_mergeXlabel_person_name_vadasX_optionXonMatch_age_35X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "vadas").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnMatch, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age", 35)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_mapXmergeXlabel_person_name_joshXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "vadas").Property("age", 29).AddV("person").Property("name", "stephen").Property("age", 27)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.MergeV(p["xx1"]))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "josh")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("c", p["xx1"]).WithSideEffect("m", p["xx2"]).MergeV(gremlingo.T__.Select("c")).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Properties("age").Drop()).Select("m"))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age", 19)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("age")}}, 
    "g_withSideEffectXm_age_19X_V_hasXperson_name_markoX_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property(gremlingo.Cardinality.List, "age", 29).Property(gremlingo.Cardinality.List, "age", 31).Property(gremlingo.Cardinality.List, "age", 32)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("m", p["xx1"]).V().Has("person", "name", "marko").MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnMatch, gremlingo.T__.SideEffect(gremlingo.T__.Properties("age").Drop()).Select("m"))}}, 
    "g_mergeV_onCreate_inheritance_existing": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "mike").Property(gremlingo.T.Id, "1")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V("1").Has("person", "name", "mike")}}, 
    "g_mergeV_onCreate_inheritance_new_1": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V("1").Has("person", "name", "mike")}}, 
    "g_mergeV_onCreate_inheritance_new_2": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V("1").Has("person", "name", "mike")}}, 
    "g_mergeV_label_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeV_id_override_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"]).Option(gremlingo.Merge.OnCreate, p["xx2"])}}, 
    "g_mergeV_hidden_id_key_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_mergeV_hidden_label_key_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_mergeV_hidden_label_value_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(p["xx1"])}}, 
    "g_mergeV_hidden_id_key_onCreate_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnCreate, p["xx1"])}}, 
    "g_mergeV_hidden_label_key_onCreate_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnCreate, p["xx1"])}}, 
    "g_mergeV_hidden_label_value_onCreate_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnCreate, p["xx1"])}}, 
    "g_mergeV_hidden_id_key_onMatch_matched_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("vertex")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnMatch, p["xx1"])}}, 
    "g_mergeV_hidden_label_key_matched_onMatch_matched_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("vertex")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnMatch, p["xx1"])}}, 
    "g_mergeV_hidden_label_key_onMatch_matched_prohibited": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.MergeV(map[interface{}]interface{}{}).Option(gremlingo.Merge.OnMatch, p["xx1"])}}, 
    "g_injectXlist1_list2X_mergeVXlimitXlocal_1XX_optionXonCreate_rangeXlocal_1_2X_optionXonMatch_tailXlocalXX_to_match": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx1"], p["xx2"]).Fold().MergeV(gremlingo.T__.Limit(gremlingo.Scope.Local, 1)).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Range(gremlingo.Scope.Local, 1, 2)).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Tail(gremlingo.Scope.Local))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Has("created", "N")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_injectXlist1_list2X_mergeVXlimitXlocal_1XX_optionXonCreate_rangeXlocal_1_2X_optionXonMatch_tailXlocalXX_to_create": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"], p["xx1"], p["xx2"]).Fold().MergeV(gremlingo.T__.Limit(gremlingo.Scope.Local, 1)).Option(gremlingo.Merge.OnCreate, gremlingo.T__.Range(gremlingo.Scope.Local, 1, 2)).Option(gremlingo.Merge.OnMatch, gremlingo.T__.Tail(gremlingo.Scope.Local))}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "stephen").HasNot("created")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_V_age_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Min()}}, 
    "g_V_foo_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Min()}}, 
    "g_V_name_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Min()}}, 
    "g_V_age_fold_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Min(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Min()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Unfold().Min()}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Min(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Min()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Unfold().Min()}}, 
    "g_V_foo_fold_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Min(gremlingo.Scope.Local)}}, 
    "g_V_name_fold_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Fold().Min(gremlingo.Scope.Local)}}, 
    "g_V_repeatXbothX_timesX5X_age_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both()).Times(5).Values("age").Min()}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_minX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Min())}}, 
    "g_V_foo_injectX9999999999X_min": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Inject(p["xx1"]).Min()}}, 
    "g_VX1X_valuesXageX_minXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Min(gremlingo.Scope.Local)}}, 
    "g_V_name_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order()}}, 
    "g_V_name_order_byXa1_b1X_byXb2_a2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Order().By(p["c1"]).By(p["c2"])}}, 
    "g_V_order_byXname_ascX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", gremlingo.Order.Asc).Values("name")}}, 
    "g_V_order_byXnameX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name").Values("name")}}, 
    "g_V_outE_order_byXweight_descX_weight": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Order().By("weight", gremlingo.Order.Desc).Values("weight")}}, 
    "g_V_order_byXname_a1_b1X_byXname_b2_a2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name", p["c1"]).By("name", p["c2"]).Values("name")}}, 
    "g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("created").As("b").Order().By(gremlingo.Order.Shuffle).Select("a", "b")}}, 
    "g_V_both_hasLabelXpersonX_order_byXage_descX_limitX5X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().HasLabel("person").Order().By("age", gremlingo.Order.Desc).Limit(5).Values("name")}}, 
    "g_V_properties_order_byXkey_descX_key": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Order().By(gremlingo.T.Key, gremlingo.Order.Desc).Key()}}, 
    "g_V_hasLabelXpersonX_order_byXvalueXageX_descX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By(p["l1"], gremlingo.Order.Desc).Values("name")}}, 
    "g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_orderXlocalX_byXvaluesX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Group().By("name").By(gremlingo.T__.OutE().Values("weight").Sum()).Order(gremlingo.Scope.Local).By(gremlingo.Column.Values)}}, 
    "g_V_mapXbothE_weight_foldX_order_byXsumXlocalX_descX_byXcountXlocalX_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Map(gremlingo.T__.BothE().Values("weight").Order().By(gremlingo.Order.Asc).Fold()).Order().By(gremlingo.T__.Sum(gremlingo.Scope.Local), gremlingo.Order.Desc).By(gremlingo.T__.Count(gremlingo.Scope.Local), gremlingo.Order.Desc)}}, 
    "g_V_group_byXlabelX_byXname_order_byXdescX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).By(gremlingo.T__.Values("name").Order().By(gremlingo.Order.Desc).Fold())}}, 
    "g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_unfold_order_byXvalues_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Group().By("name").By(gremlingo.T__.OutE().Values("weight").Sum()).Unfold().Order().By(gremlingo.Column.Values, gremlingo.Order.Desc)}}, 
    "g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_descX_byXselectXvX_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("v").Map(gremlingo.T__.BothE().Values("weight").Fold()).Sum(gremlingo.Scope.Local).As("s").Select("v", "s").Order().By(gremlingo.T__.Select("s"), gremlingo.Order.Desc).By(gremlingo.T__.Select("v").Values("name"))}}, 
    "g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Fold().Order(gremlingo.Scope.Local).By("age")}}, 
    "g_V_both_hasLabelXpersonX_order_byXage_descX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().HasLabel("person").Order().By("age", gremlingo.Order.Desc).Values("name")}}, 
    "g_V_order_byXoutE_count_descX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By(gremlingo.T__.OutE().Count(), gremlingo.Order.Desc).By("name")}}, 
    "g_V_hasLabelXpersonX_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Order().By("age")}}, 
    "g_V_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("age")}}, 
    "g_V_fold_orderXlocalX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Order(gremlingo.Scope.Local).By("age")}}, 
    "g_V_fold_orderXlocalX_byXage_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fold().Order(gremlingo.Scope.Local).By("age", gremlingo.Order.Desc)}}, 
    "g_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Or(gremlingo.T__.HasLabel("person"), gremlingo.T__.Has("software", "name", "lop")).Order().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Or(gremlingo.T__.HasLabel("person"), gremlingo.T__.Has("software", "name", "lop")).Order().By("age")}}, 
    "g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_descX_byXkeys_ascX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).HasLabel("person").Map(p["l1"]).Order(gremlingo.Scope.Local).By(gremlingo.Column.Values, gremlingo.Order.Desc).By(gremlingo.Column.Keys, gremlingo.Order.Asc)}}, 
    "g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_descX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("song", "name", "OH BOY").Out("followedBy").Out("followedBy").Order().By("performances").By("songType", gremlingo.Order.Desc).By("name")}}, 
    "g_V_hasLabelXsongX_order_byXperformances_descX_byXnameX_rangeX110_120X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Order().By("performances", gremlingo.Order.Desc).By("name").Range(110, 120).Values("name")}}, 
    "g_VX1X_elementMap_orderXlocalX_byXkeys_descXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ElementMap().Order(gremlingo.Scope.Local).By(gremlingo.Column.Keys, gremlingo.Order.Desc).Unfold()}}, 
    "g_VX1X_elementMap_orderXlocalX_byXkeys_ascXunfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ElementMap().Order(gremlingo.Scope.Local).By(gremlingo.Column.Keys, gremlingo.Order.Asc).Unfold()}}, 
    "g_VX1X_valuesXageX_orderXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Order(gremlingo.Scope.Local)}}, 
    "g_V_pageRank_hasXpageRankX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().Has("gremlin.pageRankVertexProgram.pageRank")}}, 
    "g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankX_withXtimes_0X_valueMapXname_projectRankX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").PageRank().With("~tinkerpop.pageRank.edges", gremlingo.T__.BothE()).With("~tinkerpop.pageRank.propertyName", "projectRank").With("~tinkerpop.pageRank.times", 0).ValueMap("name", "projectRank")}}, 
    "g_V_pageRank_order_byXpageRank_descX_byXnameX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().Order().By("gremlin.pageRankVertexProgram.pageRank", gremlingo.Order.Desc).By("name").Values("name")}}, 
    "g_V_pageRank_order_byXpageRank_descX_name_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().Order().By("gremlin.pageRankVertexProgram.pageRank", gremlingo.Order.Desc).Values("name").Limit(2)}}, 
    "g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().With("~tinkerpop.pageRank.edges", gremlingo.T__.OutE("knows")).With("~tinkerpop.pageRank.propertyName", "friendRank").Project("name", "friendRank").By("name").By(gremlingo.T__.Values("friendRank").Math("ceil(_ * 100)"))}}, 
    "g_V_hasLabelXpersonX_pageRank_withXpropertyName_kpageRankX_project_byXnameX_byXvaluesXpageRankX_mathX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").PageRank().With("~tinkerpop.pageRank.propertyName", "pageRank").Project("name", "pageRank").By("name").By(gremlingo.T__.Values("pageRank").Math("ceil(_ * 100)"))}}, 
    "g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PageRank().With("~tinkerpop.pageRank.propertyName", "pageRank").As("a").Out("knows").Values("pageRank").As("b").Select("a", "b").By().By(gremlingo.T__.Math("ceil(_ * 100)"))}}, 
    "g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Has("name", "ripple").PageRank(1.0).With("~tinkerpop.pageRank.edges", gremlingo.T__.InE("created")).With("~tinkerpop.pageRank.times", 1).With("~tinkerpop.pageRank.propertyName", "priors").In("created").Union(gremlingo.T__.Both(), gremlingo.T__.Identity()).ValueMap("name", "priors")}}, 
    "g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankX_withXedges_inEX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Group("m").By(gremlingo.T.Label).PageRank(1.0).With("~tinkerpop.pageRank.propertyName", "pageRank").With("~tinkerpop.pageRank.edges", gremlingo.T__.InE()).With("~tinkerpop.pageRank.times", 1).In("created").Group("m").By("pageRank").Cap("m")}}, 
    "g_VX1X_name_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("name").Path()}}, 
    "g_VX1X_out_path_byXageX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Path().By("age").By("name")}}, 
    "g_V_repeatXoutX_timesX2X_path_byXitX_byXnameX_byXlangX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out()).Times(2).Path().By().By("name").By("lang")}}, 
    "g_V_out_out_path_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Path().By("name").By("age")}}, 
    "g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Has("name", "marko").As("b").Has("age", 29).As("c").Path()}}, 
    "g_VX1X_outEXcreatedX_inV_inE_outV_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("created").InV().InE().OutV().Path()}}, 
    "g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Out().As("c").Path().From("b").To("c").By("name")}}, 
    "g_VX1X_out_path_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Path().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_VX1X_out_path_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V(p["vid1"]).Out().Path().By("age")}}, 
    "g_injectX1_null_nullX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, nil, nil).Path()}}, 
    "g_injectX1_null_nullX_path_dedup": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, nil, nil).Path().Dedup()}}, 
    "g_V_peerPressure_hasXclusterX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PeerPressure().Has("gremlin.peerPressureVertexProgram.cluster")}}, 
    "g_V_peerPressure_withXpropertyName_clusterX_withXedges_outEXknowsXX_pageRankX1X_byXrankX_withXedges_outEXknowsX_withXtimes_2X_group_byXclusterX_byXrank_sumX_limitX100X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().PeerPressure().With("~tinkerpop.peerPressure.propertyName", "cluster").With("~tinkerpop.peerPressure.edges", gremlingo.T__.OutE("knows")).PageRank(1.0).With("~tinkerpop.pageRank.propertyName", "rank").With("~tinkerpop.pageRank.edges", gremlingo.T__.OutE("knows")).With("~tinkerpop.pageRank.times", 1).Group().By("cluster").By(gremlingo.T__.Values("rank").Sum()).Limit(100)}}, 
    "g_V_hasXname_rippleX_inXcreatedX_peerPressure_withXedges_outEX_withyXpropertyName_clusterX_repeatXunionXidentity__bothX_timesX2X_dedup_valueMapXname_clusterX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "ripple").In("created").PeerPressure().With("~tinkerpop.peerPressure.edges", gremlingo.T__.OutE()).With("~tinkerpop.peerPressure.propertyName", "cluster").Repeat(gremlingo.T__.Union(gremlingo.T__.Identity(), gremlingo.T__.Both())).Times(2).Dedup().ValueMap("name", "cluster")}}, 
    "g_V_hasLabelXpersonX_projectXa_bX_byXoutE_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Project("a", "b").By(gremlingo.T__.OutE().Count()).By("age")}}, 
    "g_V_outXcreatedX_projectXa_bX_byXnameX_byXinXcreatedX_countX_order_byXselectXbX__descX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Project("a", "b").By("name").By(gremlingo.T__.In("created").Count()).Order().By(gremlingo.T__.Select("b"), gremlingo.Order.Desc).Select("a")}}, 
    "g_V_valueMap_projectXxX_byXselectXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Project("x").By(gremlingo.T__.Select("name"))}}, 
    "g_V_projectXa_bX_byXinE_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Project("a", "b").By(gremlingo.T__.InE().Count()).By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_projectXa_bX_byXinE_countX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Project("a", "b").By(gremlingo.T__.InE().Count()).By("age")}}, 
    "g_V_hasXageX_propertiesXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").Properties("name").Value()}}, 
    "g_V_hasXageX_propertiesXname_ageX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").Properties("name", "age").Value()}}, 
    "g_V_hasXageX_propertiesXage_nameX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").Properties("age", "name").Value()}}, 
    "g_V_propertiesXname_age_nullX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties("name", "age", nil).Value()}}, 
    "g_V_valuesXname_age_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name", "age", nil)}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a", "b")}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a", "b").By("name")}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a")}}, 
    "g_VX1X_asXaX_outXknowsX_asXbX_selectXaX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Out("knows").As("b").Select("a").By("name")}}, 
    "g_V_asXaX_out_asXbX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("b").Select("a", "b").By("name")}}, 
    "g_V_asXaX_out_aggregateXxX_asXbX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().Aggregate("x").As("b").Select("a", "b").By("name")}}, 
    "g_V_asXaX_name_order_asXbX_selectXa_bX_byXnameX_by_XitX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Values("name").Order().As("b").Select("a", "b").By("name").By()}}, 
    "g_V_hasXname_gremlinX_inEXusesX_order_byXskill_ascX_asXaX_outV_asXbX_selectXa_bX_byXskillX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "gremlin").InE("uses").Order().By("skill", gremlingo.Order.Asc).As("a").OutV().As("b").Select("a", "b").By("skill").By("name")}}, 
    "g_V_hasXname_isXmarkoXX_asXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", gremlingo.T__.Is("marko")).As("a").Select("a")}}, 
    "g_V_label_groupCount_asXxX_selectXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Label().GroupCount().As("x").Select("x")}}, 
    "g_V_hasLabelXpersonX_asXpX_mapXbothE_label_groupCountX_asXrX_selectXp_rX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").Map(gremlingo.T__.BothE().Label().GroupCount()).As("r").Select("p", "r")}}, 
    "g_V_chooseXoutE_count_isX0X__asXaX__asXbXX_chooseXselectXaX__selectXaX__selectXbXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Choose(gremlingo.T__.OutE().Count().Is(p["xx1"]), gremlingo.T__.As("a"), gremlingo.T__.As("b")).Choose(gremlingo.T__.Select("a"), gremlingo.T__.Select("a"), gremlingo.T__.Select("b"))}}, 
    "g_VX1X_groupXaX_byXconstantXaXX_byXnameX_selectXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Group("a").By(gremlingo.T__.Constant("a")).By(gremlingo.T__.Values("name")).Barrier().Select("a").Select("a")}}, 
    "g_VX1X_asXhereX_out_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("here").Out().Select("here")}}, 
    "g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).As("here").Out().Select("here")}}, 
    "g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Out().As("here").Has("lang", "java").Select("here").Values("name")}}, 
    "g_VX1X_outE_asXhereX_inV_hasXname_vadasX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().As("here").InV().Has("name", "vadas").Select("here")}}, 
    "g_VX1X_outEXknowsX_hasXweight_1X_asXhereX_inV_hasXname_joshX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").Has("weight", 1.0).As("here").InV().Has("name", "josh").Select("here")}}, 
    "g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_asXfakeX_inV_hasXname_joshX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").As("here").Has("weight", 1.0).As("fake").InV().Has("name", "josh").Select("here")}}, 
    "g_V_asXhereXout_name_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("here").Out().Values("name").Select("here")}}, 
    "g_V_outXcreatedX_unionXasXprojectX_inXcreatedX_hasXname_markoX_selectXprojectX__asXprojectX_inXcreatedX_inXknowsX_hasXname_markoX_selectXprojectXX_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Union(gremlingo.T__.As("project").In("created").Has("name", "marko").Select("project"), gremlingo.T__.As("project").In("created").In("knows").Has("name", "marko").Select("project")).GroupCount().By("name")}}, 
    "g_V_untilXout_outX_repeatXin_asXaXX_selectXaX_byXtailXlocalX_nameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Out().Out()).Repeat(gremlingo.T__.In().As("a")).Select("a").By(gremlingo.T__.Tail(gremlingo.Scope.Local).Values("name"))}}, 
    "g_V_outE_weight_groupCount_selectXkeysX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Select(gremlingo.Column.Keys).Unfold()}}, 
    "g_V_hasLabelXsoftwareX_asXnameX_asXlanguageX_asXcreatorsX_selectXname_language_creatorsX_byXnameX_byXlangX_byXinXcreatedX_name_fold_orderXlocalXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").As("name").As("language").As("creators").Select("name", "language", "creators").By("name").By("lang").By(gremlingo.T__.In("created").Values("name").Fold().Order(gremlingo.Scope.Local))}}, 
    "g_V_outE_weight_groupCount_unfold_selectXkeysX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Unfold().Select(gremlingo.Column.Keys).Unfold()}}, 
    "g_V_outE_weight_groupCount_unfold_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Unfold().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_untilXout_outX_repeatXin_asXaX_in_asXbXX_selectXa_bX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Until(gremlingo.T__.Out().Out()).Repeat(gremlingo.T__.In().As("a").In().As("b")).Select("a", "b").By("name")}}, 
    "g_V_outE_weight_groupCount_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_asXaX_whereXoutXknowsXX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Where(gremlingo.T__.Out("knows")).Select("a")}}, 
    "g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Repeat(gremlingo.T__.Out().As("a")).Times(2).Select(gremlingo.Pop.First, "a")}}, 
    "g_V_asXaX_outXknowsX_asXbX_localXselectXa_bX_byXnameXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("b").Local(gremlingo.T__.Select("a", "b").By("name"))}}, 
    "g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).As("a").Repeat(gremlingo.T__.Out().As("a")).Times(2).Select(gremlingo.Pop.Last, "a")}}, 
    "g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_inV_hasXname_joshX_selectXhereX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").As("here").Has("weight", 1.0).InV().Has("name", "josh").Select("here")}}, 
    "g_V_asXaX_hasXname_markoX_asXbX_asXcX_selectXa_b_cX_by_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Has("name", "marko").As("b").As("c").Select("a", "b", "c").By().By("name").By("age")}}, 
    "g_V_outE_weight_groupCount_selectXvaluesX_unfold_groupCount_selectXvaluesX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Values("weight").GroupCount().Select(gremlingo.Column.Values).Unfold().GroupCount().Select(gremlingo.Column.Values).Unfold()}}, 
    "g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Group("m").By().By(gremlingo.T__.BothE().Count()).Barrier().Select("m").Select(gremlingo.T__.Select("a"))}}, 
    "g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX_byXmathX_plus_XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Group("m").By().By(gremlingo.T__.BothE().Count()).Barrier().Select("m").Select(gremlingo.T__.Select("a")).By(gremlingo.T__.Math("_+_"))}}, 
    "g_V_asXaX_outXknowsX_asXaX_selectXall_constantXaXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out("knows").As("a").Select(gremlingo.Pop.All, gremlingo.T__.Constant("a"))}}, 
    "g_V_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select("a")}}, 
    "g_V_selectXaX_count": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select("a").Count()}}, 
    "g_V_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select("a", "b")}}, 
    "g_V_valueMap_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select("a")}}, 
    "g_V_valueMap_selectXa_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select("a", "b")}}, 
    "g_V_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.First, "a")}}, 
    "g_V_selectXfirst_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.First, "a", "b")}}, 
    "g_V_valueMap_selectXfirst_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.First, "a")}}, 
    "g_V_valueMap_selectXfirst_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.First, "a", "b")}}, 
    "g_V_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.Last, "a")}}, 
    "g_V_selectXlast_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.Last, "a", "b")}}, 
    "g_V_valueMap_selectXlast_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.Last, "a")}}, 
    "g_V_valueMap_selectXlast_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.Last, "a", "b")}}, 
    "g_V_selectXall_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.All, "a")}}, 
    "g_V_selectXall_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Select(gremlingo.Pop.All, "a", "b")}}, 
    "g_V_valueMap_selectXall_aX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.All, "a")}}, 
    "g_V_valueMap_selectXall_a_bX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Select(gremlingo.Pop.All, "a", "b")}}, 
    "g_V_asXa_bX_out_asXcX_path_selectXkeysX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a", "b").Out().As("c").Path().Select(gremlingo.Column.Keys)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a", "b").Out().As("c").Path().Select(gremlingo.Column.Keys)}}, 
    "g_V_hasXperson_name_markoX_barrier_asXaX_outXknows_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Barrier().As("a").Out("knows").Select("a")}}, 
    "g_V_hasXperson_name_markoX_elementMapXnameX_asXaX_unionXidentity_identityX_selectXaX_selectXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").ElementMap("name").As("a").Union(gremlingo.T__.Identity(), gremlingo.T__.Identity()).Select("a").Select("name")}}, 
    "g_V_hasXperson_name_markoX_count_asXaX_unionXidentity_identityX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Count().As("a").Union(gremlingo.T__.Identity(), gremlingo.T__.Identity()).Select("a")}}, 
    "g_V_hasXperson_name_markoX_path_asXaX_unionXidentity_identityX_selectXaX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Path().As("a").Union(gremlingo.T__.Identity(), gremlingo.T__.Identity()).Select("a").Unfold()}}, 
    "g_EX11X_propertiesXweightX_asXaX_selectXaX_byXkeyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).Properties("weight").As("a").Select("a").By(gremlingo.T.Key)}}, 
    "g_EX11X_propertiesXweightX_asXaX_selectXaX_byXvalueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"]).Properties("weight").As("a").Select("a").By(gremlingo.T.Value)}}, 
    "g_V_asXaX_selectXaX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Select("a").By("age")}}, 
    "g_V_asXa_nX_selectXa_nX_byXageX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a", "n").Select("a", "n").By("age").By("name")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_asXaX_selectXaX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().As("a").Select("a").By("age")}}, 
    "g_withSideEffectXk_nullX_injectXxX_selectXkX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("k", nil).Inject("x").Select("k")}}, 
    "g_V_out_in_selectXall_a_a_aX_byXunfold_name_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("A").Property("name", "a1").As("a1").AddV("A").Property("name", "a2").As("a2").AddV("A").Property("name", "a3").As("a3").AddV("B").Property("name", "b1").As("b1").AddV("B").Property("name", "b2").As("b2").AddV("B").Property("name", "b3").As("b3").AddE("ab").From("a1").To("b1").AddE("ab").From("a2").To("b2").AddE("ab").From("a3").To("b3")}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("a").Out().As("a").In().As("a").Select(gremlingo.Pop.All, "a", "a", "a").By(gremlingo.T__.Unfold().Values("name").Fold())}}, 
    "g_V_asXlabelX_aggregateXlocal_xX_selectXxX_selectXlabelX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().As("label").Aggregate(gremlingo.Scope.Local, "x").Barrier().Select("x").Select("label")}}, 
    "g_V_shortestPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath()}}, 
    "g_V_both_dedup_shortestPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().Dedup().ShortestPath()}}, 
    "g_V_shortestPath_edgesIncluded": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath().With("~tinkerpop.shortestPath.includeEdges")}}, 
    "g_V_shortestPath_directionXINX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath().With("~tinkerpop.shortestPath.edges", gremlingo.Direction.In)}}, 
    "g_V_shortestPath_edgesXoutEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath().With("~tinkerpop.shortestPath.edges", gremlingo.T__.OutE())}}, 
    "g_V_shortestPath_edgesIncluded_edgesXoutEX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath().With("~tinkerpop.shortestPath.includeEdges").With("~tinkerpop.shortestPath.edges", gremlingo.T__.OutE())}}, 
    "g_V_hasXname_markoX_shortestPath": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath()}}, 
    "g_V_shortestPath_targetXhasXname_markoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("name", "marko"))}}, 
    "g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Identity().ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Values("name").Is("marko"))}}, 
    "g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.HasLabel("software"))}}, 
    "g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("name", "josh")).With("~tinkerpop.shortestPath.distance", "weight")}}, 
    "g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "daniel").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("name", "stephen")).With("~tinkerpop.shortestPath.edges", gremlingo.T__.BothE("uses"))}}, 
    "g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("song", "name", "MIGHT AS WELL").ShortestPath().With("~tinkerpop.shortestPath.target", gremlingo.T__.Has("song", "name", "MAYBE YOU KNOW HOW I FEEL")).With("~tinkerpop.shortestPath.edges", gremlingo.T__.OutE("followedBy")).With("~tinkerpop.shortestPath.distance", "weight")}}, 
    "g_V_hasXname_markoX_shortestPath_maxDistanceX1X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.maxDistance", 1)}}, 
    "g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("name", "vadas").ShortestPath().With("~tinkerpop.shortestPath.distance", "weight").With("~tinkerpop.shortestPath.maxDistance", 1.3)}}, 
    "g_V_age_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Sum()}}, 
    "g_V_foo_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Sum()}}, 
    "g_V_age_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("age").Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_V_foo_fold_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("foo").Fold().Sum(gremlingo.Scope.Local)}}, 
    "g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("software").Group().By("name").By(gremlingo.T__.BothE().Values("weight").Sum())}}, 
    "g_V_aggregateXaX_byXageX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXageX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("age").Cap("a").Unfold().Sum()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("age").Cap("a").Unfold().Sum()}}, 
    "g_V_aggregateXaX_byXfooX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Sum(gremlingo.Scope.Local)}}, 
    "g_V_aggregateXaX_byXfooX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("a").By("foo").Cap("a").Unfold().Sum()}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("a").By("foo").Cap("a").Unfold().Sum()}}, 
    "g_injectXnull_10_5_nullX_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, p["xx1"], p["xx2"], nil).Sum()}}, 
    "g_injectXlistXnull_10_5_nullXX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Sum(gremlingo.Scope.Local)}}, 
    "g_VX1X_valuesXageX_sumXlocalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Values("age").Sum(gremlingo.Scope.Local)}}, 
    "g_V_localXoutE_foldX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Local(gremlingo.T__.OutE().Fold()).Unfold()}}, 
    "g_V_valueMap_unfold_mapXkeyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().Unfold().Map(p["l1"])}}, 
    "g_VX1X_repeatXboth_simplePathX_untilXhasIdX6XX_path_byXnameX_unfold": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Repeat(gremlingo.T__.Both().SimplePath()).Until(gremlingo.T__.HasId(p["vid6"])).Path().By("name").Unfold()}}, 
    "g_V_valueMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap()}}, 
    "g_V_valueMapXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap(true)}}, 
    "g_V_valueMap_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap().With("~tinkerpop.valueMap.tokens")}}, 
    "g_V_valueMapXname_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age")}}, 
    "g_V_valueMapXtrue_name_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap(true, "name", "age")}}, 
    "g_V_valueMapXname_ageX_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").With("~tinkerpop.valueMap.tokens")}}, 
    "g_V_valueMapXname_ageX_withXtokens_labelsX_byXunfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").With("~tinkerpop.valueMap.tokens", 2).By(gremlingo.T__.Unfold())}}, 
    "g_V_valueMapXname_ageX_withXtokens_idsX_byXunfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").With("~tinkerpop.valueMap.tokens", 1).By(gremlingo.T__.Unfold())}}, 
    "g_VX1X_outXcreatedX_valueMap": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("created").ValueMap()}}, 
    "g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMapXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).ValueMap(true)}}, 
    "g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMap_withXtokensX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Filter(gremlingo.T__.OutE("created")).ValueMap().With("~tinkerpop.valueMap.tokens")}}, 
    "g_VX1X_valueMapXname_locationX_byXunfoldX_by": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).ValueMap("name", "location").By(gremlingo.T__.Unfold()).By()}}, 
    "g_V_valueMapXname_age_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age", nil)}}, 
    "g_V_valueMapXname_ageX_byXisXxXXbyXunfoldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().ValueMap("name", "age").By(gremlingo.T__.Is("x")).By(gremlingo.T__.Unfold())}}, 
    "g_VXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(nil)}}, 
    "g_VXlistXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"])}}, 
    "g_VX1_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], nil)}}, 
    "g_VXlistX1_2_3XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("name")}}, 
    "g_VXlistXv1_v2_v3XX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("name")}}, 
    "g_V": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}}, 
    "g_VXv1X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["v1"]).Out()}}, 
    "g_VX1X_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out()}}, 
    "g_VX2X_in": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).In()}}, 
    "g_VX4X_both": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).Both()}}, 
    "g_E": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_EX11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"])}}, 
    "g_EX11AsStringX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"])}}, 
    "g_EXe11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["e11"])}}, 
    "g_EXe7_e11X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["e7"], p["e11"])}}, 
    "g_EXlistXe7_e11XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["xx1"])}}, 
    "g_EXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(nil)}}, 
    "g_EXlistXnullXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["xx1"])}}, 
    "g_EX11_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E(p["eid11"], nil)}}, 
    "g_VX1X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE()}}, 
    "g_VX2X_outE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE()}}, 
    "g_VX4X_bothEXcreatedX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE("created")}}, 
    "g_VX4X_bothE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE()}}, 
    "g_VX1X_outE_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Both()}}, 
    "g_VX2X_inE_outV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).InE().OutV()}}, 
    "g_V_outE_hasXweight_1X_outV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().OutE().Has("weight", 1.0).OutV()}}, 
    "g_V_out_outE_inV_inE_inV_both_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().InV().InE().InV().Both().Values("name")}}, 
    "g_VX1X_outEXknowsX_bothV_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").BothV().Values("name")}}, 
    "g_VX1X_outE_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().OtherV()}}, 
    "g_VX4X_bothE_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE().OtherV()}}, 
    "g_VX4X_bothE_hasXweight_lt_1X_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid4"]).BothE().Has("weight", gremlingo.P.Lt(1.0)).OtherV()}}, 
    "g_VX2X_inE": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid2"]).BothE()}}, 
    "get_g_VX1X_outE_otherV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE().OtherV()}}, 
    "g_VX1X_outXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows")}}, 
    "g_VX1AsStringX_outXknowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows")}}, 
    "g_VX1X_outXknows_createdX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out("knows", "created")}}, 
    "g_VX1X_outEXknowsX_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows").InV()}}, 
    "g_VX1X_outEXknows_createdX_inV": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).OutE("knows", "created").InV()}}, 
    "g_V_out_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out()}}, 
    "g_VX1X_out_out_out": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Out().Out()}}, 
    "g_VX1X_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Values("name")}}, 
    "g_VX1X_to_XOUT_knowsX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).To(gremlingo.Direction.Out, "knows")}}, 
    "g_VX1_2_3_4X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5).AddE("knows").From("marko").To("josh").Property("weight", 1.0).AddE("created").From("marko").To("lop").Property("weight", 0.4).AddE("created").From("josh").To("ripple").Property("weight", 1.0).AddE("created").From("josh").To("lop").Property("weight", 0.4).AddE("created").From("peter").To("lop").Property("weight", 0.2)}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("software", "name", "lop").Drop()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"], p["vid2"], p["vid3"], p["vid4"])}}, 
    "g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").V().HasLabel("software").Values("name")}}, 
    "g_V_hasLabelXloopsX_bothEXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("loops").BothE("self")}}, 
    "g_V_hasLabelXloopsX_bothXselfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("loops").Both("self")}}, 
    "g_injectX1X_VXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).V(nil)}}, 
    "g_injectX1X_VX1_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1).V(p["vid1"], nil)}}, 
    "InjectXnullX_eqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Eq(nil))}}, 
    "InjectXnullX_neqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Neq(nil))}}, 
    "InjectXnullX_ltXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Lt(nil))}}, 
    "InjectXnullX_lteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Lte(nil))}}, 
    "InjectXnullX_gtXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Gt(nil))}}, 
    "InjectXnullX_gteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil).Is(gremlingo.P.Gte(nil))}}, 
    "InjectXNaNX_eqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Eq(math.NaN()))}}, 
    "InjectXNaNX_neqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Neq(math.NaN()))}}, 
    "InjectXNaNX_ltXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Lt(math.NaN()))}}, 
    "InjectXNaNX_lteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Lte(math.NaN()))}}, 
    "InjectXNaNX_gtXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Gt(math.NaN()))}}, 
    "InjectXNaNX_gteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Gte(math.NaN()))}}, 
    "InjectX1dX_eqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(math.NaN()))}}, 
    "InjectX1dX_neqXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(math.NaN()))}}, 
    "InjectX1dX_ltXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()))}}, 
    "InjectX1dX_lteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lte(math.NaN()))}}, 
    "InjectX1dX_gtXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gt(math.NaN()))}}, 
    "InjectX1dX_gteXNaNX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gte(math.NaN()))}}, 
    "InjectXNaNX_eqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Eq(nil))}}, 
    "InjectXNaNX_neqXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Neq(nil))}}, 
    "InjectXNaNX_ltXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Lt(nil))}}, 
    "InjectXNaNX_lteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Lte(nil))}}, 
    "InjectXNaNX_gtXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Gt(nil))}}, 
    "InjectXNaNX_gteXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.NaN()).Is(gremlingo.P.Gte(nil))}}, 
    "InjectXfooX_eqX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Eq(1.0))}}, 
    "InjectXfooX_neqX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Neq(1.0))}}, 
    "InjectXfooX_ltX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Lt(1.0))}}, 
    "InjectXfooX_lteX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Lte(1.0))}}, 
    "InjectXfooX_gtX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Gt(1.0))}}, 
    "InjectXfooX_gteX1dX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject("foo").Is(gremlingo.P.Gte(1.0))}}, 
    "InjectX1dX_eqXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq("foo"))}}, 
    "InjectX1dX_neqXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq("foo"))}}, 
    "InjectX1dX_ltXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt("foo"))}}, 
    "InjectX1dX_lteXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lte("foo"))}}, 
    "InjectX1dX_gtXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gt("foo"))}}, 
    "InjectX1dX_gteXfooX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Gte("foo"))}}, 
    "InjectX1dX_andXtrue_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXtrue_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(1).And(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_andXtrue_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXtrue_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(1).And(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_andXtrue_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXtrue_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(1).And(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_andXfalse_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXfalse_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(1).And(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_andXfalse_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXfalse_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(1).And(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_andXfalse_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXfalse_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(1).And(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_andXerror_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXerror_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()).And(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_andXerror_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_isXerror_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()).And(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_andXerror_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).And(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_isXerror_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()).And(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_orXtrue_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXtrue_or_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(1).Or(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_orXtrue_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXtrue_or_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(1).Or(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_orXtrue_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Eq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXtrue_or_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Eq(1).Or(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_orXfalse_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXfalse_or_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(1).Or(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_orXfalse_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_isXfalse_or_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(1).Or(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_orXfalse_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Neq(1)), gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_isXfalse_or_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Neq(1).Or(gremlingo.P.Lt(math.NaN())))}}, 
    "InjectX1dX_orXerror_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_isXerror_or_trueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()).Or(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_orXerror_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_isXerror_or_falseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()).Or(gremlingo.P.Gt(2)))}}, 
    "InjectX1dX_orXerror_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Or(gremlingo.T__.Is(gremlingo.P.Lt(math.NaN())), gremlingo.T__.Is(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_isXerror_or_errorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Is(gremlingo.P.Lt(math.NaN()).Or(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_notXtrueX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Not(gremlingo.T__.Is(gremlingo.P.Gt(0)))}}, 
    "InjectX1dX_notXfalseX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Not(gremlingo.T__.Is(gremlingo.P.Lt(0)))}}, 
    "InjectX1dX_notXerrorX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Not(gremlingo.T__.Is(gremlingo.P.Gt(math.NaN())))}}, 
    "InjectX1dX_notXisXeqXNaNXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1.0).Not(gremlingo.T__.Is(gremlingo.P.Eq(math.NaN())))}}, 
    "InjectXInfX_eqXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Eq(math.Inf(1)))}}, 
    "InjectXInfArgX_eqXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Eq(math.Inf(1)))}}, 
    "InjectXInfX_neqXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Neq(math.Inf(1)))}}, 
    "InjectXInfArgX_neqXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Neq(math.Inf(1)))}}, 
    "InjectXNegInfX_eqXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-11)).Is(gremlingo.P.Eq(math.Inf(-11)))}}, 
    "InjectXNegInfArgX_eqXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Eq(math.Inf(-11)))}}, 
    "InjectXNegInfX_neqXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-11)).Is(gremlingo.P.Neq(math.Inf(-11)))}}, 
    "InjectXNegInfArgX_neqXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Is(gremlingo.P.Neq(math.Inf(-11)))}}, 
    "InjectXInfX_gtXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Gt(math.Inf(-11)))}}, 
    "InjectXInfX_ltXNegInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(1)).Is(gremlingo.P.Lt(math.Inf(-11)))}}, 
    "InjectXNegInfX_ltXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-11)).Is(gremlingo.P.Lt(math.Inf(1)))}}, 
    "InjectXNegInfX_gtXInfX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(math.Inf(-11)).Is(gremlingo.P.Gt(math.Inf(1)))}}, 
    "Primitives_Number_eqXbyteX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXshortX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXintX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXlongX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXbigintX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXfloatX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXdoubleX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "Primitives_Number_eqXbigdecimalX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Unfold().Where(gremlingo.T__.Is(p["xx2"]))}}, 
    "g_V_values_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values().Order()}}, 
    "g_V_properties_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Order()}}, 
    "g_V_properties_order_id": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Properties().Order().Id()}}, 
    "g_E_properties_order_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().Order().Value()}}, 
    "g_E_properties_order_byXdescX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E().Properties().Order().By(gremlingo.Order.Desc).Value()}}, 
    "g_inject_order": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx8"], p["xx7"], p["xx10"], p["xx4"], p["xx9"], p["xx12"], p["xx1"], p["xx5"], p["xx11"], p["xx6"], p["xx3"], p["xx2"], p["xx13"], p["xx14"], p["xx15"]).Order()}}, 
    "g_inject_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx8"], p["xx7"], p["xx10"], p["xx4"], p["xx9"], p["xx12"], p["xx1"], p["xx5"], p["xx11"], p["xx6"], p["xx3"], p["xx2"], p["xx13"], p["xx14"], p["xx15"]).Order().By(gremlingo.Order.Desc)}}, 
    "g_V_out_out_order_byXascX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Order().By(gremlingo.Order.Asc)}}, 
    "g_V_out_out_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Order().By(gremlingo.Order.Desc)}}, 
    "g_V_out_out_asXheadX_path_order_byXascX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head")}}, 
    "g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head")}}, 
    "g_V_out_outE_order_byXascX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().Order().By(gremlingo.Order.Asc)}}, 
    "g_V_out_outE_order_byXdescX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().Order().By(gremlingo.Order.Desc)}}, 
    "g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head")}}, 
    "g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().OutE().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head")}}, 
    "g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Properties().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head").Value()}}, 
    "g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Properties().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head").Value()}}, 
    "g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Values().As("head").Path().Order().By(gremlingo.Order.Asc).Select("head")}}, 
    "g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Out().Values().As("head").Path().Order().By(gremlingo.Order.Desc).Select("head")}}, 
    "g_V_valueXnameX_aggregateXxX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Aggregate("x").Cap("x")}}, 
    "g_V_valueXnameX_aggregateXglobal_xX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Values("name").Aggregate(gremlingo.Scope.Global, "x").Cap("x")}}, 
    "g_V_aggregateXxX_byXnameX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By("name").Cap("x")}}, 
    "g_V_out_aggregateXaX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Aggregate("a").Path()}}, 
    "g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").Aggregate("x").By("age").Cap("x").As("y").Select("y")}}, 
    "g_V_aggregateXxX_byXageX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By("age").Cap("x")}}, 
    "g_V_aggregateXlocal_xX_byXageX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate(gremlingo.Scope.Local, "x").By("age").Cap("x")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXlocal_xX_byXageX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate(gremlingo.Scope.Local, "x").By("age").Cap("x")}}, 
    "g_V_aggregateXlocal_a_nameX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate(gremlingo.Scope.Local, "a").By("name").Out().Cap("a")}}, 
    "g_VX1X_aggregateXlocal_aX_byXnameX_out_aggregateXlocal_aX_byXnameX_name_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Aggregate(gremlingo.Scope.Local, "a").By("name").Out().Aggregate(gremlingo.Scope.Local, "a").By("name").Values("name").Cap("a")}}, 
    "g_withSideEffectXa_setX_V_both_name_aggregateXlocal_aX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", p["xx1"]).V().Both().Values("name").Aggregate(gremlingo.Scope.Local, "a").Cap("a")}}, 
    "g_V_aggregateXlocal_aX_byXoutEXcreatedX_countX_out_out_aggregateXlocal_aX_byXinEXcreatedX_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate(gremlingo.Scope.Local, "a").By(gremlingo.T__.OutE("created").Count()).Out().Out().Aggregate(gremlingo.Scope.Local, "a").By(gremlingo.T__.InE("created").Values("weight").Sum()).Cap("a")}}, 
    "g_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(29))).Cap("x")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("x").By(gremlingo.T__.Values("age").Is(gremlingo.P.Gt(29))).Cap("x")}}, 
    "g_V_aggregateXxX_byXout_order_byXnameXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Aggregate("x").By(gremlingo.T__.Out().Order().By("name")).Cap("x")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXout_order_byXnameXX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Aggregate("x").By(gremlingo.T__.Out().Order().By("name")).Cap("x")}}, 
    "g_V_fail": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fail()}}, 
    "g_V_failXmsgX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Fail("msg")}}, 
    "g_V_unionXout_failX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Out(), gremlingo.T__.Fail())}}, 
    "g_V_group_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("name")}}, 
    "g_V_group_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_group_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().Group().By("age")}}, 
    "g_V_group_byXnameX_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("name").By("age")}}, 
    "g_V_group_byXnameX_by": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By("name").By()}}, 
    "g_V_hasXlangX_group_byXlangX_byXcountX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("lang").Group().By("lang").By(gremlingo.T__.Count())}}, 
    "g_V_group_byXoutE_countX_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Order().By("name").Group().By(gremlingo.T__.OutE().Count()).By("name")}}, 
    "g_V_repeatXbothXfollowedByXX_timesX2X_group_byXsongTypeX_byXcountX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both("followedBy")).Times(2).Group().By("songType").By(gremlingo.T__.Count())}}, 
    "g_V_group_byXname_substring_1X_byXconstantX1XX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(p["l1"]).By(gremlingo.T__.Constant(1))}}, 
    "g_V_out_group_byXlabelX_selectXpersonX_unfold_outXcreatedX_name_limitX2X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out().Group().By(gremlingo.T.Label).Select("person").Unfold().Out("created").Values("name").Limit(2)}}, 
    "g_V_hasLabelXsongX_group_byXnameX_byXproperties_groupCount_byXlabelXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Group().By("name").By(gremlingo.T__.Properties().GroupCount().By(gremlingo.T.Label))}}, 
    "g_V_outXfollowedByX_group_byXsongTypeX_byXbothE_group_byXlabelX_byXweight_sumXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("followedBy").Group().By("songType").By(gremlingo.T__.BothE().Group().By(gremlingo.T.Label).By(gremlingo.T__.Values("weight").Sum()))}}, 
    "g_V_group_byXlabelX_byXbothE_groupXaX_byXlabelX_byXweight_sumX_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T.Label).By(gremlingo.T__.BothE().Group("a").By(gremlingo.T.Label).By(gremlingo.T__.Values("weight").Sum()).Values("weight").Sum())}}, 
    "g_V_hasLabelXpersonX_asXpX_outXcreatedX_group_byXnameX_byXselectXpX_valuesXageX_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").Out("created").Group().By("name").By(gremlingo.T__.Select("p").Values("age").Sum())}}, 
    "g_V_group_byXlabelX_byXlabel_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group().By(gremlingo.T__.Label()).By(gremlingo.T__.Label().Count())}}, 
    "g_V_outXcreatedX_groupCount_byXnameX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount().By("name")}}, 
    "g_V_groupCount_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().By("age")}}, 
    "g_withStrategiesXProductiveByStrategyX_V_groupCount_byXageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithStrategies(gremlingo.ProductiveByStrategy(gremlingo.ProductiveByStrategyConfig{ProductiveKeys: []string{}})).V().GroupCount().By("age")}}, 
    "g_V_outXcreatedX_name_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Values("name").GroupCount()}}, 
    "g_V_outXcreatedX_groupCountXaX_byXnameX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount("a").By("name").Cap("a")}}, 
    "g_V_outXcreatedX_name_groupCountXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").Values("name").GroupCount("a").Cap("a")}}, 
    "g_V_repeatXout_groupCountXaX_byXnameXX_timesX2X_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().GroupCount("a").By("name")).Times(2).Cap("a")}}, 
    "g_V_both_groupCountXaX_byXlabelX_asXbX_barrier_whereXselectXaX_selectXsoftwareX_isXgtX2XXX_selectXbX_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().GroupCount("a").By(gremlingo.T.Label).As("b").Barrier().Where(gremlingo.T__.Select("a").Select("software").Is(gremlingo.P.Gt(2))).Select("b").Values("name")}}, 
    "g_V_unionXoutXknowsX__outXcreatedX_inXcreatedXX_groupCount_selectXvaluesX_unfold_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Out("knows"), gremlingo.T__.Out("created").In("created")).GroupCount().Select(gremlingo.Column.Values).Unfold().Sum()}}, 
    "g_V_hasXnoX_groupCount": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("no").GroupCount()}}, 
    "g_V_hasXnoX_groupCountXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("no").GroupCount("a").Cap("a")}}, 
    "g_V_unionXrepeatXoutX_timesX2X_groupCountXmX_byXlangXX__repeatXinX_timesX2X_groupCountXmX_byXnameXX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Union(gremlingo.T__.Repeat(gremlingo.T__.Out()).Times(2).GroupCount("m").By("lang"), gremlingo.T__.Repeat(gremlingo.T__.In()).Times(2).GroupCount("m").By("name")).Cap("m")}}, 
    "g_V_outXcreatedX_groupCountXxX_capXxX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Out("created").GroupCount("x").Cap("x")}}, 
    "g_V_groupCount_byXbothE_countX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().GroupCount().By(gremlingo.T__.BothE().Count())}}, 
    "g_V_both_groupCountXaX_out_capXaX_selectXkeysX_unfold_both_groupCountXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Both().GroupCount("a").Out().Cap("a").Select(gremlingo.Column.Keys).Unfold().Both().GroupCount("a").Cap("a")}}, 
    "g_V_hasXperson_name_markoX_bothXknowsX_groupCount_byXvaluesXnameX_foldX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("person", "name", "marko").Both("knows").GroupCount().By(gremlingo.T__.Values("name").Fold())}}, 
    "g_VX1X_out_injectXv2X_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Inject(p["v2"]).Values("name")}}, 
    "g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Out().Values("name").Inject("daniel").As("a").Map(p["l1"]).Path()}}, 
    "g_VX1X_injectXg_VX4XX_out_name": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Inject(p["v2"]).Out().Values("name")}}, 
    "g_injectXnull_1_3_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 1, 3, nil)}}, 
    "g_injectX10_20_null_20_10_10X_groupCountXxX_dedup_asXyX_projectXa_bX_by_byXselectXxX_selectXselectXyXXX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(10, 20, nil, 20, 10, 10).GroupCount("x").Dedup().As("y").Project("a", "b").By().By(gremlingo.T__.Select("x").Select(gremlingo.T__.Select("y")))}}, 
    "g_injectXname_marko_age_nullX_selectXname_ageX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(p["xx1"]).Select("name", "age")}}, 
  "g_injectXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, nil)}}, 
    "g_injectXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil)}}, 
    "g_inject": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject()}}, 
  "g_VX1X_valuesXageX_injectXnull_nullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("age").Inject(nil, nil)}}, 
    "g_VX1X_valuesXageX_injectXnullX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("age").Inject(nil)}}, 
    "g_VX1X_valuesXageX_inject": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["xx1"]).Values("age").Inject()}}, 
    "g_injectXnull_1_3_nullX_asXaX_selectXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(nil, 1, 3, nil).As("a").Select("a")}}, 
    "g_injectX1_3lX_injectX100_300X": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Inject(1, 3).Inject(100, 300)}}, 
    "g_io_readXkryoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.kryo").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_read_withXreader_gryoX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.kryo").With("~tinkerpop.io.reader", "gryo").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_readXgraphsonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.json").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_read_withXreader_graphsonX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.json").With("~tinkerpop.io.reader", "graphson").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_readXgraphmlX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.xml").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_io_read_withXreader_graphmlX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.Io("data/tinkerpop-modern.xml").With("~tinkerpop.io.reader", "graphml").Read()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V()}, func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.E()}}, 
    "g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack("hello").V().OutE().Sack(gremlingo.Operator.Assign).By(gremlingo.T.Label).InV().Sack()}}, 
    "g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(0.0).V().OutE().Sack(gremlingo.Operator.Sum).By("weight").InV().Sack().Sum()}}, 
    "g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(0.0).V().Repeat(gremlingo.T__.OutE().Sack(gremlingo.Operator.Sum).By("weight").InV()).Times(2).Sack()}}, 
    "g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithBulk(false).WithSack(1.0, gremlingo.Operator.Sum).V(p["vid1"]).Local(gremlingo.T__.OutE("knows").Barrier(gremlingo.Barrier.NormSack).InV()).In("knows").Barrier().Sack()}}, 
    "g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithBulk(false).WithSack(1, gremlingo.Operator.Sum).V().Out().Barrier().Sack()}}, 
    "g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSack(1.0, gremlingo.Operator.Sum).V(p["vid1"]).Local(gremlingo.T__.Out("knows").Barrier(gremlingo.Barrier.NormSack)).In("knows").Barrier().Sack()}}, 
    "g_V_sackXassignX_byXageX_sack": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Sack(gremlingo.Operator.Assign).By("age").Sack()}}, 
    "g_V_hasXageX_groupCountXaX_byXnameX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("age").GroupCount("a").By("name").Out().Cap("a")}}, 
    "g_V_groupXaX_byXageX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By("age").Cap("a")}}, 
    "g_V_groupXaX_byXnameX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By("name").Cap("a")}}, 
    "g_V_hasXlangX_groupXaX_byXlangX_byXnameX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Has("lang").Group("a").By("lang").By("name").Out().Cap("a")}}, 
    "g_V_repeatXout_groupXaX_byXnameX_byXcountX_timesX2X_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Out().Group("a").By("name").By(gremlingo.T__.Count())).Times(2).Cap("a")}}, 
    "g_V_groupXaX_byXlabelX_byXoutE_weight_sumX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By(gremlingo.T.Label).By(gremlingo.T__.OutE().Values("weight").Sum()).Cap("a")}}, 
    "g_V_repeatXbothXfollowedByXX_timesX2X_groupXaX_byXsongTypeX_byXcountX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Repeat(gremlingo.T__.Both("followedBy")).Times(2).Group("a").By("songType").By(gremlingo.T__.Count()).Cap("a")}}, 
    "g_V_groupXaX_byXname_substring_1X_byXconstantX1XX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("a").By(p["l1"]).By(gremlingo.T__.Constant(1)).Cap("a")}}, 
    "g_V_hasLabelXsongX_groupXaX_byXnameX_byXproperties_groupCount_byXlabelXX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("song").Group("a").By("name").By(gremlingo.T__.Properties().GroupCount().By(gremlingo.T.Label)).Out().Cap("a")}}, 
    "g_V_hasLabelXpersonX_asXpX_outXcreatedX_groupXaX_byXnameX_byXselectXpX_valuesXageX_sumX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().HasLabel("person").As("p").Out("created").Group("a").By("name").By(gremlingo.T__.Select("p").Values("age").Sum()).Cap("a")}}, 
    "g_V_groupXmX_byXnameX_byXinXknowsX_nameX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("m").By("name").By(gremlingo.T__.In("knows").Values("name")).Cap("m")}}, 
    "g_V_groupXmX_byXlabelX_byXlabel_countX_capXmX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Group("m").By(gremlingo.T__.Label()).By(gremlingo.T__.Label().Count()).Cap("m")}}, 
    "g_V_storeXa_nameX_out_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Store("a").By("name").Out().Cap("a")}}, 
    "g_VX1X_storeXaX_byXnameX_out_storeXaX_byXnameX_name_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V(p["vid1"]).Store("a").By("name").Out().Store("a").By("name").Values("name").Cap("a")}}, 
    "g_withSideEffectXa_setX_V_both_name_storeXaX_capXaX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.WithSideEffect("a", p["xx1"]).V().Both().Values("name").Store("a").Cap("a")}}, 
    "g_V_storeXaX_byXoutEXcreatedX_countX_out_out_storeXaX_byXinEXcreatedX_weight_sumX": {func(g *gremlingo.GraphTraversalSource, p map[string]interface{}) *gremlingo.GraphTraversal {return g.V().Store("a").By(gremlingo.T__.OutE("created").Count()).Out().Out().Store("a").By(gremlingo.T__.InE("created").Values("weight").Sum()).Cap("a")}}, 
}

   func GetTraversal(scenarioName string, g *gremlingo.GraphTraversalSource, parameters map[string]interface{}) (*gremlingo.GraphTraversal, error) {
       if traversalFns, ok := translationMap[scenarioName]; ok {
           traversal := traversalFns[0]
           translationMap[scenarioName] = traversalFns[1:]
           return traversal(g, parameters), nil
       } else {
           return nil, errors.New("scenario for traversal not recognized")
       }
   }

