/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.jsr223.CoreImports;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GroovyTranslator
implements Translator.ScriptTranslator {
    private final String traversalSource;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;

    private GroovyTranslator(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        this.traversalSource = traversalSource;
        this.typeTranslator = typeTranslator;
    }

    public static GroovyTranslator of(String traversalSource) {
        return GroovyTranslator.of(traversalSource, false);
    }

    public static GroovyTranslator of(String traversalSource, boolean withParameters) {
        return GroovyTranslator.of(traversalSource, new DefaultTypeTranslator(withParameters));
    }

    public static GroovyTranslator of(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        return new GroovyTranslator(traversalSource, typeTranslator);
    }

    @Override
    public Script translate(Bytecode bytecode) {
        return (Script)this.typeTranslator.apply(this.traversalSource, bytecode);
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-groovy";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    @Override
    public String getTraversalSource() {
        return this.traversalSource;
    }

    public static class LanguageTypeTranslator
    extends DefaultTypeTranslator {
        public LanguageTypeTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected String getSyntax(Date o) {
            return LanguageTypeTranslator.getDatetimeSyntax(o.toInstant());
        }

        @Override
        protected String getSyntax(Timestamp o) {
            return LanguageTypeTranslator.getDatetimeSyntax(o.toInstant());
        }

        @Override
        protected Script produceScript(Vertex o) {
            this.script.append("new Vertex(");
            this.convertToScript(o.id());
            this.script.append(",");
            this.convertToScript(o.label());
            return this.script.append(")");
        }

        @Override
        protected String getSyntax(Number o) {
            if (o instanceof Double || o instanceof Float) {
                if (NumberHelper.isNaN(o)) {
                    return "NaN";
                }
                if (NumberHelper.isPositiveInfinity(o)) {
                    return "Infinity";
                }
                if (NumberHelper.isNegativeInfinity(o)) {
                    return "-Infinity";
                }
                return o + (o instanceof Double ? "D" : "F");
            }
            if (o instanceof Long) {
                return o + "L";
            }
            if (o instanceof Integer) {
                return o + "I";
            }
            if (o instanceof Byte) {
                return o + "B";
            }
            if (o instanceof Short) {
                return o + "S";
            }
            if (o instanceof BigInteger) {
                return o + "N";
            }
            if (o instanceof BigDecimal) {
                return o + "D";
            }
            return o.toString();
        }

        private static String getDatetimeSyntax(Instant i) {
            return String.format("datetime('%s')", DatetimeHelper.format(i));
        }
    }

    public static class DefaultTypeTranslator
    extends Translator.ScriptTranslator.AbstractTypeTranslator {
        public DefaultTypeTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected String getNullSyntax() {
            return "null";
        }

        @Override
        protected String getSyntax(String o) {
            return (o.contains("\"") ? "\"\"\"" + StringEscapeUtils.escapeJava((String)o) + "\"\"\"" : "\"" + StringEscapeUtils.escapeJava((String)o) + "\"").replace("$", "\\$");
        }

        @Override
        protected String getSyntax(Boolean o) {
            return o.toString();
        }

        @Override
        protected String getSyntax(Date o) {
            return "new Date(" + o.getTime() + "L)";
        }

        @Override
        protected String getSyntax(Timestamp o) {
            return "new Timestamp(" + o.getTime() + "L)";
        }

        @Override
        protected String getSyntax(UUID o) {
            return "UUID.fromString('" + o.toString() + "')";
        }

        @Override
        protected String getSyntax(Lambda o) {
            String lambdaString = o.getLambdaScript().trim();
            return lambdaString.startsWith("{") ? lambdaString : "{" + lambdaString + "}";
        }

        @Override
        protected String getSyntax(SackFunctions.Barrier o) {
            return "SackFunctions.Barrier." + o.toString();
        }

        @Override
        protected String getSyntax(VertexProperty.Cardinality o) {
            return "VertexProperty.Cardinality." + o.toString();
        }

        @Override
        protected String getSyntax(Pick o) {
            return "Pick." + o.toString();
        }

        @Override
        protected String getSyntax(Number o) {
            if (o instanceof Double || o instanceof Float) {
                if (NumberHelper.isNaN(o)) {
                    return (o instanceof Double ? "Double" : "Float") + ".NaN";
                }
                if (NumberHelper.isPositiveInfinity(o)) {
                    return (o instanceof Double ? "Double" : "Float") + ".POSITIVE_INFINITY";
                }
                if (NumberHelper.isNegativeInfinity(o)) {
                    return (o instanceof Double ? "Double" : "Float") + ".POSITIVE_INFINITY";
                }
                return o + (o instanceof Double ? "d" : "f");
            }
            if (o instanceof Long) {
                return o + "L";
            }
            if (o instanceof Integer) {
                return "(int) " + o;
            }
            if (o instanceof Byte) {
                return "(byte) " + o;
            }
            if (o instanceof Short) {
                return "(short) " + o;
            }
            if (o instanceof BigInteger) {
                return "new BigInteger('" + o.toString() + "')";
            }
            if (o instanceof BigDecimal) {
                return "new BigDecimal('" + o.toString() + "')";
            }
            return o.toString();
        }

        @Override
        protected Script produceScript(Set<?> o) {
            return this.produceScript(new ArrayList(o)).append(" as Set");
        }

        @Override
        protected Script produceScript(List<?> o) {
            Iterator<?> iterator = o.iterator();
            this.script.append("[");
            while (iterator.hasNext()) {
                Object nextItem = iterator.next();
                this.convertToScript(nextItem);
                if (!iterator.hasNext()) continue;
                this.script.append(",").append(" ");
            }
            return this.script.append("]");
        }

        @Override
        protected Script produceScript(Map<?, ?> o) {
            this.script.append("[");
            Iterator<Map.Entry<?, ?>> itty = o.entrySet().iterator();
            while (itty.hasNext()) {
                Map.Entry<?, ?> entry = itty.next();
                this.script.append("(");
                this.convertToScript(entry.getKey());
                this.script.append("):(");
                this.convertToScript(entry.getValue());
                this.script.append(")");
                if (!itty.hasNext()) continue;
                this.script.append(",");
            }
            return this.script.append("]");
        }

        @Override
        protected Script produceScript(Class<?> o) {
            return this.script.append(CoreImports.getClassImports().contains(o) ? o.getSimpleName() : o.getCanonicalName());
        }

        @Override
        protected Script produceScript(Enum<?> o) {
            return this.script.append(o.getDeclaringClass().getSimpleName() + "." + o.toString());
        }

        @Override
        protected Script produceScript(Vertex o) {
            this.script.append("new ReferenceVertex(");
            this.convertToScript(o.id());
            this.script.append(",");
            this.convertToScript(o.label());
            return this.script.append(")");
        }

        @Override
        protected Script produceScript(Edge o) {
            this.script.append("new ReferenceEdge(");
            this.convertToScript(o.id());
            this.script.append(",");
            this.convertToScript(o.label());
            this.script.append(",new ReferenceVertex(");
            this.convertToScript(o.inVertex().id());
            this.script.append(",");
            this.convertToScript(o.inVertex().label());
            this.script.append("),new ReferenceVertex(");
            this.convertToScript(o.outVertex().id());
            this.script.append(",");
            this.convertToScript(o.outVertex().label());
            return this.script.append("))");
        }

        @Override
        protected Script produceScript(VertexProperty<?> o) {
            this.script.append("new ReferenceVertexProperty(");
            this.convertToScript(o.id());
            this.script.append(",");
            this.convertToScript(o.label());
            this.script.append(",");
            this.convertToScript(o.value());
            return this.script.append(")");
        }

        @Override
        protected Script produceScript(TraversalStrategyProxy<?> o) {
            if (o.getConfiguration().isEmpty()) {
                return this.produceScript(o.getStrategyClass());
            }
            this.script.append("new ");
            this.produceScript(o.getStrategyClass());
            this.script.append("(");
            Iterator itty = ConfigurationConverter.getMap((Configuration)o.getConfiguration()).entrySet().iterator();
            while (itty.hasNext()) {
                Map.Entry entry = itty.next();
                this.script.append(entry.getKey().toString());
                this.script.append(": ");
                this.convertToScript(entry.getValue());
                if (!itty.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script.append(")");
        }

        @Override
        protected Script produceScript(String traversalSource, Bytecode bytecode) {
            this.script.append(traversalSource);
            for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
                Iterator itty;
                String methodName = instruction.getOperator();
                if (0 == instruction.getArguments().length) {
                    this.script.append(".").append(methodName).append("()");
                    continue;
                }
                this.script.append(".").append(methodName).append("(");
                if (methodName.equals("inject")) {
                    itty = Arrays.stream(instruction.getArguments()).iterator();
                    while (itty.hasNext()) {
                        Object o = itty.next();
                        if (null == o) {
                            this.script.append("(Object)");
                        }
                        this.convertToScript(o);
                        if (!itty.hasNext()) continue;
                        this.script.append(",");
                    }
                } else {
                    itty = Arrays.stream(instruction.getArguments()).iterator();
                    while (itty.hasNext()) {
                        this.convertToScript(itty.next());
                        if (!itty.hasNext()) continue;
                        this.script.append(",");
                    }
                }
                this.script.append(")");
            }
            return this.script;
        }

        @Override
        protected Script produceScript(P<?> p) {
            if (p instanceof TextP) {
                this.script.append("TextP.").append(p.getBiPredicate().toString()).append("(");
                this.convertToScript(p.getValue());
            } else if (p instanceof ConnectiveP) {
                List list = ((ConnectiveP)p).getPredicates();
                String connector = p instanceof OrP ? "or" : "and";
                for (int i = 0; i < list.size(); ++i) {
                    this.produceScript(list.get(i));
                    if (i > 0 && i < list.size() - 1) {
                        this.script.append(")");
                    }
                    if (i >= list.size() - 1) continue;
                    this.script.append(".").append(connector).append("(");
                }
            } else {
                this.script.append("P.").append(p.getBiPredicate().toString()).append("(");
                this.convertToScript(p.getValue());
            }
            this.script.append(")");
            return this.script;
        }

        private String convertMapToArguments(Map<Object, Object> map) {
            return map.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey().toString(), this.convertToScript(entry.getValue()))).collect(Collectors.joining(", "));
        }
    }
}

