/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.MapReducePool;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramPool;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMemory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerWorkerMemory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.function.TriConsumer;

public final class TinkerWorkerPool
implements AutoCloseable {
    private static final BasicThreadFactory THREAD_FACTORY_WORKER = new BasicThreadFactory.Builder().namingPattern("tinker-worker-%d").build();
    private final int numberOfWorkers;
    private final ExecutorService workerPool;
    private final CompletionService<Object> completionService;
    private VertexProgramPool vertexProgramPool;
    private MapReducePool mapReducePool;
    private final Queue<TinkerWorkerMemory> workerMemoryPool = new ConcurrentLinkedQueue<TinkerWorkerMemory>();
    private final List<List<Vertex>> workerVertices = new ArrayList<List<Vertex>>();

    public TinkerWorkerPool(TinkerGraph graph, TinkerMemory memory, int numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
        this.workerPool = Executors.newFixedThreadPool(numberOfWorkers, (ThreadFactory)THREAD_FACTORY_WORKER);
        this.completionService = new ExecutorCompletionService<Object>(this.workerPool);
        for (int i = 0; i < this.numberOfWorkers; ++i) {
            this.workerMemoryPool.add(new TinkerWorkerMemory(memory));
            this.workerVertices.add(new ArrayList());
        }
        int batchSize = TinkerHelper.getVertices(graph).size() / this.numberOfWorkers;
        if (0 == batchSize) {
            batchSize = 1;
        }
        int counter = 0;
        int index = 0;
        List<Vertex> currentWorkerVertices = this.workerVertices.get(index);
        Iterator<Vertex> iterator = graph.vertices(new Object[0]);
        while (iterator.hasNext()) {
            Vertex vertex = iterator.next();
            if (counter++ < batchSize || index == this.workerVertices.size() - 1) {
                currentWorkerVertices.add(vertex);
                continue;
            }
            currentWorkerVertices = this.workerVertices.get(++index);
            currentWorkerVertices.add(vertex);
            counter = 1;
        }
    }

    public void setVertexProgram(VertexProgram vertexProgram) {
        this.vertexProgramPool = new VertexProgramPool(vertexProgram, this.numberOfWorkers);
    }

    public void setMapReduce(MapReduce mapReduce) {
        this.mapReducePool = new MapReducePool(mapReduce, this.numberOfWorkers);
    }

    public void executeVertexProgram(TriConsumer<Iterator<Vertex>, VertexProgram, TinkerWorkerMemory> worker) throws InterruptedException {
        int i = 0;
        while (i < this.numberOfWorkers) {
            int index = i++;
            this.completionService.submit(() -> {
                VertexProgram vp = this.vertexProgramPool.take();
                TinkerWorkerMemory workerMemory = this.workerMemoryPool.poll();
                List<Vertex> vertices = this.workerVertices.get(index);
                worker.accept(vertices.iterator(), (Object)vp, (Object)workerMemory);
                this.vertexProgramPool.offer(vp);
                this.workerMemoryPool.offer(workerMemory);
                return null;
            });
        }
        for (i = 0; i < this.numberOfWorkers; ++i) {
            try {
                this.completionService.take().get();
                continue;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public void executeMapReduce(Consumer<MapReduce> worker) throws InterruptedException {
        int i;
        for (i = 0; i < this.numberOfWorkers; ++i) {
            this.completionService.submit(() -> {
                MapReduce mr = this.mapReducePool.take();
                worker.accept(mr);
                this.mapReducePool.offer(mr);
                return null;
            });
        }
        for (i = 0; i < this.numberOfWorkers; ++i) {
            try {
                this.completionService.take().get();
                continue;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public void closeNow() throws Exception {
        this.workerPool.shutdownNow();
    }

    @Override
    public void close() throws Exception {
        this.workerPool.shutdown();
    }
}

