/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.util.iterator.ArrayIterator;
import org.apache.tinkerpop.gremlin.util.iterator.DoubleIterator;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;
import org.apache.tinkerpop.gremlin.util.iterator.SingleIterator;

public final class IteratorUtils {
    private IteratorUtils() {
    }

    public static final <S> Iterator<S> of(S a) {
        return new SingleIterator<S>(a);
    }

    public static final <S> Iterator<S> of(S a, S b) {
        return new DoubleIterator<S>(a, b);
    }

    public static final <S extends Collection<T>, T> S fill(Iterator<T> iterator, S collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static void iterate(Iterator iterator) {
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public static final long count(Iterator iterator) {
        long ix = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++ix;
        }
        return ix;
    }

    public static final long count(Iterable iterable) {
        return IteratorUtils.count(iterable.iterator());
    }

    public static <S> List<S> list(Iterator<S> iterator) {
        return IteratorUtils.fill(iterator, new ArrayList());
    }

    public static <S> List<S> list(Iterator<S> iterator, Comparator comparator) {
        List<S> l = IteratorUtils.list(iterator);
        Collections.sort(l, comparator);
        return l;
    }

    public static <S> Set<S> set(Iterator<S> iterator) {
        return IteratorUtils.fill(iterator, new HashSet());
    }

    public static <S> Iterator<S> limit(final Iterator<S> iterator, final int limit) {
        return new Iterator<S>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext() && this.count < limit;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public S next() {
                if (this.count++ >= limit) {
                    throw FastNoSuchElementException.instance();
                }
                return iterator.next();
            }
        };
    }

    public static <T> boolean allMatch(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            if (predicate.test(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean noneMatch(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <K, S> Map<K, S> collectMap(Iterator<S> iterator, Function<S, K> key) {
        return IteratorUtils.collectMap(iterator, key, Function.identity());
    }

    public static <K, S, V> Map<K, V> collectMap(Iterator<S> iterator, Function<S, K> key, Function<S, V> value) {
        HashMap<K, V> map = new HashMap<K, V>();
        while (iterator.hasNext()) {
            S obj = iterator.next();
            map.put(key.apply(obj), value.apply(obj));
        }
        return map;
    }

    public static <K, S> Map<K, List<S>> groupBy(Iterator<S> iterator, Function<S, K> groupBy) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        while (iterator.hasNext()) {
            S obj = iterator.next();
            map.computeIfAbsent(groupBy.apply(obj), k -> new ArrayList()).add(obj);
        }
        return map;
    }

    public static <S> S reduce(Iterator<S> iterator, S identity, BinaryOperator<S> accumulator) {
        Object result = identity;
        while (iterator.hasNext()) {
            result = accumulator.apply(result, iterator.next());
        }
        return result;
    }

    public static <S> S reduce(Iterable<S> iterable, S identity, BinaryOperator<S> accumulator) {
        return IteratorUtils.reduce(iterable.iterator(), identity, accumulator);
    }

    public static <S, E> E reduce(Iterator<S> iterator, E identity, BiFunction<E, S, E> accumulator) {
        E result = identity;
        while (iterator.hasNext()) {
            result = accumulator.apply(result, iterator.next());
        }
        return result;
    }

    public static <S, E> E reduce(Iterable<S> iterable, E identity, BiFunction<E, S, E> accumulator) {
        return IteratorUtils.reduce(iterable.iterator(), identity, accumulator);
    }

    public static final <S> Iterator<S> consume(final Iterator<S> iterator, final Consumer<S> consumer) {
        return new Iterator<S>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public S next() {
                Object s = iterator.next();
                consumer.accept(s);
                return s;
            }
        };
    }

    public static final <S> Iterable<S> consume(Iterable<S> iterable, Consumer<S> consumer) {
        return () -> IteratorUtils.consume(iterable.iterator(), consumer);
    }

    public static final <S, E> Iterator<E> map(final Iterator<S> iterator, final Function<S, E> function) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public E next() {
                return function.apply(iterator.next());
            }
        };
    }

    public static final <S, E> Iterable<E> map(Iterable<S> iterable, Function<S, E> function) {
        return () -> IteratorUtils.map(iterable.iterator(), function);
    }

    public static <S, E> Iterator<E> cast(Iterator<S> iterator) {
        return IteratorUtils.map(iterator, (S s) -> s);
    }

    public static final <S> Iterator<S> filter(final Iterator<S> iterator, final Predicate<S> predicate) {
        return new Iterator<S>(){
            S nextResult = null;

            @Override
            public boolean hasNext() {
                if (null != this.nextResult) {
                    return true;
                }
                this.advance();
                return null != this.nextResult;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public S next() {
                try {
                    if (null != this.nextResult) {
                        Object s = this.nextResult;
                        return s;
                    }
                    this.advance();
                    if (null != this.nextResult) {
                        Object s = this.nextResult;
                        return s;
                    }
                    throw FastNoSuchElementException.instance();
                }
                finally {
                    this.nextResult = null;
                }
            }

            private final void advance() {
                this.nextResult = null;
                while (iterator.hasNext()) {
                    Object s = iterator.next();
                    if (!predicate.test(s)) continue;
                    this.nextResult = s;
                    return;
                }
            }
        };
    }

    public static final <S> Iterable<S> filter(Iterable<S> iterable, Predicate<S> predicate) {
        return () -> IteratorUtils.filter(iterable.iterator(), predicate);
    }

    public static final <S, E> Iterator<E> flatMap(final Iterator<S> iterator, final Function<S, Iterator<E>> function) {
        return new Iterator<E>(){
            private Iterator<E> currentIterator = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.currentIterator = (Iterator)function.apply(iterator.next());
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw FastNoSuchElementException.instance();
            }
        };
    }

    public static final <S> Iterator<S> concat(Iterator<S> ... iterators) {
        MultiIterator<S> iterator = new MultiIterator<S>();
        for (Iterator<S> itty : iterators) {
            iterator.addIterator(itty);
        }
        return iterator;
    }

    public static Iterator asIterator(Object o) {
        Iterator<Object> itty = o instanceof Iterable ? ((Iterable)o).iterator() : (o instanceof Iterator ? (ArrayIterator<Object>)o : (o instanceof Object[] ? new ArrayIterator<Object>((Object[])o) : (o instanceof Stream ? ((Stream)o).iterator() : (o instanceof Map ? ((Map)o).entrySet().iterator() : (o instanceof Throwable ? IteratorUtils.of(((Throwable)o).getMessage()) : IteratorUtils.of(o))))));
        return itty;
    }

    public static List asList(Object o) {
        return IteratorUtils.list(IteratorUtils.asIterator(o));
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1088), false).onClose(() -> CloseableIterator.closeIterator(iterator));
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return IteratorUtils.stream(iterable.iterator());
    }

    public static <T> Iterator<T> noRemove(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <T> Iterator<T> removeOnNext(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public T next() {
                Object object = iterator.next();
                iterator.remove();
                return object;
            }
        };
    }
}

