/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public final class DatetimeHelper {
    private static final DateTimeFormatter datetimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HHMMss", "Z").toFormatter();
    private static final DateTimeFormatter yearMonthFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(datetimeFormatter).appendOptional(DateTimeFormatter.ISO_LOCAL_DATE).appendOptional(yearMonthFormatter).toFormatter();

    private DatetimeHelper() {
    }

    public static String format(Instant d) {
        return datetimeFormatter.format(d.atZone(ZoneOffset.UTC));
    }

    public static Date parse(String d) {
        TemporalAccessor t = formatter.parse(d);
        if (!t.isSupported(ChronoField.HOUR_OF_DAY)) {
            if (!t.isSupported(ChronoField.DAY_OF_MONTH)) {
                return Date.from(YearMonth.from(t).atDay(1).atStartOfDay(ZoneOffset.UTC).toInstant());
            }
            return Date.from(Instant.ofEpochSecond(LocalDate.from(t).atStartOfDay().toEpochSecond(ZoneOffset.UTC)));
        }
        if (!t.isSupported(ChronoField.MONTH_OF_YEAR)) {
            Instant timeOnEpochDay = LocalDate.ofEpochDay(0L).atTime(LocalTime.from(t)).atZone(ZoneOffset.UTC).toInstant();
            return Date.from(timeOnEpochDay);
        }
        if (t.isSupported(ChronoField.OFFSET_SECONDS)) {
            return Date.from(ZonedDateTime.from(t).toInstant());
        }
        return Date.from(ZonedDateTime.of(LocalDateTime.from(t), ZoneOffset.UTC).toInstant());
    }

    public static Date datetime(String d) {
        return DatetimeHelper.parse(d);
    }
}

