/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.Text;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GolangTranslator
implements Translator.ScriptTranslator {
    private final String traversalSource;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;
    private static final String GO_PACKAGE_NAME = "gremlingo.";
    private static final Set<String> METHODS_TO_CHECK = new HashSet<String>(Arrays.asList("inject", "withSack", "sample", "with", "constant"));

    private GolangTranslator(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        this.traversalSource = traversalSource;
        this.typeTranslator = typeTranslator;
    }

    public static GolangTranslator of(String traversalSource) {
        return GolangTranslator.of(traversalSource, false);
    }

    public static GolangTranslator of(String traversalSource, boolean withParameters) {
        return GolangTranslator.of(traversalSource, new DefaultTypeTranslator(withParameters));
    }

    public static GolangTranslator of(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        return new GolangTranslator(traversalSource, typeTranslator);
    }

    @Override
    public String getTraversalSource() {
        return this.traversalSource;
    }

    @Override
    public Script translate(Bytecode bytecode) {
        return (Script)this.typeTranslator.apply(this.traversalSource, bytecode);
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-go";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_GO_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_GO_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toGolang(String symbol) {
            return TO_GO_MAP.getOrDefault(symbol, StringUtils.capitalize((String)symbol));
        }

        public static String toJava(String symbol) {
            return FROM_GO_MAP.getOrDefault(symbol, StringUtils.uncapitalize((String)symbol));
        }

        static {
            TO_GO_MAP.put("OUT", "Out");
            TO_GO_MAP.put("IN", "In");
            TO_GO_MAP.put("BOTH", "Both");
            TO_GO_MAP.put("set", "Set_");
            TO_GO_MAP.forEach((k, v) -> FROM_GO_MAP.put((String)v, (String)k));
        }
    }

    public static class DefaultTypeTranslator
    extends Translator.ScriptTranslator.AbstractTypeTranslator {
        public DefaultTypeTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected String getNullSyntax() {
            return "nil";
        }

        @Override
        protected String getSyntax(String o) {
            return "\"" + StringEscapeUtils.escapeJava((String)o) + "\"";
        }

        @Override
        protected String getSyntax(Boolean o) {
            return o.toString();
        }

        @Override
        protected String getSyntax(Date o) {
            return "time.Unix(" + o.getTime() + ", 0)";
        }

        @Override
        protected String getSyntax(Timestamp o) {
            return "time.Unix(" + o.getTime() + ", 0)";
        }

        @Override
        protected String getSyntax(UUID o) {
            return "uuid.MustParse(\"" + o.toString() + "\")";
        }

        @Override
        protected String getSyntax(Lambda o) {
            return "&gremlingo.Lambda{Script:\"" + o.getLambdaScript().trim() + "\", Language:\"\"}";
        }

        @Override
        protected String getSyntax(Number o) {
            if (o instanceof Float || o instanceof Double) {
                if (NumberHelper.isNaN(o)) {
                    return "math.NaN()";
                }
                if (NumberHelper.isPositiveInfinity(o)) {
                    return "math.Inf(1)";
                }
                if (NumberHelper.isNegativeInfinity(o)) {
                    return "math.Inf(-11)";
                }
            }
            return o.toString();
        }

        @Override
        protected String getSyntax(SackFunctions.Barrier o) {
            return GolangTranslator.GO_PACKAGE_NAME + this.resolveSymbol(o.toString());
        }

        @Override
        protected String getSyntax(VertexProperty.Cardinality o) {
            return GolangTranslator.GO_PACKAGE_NAME + this.resolveSymbol(o.toString());
        }

        @Override
        protected String getSyntax(Pick o) {
            return GolangTranslator.GO_PACKAGE_NAME + this.resolveSymbol(o.toString());
        }

        @Override
        protected Script produceScript(Set<?> o) {
            Iterator<?> iterator = o.iterator();
            this.script.append("[]interface{}{");
            while (iterator.hasNext()) {
                this.convertToScript(iterator.next());
                if (!iterator.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script.append("}");
        }

        @Override
        protected Script produceScript(List<?> o) {
            Iterator<?> iterator = o.iterator();
            while (iterator.hasNext()) {
                this.convertToScript(iterator.next());
                if (!iterator.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script;
        }

        @Override
        protected Script produceScript(Map<?, ?> o) {
            this.script.append("map[interface{}]interface{}{");
            Iterator<Map.Entry<?, ?>> itty = o.entrySet().iterator();
            while (itty.hasNext()) {
                Map.Entry<?, ?> entry = itty.next();
                this.convertToScript(entry.getKey()).append(": ");
                this.convertToScript(entry.getValue());
                if (!itty.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script.append("}");
        }

        @Override
        protected Script produceScript(Class<?> o) {
            return this.script.append(o.getCanonicalName());
        }

        @Override
        protected Script produceScript(Enum<?> o) {
            return this.script.append(GolangTranslator.GO_PACKAGE_NAME + this.resolveSymbol(o.toString()));
        }

        @Override
        protected Script produceScript(Vertex o) {
            this.script.append("gremlingo.Vertex{Element{");
            this.convertToScript(o.id()).append(", ");
            return this.convertToScript(o.label()).append("}}");
        }

        @Override
        protected Script produceScript(Edge o) {
            this.script.append("gremlingo.Edge{Element{");
            this.convertToScript(o.id()).append(", ");
            this.convertToScript(o.label()).append("}, ");
            this.convertToScript(o.outVertex()).append(",");
            return this.convertToScript(o.inVertex()).append("}");
        }

        @Override
        protected Script produceScript(VertexProperty<?> o) {
            this.script.append("gremlingo.VertexProperty{");
            this.convertToScript(o.id()).append(", ");
            this.convertToScript(o.label()).append("}, ");
            return this.convertToScript(o.value()).append("}");
        }

        @Override
        protected Script produceScript(TraversalStrategyProxy<?> o) {
            throw new NotImplementedException("TraversalStrategy translation not currently supported");
        }

        @Override
        protected Script produceScript(String traversalSource, Bytecode o) {
            String source = traversalSource.equals("__") ? "gremlingo.T__" : traversalSource;
            this.script.append(source);
            for (Bytecode.Instruction instruction : o.getInstructions()) {
                String methodName = instruction.getOperator();
                Object[] arguments = instruction.getArguments();
                this.script.append(".").append(this.resolveSymbol(methodName)).append("(");
                for (int i = 0; i < arguments.length; ++i) {
                    if (methodName.equals("times")) {
                        this.script.append("int32(");
                        this.convertToScript(arguments[i]);
                        this.script.append(")");
                        continue;
                    }
                    if (METHODS_TO_CHECK.contains(methodName) && arguments[i] instanceof Integer) {
                        this.script.append("int32(");
                        this.convertToScript(arguments[i]);
                        this.script.append(")");
                        if (i == arguments.length - 1) continue;
                        this.script.append(", ");
                        continue;
                    }
                    this.convertToScript(arguments[i]);
                    if (i == arguments.length - 1) continue;
                    this.script.append(", ");
                }
                this.script.append(")");
            }
            return this.script;
        }

        @Override
        protected Script produceScript(P<?> p) {
            if (p instanceof TextP) {
                BiPredicate<?, ?> tp = p.getBiPredicate();
                if (tp instanceof Text.RegexPredicate) {
                    String regexToken = ((Text.RegexPredicate)p.getBiPredicate()).isNegate() ? "NotRegex" : "Regex";
                    this.script.append("gremlingo.TextP.").append(regexToken).append("(");
                } else if (tp instanceof Text) {
                    this.script.append("gremlingo.TextP.").append(this.resolveSymbol(p.getBiPredicate().toString())).append("(");
                } else {
                    this.script.append("gremlingo.TextP.").append(this.resolveSymbol(p.getBiPredicate().toString())).append("(");
                }
                this.convertToScript(p.getValue());
            } else if (p instanceof ConnectiveP) {
                List list = ((ConnectiveP)p).getPredicates();
                String connector = p instanceof OrP ? "Or" : "And";
                for (int i = 0; i < list.size(); ++i) {
                    this.produceScript(list.get(i));
                    if (i > 0 && i < list.size() - 1) {
                        this.script.append(")");
                    }
                    if (i >= list.size() - 1) continue;
                    this.script.append(".").append(connector).append("(");
                }
            } else {
                this.script.append("gremlingo.P.").append(this.resolveSymbol(p.getBiPredicate().toString())).append("(");
                this.convertToScript(p.getValue());
            }
            this.script.append(")");
            return this.script;
        }

        protected String resolveSymbol(String methodName) {
            return SymbolHelper.toGolang(methodName);
        }
    }
}

