/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.ComparatorHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Seedable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalProduct;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.javatuples.Pair;

public final class OrderLocalStep<S, C extends Comparable>
extends ScalarMapStep<S, S>
implements ComparatorHolder<S, C>,
ByModulating,
TraversalParent,
Seedable {
    private List<Pair<Traversal.Admin<S, C>, Comparator<C>>> comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
    private final Random random = new Random();

    public OrderLocalStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    public void resetSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start = traverser.get();
        if (start instanceof Collection) {
            Collection original = (Collection)start;
            List<Pair<S, List<C>>> filteredAndModulated = this.filterAndModulate(original);
            return (S)filteredAndModulated.stream().map(Pair::getValue0).collect(Collectors.toList());
        }
        if (start instanceof Map) {
            List filteredAndModulated = this.filterAndModulate(((Map)start).entrySet());
            LinkedHashMap sortedMap = new LinkedHashMap();
            filteredAndModulated.stream().map(Pair::getValue0).map((? super T entry) -> (Map.Entry)entry).forEach(entry -> sortedMap.put(entry.getKey(), entry.getValue()));
            return (S)sortedMap;
        }
        return (S)start;
    }

    private List<Pair<S, List<C>>> filterAndModulate(Collection<S> original) {
        if (this.comparators.isEmpty()) {
            this.comparators.add(new Pair(new IdentityTraversal(), (Object)Order.asc));
        }
        boolean isShuffle = (Comparator)this.comparators.get(this.comparators.size() - 1).getValue1() == Order.shuffle;
        List relevantComparators = isShuffle ? this.comparators : this.comparators.stream().filter(p -> (Comparator)p.getValue1() != Order.shuffle).collect(Collectors.toList());
        ArrayList<Pair<S, List<C>>> filteredAndModulated = new ArrayList<Pair<S, List<C>>>();
        List modulators = relevantComparators.stream().map(Pair::getValue0).collect(Collectors.toList());
        for (Object s : original) {
            List modulations = modulators.stream().map((? super T t) -> TraversalUtil.produce(s, t)).filter(TraversalProduct::isProductive).map((? super T product) -> (Comparable)product.get()).collect(Collectors.toList());
            if (modulations.size() != modulators.size()) continue;
            filteredAndModulated.add(Pair.with(s, modulations));
        }
        if (isShuffle) {
            Collections.shuffle(filteredAndModulated, this.random);
        } else {
            Collections.sort(filteredAndModulated, (o1, o2) -> {
                List modulated1 = (List)o1.getValue1();
                List modulated2 = (List)o2.getValue1();
                for (int ix = 0; ix < modulated1.size(); ++ix) {
                    int comparison = ((Comparator)((Pair)relevantComparators.get(ix)).getValue1()).compare(modulated1.get(ix), modulated2.get(ix));
                    if (comparison == 0) continue;
                    return comparison;
                }
                return 0;
            });
        }
        return filteredAndModulated;
    }

    @Override
    public void addComparator(Traversal.Admin<S, C> traversal, Comparator<C> comparator) {
        this.comparators.add(new Pair(this.integrateChild(traversal), comparator));
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal) {
        this.addComparator(traversal, Order.asc);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal, Comparator comparator) {
        this.addComparator(traversal, comparator);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        int i = 0;
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> pair : this.comparators) {
            Traversal.Admin traversal = (Traversal.Admin)pair.getValue0();
            if (null != traversal && traversal.equals((Object)oldTraversal)) {
                this.comparators.set(i, Pair.with(this.integrateChild(newTraversal), (Object)pair.getValue1()));
                break;
            }
            ++i;
        }
    }

    @Override
    public List<Pair<Traversal.Admin<S, C>, Comparator<C>>> getComparators() {
        return this.comparators.isEmpty() ? Collections.singletonList(new Pair(new IdentityTraversal(), (Object)Order.asc)) : Collections.unmodifiableList(this.comparators);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.comparators);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (int i = 0; i < this.comparators.size(); ++i) {
            result ^= this.comparators.get(i).hashCode() * (i + 1);
        }
        return result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    public List<Traversal.Admin<S, C>> getLocalChildren() {
        return this.comparators.stream().map(Pair::getValue0).collect(Collectors.toList());
    }

    @Override
    public OrderLocalStep<S, C> clone() {
        OrderLocalStep clone = (OrderLocalStep)super.clone();
        clone.comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> comparator : this.comparators) {
            clone.comparators.add(new Pair(((Traversal.Admin)comparator.getValue0()).clone(), comparator.getValue1()));
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.comparators.stream().map(Pair::getValue0).forEach(x$0 -> TraversalParent.super.integrateChild((Traversal.Admin<?, ?>)x$0));
    }
}

