/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MergeVertexStep<S>
extends FlatMapStep<S, Vertex>
implements Mutating<Event>,
TraversalOptionParent<Merge, S, Vertex> {
    private final boolean isStart;
    private boolean first = true;
    private Traversal.Admin<S, Map<Object, Object>> searchCreateTraversal;
    private Traversal.Admin<S, Map<Object, Object>> onCreateTraversal = null;
    private Traversal.Admin<S, Map<String, Object>> onMatchTraversal = null;
    protected CallbackRegistry<Event> callbackRegistry;

    public MergeVertexStep(Traversal.Admin traversal, boolean isStart) {
        this(traversal, isStart, new IdentityTraversal<Map<Object, Object>>());
    }

    public MergeVertexStep(Traversal.Admin traversal, boolean isStart, Map<Object, Object> searchCreate) {
        this(traversal, isStart, new ConstantTraversal(searchCreate));
    }

    public MergeVertexStep(Traversal.Admin traversal, boolean isStart, Traversal.Admin<S, Map<Object, Object>> searchCreateTraversal) {
        super(traversal);
        this.isStart = isStart;
        this.searchCreateTraversal = this.integrateChild(searchCreateTraversal);
    }

    public Traversal.Admin<S, Map<Object, Object>> getSearchCreateTraversal() {
        return this.searchCreateTraversal;
    }

    public Traversal.Admin<S, Map<Object, Object>> getOnCreateTraversal() {
        return this.onCreateTraversal;
    }

    public Traversal.Admin<S, Map<String, Object>> getOnMatchTraversal() {
        return this.onMatchTraversal;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isFirst() {
        return this.first;
    }

    public CallbackRegistry<Event> getCallbackRegistry() {
        return this.callbackRegistry;
    }

    @Override
    public void addChildOption(Merge token, Traversal.Admin<S, Vertex> traversalOption) {
        if (token == Merge.onCreate) {
            this.onCreateTraversal = this.integrateChild(traversalOption);
        } else if (token == Merge.onMatch) {
            this.onMatchTraversal = this.integrateChild(traversalOption);
        } else {
            throw new UnsupportedOperationException(String.format("Option %s for Merge is not supported", token.name()));
        }
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        ArrayList<Traversal.Admin<S, Traversal.Admin<S, Map<Object, Object>>>> children = new ArrayList<Traversal.Admin<S, Traversal.Admin<S, Map<Object, Object>>>>();
        if (this.searchCreateTraversal != null) {
            children.add(this.searchCreateTraversal);
        }
        if (this.onMatchTraversal != null) {
            children.add(this.onMatchTraversal);
        }
        if (this.onCreateTraversal != null) {
            children.add(this.onCreateTraversal);
        }
        return children;
    }

    @Override
    public void configure(Object ... keyValues) {
    }

    @Override
    public Parameters getParameters() {
        return null;
    }

    @Override
    protected Traverser.Admin<Vertex> processNextStart() {
        if (this.isStart && this.first) {
            this.first = false;
            this.generateTraverser(false);
        }
        return super.processNextStart();
    }

    private void generateTraverser(Object o) {
        TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
        this.addStart(generator.generate(o, this, 1L));
    }

    protected Stream<Vertex> createSearchStream(Map<Object, Object> search) {
        Graph graph = this.getTraversal().getGraph().get();
        if (null == search) {
            return Stream.empty();
        }
        Stream<Vertex> stream = search.containsKey(T.id) ? IteratorUtils.stream(graph.vertices(search.get(T.id))) : IteratorUtils.stream(graph.vertices(new Object[0]));
        stream = stream.filter(v -> search.entrySet().stream().filter(kv -> kv.getKey() != T.id).allMatch(kv -> {
            if (kv.getKey() == T.label) {
                return v.label().equals(kv.getValue());
            }
            Property vp = v.property(kv.getKey().toString());
            return vp.isPresent() && kv.getValue().equals(vp.value());
        }));
        return stream;
    }

    @Override
    protected Iterator<Vertex> flatMap(Traverser.Admin<S> traverser) {
        Map<Object, Object> onCreateMap;
        Map<Object, Object> searchCreate = TraversalUtil.apply(traverser, this.searchCreateTraversal);
        MergeVertexStep.validateMapInput(searchCreate, false);
        Stream<Vertex> stream = this.createSearchStream(searchCreate);
        stream = stream.map(v -> {
            if (null == this.onMatchTraversal) {
                return v;
            }
            if (this.isStart) {
                traverser.set(v);
            }
            Map<String, Object> onMatchMap = TraversalUtil.apply(traverser, this.onMatchTraversal);
            MergeVertexStep.validateMapInput(onMatchMap, true);
            if (onMatchMap != null) {
                onMatchMap.forEach((key, value) -> {
                    if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
                        EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                        Property p = v.property((String)key);
                        Property oldValue = p.isPresent() ? eventStrategy.detach(v.property((String)key)) : null;
                        Event.VertexPropertyChangedEvent vpce = new Event.VertexPropertyChangedEvent(eventStrategy.detach(v), oldValue, value, new Object[0]);
                        this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vpce));
                    }
                    Graph graph = this.getTraversal().getGraph().get();
                    v.property(graph.features().vertex().getCardinality((String)key), (String)key, value, new Object[0]);
                });
            }
            return v;
        });
        Iterator<Vertex> vertices = stream.iterator();
        if (vertices.hasNext()) {
            return vertices;
        }
        boolean useOnCreate = this.onCreateTraversal != null;
        Map<Object, Object> map = onCreateMap = useOnCreate ? TraversalUtil.apply(traverser, this.onCreateTraversal) : searchCreate;
        if (useOnCreate) {
            MergeVertexStep.validateMapInput(onCreateMap, false);
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        if (onCreateMap != null) {
            for (Map.Entry<Object, Object> entry : onCreateMap.entrySet()) {
                keyValues.add(entry.getKey());
                keyValues.add(entry.getValue());
            }
            Vertex vertex = this.getTraversal().getGraph().get().addVertex(keyValues.toArray(new Object[keyValues.size()]));
            if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
                EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                Event.VertexAddedEvent vae = new Event.VertexAddedEvent(eventStrategy.detach(vertex));
                this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
            }
            return IteratorUtils.of(vertex);
        }
        return Collections.emptyIterator();
    }

    public static void validateMapInput(Map<?, Object> m, boolean ignoreTokens) {
        if (null == m) {
            return;
        }
        if (ignoreTokens) {
            m.entrySet().stream().filter(e -> {
                Object k = e.getKey();
                return !(k instanceof String);
            }).findFirst().map(e -> {
                throw new IllegalArgumentException(String.format("option(onMatch) expects keys in Map to be of String - check: %s", e.getKey()));
            });
        } else {
            m.entrySet().stream().filter(e -> {
                Object k = e.getKey();
                return k != T.id && k != T.label && !(k instanceof String);
            }).findFirst().map(e -> {
                throw new IllegalArgumentException(String.format("mergeV() and option(onCreate) expects keys in Map to be of String, T.id, T.label - check: %s", e.getKey()));
            });
        }
        if (!ignoreTokens) {
            if (m.containsKey(T.id) && null == m.get(T.id)) {
                throw new IllegalArgumentException("Vertex id cannot be null");
            }
            if (m.containsKey(T.label)) {
                Object l = m.get(T.label);
                if (null == l) {
                    throw new IllegalArgumentException("Vertex label cannot be null");
                }
                if (!(l instanceof String)) {
                    throw new IllegalArgumentException(String.format("mergeV() expects T.label value to be of String - found: %s", l.getClass().getSimpleName()));
                }
            }
        }
    }

    @Override
    public CallbackRegistry<Event> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.searchCreateTraversal != null) {
            result ^= this.searchCreateTraversal.hashCode();
        }
        if (this.onCreateTraversal != null) {
            result ^= this.onCreateTraversal.hashCode();
        }
        if (this.onMatchTraversal != null) {
            result ^= this.onMatchTraversal.hashCode();
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.first = true;
        this.searchCreateTraversal.reset();
        if (this.onCreateTraversal != null) {
            this.onCreateTraversal.reset();
        }
        if (this.onMatchTraversal != null) {
            this.onMatchTraversal.reset();
        }
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.searchCreateTraversal, this.onCreateTraversal, this.onMatchTraversal);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.searchCreateTraversal);
        this.integrateChild(this.onCreateTraversal);
        this.integrateChild(this.onMatchTraversal);
    }

    @Override
    public MergeVertexStep<S> clone() {
        MergeVertexStep clone = (MergeVertexStep)super.clone();
        clone.searchCreateTraversal = this.searchCreateTraversal.clone();
        clone.onCreateTraversal = this.onCreateTraversal != null ? this.onCreateTraversal.clone() : null;
        clone.onMatchTraversal = this.onMatchTraversal != null ? this.onMatchTraversal.clone() : null;
        return clone;
    }
}

