/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MergeEdgeStep<S>
extends FlatMapStep<S, Edge>
implements Mutating<Event>,
TraversalOptionParent<Merge, S, Edge> {
    public static final Vertex PLACEHOLDER_VERTEX = new ReferenceVertex(Graph.Hidden.hide(MergeEdgeStep.class.getName()));
    private final boolean isStart;
    private boolean first = true;
    private Traversal.Admin<S, Map<Object, Object>> searchCreateTraversal;
    private Traversal.Admin<S, Map<Object, Object>> onCreateTraversal = null;
    private Traversal.Admin<S, Map<String, Object>> onMatchTraversal = null;
    protected CallbackRegistry<Event> callbackRegistry;

    public MergeEdgeStep(Traversal.Admin traversal, boolean isStart) {
        this(traversal, isStart, new IdentityTraversal<Map<Object, Object>>());
    }

    public MergeEdgeStep(Traversal.Admin traversal, boolean isStart, Map<Object, Object> searchCreate) {
        this(traversal, isStart, new ConstantTraversal(searchCreate));
    }

    public MergeEdgeStep(Traversal.Admin traversal, boolean isStart, Traversal.Admin<?, Map<Object, Object>> searchCreateTraversal) {
        super(traversal);
        this.isStart = isStart;
        this.searchCreateTraversal = this.integrateChild(searchCreateTraversal);
    }

    public Traversal.Admin<S, Map<Object, Object>> getSearchCreateTraversal() {
        return this.searchCreateTraversal;
    }

    public Traversal.Admin<S, Map<Object, Object>> getOnCreateTraversal() {
        return this.onCreateTraversal;
    }

    public Traversal.Admin<S, Map<String, Object>> getOnMatchTraversal() {
        return this.onMatchTraversal;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isFirst() {
        return this.first;
    }

    public CallbackRegistry<Event> getCallbackRegistry() {
        return this.callbackRegistry;
    }

    @Override
    public void addChildOption(Merge token, Traversal.Admin<S, Edge> traversalOption) {
        if (token == Merge.onCreate) {
            this.onCreateTraversal = this.integrateChild(traversalOption);
        } else if (token == Merge.onMatch) {
            this.onMatchTraversal = this.integrateChild(traversalOption);
        } else {
            throw new UnsupportedOperationException(String.format("Option %s for Merge is not supported", token.name()));
        }
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        ArrayList<Traversal.Admin<S, Traversal.Admin<S, Map<Object, Object>>>> children = new ArrayList<Traversal.Admin<S, Traversal.Admin<S, Map<Object, Object>>>>();
        if (this.searchCreateTraversal != null) {
            children.add(this.searchCreateTraversal);
        }
        if (this.onMatchTraversal != null) {
            children.add(this.onMatchTraversal);
        }
        if (this.onCreateTraversal != null) {
            children.add(this.onCreateTraversal);
        }
        return children;
    }

    @Override
    public void configure(Object ... keyValues) {
    }

    @Override
    public Parameters getParameters() {
        return null;
    }

    @Override
    protected Traverser.Admin<Edge> processNextStart() {
        if (this.isStart && this.first) {
            this.first = false;
            TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
            this.addStart(generator.generate(PLACEHOLDER_VERTEX, this, 1L));
        }
        return super.processNextStart();
    }

    protected Stream<Edge> createSearchStream(Map<Object, Object> search) {
        Optional<Object> directionUsedInLookup;
        Stream<Edge> stream;
        Graph graph = this.getTraversal().getGraph().get();
        if (null == search) {
            return Stream.empty();
        }
        if (search.containsKey(T.id)) {
            stream = IteratorUtils.stream(graph.edges(search.get(T.id)));
            directionUsedInLookup = Optional.empty();
        } else if (search.containsKey((Object)Direction.BOTH)) {
            stream = IteratorUtils.stream(graph.vertices(search.get((Object)Direction.BOTH))).flatMap((? super T v) -> IteratorUtils.stream(v.edges(Direction.BOTH, new String[0]))).distinct();
            directionUsedInLookup = Optional.of(Direction.BOTH);
        } else if (search.containsKey((Object)Direction.OUT)) {
            stream = IteratorUtils.stream(graph.vertices(search.get((Object)Direction.OUT))).flatMap((? super T v) -> IteratorUtils.stream(v.edges(Direction.OUT, new String[0])));
            directionUsedInLookup = Optional.of(Direction.OUT);
        } else if (search.containsKey((Object)Direction.IN)) {
            stream = IteratorUtils.stream(graph.vertices(search.get((Object)Direction.IN))).flatMap((? super T v) -> IteratorUtils.stream(v.edges(Direction.IN, new String[0])));
            directionUsedInLookup = Optional.of(Direction.IN);
        } else {
            stream = IteratorUtils.stream(graph.edges(new Object[0]));
            directionUsedInLookup = Optional.empty();
        }
        stream = stream.filter(e -> search.entrySet().stream().filter(kv -> kv.getKey() != T.id && (!directionUsedInLookup.isPresent() || kv.getKey() != directionUsedInLookup.get())).allMatch(kv -> {
            if (kv.getKey() == T.label) {
                return e.label().equals(kv.getValue());
            }
            if (kv.getKey() instanceof Direction) {
                Direction direction = (Direction)((Object)((Object)((Object)kv.getKey())));
                Iterator<Vertex> found = graph.vertices(kv.getValue());
                Iterator<Vertex> dfound = e.vertices(direction);
                boolean matched = found.hasNext() && dfound.next().equals(found.next());
                CloseableIterator.closeIterator(found);
                CloseableIterator.closeIterator(dfound);
                return matched;
            }
            Property vp = e.property(kv.getKey().toString());
            return vp.isPresent() && kv.getValue().equals(vp.value());
        }));
        return stream;
    }

    @Override
    protected Iterator<Edge> flatMap(Traverser.Admin<S> traverser) {
        HashMap<Object, Object> onCreateMap;
        HashMap<Object, Object> searchCreateCopy;
        Map<Object, Object> searchCreate = TraversalUtil.apply(traverser, this.searchCreateTraversal);
        MergeEdgeStep.validateMapInput(searchCreate, false);
        Vertex outV = this.resolveVertex(traverser, searchCreate, Direction.OUT);
        Vertex inV = this.resolveVertex(traverser, searchCreate, Direction.IN);
        HashMap<Object, Object> hashMap = searchCreateCopy = null == searchCreate ? null : new HashMap<Object, Object>();
        if (searchCreateCopy != null) {
            searchCreateCopy.putAll(searchCreate);
            if (!searchCreateCopy.containsKey((Object)Direction.OUT) && !searchCreateCopy.containsKey((Object)Direction.IN) && outV == inV && inV != PLACEHOLDER_VERTEX) {
                searchCreateCopy.put((Object)Direction.BOTH, outV);
            }
        }
        Stream<Edge> stream = this.createSearchStream(searchCreateCopy);
        Iterator<Edge> edges = (stream = stream.map(e -> {
            if (null == this.onMatchTraversal) {
                return e;
            }
            if (this.isStart) {
                traverser.set(e);
            }
            Map<String, Object> onMatchMap = TraversalUtil.apply(traverser, this.onMatchTraversal);
            MergeEdgeStep.validateMapInput(onMatchMap, true);
            if (onMatchMap != null) {
                onMatchMap.forEach((key, value) -> {
                    if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
                        EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                        Property p = e.property((String)key);
                        Property oldValue = p.isPresent() ? eventStrategy.detach(e.property((String)key)) : null;
                        Event.EdgePropertyChangedEvent vpce = new Event.EdgePropertyChangedEvent(eventStrategy.detach(e), oldValue, value);
                        this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vpce));
                    }
                    e.property((String)key, value);
                });
            }
            return e;
        })).iterator();
        if (edges.hasNext()) {
            return edges;
        }
        boolean useOnCreate = this.onCreateTraversal != null;
        Map<Object, Object> map = onCreateMap = useOnCreate ? TraversalUtil.apply(traverser, this.onCreateTraversal) : searchCreateCopy;
        if (useOnCreate) {
            MergeEdgeStep.validateMapInput(onCreateMap, false);
        }
        if (onCreateMap != null) {
            if (outV == PLACEHOLDER_VERTEX && !onCreateMap.containsKey((Object)Direction.OUT)) {
                throw new IllegalArgumentException("Out Vertex not specified - edge cannot be created");
            }
            if (inV == PLACEHOLDER_VERTEX && !onCreateMap.containsKey((Object)Direction.IN)) {
                throw new IllegalArgumentException("In Vertex not specified - edge cannot be created");
            }
            ArrayList<Object> keyValues = new ArrayList<Object>();
            String label = "edge";
            Vertex fromV = outV;
            Vertex toV = inV;
            for (Map.Entry entry : onCreateMap.entrySet()) {
                if (entry.getKey() instanceof Direction) {
                    Object o;
                    if (useOnCreate && entry.getKey().equals((Object)Direction.IN)) {
                        o = searchCreateCopy.getOrDefault((Object)Direction.IN, entry.getValue());
                        toV = this.tryAttachVertex(o instanceof Vertex ? (Vertex)o : new ReferenceVertex(o));
                        continue;
                    }
                    if (!useOnCreate || !entry.getKey().equals((Object)Direction.OUT)) continue;
                    o = searchCreateCopy.getOrDefault((Object)Direction.OUT, entry.getValue());
                    fromV = this.tryAttachVertex(o instanceof Vertex ? (Vertex)o : new ReferenceVertex(o));
                    continue;
                }
                if (entry.getKey().equals(T.label)) {
                    label = (String)entry.getValue();
                    continue;
                }
                keyValues.add(entry.getKey());
                keyValues.add(entry.getValue());
            }
            Edge edge = fromV.addEdge(label, toV, keyValues.toArray(new Object[keyValues.size()]));
            if (this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty()) {
                EventStrategy eventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class).get();
                Event.EdgeAddedEvent vae = new Event.EdgeAddedEvent(eventStrategy.detach(edge));
                this.callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
            }
            return IteratorUtils.of(edge);
        }
        return Collections.emptyIterator();
    }

    protected Vertex resolveVertex(Traverser.Admin<S> traverser, Map<Object, Object> searchCreate, Direction direction) {
        Vertex v;
        Vertex traverserVertex = traverser.get() instanceof Vertex ? (Vertex)traverser.get() : PLACEHOLDER_VERTEX;
        Vertex o = searchCreate != null ? searchCreate.getOrDefault((Object)direction, traverserVertex) : traverserVertex;
        Vertex vertex = v = o instanceof Vertex ? o : new ReferenceVertex((Object)o);
        if (v != PLACEHOLDER_VERTEX && v instanceof Attachable) {
            return this.tryAttachVertex(v);
        }
        return v;
    }

    protected Vertex tryAttachVertex(Vertex maybeAttachable) {
        if (maybeAttachable instanceof Attachable) {
            try {
                return (Vertex)((Attachable)((Object)maybeAttachable)).attach(Attachable.Method.get(this.getTraversal().getGraph().orElse(EmptyGraph.instance())));
            }
            catch (IllegalStateException ise) {
                throw new IllegalArgumentException(String.format("%s could not be found and edge could not be created", maybeAttachable));
            }
        }
        return maybeAttachable;
    }

    public static void validateMapInput(Map<?, Object> m, boolean ignoreTokens) {
        if (null == m) {
            return;
        }
        if (ignoreTokens) {
            m.entrySet().stream().filter(e -> {
                Object k = e.getKey();
                return !(k instanceof String);
            }).findFirst().map(e -> {
                throw new IllegalArgumentException(String.format("option(onMatch) expects keys in Map to be of String - check: %s", e.getKey()));
            });
        } else {
            m.entrySet().stream().filter(e -> {
                Object k = e.getKey();
                return k != T.id && k != T.label && k != Direction.OUT && k != Direction.IN && !(k instanceof String);
            }).findFirst().map(e -> {
                throw new IllegalArgumentException(String.format("mergeE() and option(onCreate) expects keys in Map to be of String, T.id, T.label, or any Direction except BOTH - check: %s", e.getKey()));
            });
        }
        if (!ignoreTokens) {
            m.entrySet().stream().filter(e -> e.getKey() == T.label && !(e.getValue() instanceof String)).findFirst().map(e -> {
                throw new IllegalArgumentException(String.format("mergeE() expects T.label value to be of String - found: %s", e.getValue().getClass().getSimpleName()));
            });
        }
    }

    @Override
    public CallbackRegistry<Event> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.searchCreateTraversal != null) {
            result ^= this.searchCreateTraversal.hashCode();
        }
        if (this.onCreateTraversal != null) {
            result ^= this.onCreateTraversal.hashCode();
        }
        if (this.onMatchTraversal != null) {
            result ^= this.onMatchTraversal.hashCode();
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.first = true;
        this.searchCreateTraversal.reset();
        if (this.onCreateTraversal != null) {
            this.onCreateTraversal.reset();
        }
        if (this.onMatchTraversal != null) {
            this.onMatchTraversal.reset();
        }
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.searchCreateTraversal, this.onCreateTraversal, this.onMatchTraversal);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.searchCreateTraversal);
        this.integrateChild(this.onCreateTraversal);
        this.integrateChild(this.onMatchTraversal);
    }

    @Override
    public MergeEdgeStep<S> clone() {
        MergeEdgeStep clone = (MergeEdgeStep)super.clone();
        clone.searchCreateTraversal = this.searchCreateTraversal.clone();
        clone.onCreateTraversal = this.onCreateTraversal != null ? this.onCreateTraversal.clone() : null;
        clone.onMatchTraversal = this.onMatchTraversal != null ? this.onMatchTraversal.clone() : null;
        return clone;
    }
}

