/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class PythonTranslator
implements Translator.ScriptTranslator {
    private static final Set<String> STEP_NAMES = Stream.of(GraphTraversal.class.getMethods()).filter(method -> Traversal.class.isAssignableFrom(method.getReturnType())).map(Method::getName).collect(Collectors.toSet());
    private final String traversalSource;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;

    private PythonTranslator(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        this.traversalSource = traversalSource;
        this.typeTranslator = typeTranslator;
    }

    public static PythonTranslator of(String traversalSource) {
        return PythonTranslator.of(traversalSource, false);
    }

    public static PythonTranslator of(String traversalSource, boolean withParameters) {
        return PythonTranslator.of(traversalSource, new DefaultTypeTranslator(withParameters));
    }

    public static PythonTranslator of(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        return new PythonTranslator(traversalSource, typeTranslator);
    }

    @Override
    public String getTraversalSource() {
        return this.traversalSource;
    }

    @Override
    public Script translate(Bytecode bytecode) {
        return (Script)this.typeTranslator.apply(this.traversalSource, bytecode);
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-python";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_PYTHON_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_PYTHON_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toPython(String symbol) {
            return TO_PYTHON_MAP.getOrDefault(symbol, symbol);
        }

        public static String toJava(String symbol) {
            return FROM_PYTHON_MAP.getOrDefault(symbol, symbol);
        }

        static {
            TO_PYTHON_MAP.put("global", "global_");
            TO_PYTHON_MAP.put("as", "as_");
            TO_PYTHON_MAP.put("in", "in_");
            TO_PYTHON_MAP.put("and", "and_");
            TO_PYTHON_MAP.put("or", "or_");
            TO_PYTHON_MAP.put("is", "is_");
            TO_PYTHON_MAP.put("not", "not_");
            TO_PYTHON_MAP.put("from", "from_");
            TO_PYTHON_MAP.put("list", "list_");
            TO_PYTHON_MAP.put("set", "set_");
            TO_PYTHON_MAP.put("all", "all_");
            TO_PYTHON_MAP.put("with", "with_");
            TO_PYTHON_MAP.put("range", "range_");
            TO_PYTHON_MAP.put("filter", "filter_");
            TO_PYTHON_MAP.put("id", "id_");
            TO_PYTHON_MAP.put("max", "max_");
            TO_PYTHON_MAP.put("min", "min_");
            TO_PYTHON_MAP.put("sum", "sum_");
            TO_PYTHON_MAP.forEach((k, v) -> FROM_PYTHON_MAP.put((String)v, (String)k));
        }
    }

    public static class NoSugarTranslator
    extends DefaultTypeTranslator {
        public NoSugarTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected Script produceScript(String traversalSource, Bytecode o) {
            this.script.append(traversalSource);
            for (Bytecode.Instruction instruction : o.getInstructions()) {
                boolean varargsBeware;
                String methodName = instruction.getOperator();
                Object[] arguments = instruction.getArguments();
                if (0 == arguments.length) {
                    this.script.append(".").append(this.resolveSymbol(methodName)).append("()");
                    continue;
                }
                this.script.append(".").append(this.resolveSymbol(methodName)).append("(");
                boolean bl = varargsBeware = instruction.getOperator().equals("withStrategies") || instruction.getOperator().equals("withoutStrategies");
                if (varargsBeware) {
                    this.script.append("*[");
                }
                Iterator itty = Stream.of(arguments).iterator();
                while (itty.hasNext()) {
                    this.convertToScript(itty.next());
                    if (!itty.hasNext()) continue;
                    this.script.append(",");
                }
                if (varargsBeware) {
                    this.script.append("]");
                }
                this.script.append(")");
            }
            return this.script;
        }
    }

    public static class DefaultTypeTranslator
    extends Translator.ScriptTranslator.AbstractTypeTranslator {
        public DefaultTypeTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected String getNullSyntax() {
            return "None";
        }

        @Override
        protected String getSyntax(String o) {
            return o.contains("'") || o.contains(System.lineSeparator()) ? "\"\"\"" + o + "\"\"\"" : "'" + o + "'";
        }

        @Override
        protected String getSyntax(Boolean o) {
            return o != false ? "True" : "False";
        }

        @Override
        protected String getSyntax(Date o) {
            return "datetime.datetime.utcfromtimestamp(" + o.getTime() + " / 1000.0)";
        }

        @Override
        protected String getSyntax(Timestamp o) {
            return "timestamp(" + o.getTime() + " / 1000.0)";
        }

        @Override
        protected String getSyntax(UUID o) {
            return "UUID('" + o.toString() + "')";
        }

        @Override
        protected String getSyntax(Lambda o) {
            String lambdaString = o.getLambdaScript().trim();
            return "lambda: \"" + StringEscapeUtils.escapeJava((String)lambdaString) + "\"";
        }

        @Override
        protected String getSyntax(Number o) {
            if (o instanceof Double || o instanceof Float || o instanceof BigDecimal) {
                return "float(" + o + ")";
            }
            if (o instanceof Byte) {
                return "SingleByte(" + o + ")";
            }
            return o.toString();
        }

        @Override
        protected String getSyntax(SackFunctions.Barrier o) {
            return "Barrier." + this.resolveSymbol(o.toString());
        }

        @Override
        protected String getSyntax(VertexProperty.Cardinality o) {
            return "Cardinality." + this.resolveSymbol(o.toString());
        }

        @Override
        protected String getSyntax(TraversalOptionParent.Pick o) {
            return "Pick." + this.resolveSymbol(o.toString());
        }

        @Override
        protected Script produceScript(Set<?> o) {
            Iterator<?> iterator = o.iterator();
            this.script.append("set(");
            while (iterator.hasNext()) {
                this.convertToScript(iterator.next());
                if (!iterator.hasNext()) continue;
                this.script.append(",");
            }
            return this.script.append(")");
        }

        @Override
        protected Script produceScript(List<?> o) {
            Iterator<?> iterator = o.iterator();
            this.script.append("[");
            while (iterator.hasNext()) {
                this.convertToScript(iterator.next());
                if (!iterator.hasNext()) continue;
                this.script.append(",");
            }
            return this.script.append("]");
        }

        @Override
        protected Script produceScript(Map<?, ?> o) {
            this.script.append("{");
            Iterator<Map.Entry<?, ?>> itty = o.entrySet().iterator();
            while (itty.hasNext()) {
                Map.Entry<?, ?> entry = itty.next();
                this.convertToScript(entry.getKey()).append(":");
                this.convertToScript(entry.getValue());
                if (!itty.hasNext()) continue;
                this.script.append(",");
            }
            return this.script.append("}");
        }

        @Override
        protected Script produceScript(Class<?> o) {
            return this.script.append("GremlinType(" + o.getCanonicalName() + ")");
        }

        @Override
        protected Script produceScript(Enum<?> o) {
            return this.script.append(o.getDeclaringClass().getSimpleName() + "." + this.resolveSymbol(o.toString()));
        }

        @Override
        protected Script produceScript(Vertex o) {
            this.script.append("Vertex(");
            this.convertToScript(o.id()).append(",");
            return this.convertToScript(o.label()).append(")");
        }

        @Override
        protected Script produceScript(Edge o) {
            this.script.append("Edge(");
            this.convertToScript(o.id()).append(",");
            this.convertToScript(o.outVertex()).append(",");
            this.convertToScript(o.label()).append(",");
            return this.convertToScript(o.inVertex()).append(")");
        }

        @Override
        protected Script produceScript(VertexProperty<?> o) {
            this.script.append("VertexProperty(");
            this.convertToScript(o.id()).append(",");
            this.convertToScript(o.label()).append(",");
            return this.convertToScript(o.value()).append(")");
        }

        @Override
        protected Script produceScript(TraversalStrategyProxy<?> o) {
            if (o.getConfiguration().isEmpty()) {
                return this.script.append("TraversalStrategy('" + o.getStrategyClass().getSimpleName() + "', None, '" + o.getStrategyClass().getName() + "')");
            }
            this.script.append("TraversalStrategy('").append(o.getStrategyClass().getSimpleName()).append("',");
            this.convertToScript(ConfigurationConverter.getMap((Configuration)o.getConfiguration()));
            this.script.append(", '");
            this.script.append(o.getStrategyClass().getName());
            return this.script.append("')");
        }

        @Override
        protected Script produceScript(String traversalSource, Bytecode o) {
            this.script.append(traversalSource);
            for (Bytecode.Instruction instruction : o.getInstructions()) {
                boolean varargsBeware;
                String methodName = instruction.getOperator();
                Object[] arguments = instruction.getArguments();
                if (0 == arguments.length) {
                    this.script.append(".").append(this.resolveSymbol(methodName)).append("()");
                    continue;
                }
                if (methodName.equals("range") && 2 == arguments.length) {
                    if (((Number)arguments[0]).longValue() + 1L == ((Number)arguments[1]).longValue()) {
                        this.script.append("[").append(arguments[0].toString()).append("]");
                        continue;
                    }
                    this.script.append("[").append(arguments[0].toString()).append(":").append(arguments[1].toString()).append("]");
                    continue;
                }
                if (methodName.equals("limit") && 1 == arguments.length) {
                    this.script.append("[0:").append(arguments[0].toString()).append("]");
                    continue;
                }
                if (methodName.equals("values") && 1 == arguments.length && this.script.getScript().length() > 3 && !STEP_NAMES.contains(arguments[0].toString())) {
                    this.script.append(".").append(arguments[0].toString());
                    continue;
                }
                this.script.append(".").append(this.resolveSymbol(methodName)).append("(");
                boolean bl = varargsBeware = instruction.getOperator().equals("withStrategies") || instruction.getOperator().equals("withoutStrategies");
                if (varargsBeware) {
                    this.script.append("*[");
                }
                Iterator itty = Stream.of(arguments).iterator();
                while (itty.hasNext()) {
                    this.convertToScript(itty.next());
                    if (!itty.hasNext()) continue;
                    this.script.append(",");
                }
                if (varargsBeware) {
                    this.script.append("]");
                }
                this.script.append(")");
            }
            return this.script;
        }

        @Override
        protected Script produceScript(P<?> p) {
            if (p instanceof TextP) {
                this.script.append("TextP.").append(this.resolveSymbol(p.getBiPredicate().toString())).append("(");
                this.convertToScript(p.getValue());
            } else if (p instanceof ConnectiveP) {
                List list = ((ConnectiveP)p).getPredicates();
                String connector = p instanceof OrP ? "or_" : "and_";
                for (int i = 0; i < list.size(); ++i) {
                    this.produceScript(list.get(i));
                    if (i > 0 && i < list.size() - 1) {
                        this.script.append(")");
                    }
                    if (i >= list.size() - 1) continue;
                    this.script.append(".").append(connector).append("(");
                }
            } else {
                this.script.append("P.").append(this.resolveSymbol(p.getBiPredicate().toString())).append("(");
                this.convertToScript(p.getValue());
            }
            this.script.append(")");
            return this.script;
        }

        protected String resolveSymbol(String methodName) {
            return SymbolHelper.toPython(methodName);
        }
    }
}

