/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.ComparatorHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Seedable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.ChainedComparator;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;

public final class OrderLocalStep<S, C extends Comparable>
extends ScalarMapStep<S, S>
implements ComparatorHolder<S, C>,
ByModulating,
TraversalParent,
Seedable {
    private List<Pair<Traversal.Admin<S, C>, Comparator<C>>> comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
    private ChainedComparator<S, C> chainedComparator = null;
    private final Random random = new Random();

    public OrderLocalStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    public void resetSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start;
        if (null == this.chainedComparator) {
            this.chainedComparator = new ChainedComparator<S, C>(false, this.comparators);
        }
        if ((start = traverser.get()) instanceof Collection) {
            return (S)this.sortCollection((Collection)start, this.chainedComparator);
        }
        if (start instanceof Map) {
            return (S)this.sortMap((Map)start, this.chainedComparator);
        }
        if (start != null && start.getClass().isArray()) {
            return (S)this.sortCollection(IteratorUtils.asList(start), this.chainedComparator);
        }
        return (S)start;
    }

    @Override
    public void addComparator(Traversal.Admin<S, C> traversal, Comparator<C> comparator) {
        this.comparators.add(new Pair(this.integrateChild(traversal), comparator));
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal) {
        this.addComparator(traversal, Order.asc);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal, Comparator comparator) {
        this.addComparator(traversal, comparator);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        int i = 0;
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> pair : this.comparators) {
            Traversal.Admin traversal = (Traversal.Admin)pair.getValue0();
            if (null != traversal && traversal.equals((Object)oldTraversal)) {
                this.comparators.set(i, Pair.with(this.integrateChild(newTraversal), (Object)((Comparator)pair.getValue1())));
                break;
            }
            ++i;
        }
    }

    @Override
    public List<Pair<Traversal.Admin<S, C>, Comparator<C>>> getComparators() {
        return this.comparators.isEmpty() ? Collections.singletonList(new Pair(new IdentityTraversal(), (Object)Order.asc)) : Collections.unmodifiableList(this.comparators);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.comparators);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (int i = 0; i < this.comparators.size(); ++i) {
            result ^= this.comparators.get(i).hashCode() * (i + 1);
        }
        return result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    public List<Traversal.Admin<S, C>> getLocalChildren() {
        return this.comparators.stream().map(Pair::getValue0).collect(Collectors.toList());
    }

    @Override
    public OrderLocalStep<S, C> clone() {
        OrderLocalStep clone = (OrderLocalStep)super.clone();
        clone.comparators = new ArrayList<Pair<Traversal.Admin<S, C>, Comparator<C>>>();
        for (Pair<Traversal.Admin<S, C>, Comparator<C>> comparator : this.comparators) {
            clone.comparators.add(new Pair(((Traversal.Admin)comparator.getValue0()).clone(), (Object)((Comparator)comparator.getValue1())));
        }
        clone.chainedComparator = null;
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.comparators.stream().map(Pair::getValue0).forEach(x$0 -> TraversalParent.super.integrateChild((Traversal.Admin<?, ?>)x$0));
    }

    private <A> List<A> sortCollection(Collection<A> collection, ChainedComparator comparator) {
        if (collection instanceof List) {
            if (comparator.isShuffle()) {
                Collections.shuffle((List)collection, this.random);
            } else {
                Collections.sort((List)collection, comparator);
            }
            return (List)collection;
        }
        return this.sortCollection(new ArrayList<A>(collection), comparator);
    }

    private <K, V> Map<K, V> sortMap(Map<K, V> map, ChainedComparator comparator) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        if (comparator.isShuffle()) {
            Collections.shuffle(entries, this.random);
        } else {
            Collections.sort(entries, comparator);
        }
        LinkedHashMap sortedMap = new LinkedHashMap();
        entries.forEach(entry -> sortedMap.put(entry.getKey(), entry.getValue()));
        return sortedMap;
    }
}

