/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.Grouping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CoalesceStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConstantStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ByModulatorOptimizationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;

public class ProductiveByStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    public static final String PRODUCTIVE_KEYS = "productiveKeys";
    private static final ProductiveByStrategy INSTANCE = new ProductiveByStrategy(Collections.emptyList());
    private final List<String> productiveKeys;
    private static final ConstantTraversal<?, ?> nullTraversal = new ConstantTraversal(null);
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(ByModulatorOptimizationStrategy.class));

    private ProductiveByStrategy(List<String> productiveKeys) {
        this.productiveKeys = productiveKeys;
    }

    public static ProductiveByStrategy create(Configuration configuration) {
        return new ProductiveByStrategy(new ArrayList<String>((Collection)configuration.getProperty(PRODUCTIVE_KEYS)));
    }

    public static ProductiveByStrategy instance() {
        return INSTANCE;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfAssignableClass(ByModulating.class, traversal).stream().filter(bm -> bm instanceof TraversalParent).forEach(bm -> {
            TraversalParent parentStep = (TraversalParent)((Object)bm);
            boolean parentStepIsGrouping = parentStep instanceof Grouping;
            for (Traversal.Admin<Object, Object> admin : parentStep.getLocalChildren()) {
                Traversal.Admin<Element, Property> propertyTraversal;
                if (parentStep instanceof PropertyMapStep && (propertyTraversal = ((PropertyMapStep)parentStep).getPropertyTraversal()) != null && propertyTraversal.equals(admin)) continue;
                if (!parentStepIsGrouping) {
                    if (admin instanceof ValueTraversal && this.hasKeyNotKnownAsProductive((ValueTraversal)admin)) {
                        this.wrapValueTraversalInCoalesce(parentStep, admin);
                        continue;
                    }
                    if (admin.getEndStep() instanceof ReducingBarrierStep) continue;
                    DefaultGraphTraversal extractedChildTraversal = new DefaultGraphTraversal();
                    TraversalHelper.removeToTraversal(admin.getStartStep(), EmptyStep.instance(), extractedChildTraversal);
                    admin.addStep(new CoalesceStep(admin, extractedChildTraversal, nullTraversal));
                    try {
                        parentStep.replaceLocalChild(admin, admin);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    continue;
                }
                if (!(admin instanceof ValueTraversal) || ((Grouping)((Object)parentStep)).getKeyTraversal() != admin || !this.hasKeyNotKnownAsProductive((ValueTraversal)admin) || this.containsValidByPass((ValueTraversal)admin)) continue;
                this.wrapValueTraversalInCoalesce(parentStep, admin);
            }
        });
    }

    private boolean containsValidByPass(ValueTraversal vt) {
        if (null == vt.getBypassTraversal()) {
            return false;
        }
        if (!(vt.getStartStep() instanceof CoalesceStep)) {
            return false;
        }
        CoalesceStep coalesceStep = (CoalesceStep)vt.getStartStep();
        List children = coalesceStep.getLocalChildren();
        Traversal lastChild = children.get(children.size() - 1);
        return lastChild == nullTraversal || lastChild instanceof ConstantTraversal && ((ConstantTraversal)lastChild).next() == null || lastChild.asAdmin().getEndStep() instanceof ConstantStep && ((ConstantStep)lastChild.asAdmin().getEndStep()).getConstant() == null;
    }

    private void wrapValueTraversalInCoalesce(TraversalParent parentStep, Traversal.Admin<Object, Object> child) {
        DefaultGraphTraversal temp = new DefaultGraphTraversal();
        temp.addStep(new CoalesceStep(temp, child.clone(), nullTraversal));
        temp.setParent(parentStep);
        ((ValueTraversal)child).setBypassTraversal(temp);
    }

    private boolean hasKeyNotKnownAsProductive(ValueTraversal child) {
        return this.productiveKeys.isEmpty() || child.getBypassTraversal() == null && !this.productiveKeys.contains(child.getPropertyKey());
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strategy", ProductiveByStrategy.class.getCanonicalName());
        map.put(PRODUCTIVE_KEYS, this.productiveKeys);
        return new MapConfiguration(map);
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private final ArrayList<String> productiveKeys = new ArrayList();

        private Builder() {
        }

        public Builder productiveKeys(String key, String ... rest) {
            this.productiveKeys.clear();
            this.productiveKeys.add(key);
            this.productiveKeys.addAll(Arrays.asList(rest));
            return this;
        }

        public Builder productiveKeys(Collection<String> keys) {
            this.productiveKeys.clear();
            this.productiveKeys.addAll(keys);
            return this;
        }

        public ProductiveByStrategy create() {
            return new ProductiveByStrategy(this.productiveKeys);
        }
    }
}

