/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class PropertyMapStep<K, E>
extends ScalarMapStep<Element, Map<K, E>>
implements TraversalParent,
ByModulating,
Configuring {
    protected final String[] propertyKeys;
    protected final PropertyType returnType;
    protected int tokens;
    protected Traversal.Admin<Element, ? extends Property> propertyTraversal;
    private Parameters parameters = new Parameters();
    private TraversalRing<K, E> traversalRing;

    public PropertyMapStep(Traversal.Admin traversal, PropertyType propertyType, String ... propertyKeys) {
        super(traversal);
        this.propertyKeys = propertyKeys;
        this.returnType = propertyType;
        this.propertyTraversal = null;
        this.traversalRing = new TraversalRing(new Traversal.Admin[0]);
    }

    public PropertyMapStep(Traversal.Admin traversal, int options, PropertyType propertyType, String ... propertyKeys) {
        this(traversal, propertyType, propertyKeys);
        this.configure(WithOptions.tokens, options);
    }

    @Override
    protected Map<K, E> map(Traverser.Admin<Element> traverser) {
        Iterator properties;
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Element element = (Element)traverser.get();
        boolean isVertex = element instanceof Vertex;
        if (this.returnType == PropertyType.VALUE) {
            if (this.includeToken(WithOptions.ids)) {
                map.put(T.id, element.id());
            }
            if (element instanceof VertexProperty) {
                if (this.includeToken(WithOptions.keys)) {
                    map.put(T.key, ((VertexProperty)element).key());
                }
                if (this.includeToken(WithOptions.values)) {
                    map.put(T.value, ((VertexProperty)element).value());
                }
            } else if (this.includeToken(WithOptions.labels)) {
                map.put(T.label, element.label());
            }
        }
        Iterator iterator = properties = null == this.propertyTraversal ? element.properties(this.propertyKeys) : TraversalUtil.applyAll(traverser, this.propertyTraversal);
        while (properties.hasNext()) {
            Property value;
            Property property = properties.next();
            Property property2 = value = this.returnType == PropertyType.VALUE ? property.value() : property;
            if (isVertex) {
                map.compute(property.key(), (k, v) -> {
                    List values = v != null ? (List)v : new ArrayList();
                    values.add(value);
                    return values;
                });
                continue;
            }
            map.put(property.key(), value);
        }
        if (!this.traversalRing.isEmpty()) {
            for (Object key : map.keySet()) {
                map.compute(key, (k, v) -> TraversalUtil.applyNullable(v, this.traversalRing.next()));
            }
            this.traversalRing.reset();
        }
        return map;
    }

    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0].equals(WithOptions.tokens)) {
            if (keyValues.length == 2 && keyValues[1] instanceof Boolean) {
                this.tokens = (Boolean)keyValues[1] != false ? WithOptions.all : WithOptions.none;
            } else {
                for (int i = 1; i < keyValues.length; ++i) {
                    if (!(keyValues[i] instanceof Integer)) {
                        throw new IllegalArgumentException("WithOptions.tokens requires Integer arguments (possible values are: WithOptions.[none|ids|labels|keys|values|all])");
                    }
                    this.tokens |= ((Integer)keyValues[i]).intValue();
                }
            }
        } else {
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    public List<Traversal.Admin<K, E>> getLocalChildren() {
        ArrayList<Traversal.Admin<Element, Property<Object>>> result = new ArrayList<Traversal.Admin<Element, Property<Object>>>();
        if (null != this.propertyTraversal) {
            result.add(this.propertyTraversal);
        }
        result.addAll(this.traversalRing.getTraversals());
        return Collections.unmodifiableList(result);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    public void setPropertyTraversal(Traversal.Admin<Element, ? extends Property> propertyTraversal) {
        this.propertyTraversal = this.integrateChild(propertyTraversal);
    }

    public PropertyType getReturnType() {
        return this.returnType;
    }

    public String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, Arrays.asList(this.propertyKeys), this.traversalRing, this.returnType.name().toLowerCase());
    }

    @Override
    public PropertyMapStep<K, E> clone() {
        PropertyMapStep clone = (PropertyMapStep)super.clone();
        if (null != this.propertyTraversal) {
            clone.propertyTraversal = this.propertyTraversal.clone();
        }
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.returnType.hashCode() ^ Integer.hashCode(this.tokens);
        if (null != this.propertyTraversal) {
            result ^= this.propertyTraversal.hashCode();
        }
        for (String propertyKey : this.propertyKeys) {
            result ^= Objects.hashCode(propertyKey);
        }
        return result ^ this.traversalRing.hashCode();
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (null != this.propertyTraversal) {
            this.integrateChild(this.propertyTraversal);
        }
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    public int getIncludedTokens() {
        return this.tokens;
    }

    private boolean includeToken(int token) {
        return 0 != (this.tokens & token);
    }
}

