/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.MatchPredicateStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ProductiveByStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class PathProcessorStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final PathProcessorStrategy INSTANCE = new PathProcessorStrategy();
    private static final boolean IS_TESTING = Boolean.valueOf(System.getProperty("is.testing", "false"));
    private static final String MARKER = Graph.Hidden.hide("gremlin.pathProcessor");
    private static final Set<Class> INVALIDATING_STEP_CLASSES = new HashSet<Class>(Arrays.asList(PathStep.class, TreeStep.class, LambdaHolder.class));

    private PathProcessorStrategy() {
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return Collections.singleton(MatchPredicateStrategy.class);
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPost() {
        return Collections.singleton(InlineFilterStrategy.class);
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if ((traversal.getParent() instanceof EmptyStep || traversal.getParent() instanceof VertexProgramStep) && TraversalHelper.hasStepOfAssignableClassRecursively(INVALIDATING_STEP_CLASSES, traversal)) {
            TraversalHelper.applyTraversalRecursively(t -> t.getStartStep().addLabel(MARKER), traversal);
        }
        if (traversal.getStartStep().getLabels().contains(MARKER)) {
            traversal.getStartStep().removeLabel(MARKER);
            return;
        }
        List<WhereTraversalStep> whereTraversalSteps = TraversalHelper.getStepsOfClass(WhereTraversalStep.class, traversal);
        for (WhereTraversalStep whereTraversalStep : whereTraversalSteps) {
            Traversal.Admin<?, ?> localChild = whereTraversalStep.getLocalChildren().get(0);
            if (!(localChild.getStartStep() instanceof WhereTraversalStep.WhereStartStep) || ((WhereTraversalStep.WhereStartStep)localChild.getStartStep()).getScopeKeys().isEmpty()) continue;
            boolean done = false;
            while (!done) {
                done = true;
                int index = TraversalHelper.stepIndex(whereTraversalStep, traversal);
                if (!(whereTraversalStep.getPreviousStep() instanceof SelectStep)) continue;
                done = false;
                traversal.removeStep(index);
                traversal.addStep(index - 1, whereTraversalStep);
            }
            WhereTraversalStep.WhereStartStep whereStartStep = (WhereTraversalStep.WhereStartStep)localChild.getStartStep();
            int index = TraversalHelper.stepIndex(whereTraversalStep, traversal);
            SelectOneStep selectOneStep = new SelectOneStep(traversal, Pop.last, whereStartStep.getScopeKeys().iterator().next());
            traversal.addStep(index, selectOneStep);
            String generatedLabel = PathProcessorStrategy.generateLabel();
            if (selectOneStep.getPreviousStep() instanceof EmptyStep) {
                TraversalHelper.insertBeforeStep(new IdentityStep(traversal), selectOneStep, traversal);
                ++index;
            }
            selectOneStep.getPreviousStep().addLabel(generatedLabel);
            TraversalHelper.insertAfterStep(new SelectOneStep(traversal, Pop.last, generatedLabel), whereTraversalStep, traversal);
            whereStartStep.removeScopeKey();
            if (localChild.getEndStep() instanceof WhereTraversalStep.WhereEndStep) continue;
            localChild.removeStep(localChild.getStartStep());
            traversal.addStep(index + 1, new TraversalFilterStep(traversal, localChild));
            traversal.removeStep(whereTraversalStep);
        }
        List<SelectStep> selectSteps = TraversalHelper.getStepsOfClass(SelectStep.class, traversal);
        for (SelectStep selectStep : selectSteps) {
            if (selectStep.getPop() == Pop.all || selectStep.getPop() == Pop.mixed || selectStep.getMaxRequirement().compareTo(PathProcessor.ElementRequirement.ID) <= 0) continue;
            boolean oneLabel = true;
            for (String key : selectStep.getScopeKeys()) {
                if (PathProcessorStrategy.labelCount(key, TraversalHelper.getRootTraversal(traversal)) <= 1) continue;
                oneLabel = false;
                break;
            }
            if (!oneLabel) continue;
            int index = TraversalHelper.stepIndex(selectStep, traversal);
            Map byTraversals = selectStep.getByTraversals();
            String[] keys = new String[byTraversals.size()];
            int counter = 0;
            for (Map.Entry entry : byTraversals.entrySet()) {
                SelectOneStep selectOneStep = new SelectOneStep(traversal, selectStep.getPop(), entry.getKey());
                TraversalMapStep mapStep = new TraversalMapStep(traversal, entry.getValue().clone());
                mapStep.addLabel(entry.getKey());
                traversal.addStep(index + 1, mapStep);
                traversal.addStep(index + 1, selectOneStep);
                keys[counter++] = entry.getKey();
            }
            traversal.addStep(index + 1 + byTraversals.size() * 2, new SelectStep(traversal, Pop.last, keys));
            traversal.removeStep(index);
        }
        if (!traversal.getStrategies().getStrategy(ProductiveByStrategy.class).isPresent()) {
            List<SelectOneStep> list = TraversalHelper.getStepsOfClass(SelectOneStep.class, traversal);
            for (SelectOneStep selectOneStep : list) {
                if (selectOneStep.getPop() == Pop.all || selectOneStep.getPop() == Pop.mixed || selectOneStep.getMaxRequirement().compareTo(PathProcessor.ElementRequirement.ID) <= 0 || PathProcessorStrategy.labelCount(selectOneStep.getScopeKeys().iterator().next(), TraversalHelper.getRootTraversal(traversal)) > 1) continue;
                int index = TraversalHelper.stepIndex(selectOneStep, traversal);
                Traversal.Admin localChild = selectOneStep.getLocalChildren().get(0);
                selectOneStep.removeLocalChild(localChild);
                TraversalMapStep mapStep = new TraversalMapStep(traversal, localChild.clone());
                traversal.addStep(index + 1, mapStep);
            }
        }
    }

    public static PathProcessorStrategy instance() {
        return INSTANCE;
    }

    private static String generateLabel() {
        return IS_TESTING ? "xyz" : UUID.randomUUID().toString();
    }

    private static int labelCount(String label, Traversal.Admin<?, ?> traversal) {
        int count = 0;
        for (Step step : traversal.getSteps()) {
            if (step.getLabels().contains(label)) {
                ++count;
            }
            if (!(step instanceof TraversalParent)) continue;
            count += ((TraversalParent)((Object)step)).getLocalChildren().stream().map(t -> PathProcessorStrategy.labelCount(label, t)).reduce(0, (a, b) -> a + b).intValue();
            count += ((TraversalParent)((Object)step)).getGlobalChildren().stream().map(t -> PathProcessorStrategy.labelCount(label, t)).reduce(0, (a, b) -> a + b).intValue();
        }
        return count;
    }
}

