/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class WhereTraversalStep<S>
extends FilterStep<S>
implements TraversalParent,
Scoping,
PathProcessor {
    protected Traversal.Admin<?, ?> whereTraversal;
    protected final Set<String> scopeKeys = new HashSet<String>();
    protected Set<String> keepLabels;

    public WhereTraversalStep(Traversal.Admin traversal, Traversal<?, ?> whereTraversal) {
        super(traversal);
        this.whereTraversal = whereTraversal.asAdmin();
        this.configureStartAndEndSteps(this.whereTraversal);
        if (this.scopeKeys.isEmpty()) {
            throw new IllegalArgumentException("A where()-traversal must have at least a start or end label (i.e. variable): " + whereTraversal);
        }
        this.whereTraversal = this.integrateChild(this.whereTraversal);
    }

    private void configureStartAndEndSteps(Traversal.Admin<?, ?> whereTraversal) {
        ConnectiveStrategy.instance().apply(whereTraversal);
        Step<?, ?> startStep = whereTraversal.getStartStep();
        if (startStep instanceof ConnectiveStep || startStep instanceof NotStep) {
            ((TraversalParent)((Object)startStep)).getLocalChildren().forEach(this::configureStartAndEndSteps);
        } else if (StartStep.isVariableStartStep(startStep)) {
            String label = startStep.getLabels().iterator().next();
            this.scopeKeys.add(label);
            TraversalHelper.replaceStep(startStep, new WhereStartStep(whereTraversal, label), whereTraversal);
        } else if (!whereTraversal.getEndStep().getLabels().isEmpty()) {
            TraversalHelper.insertBeforeStep(new WhereStartStep(whereTraversal, null), startStep, whereTraversal);
        }
        Step<?, ?> endStep = whereTraversal.getEndStep();
        if (!endStep.getLabels().isEmpty()) {
            if (endStep.getLabels().size() > 1) {
                throw new IllegalArgumentException("The end step of a where()-traversal can only have one label: " + endStep);
            }
            String label = endStep.getLabels().iterator().next();
            this.scopeKeys.add(label);
            endStep.removeLabel(label);
            whereTraversal.addStep(new WhereEndStep(whereTraversal, label));
        }
    }

    @Override
    public PathProcessor.ElementRequirement getMaxRequirement() {
        return TraversalHelper.getVariableLocations(this.whereTraversal).contains((Object)Scoping.Variable.START) ? PathProcessor.super.getMaxRequirement() : PathProcessor.ElementRequirement.ID;
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        return TraversalUtil.test(traverser, this.whereTraversal);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        return null == this.whereTraversal ? Collections.emptyList() : Collections.singletonList(this.whereTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.whereTraversal);
    }

    @Override
    public Set<String> getScopeKeys() {
        return Collections.unmodifiableSet(this.scopeKeys);
    }

    @Override
    public WhereTraversalStep<S> clone() {
        WhereTraversalStep clone = (WhereTraversalStep)super.clone();
        clone.whereTraversal = this.whereTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.whereTraversal);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.whereTraversal.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    public static class WhereEndStep
    extends FilterStep<Object>
    implements Scoping {
        private final String matchKey;
        private Object matchValue = null;

        public WhereEndStep(Traversal.Admin traversal, String matchKey) {
            super(traversal);
            this.matchKey = matchKey;
        }

        public void processStartTraverser(Traverser.Admin traverser) {
            if (null != this.matchKey) {
                this.matchValue = this.getSafeScopeValue(Pop.last, this.matchKey, traverser);
            }
        }

        @Override
        protected boolean filter(Traverser.Admin<Object> traverser) {
            return null == this.matchKey || traverser.get().equals(this.matchValue);
        }

        @Override
        public String toString() {
            return StringFactory.stepString(this, this.matchKey);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (null == this.matchKey ? "null".hashCode() : this.matchKey.hashCode());
        }

        @Override
        public Set<String> getScopeKeys() {
            return null == this.matchKey ? Collections.emptySet() : Collections.singleton(this.matchKey);
        }
    }

    public static class WhereStartStep<S>
    extends ScalarMapStep<S, Object>
    implements Scoping {
        private String selectKey;

        public WhereStartStep(Traversal.Admin traversal, String selectKey) {
            super(traversal);
            this.selectKey = selectKey;
        }

        @Override
        protected Object map(Traverser.Admin<S> traverser) {
            if (this.getTraversal().getEndStep() instanceof WhereEndStep) {
                ((WhereEndStep)this.getTraversal().getEndStep()).processStartTraverser(traverser);
            } else if (this.getTraversal().getEndStep() instanceof ProfileStep && this.getTraversal().getEndStep().getPreviousStep() instanceof WhereEndStep) {
                ((WhereEndStep)this.getTraversal().getEndStep().getPreviousStep()).processStartTraverser(traverser);
            }
            return null == this.selectKey ? traverser.get() : this.getSafeScopeValue(Pop.last, this.selectKey, traverser);
        }

        @Override
        public String toString() {
            return StringFactory.stepString(this, this.selectKey);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (null == this.selectKey ? "null".hashCode() : this.selectKey.hashCode());
        }

        public void removeScopeKey() {
            this.selectKey = null;
        }

        @Override
        public Set<String> getScopeKeys() {
            return null == this.selectKey ? Collections.emptySet() : Collections.singleton(this.selectKey);
        }
    }
}

