/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SelectOneStep<S, E>
extends MapStep<S, E>
implements TraversalParent,
Scoping,
PathProcessor,
ByModulating {
    private final Pop pop;
    private final String selectKey;
    private Traversal.Admin<S, E> selectTraversal = null;
    private Set<String> keepLabels;

    public SelectOneStep(Traversal.Admin traversal, Pop pop, String selectKey) {
        super(traversal);
        this.pop = pop;
        this.selectKey = selectKey;
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Object end = this.getNullableScopeValue(this.pop, this.selectKey, traverser);
        return null != end ? (E)TraversalUtil.applyNullable(end, this.selectTraversal) : null;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[]{this.pop, this.selectKey, this.selectTraversal});
    }

    @Override
    public SelectOneStep<S, E> clone() {
        SelectOneStep clone = (SelectOneStep)super.clone();
        if (null != this.selectTraversal) {
            clone.selectTraversal = this.selectTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.selectTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.selectKey.hashCode();
        if (null != this.selectTraversal) {
            result ^= this.selectTraversal.hashCode();
        }
        if (null != this.pop) {
            result ^= this.pop.hashCode();
        }
        return result;
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.selectTraversal ? Collections.emptyList() : Collections.singletonList(this.selectTraversal);
    }

    @Override
    public void removeLocalChild(Traversal.Admin<?, ?> traversal) {
        if (this.selectTraversal == traversal) {
            this.selectTraversal = null;
        }
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.selectTraversal = this.integrateChild(selectTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public Set<String> getScopeKeys() {
        return Collections.singleton(this.selectKey);
    }

    public Pop getPop() {
        return this.pop;
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        Traverser.Admin traverser = super.processNextStart();
        if (!(this.getTraversal().getParent() instanceof MatchStep)) {
            PathProcessor.processTraverserPathLabels(traverser, this.keepLabels);
        }
        return traverser;
    }
}

