/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPDC;
import org.apache.tika.metadata.XMPPDF;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFEncodedStringDecoder;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaIllustrator;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFUA;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFVT;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFX;
import org.apache.tika.parser.pdf.xmpschemas.XMPSchemaPDFXId;
import org.apache.tika.parser.xmp.JempboxExtractor;
import org.apache.tika.utils.StringUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PDMetadataExtractor {
    public static void extract(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            metadata.set(PDF.HAS_XMP, "false");
            return;
        }
        metadata.set(PDF.HAS_XMP, "true");
        Document dom = PDMetadataExtractor.loadDOM(pdMetadata, metadata, context);
        if (dom == null) {
            return;
        }
        XMPMetadata xmp = new XMPMetadata(dom);
        PDMetadataExtractor.extract(xmp, metadata, context);
    }

    public static void extract(XMPMetadata xmp, Metadata metadata, ParseContext context) {
        PDMetadataExtractor.extractBasic(xmp, metadata);
        PDMetadataExtractor.extractPDF(xmp, metadata);
        PDMetadataExtractor.extractDublinCore(xmp, metadata);
        JempboxExtractor.extractXMPMM(xmp, metadata);
        PDMetadataExtractor.extractPDFA(xmp, metadata);
        PDMetadataExtractor.extractPDFX(xmp, metadata);
        PDMetadataExtractor.extractPDFVT(xmp, metadata);
        PDMetadataExtractor.extractPDFUA(xmp, metadata);
        PDMetadataExtractor.extractIllustrator(xmp, metadata);
    }

    private static void extractIllustrator(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://ns.adobe.com/illustrator/1.0/", XMPSchemaIllustrator.class);
        XMPSchemaIllustrator schema = null;
        try {
            schema = (XMPSchemaIllustrator)xmp.getSchemaByClass(XMPSchemaIllustrator.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        String type = schema.getType();
        if (!StringUtils.isBlank((String)type)) {
            metadata.set(PDF.ILLUSTRATOR_TYPE, type);
        }
    }

    private static void extractDublinCore(XMPMetadata xmp, Metadata metadata) {
        XMPSchemaDublinCore dcSchema = null;
        try {
            dcSchema = xmp.getDublinCoreSchema();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dcSchema == null) {
            return;
        }
        PDMetadataExtractor.extractDublinCoreSimpleItem(metadata, dcSchema, TikaCoreProperties.IDENTIFIER.getName(), TikaCoreProperties.IDENTIFIER, XMPDC.IDENTIFIER);
        PDMetadataExtractor.extractDublinCoreSimpleItem(metadata, dcSchema, TikaCoreProperties.SOURCE.getName(), TikaCoreProperties.SOURCE, XMPDC.SOURCE);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.CONTRIBUTOR.getName(), TikaCoreProperties.CONTRIBUTOR, XMPDC.CONTRIBUTOR);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.CREATOR.getName(), TikaCoreProperties.CREATOR, XMPDC.CREATOR);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.LANGUAGE.getName(), TikaCoreProperties.LANGUAGE, XMPDC.LANGUAGE);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.PUBLISHER.getName(), TikaCoreProperties.PUBLISHER, XMPDC.PUBLISHER);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.RELATION.getName(), TikaCoreProperties.RELATION, XMPDC.RELATION);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.SUBJECT.getName(), TikaCoreProperties.SUBJECT, XMPDC.SUBJECT);
        PDMetadataExtractor.extractDublinCoreListItems(metadata, dcSchema, TikaCoreProperties.TYPE.getName(), TikaCoreProperties.TYPE, XMPDC.TYPE);
        PDMetadataExtractor.extractMultilingualItems(metadata, dcSchema, TikaCoreProperties.DESCRIPTION.getName(), TikaCoreProperties.DESCRIPTION, XMPDC.DESCRIPTION);
        PDMetadataExtractor.extractMultilingualItems(metadata, dcSchema, TikaCoreProperties.RIGHTS.getName(), TikaCoreProperties.RIGHTS, XMPDC.RIGHTS);
        PDMetadataExtractor.extractMultilingualItems(metadata, dcSchema, TikaCoreProperties.TITLE.getName(), TikaCoreProperties.TITLE, XMPDC.TITLE);
    }

    private static void extractPDFVT(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://www.npes.org/pdfvt/ns/id/", XMPSchemaPDFVT.class);
        XMPSchemaPDFVT schema = null;
        try {
            schema = (XMPSchemaPDFVT)xmp.getSchemaByClass(XMPSchemaPDFVT.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        String version = schema.getPDFVTVersion();
        if (!StringUtils.isBlank((String)version)) {
            metadata.set(PDF.PDFVT_VERSION, version);
        }
        try {
            Calendar modified = schema.getPDFVTModified();
            metadata.set(PDF.PDFVT_MODIFIED, modified);
        }
        catch (IOException ex) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, "bad date in vt modified");
        }
    }

    private static void extractPDFX(XMPMetadata xmp, Metadata metadata) {
        String version;
        xmp.addXMLNSMapping("http://www.npes.org/pdfx/ns/id/", XMPSchemaPDFXId.class);
        xmp.addXMLNSMapping("http://ns.adobe.com/pdfx/1.3/", XMPSchemaPDFX.class);
        try {
            XMPSchemaPDFXId XMPSchemaPDFXId2 = (XMPSchemaPDFXId)xmp.getSchemaByClass(XMPSchemaPDFXId.class);
            if (XMPSchemaPDFXId2 != null && !StringUtils.isBlank((String)(version = XMPSchemaPDFXId2.getPDFXVersion()))) {
                metadata.set(PDF.PDFXID_VERSION, version);
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        try {
            XMPSchemaPDFX XMPSchemaPDFX2 = (XMPSchemaPDFX)xmp.getSchemaByClass(XMPSchemaPDFX.class);
            if (XMPSchemaPDFX2 != null) {
                String conformance;
                version = XMPSchemaPDFX2.getPDFXVersion();
                if (!StringUtils.isBlank((String)version)) {
                    metadata.set(PDF.PDFX_VERSION, version);
                }
                if (!StringUtils.isBlank((String)(conformance = XMPSchemaPDFX2.getPDFXConformance()))) {
                    metadata.set(PDF.PDFX_CONFORMANCE, conformance);
                }
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
    }

    private static void extractPDFUA(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://www.aiim.org/pdfua/ns/id/", XMPSchemaPDFUA.class);
        XMPSchemaPDFUA schema = null;
        try {
            schema = (XMPSchemaPDFUA)xmp.getSchemaByClass(XMPSchemaPDFUA.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        try {
            Integer part = schema.getPart();
            if (schema.getPart() != null) {
                metadata.set(PDF.PDFUAID_PART, part.intValue());
            }
        }
        catch (NumberFormatException e) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, "expected integer part");
        }
    }

    private static void extractPDFA(XMPMetadata xmp, Metadata metadata) {
        xmp.addXMLNSMapping("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class);
        XMPSchemaPDFAId schema = null;
        try {
            schema = (XMPSchemaPDFAId)xmp.getSchemaByClass(XMPSchemaPDFAId.class);
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        if (schema == null) {
            return;
        }
        String partString = "UNKNOWN";
        try {
            Integer part = schema.getPart();
            if (part != null) {
                partString = Integer.toString(part);
                metadata.set(PDF.PDFAID_PART, part.intValue());
            }
        }
        catch (NumberFormatException e) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, "expected integer part");
        }
        if (schema.getConformance() != null) {
            metadata.set(PDF.PDFAID_CONFORMANCE, schema.getConformance());
            String version = "A-" + partString + schema.getConformance().toLowerCase(Locale.ROOT);
            metadata.set(PDF.PDFA_VERSION, version);
        }
    }

    private static void extractPDF(XMPMetadata xmp, Metadata metadata) {
        if (xmp == null) {
            return;
        }
        XMPSchemaPDF pdf = null;
        try {
            pdf = xmp.getPDFSchema();
        }
        catch (IOException e) {
            return;
        }
        if (pdf == null) {
            return;
        }
        PDMetadataExtractor.setNotNull(pdf.getProducer(), metadata, PDF.PRODUCER, XMPPDF.PRODUCER);
        PDMetadataExtractor.setNotNull(pdf.getKeywords(), metadata, Office.KEYWORDS, XMPPDF.KEY_WORDS);
        PDMetadataExtractor.setNotNull(pdf.getPDFVersion(), metadata, PDF.PDF_VERSION, XMPPDF.PDF_VERSION);
    }

    private static void extractBasic(XMPMetadata xmp, Metadata metadata) {
        List<String> advisories;
        if (xmp == null) {
            return;
        }
        XMPSchemaBasic basic = null;
        try {
            basic = xmp.getBasicSchema();
        }
        catch (IOException e) {
            return;
        }
        if (basic == null) {
            return;
        }
        PDMetadataExtractor.setNotNull(basic.getCreatorTool(), metadata, XMP.CREATOR_TOOL);
        PDMetadataExtractor.setNotNull(basic.getTitle(), metadata, DublinCore.TITLE, XMP.TITLE);
        PDMetadataExtractor.setNotNull(basic.getAbout(), metadata, XMP.ABOUT);
        PDMetadataExtractor.setNotNull(basic.getLabel(), metadata, XMP.LABEL);
        try {
            PDMetadataExtractor.setNotNull(XMP.CREATE_DATE, basic.getCreateDate(), metadata);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            PDMetadataExtractor.setNotNull(XMP.MODIFY_DATE, basic.getModifyDate(), metadata);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            PDMetadataExtractor.setNotNull(XMP.METADATA_DATE, basic.getMetadataDate(), metadata);
        }
        catch (IOException e) {
            // empty catch block
        }
        List<String> identifiers = basic.getIdentifiers();
        if (identifiers != null) {
            for (String identifier : identifiers) {
                metadata.add(XMP.IDENTIFIER, identifier);
            }
        }
        if ((advisories = basic.getAdvisories()) != null) {
            for (String advisory : advisories) {
                metadata.add(XMP.ADVISORY, advisory);
            }
        }
        PDMetadataExtractor.setNotNull(basic.getNickname(), metadata, XMP.NICKNAME);
        try {
            PDMetadataExtractor.setNotNull(XMP.RATING, basic.getRating(), metadata);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void setNotNull(String value, Metadata metadata, Property ... properties) {
        if (value == null || value.isBlank()) {
            return;
        }
        String decoded = PDMetadataExtractor.decode(value);
        for (Property property : properties) {
            metadata.set(property, decoded);
        }
    }

    private static void setNotNull(Property property, Calendar value, Metadata metadata) {
        if (metadata.get(property) == null && value != null) {
            metadata.set(property, value);
        }
    }

    private static void setNotNull(Property property, Integer value, Metadata metadata) {
        if (metadata.get(property) == null && value != null) {
            metadata.set(property, value.intValue());
        }
    }

    static void addNotNull(String value, Metadata metadata, Property ... properties) {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        for (Property property : properties) {
            metadata.add(property, value);
        }
    }

    static List<String> getXMPBagOrSeqList(XMPSchema schema, String name) {
        List<String> ret = schema.getBagList(name);
        if (ret == null) {
            ret = schema.getSequenceList(name);
        }
        return ret;
    }

    private static void extractMultilingualItems(Metadata metadata, XMPSchema schema, String dcName, Property ... properties) {
        for (Property property : properties) {
            for (String lang : schema.getLanguagePropertyLanguages(dcName)) {
                String value = schema.getLanguageProperty(dcName, lang);
                if (value == null || value.isBlank()) continue;
                PDMetadataExtractor.addMetadata(metadata, property, value);
            }
        }
    }

    private static void extractDublinCoreListItems(Metadata metadata, XMPSchemaDublinCore dc, String dcName, Property ... properties) {
        List<String> items = PDMetadataExtractor.getXMPBagOrSeqList(dc, dcName);
        if (items == null) {
            return;
        }
        for (Property property : properties) {
            for (String item : items) {
                PDMetadataExtractor.addMetadata(metadata, property, item);
            }
        }
    }

    private static void extractDublinCoreSimpleItem(Metadata metadata, XMPSchemaDublinCore dc, String dcName, Property ... properties) {
        String textProperty = dc.getTextProperty(dcName);
        for (Property property : properties) {
            PDMetadataExtractor.addMetadata(metadata, property, textProperty);
        }
    }

    static void addMetadata(Metadata metadata, Property property, String value) {
        if (value == null || value.isBlank()) {
            return;
        }
        String decoded = PDMetadataExtractor.decode(value);
        if (StringUtils.isBlank((String)decoded)) {
            return;
        }
        if (property.isMultiValuePermitted() || metadata.get(property) == null) {
            for (String v : metadata.getValues(property)) {
                if (!v.equals(decoded)) continue;
                return;
            }
            metadata.add(property, decoded);
        }
    }

    static void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            String decoded = PDMetadataExtractor.decode(value);
            if (StringUtils.isBlank((String)decoded)) {
                return;
            }
            for (String v : metadata.getValues(name)) {
                if (!v.equals(decoded)) continue;
                return;
            }
            metadata.add(name, decoded);
        }
    }

    static String decode(String value) {
        if (PDFEncodedStringDecoder.shouldDecode(value)) {
            PDFEncodedStringDecoder d = new PDFEncodedStringDecoder();
            return d.decode(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDOM(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            return null;
        }
        InputStream is = null;
        try {
            try {
                is = pdMetadata.exportXMPMetadata();
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
                Document document = null;
                IOUtils.closeQuietly(is);
                return document;
            }
            Document e = XMLReaderUtils.buildDOM((InputStream)is, (ParseContext)context);
            return e;
        }
        catch (IOException | TikaException | SAXException e) {
            EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)metadata);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    static void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value);
        }
    }

    static void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (COSBase cOSBase : ((COSArray)value).toList()) {
                PDMetadataExtractor.addMetadata(metadata, name, cOSBase);
            }
        } else if (value instanceof COSString) {
            PDMetadataExtractor.addMetadata(metadata, name, ((COSString)value).getString());
        } else if (value != null && !(value instanceof COSDictionary)) {
            PDMetadataExtractor.addMetadata(metadata, name, value.toString());
        }
    }
}

