/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.tika.parser.grib;

import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.io.InputStream;

import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;

/**
 * Test cases to exercise the {@link org.apache.tika.parser.grib.GribParser}.
 */

public class GribParserTest {

    @Test
    public void testParseGlobalMetadata() throws Exception {
        Parser parser = new GribParser();
        Metadata metadata = new Metadata();
        ContentHandler handler = new BodyContentHandler();
        try (InputStream stream = GribParser.class
                .getResourceAsStream("/test-documents/gdas1.forecmwf.2014062612.grib2")) {
            parser.parse(stream, handler, metadata, new ParseContext());
        }
        assertNotNull(metadata);
        String content = handler.toString();
        assertTrue(content.contains("dimensions:"));
        assertTrue(content.contains("variables:"));
    }
}
 
