/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.TransformationAccuracy;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.sql.util.SQLUtilities;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.AxisName;
import org.apache.sis.referencing.factory.sql.BursaWolfInfo;
import org.apache.sis.referencing.factory.sql.CloseableReference;
import org.apache.sis.referencing.factory.sql.CoordinateOperationSet;
import org.apache.sis.referencing.factory.sql.EPSGCodeFinder;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.referencing.factory.sql.SQLTranslator;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.referencing.internal.DeferredCoordinateOperation;
import org.apache.sis.referencing.internal.DeprecatedCode;
import org.apache.sis.referencing.internal.EPSGParameterDomain;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.ServicesForMetadata;
import org.apache.sis.referencing.internal.SignReversalComment;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;

public class EPSGDataAccess
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
Localized,
AutoCloseable {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.factory");
    static final VerticalDatumType VERTICAL_DATUM_TYPE = VerticalDatumType.GEOIDAL;
    private static final int[] EPSG_CODE_PARAMETERS = new int[]{1048, 1062};
    private static final Map<Integer, Integer> DEPRECATED_CS = EPSGDataAccess.deprecatedCS();
    private final NameSpace namespace;
    private String lastTableForName;
    private Calendar calendar;
    private DateFormat dateFormat;
    private final Map<String, PreparedStatement> statements = new HashMap<String, PreparedStatement>();
    private final Map<Class<?>, CloseableReference> authorityCodes = new HashMap();
    private final Map<Integer, AxisName> axisNames = new HashMap<Integer, AxisName>();
    private final Map<Integer, Boolean> isProjection = new HashMap<Integer, Boolean>();
    private final Map<String, NameSpace> namingSystems = new HashMap<String, NameSpace>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<Integer, Class<?>> safetyGuard = new HashMap();
    transient boolean quiet;
    private transient boolean replaceDeprecatedCS;
    protected final EPSGFactory owner;
    protected final Connection connection;
    protected final SQLTranslator translator;

    static Map<Integer, Integer> deprecatedCS() {
        int code;
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(24);
        Integer replacement = 6422;
        m.put(6402, replacement);
        for (code = 6405; code <= 6412; ++code) {
            m.put(code, replacement);
        }
        replacement = 6423;
        m.put(6401, replacement);
        for (code = 6413; code <= 6420; ++code) {
            m.put(code, replacement);
        }
        return m;
    }

    protected EPSGDataAccess(EPSGFactory owner, Connection connection, SQLTranslator translator) {
        ArgumentChecks.ensureNonNull("connection", connection);
        ArgumentChecks.ensureNonNull("translator", translator);
        this.owner = owner;
        this.connection = connection;
        this.translator = translator;
        this.namespace = owner.nameFactory.createNameSpace(owner.nameFactory.createLocalName(null, "IOGP"), null);
    }

    @Override
    public Locale getLocale() {
        return this.owner.getLocale();
    }

    private Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.CANADA);
        }
        this.calendar.clear();
        return this.calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Citation getAuthority() {
        DefaultCitation c;
        block27: {
            c = new DefaultCitation("EPSG Geodetic Parameter Dataset");
            c.setIdentifiers(Set.of(new ImmutableIdentifier(null, null, "EPSG")));
            try {
                String query = this.translator.apply("SELECT VERSION_NUMBER, VERSION_DATE FROM [Version History] ORDER BY VERSION_DATE DESC, VERSION_HISTORY_CODE DESC");
                String version = null;
                try (Statement stmt = this.connection.createStatement();
                     ResultSet result = stmt.executeQuery(query);){
                    while (result.next()) {
                        version = EPSGDataAccess.getOptionalString(result, 1);
                        java.sql.Date date = result.getDate(2);
                        if (version == null || date == null) continue;
                        c.setEdition(new SimpleInternationalString(version));
                        c.setEditionDate(date);
                        break;
                    }
                }
                DatabaseMetaData metadata = this.connection.getMetaData();
                int i = 0;
                while (true) {
                    OnLineFunction function;
                    String url;
                    InternationalString description = null;
                    switch (i) {
                        case 0: {
                            url = "https://epsg.org/";
                            function = OnLineFunction.SEARCH;
                            break;
                        }
                        case 1: {
                            url = "https://epsg.org/";
                            function = OnLineFunction.DOWNLOAD;
                            break;
                        }
                        case 2: {
                            url = SQLUtilities.getSimplifiedURL(metadata);
                            function = OnLineFunction.valueOf("CONNECTION");
                            description = Resources.formatInternational((short)18, "EPSG", version, metadata.getDatabaseProductName(), Version.valueOf(metadata.getDatabaseMajorVersion(), metadata.getDatabaseMinorVersion()));
                            break;
                        }
                        default: {
                            break block27;
                        }
                    }
                    DefaultOnlineResource r = new DefaultOnlineResource();
                    try {
                        r.setLinkage(new URI(url));
                    }
                    catch (URISyntaxException exception) {
                        Logging.recoverableException(LOGGER, EPSGDataAccess.class, "getAuthority", exception);
                    }
                    r.setFunction(function);
                    r.setDescription(description);
                    c.getOnlineResources().add(r);
                    ++i;
                }
            }
            catch (SQLException exception) {
                EPSGDataAccess.unexpectedException("getAuthority", exception);
            }
            finally {
                c.transitionTo(ModifiableMetadata.State.FINAL);
            }
        }
        return c;
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        try {
            if (this.connection.isClosed()) {
                throw new FactoryException(this.error().getString((short)194));
            }
            return this.getCodeMap(type).keySet();
        }
        catch (SQLException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
    }

    private synchronized Map<String, String> getCodeMap(Class<?> type) throws SQLException {
        AuthorityCodes existing;
        CloseableReference reference = this.authorityCodes.get(type);
        if (reference != null && (existing = (AuthorityCodes)reference.get()) != null) {
            return existing;
        }
        Map<String, String> result = Map.of();
        for (TableInfo table : TableInfo.EPSG) {
            if (!table.type.isAssignableFrom(type) && !type.isAssignableFrom(table.type)) continue;
            AuthorityCodes codes = new AuthorityCodes(this.connection, table, type, this);
            reference = this.authorityCodes.get(codes.type);
            if (reference != null) {
                AuthorityCodes existing2 = (AuthorityCodes)reference.get();
                if (existing2 != null) {
                    codes = existing2;
                } else {
                    reference = null;
                }
            }
            if (reference == null) {
                reference = codes.createReference();
                this.authorityCodes.put(codes.type, reference);
            }
            if (type != codes.type) {
                this.authorityCodes.put(type, reference);
            }
            if (result.isEmpty()) {
                result = codes;
                continue;
            }
            if (result instanceof AuthorityCodes) {
                result = new LinkedHashMap<String, String>(result);
            }
            result.putAll(codes);
        }
        return result;
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Set.of();
    }

    @Override
    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        try {
            for (TableInfo table : TableInfo.EPSG) {
                String text = this.getCodeMap(table.type).get(code);
                if (text == null) continue;
                return table.nameColumn != null ? new SimpleInternationalString(text) : null;
            }
        }
        catch (SQLException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
        catch (BackingStoreException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), exception.getCause());
        }
        throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
    }

    private boolean isPrimaryKey(String code) throws FactoryException {
        int i = code.length();
        if (i == 0) {
            return false;
        }
        do {
            char c;
            if ((c = code.charAt(--i)) >= '0' && c <= '9') continue;
            return false;
        } while (i != 0);
        return true;
    }

    private int[] toPrimaryKeys(String table, String codeColumn, String nameColumn, String ... codes) throws SQLException, FactoryException {
        int[] primaryKeys = new int[codes.length];
        block7: for (int i = 0; i < codes.length; ++i) {
            String code = codes[i];
            if (codeColumn != null && nameColumn != null && !this.isPrimaryKey(code)) {
                String pattern = EPSGDataAccess.toLikePattern(code);
                Integer resolved = null;
                boolean alias = false;
                do {
                    PreparedStatement stmt;
                    if (alias) {
                        stmt = this.prepareStatement("AliasKey", "SELECT OBJECT_CODE, ALIAS FROM [Alias] WHERE OBJECT_TABLE_NAME=? AND ALIAS LIKE ?");
                        stmt.setString(1, table);
                        stmt.setString(2, pattern);
                    } else {
                        String KEY = "PrimaryKey";
                        stmt = this.statements.get("PrimaryKey");
                        if (stmt != null && !table.equals(this.lastTableForName)) {
                            this.statements.remove("PrimaryKey");
                            stmt.close();
                            stmt = null;
                            this.lastTableForName = null;
                        }
                        if (stmt == null) {
                            stmt = this.connection.prepareStatement(this.translator.apply("SELECT " + codeColumn + ", " + nameColumn + " FROM [" + table + "] WHERE " + nameColumn + " LIKE ?"));
                            this.statements.put("PrimaryKey", stmt);
                            this.lastTableForName = table;
                        }
                        stmt.setString(1, pattern);
                    }
                    try (ResultSet result = stmt.executeQuery();){
                        while (result.next()) {
                            if (!SQLUtilities.filterFalsePositive(code, result.getString(2))) continue;
                            resolved = this.ensureSingleton((Object)EPSGDataAccess.getOptionalInteger(result, 1), (Object)resolved, (Comparable<?>)((Object)code));
                        }
                    }
                    if (resolved == null) continue;
                    primaryKeys[i] = resolved;
                    continue block7;
                } while (alias = !alias);
            }
            try {
                primaryKeys[i] = Integer.parseInt(code);
                continue;
            }
            catch (NumberFormatException e) {
                throw (NoSuchAuthorityCodeException)new NoSuchAuthorityCodeException(this.error().getString((short)53, "EPSG", code), "EPSG", code).initCause(e);
            }
        }
        return primaryKeys;
    }

    private ResultSet executeQuery(String table, String codeColumn, String nameColumn, String sql, String ... codes) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        assert (sql.contains("[" + table + "]")) : table;
        assert (codeColumn == null || sql.contains(codeColumn) || table.equals("Area")) : codeColumn;
        assert (nameColumn == null || sql.contains(nameColumn) || table.equals("Area")) : nameColumn;
        return this.executeQuery(table, sql, this.toPrimaryKeys(table, codeColumn, nameColumn, codes));
    }

    private ResultSet executeQuery(String table, String sql, int ... codes) throws SQLException {
        assert (Thread.holdsLock(this));
        assert (CharSequences.count((CharSequence)sql, '?') == codes.length);
        PreparedStatement stmt = this.prepareStatement(table, sql);
        assert (stmt.getParameterMetaData().getParameterCount() == codes.length);
        for (int i = 0; i < codes.length; ++i) {
            stmt.setInt(i + 1, codes[i]);
        }
        return stmt.executeQuery();
    }

    private ResultSet executeMetadataQuery(String key, String sql, String table, int code) throws SQLException {
        assert (Thread.holdsLock(this));
        assert (CharSequences.count((CharSequence)sql, '?') == 2);
        PreparedStatement stmt = this.prepareStatement(key, sql);
        assert (stmt.getParameterMetaData().getParameterCount() == 2);
        stmt.setString(1, table);
        stmt.setInt(2, code);
        return stmt.executeQuery();
    }

    private PreparedStatement prepareStatement(String table, String sql) throws SQLException {
        PreparedStatement stmt = this.statements.get(table);
        if (stmt == null) {
            stmt = this.connection.prepareStatement(this.translator.apply(sql));
            this.statements.put(table, stmt);
        }
        return stmt;
    }

    private static String getOptionalString(ResultSet result, int columnIndex) throws SQLException {
        String value = Strings.trimOrNull(result.getString(columnIndex));
        return value == null || result.wasNull() ? null : value;
    }

    private static double getOptionalDouble(ResultSet result, int columnIndex) throws SQLException {
        double value = result.getDouble(columnIndex);
        return result.wasNull() ? Double.NaN : value;
    }

    private static Integer getOptionalInteger(ResultSet result, int columnIndex) throws SQLException {
        int value = result.getInt(columnIndex);
        return result.wasNull() ? null : Integer.valueOf(value);
    }

    private boolean getOptionalBoolean(ResultSet result, int columnIndex) throws SQLException {
        return this.translator.useBoolean() ? result.getBoolean(columnIndex) : result.getInt(columnIndex) != 0;
    }

    private String nullValue(ResultSet result, int columnIndex, Comparable<?> code) throws SQLException {
        ResultSetMetaData metadata = result.getMetaData();
        String column = metadata.getColumnName(columnIndex);
        String table = metadata.getTableName(columnIndex);
        result.close();
        return this.error().getString((short)117, table, column, code);
    }

    private String getString(String code, ResultSet result, int columnIndex, int columnFault) throws SQLException, FactoryDataException {
        String value = Strings.trimOrNull(result.getString(columnIndex));
        if (value == null || result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnFault, (Comparable<?>)((Object)code)));
        }
        return value;
    }

    private String getString(Comparable<?> code, ResultSet result, int columnIndex) throws SQLException, FactoryDataException {
        String value = Strings.trimOrNull(result.getString(columnIndex));
        if (value == null || result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnIndex, code));
        }
        return value;
    }

    private double getDouble(Comparable<?> code, ResultSet result, int columnIndex) throws SQLException, FactoryDataException {
        double value = result.getDouble(columnIndex);
        if (Double.isNaN(value) || result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnIndex, code));
        }
        return value;
    }

    private Integer getInteger(Comparable<?> code, ResultSet result, int columnIndex) throws SQLException, FactoryDataException {
        int value = result.getInt(columnIndex);
        if (result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnIndex, code));
        }
        return value;
    }

    private <T> T ensureSingleton(T newValue, T oldValue, Comparable<?> code) throws FactoryDataException {
        if (oldValue == null) {
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return oldValue;
        }
        throw new FactoryDataException(this.error().getString((short)25, code));
    }

    private void ensureNoCycle(Class<?> type, Integer code) throws FactoryException {
        if (this.safetyGuard.putIfAbsent(code, type) != null) {
            throw new FactoryException(this.resources().getString((short)62, type, code));
        }
    }

    private void endOfRecursivity(Class<?> type, Integer code) throws FactoryException {
        if (this.safetyGuard.remove(code) != type) {
            throw new FactoryException(String.valueOf(code));
        }
    }

    private String getSupersession(String table, Integer code, Locale locale) throws SQLException {
        String reason = null;
        Object replacedBy = null;
        try (ResultSet result = this.executeMetadataQuery("Deprecation", "SELECT DEPRECATION_REASON, REPLACED_BY FROM [Deprecation] WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=?", table, code);){
            while (result.next()) {
                reason = EPSGDataAccess.getOptionalString(result, 1);
                replacedBy = EPSGDataAccess.getOptionalInteger(result, 2);
                if (replacedBy == null) continue;
                break;
            }
        }
        replacedBy = replacedBy == null ? "(" + Vocabulary.getResources(locale).getString((short)141).toLowerCase(locale) + ")" : replacedBy.toString();
        Object method = "create";
        for (TableInfo info : TableInfo.EPSG) {
            if (!TableInfo.tableMatches(info.table, table)) continue;
            method = (String)method + info.type.getSimpleName();
            break;
        }
        if (!this.quiet) {
            LogRecord record = Resources.forLocale(locale).getLogRecord(Level.WARNING, (short)15, "EPSG:" + code, replacedBy, reason);
            Logging.completeAndLog(LOGGER, EPSGDataAccess.class, (String)method, record);
        }
        return (String)replacedBy;
    }

    private Map<String, Object> createProperties(String table, String name, Integer code, CharSequence remarks, boolean deprecated) throws SQLException, FactoryDataException {
        String version;
        ArrayList<LocalName> aliases = new ArrayList<LocalName>();
        try (ResultSet result = this.executeMetadataQuery("Alias", "SELECT NAMING_SYSTEM_NAME, ALIAS FROM [Alias] INNER JOIN [Naming System] ON [Alias].NAMING_SYSTEM_CODE = [Naming System].NAMING_SYSTEM_CODE WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=?", table, code);){
            while (result.next()) {
                String naming = EPSGDataAccess.getOptionalString(result, 1);
                String alias = this.getString(code, result, 2);
                NameSpace ns = null;
                if (naming != null && (ns = this.namingSystems.get(naming)) == null) {
                    ns = this.owner.nameFactory.createNameSpace(this.owner.nameFactory.createLocalName(null, naming), null);
                    this.namingSystems.put(naming, ns);
                }
                if (CharSequences.toASCII(alias).toString().equals(name)) {
                    name = alias;
                    continue;
                }
                aliases.add(this.owner.nameFactory.createLocalName(ns, alias));
            }
        }
        this.properties.clear();
        GenericName gn = null;
        Locale locale = this.getLocale();
        Citation authority = this.owner.getAuthority();
        InternationalString edition = authority.getEdition();
        String string = version = edition != null ? edition.toString() : null;
        if (name != null) {
            gn = this.owner.nameFactory.createGenericName(this.namespace, "EPSG", name);
            this.properties.put("name", gn);
            this.properties.put("code", name);
            this.properties.put("version", version);
            this.properties.put("authority", authority);
            this.properties.put("locale", locale);
            NamedIdentifier id = new NamedIdentifier(this.properties);
            this.properties.clear();
            this.properties.put("name", id);
        }
        if (!aliases.isEmpty()) {
            this.properties.put("alias", aliases.toArray(GenericName[]::new));
        }
        if (code != null) {
            ImmutableIdentifier identifier;
            String codeString = code.toString();
            if (deprecated) {
                String replacedBy = this.getSupersession(table, code, locale);
                identifier = new DeprecatedCode(authority, "EPSG", codeString, version, Character.isDigit(replacedBy.charAt(0)) ? replacedBy : null, Vocabulary.formatInternational((short)190, (Object)replacedBy));
                this.properties.put("deprecated", Boolean.TRUE);
            } else {
                identifier = new ImmutableIdentifier(authority, "EPSG", codeString, version, gn != null ? gn.toInternationalString() : null);
            }
            this.properties.put("identifiers", identifier);
        }
        this.properties.put("remarks", remarks);
        this.properties.put("locale", locale);
        this.properties.put("mtFactory", this.owner.mtFactory);
        return this.properties;
    }

    private Map<String, Object> createProperties(String table, String name, Integer code, String domainCode, String scope, String remarks, boolean deprecated) throws SQLException, FactoryException {
        if ("?".equals(scope)) {
            scope = null;
        }
        Map<String, Object> properties = this.createProperties(table, name, code, remarks, deprecated);
        if (domainCode != null) {
            properties.put("domainOfValidity", this.owner.createExtent(domainCode));
        }
        properties.put("scope", scope);
        return properties;
    }

    private static String toLikePattern(String name) {
        StringBuilder buffer = new StringBuilder(name.length());
        SQLUtilities.toLikePattern(name, 0, name.length(), false, false, buffer);
        return buffer.toString();
    }

    @Override
    public synchronized IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        boolean isPrimaryKey = this.isPrimaryKey(code);
        StringBuilder query = new StringBuilder("SELECT ");
        int queryStart = query.length();
        int found = -1;
        try {
            int pk = isPrimaryKey ? this.toPrimaryKeys(null, null, null, code)[0] : 0;
            for (int i = 0; i < TableInfo.EPSG.length; ++i) {
                String column;
                TableInfo table = TableInfo.EPSG[i];
                String string = column = isPrimaryKey ? table.codeColumn : table.nameColumn;
                if (column == null) continue;
                query.setLength(queryStart);
                query.append(table.codeColumn);
                if (!isPrimaryKey) {
                    query.append(", ").append(column);
                }
                query.append(" FROM ").append(table.table).append(" WHERE ").append(column).append(isPrimaryKey ? " = ?" : " LIKE ?");
                try (PreparedStatement stmt = this.connection.prepareStatement(this.translator.apply(query.toString()));){
                    if (isPrimaryKey) {
                        stmt.setInt(1, pk);
                    } else {
                        stmt.setString(1, EPSGDataAccess.toLikePattern(code));
                    }
                    Integer present = null;
                    try (ResultSet result = stmt.executeQuery();){
                        while (result.next()) {
                            if (!isPrimaryKey && !SQLUtilities.filterFalsePositive(code, result.getString(2))) continue;
                            present = this.ensureSingleton((Object)EPSGDataAccess.getOptionalInteger(result, 1), (Object)present, (Comparable<?>)((Object)code));
                        }
                    }
                    if (present == null) continue;
                    if (found >= 0) {
                        throw new FactoryDataException(this.error().getString((short)25, code));
                    }
                    found = i;
                    continue;
                }
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(IdentifiedObject.class, (Comparable<?>)((Object)code), exception);
        }
        if (found >= 0) {
            switch (found) {
                case 0: {
                    return this.createCoordinateReferenceSystem(code);
                }
                case 1: {
                    return this.createCoordinateSystem(code);
                }
                case 2: {
                    return this.createCoordinateSystemAxis(code);
                }
                case 3: {
                    return this.createDatum(code);
                }
                case 4: {
                    return this.createEllipsoid(code);
                }
                case 5: {
                    return this.createPrimeMeridian(code);
                }
                case 6: {
                    return this.createCoordinateOperation(code);
                }
                case 7: {
                    return this.createOperationMethod(code);
                }
                case 8: {
                    return this.createParameterDescriptor(code);
                }
                case 9: {
                    break;
                }
                default: {
                    throw new AssertionError(found);
                }
            }
        }
        throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        returnValue = null;
        try {
            result = this.executeQuery("Coordinate Reference System", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, DEPRECATED, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?", new String[]{code});
            try {
                while (result.next()) {
                    epsg = this.getInteger((Comparable<?>)code, result, 1);
                    name = this.getString((Comparable<?>)code, result, 2);
                    area = EPSGDataAccess.getOptionalString(result, 3);
                    scope = EPSGDataAccess.getOptionalString(result, 4);
                    remarks = EPSGDataAccess.getOptionalString(result, 5);
                    deprecated = this.getOptionalBoolean(result, 6);
                    type = this.getString((Comparable<?>)code, result, 7);
                    crsFactory = this.owner.crsFactory;
                    var13_16 = type.toLowerCase(Locale.US);
                    var14_17 = -1;
                    switch (var13_16.hashCode()) {
                        case 393633979: {
                            if (!var13_16.equals("geographic 2d")) break;
                            var14_17 = 0;
                            break;
                        }
                        case 393634010: {
                            if (!var13_16.equals("geographic 3d")) break;
                            var14_17 = 1;
                            break;
                        }
                        case -894831240: {
                            if (!var13_16.equals("projected")) break;
                            var14_17 = 2;
                            break;
                        }
                        case -1984141450: {
                            if (!var13_16.equals("vertical")) break;
                            var14_17 = 3;
                            break;
                        }
                        case 3560141: {
                            if (!var13_16.equals("time")) break;
                            var14_17 = 4;
                            break;
                        }
                        case -1321441502: {
                            if (!var13_16.equals("temporal")) break;
                            var14_17 = 5;
                            break;
                        }
                        case -599340629: {
                            if (!var13_16.equals("compound")) break;
                            var14_17 = 6;
                            break;
                        }
                        case -86658573: {
                            if (!var13_16.equals("geocentric")) break;
                            var14_17 = 7;
                            break;
                        }
                        case 1706610451: {
                            if (!var13_16.equals("engineering")) break;
                            var14_17 = 8;
                            break;
                        }
                        case 458748304: {
                            if (!var13_16.equals("parametric")) break;
                            var14_17 = 9;
                            break;
                        }
                    }
                    switch (var14_17) {
                        case 0: 
                        case 1: {
                            csCode = this.getInteger((Comparable<?>)code, result, 8);
                            if (this.replaceDeprecatedCS) {
                                csCode = EPSGDataAccess.DEPRECATED_CS.getOrDefault(csCode, (Integer)csCode);
                            }
                            cs = this.owner.createEllipsoidalCS(csCode.toString());
                            datumCode = EPSGDataAccess.getOptionalString(result, 9);
                            if (datumCode == null) ** GOTO lbl68
                            datum = this.owner.createGeodeticDatum(datumCode);
                            ** GOTO lbl77
lbl68:
                            // 1 sources

                            geoCode = this.getString(code, result, 10, 9);
                            result.close();
                            this.ensureNoCycle(GeographicCRS.class, epsg);
                            try {
                                datum = this.owner.createGeographicCRS(geoCode).getDatum();
                            }
                            finally {
                                this.endOfRecursivity(GeographicCRS.class, epsg);
                            }
lbl77:
                            // 2 sources

                            crs /* !! */  = crsFactory.createGeographicCRS(this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated), datum, cs);
                            break;
                        }
                        case 2: {
                            csCode = this.getString((Comparable<?>)code, result, 8);
                            geoCode = this.getString((Comparable<?>)code, result, 10);
                            opCode = this.getString((Comparable<?>)code, result, 11);
                            result.close();
                            this.ensureNoCycle(ProjectedCRS.class, epsg);
                            cs = this.owner.createCartesianCS((String)csCode);
                            try {
                                op = (Conversion)this.owner.createCoordinateOperation(opCode);
                            }
                            catch (ClassCastException e) {
                                throw (NoSuchAuthorityCodeException)this.noSuchAuthorityCode(Projection.class, opCode).initCause(e);
                            }
                            if (deprecated) ** GOTO lbl96
                            baseCRS = this.owner.createCoordinateReferenceSystem(geoCode);
                            suspendParamChecks = true;
                            ** GOTO lbl107
lbl96:
                            // 1 sources

                            old = this.quiet;
                            try {
                                this.quiet = true;
                                this.replaceDeprecatedCS = true;
                                baseCRS = this.createCoordinateReferenceSystem(geoCode);
                            }
                            finally {
                                this.replaceDeprecatedCS = false;
                                this.quiet = old;
                            }
                            suspendParamChecks = Semaphores.queryAndSet(16);
lbl107:
                            // 2 sources

                            try {
                                properties = this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated);
                                if (baseCRS instanceof GeographicCRS) {
                                    crs /* !! */  = crsFactory.createProjectedCRS(properties, (GeographicCRS)baseCRS, op, cs);
                                    break;
                                }
                                crs /* !! */  = crsFactory.createDerivedCRS(properties, baseCRS, op, cs);
                                break;
                            }
                            finally {
                                Semaphores.clear(16, suspendParamChecks);
                            }
                        }
                        finally {
                            this.endOfRecursivity(ProjectedCRS.class, epsg);
                        }
                        case 3: {
                            cs = this.owner.createVerticalCS(this.getString((Comparable<?>)code, result, 8));
                            datum /* !! */  = this.owner.createVerticalDatum(this.getString((Comparable<?>)code, result, 9));
                            crs /* !! */  = crsFactory.createVerticalCRS(this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated), datum /* !! */ , (VerticalCS)cs);
                            break;
                        }
                        case 4: 
                        case 5: {
                            cs = this.owner.createTimeCS(this.getString((Comparable<?>)code, result, 8));
                            datum /* !! */  = this.owner.createTemporalDatum(this.getString((Comparable<?>)code, result, 9));
                            crs /* !! */  = crsFactory.createTemporalCRS(this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated), (TemporalDatum)datum /* !! */ , (TimeCS)cs);
                            break;
                        }
                        case 6: {
                            code1 = this.getString((Comparable<?>)code, result, 12);
                            code2 = this.getString((Comparable<?>)code, result, 13);
                            result.close();
                            this.ensureNoCycle(CompoundCRS.class, epsg);
                            try {
                                crs1 = this.owner.createCoordinateReferenceSystem(code1);
                                crs2 = this.owner.createCoordinateReferenceSystem(code2);
                            }
                            finally {
                                this.endOfRecursivity(CompoundCRS.class, epsg);
                            }
                            crs /* !! */  = crsFactory.createCompoundCRS(this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated), new CoordinateReferenceSystem[]{crs1, crs2});
                            break;
                        }
                        case 7: {
                            cs = this.owner.createCoordinateSystem(this.getString((Comparable<?>)code, result, 8));
                            datum /* !! */  = this.owner.createGeodeticDatum(this.getString((Comparable<?>)code, result, 9));
                            properties = this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated);
                            if (cs instanceof CartesianCS) {
                                crs /* !! */  = crsFactory.createGeocentricCRS(properties, (GeodeticDatum)datum /* !! */ , (CartesianCS)cs);
                                break;
                            }
                            if (cs instanceof SphericalCS == false) throw new FactoryDataException(this.error().getString((short)51, cs.getName()));
                            crs /* !! */  = crsFactory.createGeocentricCRS(properties, (GeodeticDatum)datum /* !! */ , (SphericalCS)cs);
                            break;
                        }
                        case 8: {
                            cs = this.owner.createCoordinateSystem(this.getString((Comparable<?>)code, result, 8));
                            datum /* !! */  = this.owner.createEngineeringDatum(this.getString((Comparable<?>)code, result, 9));
                            crs /* !! */  = crsFactory.createEngineeringCRS(this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated), (EngineeringDatum)datum /* !! */ , cs);
                            break;
                        }
                        case 9: {
                            cs = this.owner.createParametricCS(this.getString((Comparable<?>)code, result, 8));
                            datum /* !! */  = this.owner.createParametricDatum(this.getString((Comparable<?>)code, result, 9));
                            crs /* !! */  = ServicesForMetadata.createParametricCRS(this.createProperties("Coordinate Reference System", name, epsg, area, scope, remarks, deprecated), datum /* !! */ , cs, crsFactory);
                            break;
                        }
                        default: {
                            throw new FactoryDataException(this.error().getString((short)149, type));
                        }
                    }
                    returnValue = this.ensureSingleton((T)crs /* !! */ , (T)returnValue, (Comparable<?>)code);
                    if (!result.isClosed()) continue;
                    var13_16 = returnValue;
                    return var13_16;
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateReferenceSystem.class, (Comparable<?>)code, exception);
        }
        if (returnValue != null) return returnValue;
        throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
    }

    @Override
    public synchronized Datum createDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        Datum returnValue = null;
        try (ResultSet result = this.executeQuery("Datum", "DATUM_CODE", "DATUM_NAME", "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, REALIZATION_EPOCH, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, DEPRECATED, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE FROM [Datum] WHERE DATUM_CODE = ?", code);){
            while (result.next()) {
                Datum datum;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String type = this.getString((Comparable<?>)((Object)code), result, 3);
                String anchor = EPSGDataAccess.getOptionalString(result, 4);
                String epoch = EPSGDataAccess.getOptionalString(result, 5);
                String area = EPSGDataAccess.getOptionalString(result, 6);
                String scope = EPSGDataAccess.getOptionalString(result, 7);
                String remarks = EPSGDataAccess.getOptionalString(result, 8);
                boolean deprecated = this.getOptionalBoolean(result, 9);
                Map<String, Object> properties = this.createProperties("Datum", name, epsg, area, scope, remarks, deprecated);
                if (anchor != null) {
                    properties.put("anchorPoint", anchor);
                }
                if (epoch != null) {
                    try {
                        CharSequence[] fields = CharSequences.split(epoch, '-');
                        int year = 0;
                        int month = 0;
                        int day = 1;
                        int i = Math.min(fields.length, 3);
                        while (--i >= 0) {
                            int f = Integer.parseInt(fields[i].toString());
                            switch (i) {
                                case 0: {
                                    year = f;
                                    break;
                                }
                                case 1: {
                                    month = f - 1;
                                    break;
                                }
                                case 2: {
                                    day = f;
                                }
                            }
                        }
                        if (year != 0) {
                            Calendar calendar = this.getCalendar();
                            calendar.set(year, month, day);
                            properties.put("realizationEpoch", calendar.getTime());
                        }
                    }
                    catch (NumberFormatException exception) {
                        EPSGDataAccess.unexpectedException("createDatum", exception);
                    }
                }
                DatumFactory datumFactory = this.owner.datumFactory;
                switch (type.toLowerCase(Locale.US)) {
                    case "geodetic": {
                        properties = new HashMap<String, Object>(properties);
                        Ellipsoid ellipsoid = this.owner.createEllipsoid(this.getString((Comparable<?>)((Object)code), result, 10));
                        PrimeMeridian meridian = this.owner.createPrimeMeridian(this.getString((Comparable<?>)((Object)code), result, 11));
                        BursaWolfParameters[] param = this.createBursaWolfParameters(meridian, epsg);
                        if (param != null) {
                            properties.put("bursaWolf", param);
                        }
                        datum = datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
                        break;
                    }
                    case "vertical": {
                        datum = datumFactory.createVerticalDatum(properties, VERTICAL_DATUM_TYPE);
                        break;
                    }
                    case "temporal": {
                        Date originDate;
                        if (anchor == null || anchor.isEmpty()) {
                            throw new FactoryDataException(this.resources().getString((short)14));
                        }
                        if (this.dateFormat == null) {
                            this.dateFormat = new StandardDateFormat();
                            this.dateFormat.setCalendar(this.getCalendar());
                        }
                        try {
                            originDate = this.dateFormat.parse(anchor);
                        }
                        catch (ParseException e) {
                            throw new FactoryDataException(this.resources().getString((short)14), e);
                        }
                        datum = datumFactory.createTemporalDatum(properties, originDate);
                        break;
                    }
                    case "engineering": {
                        datum = datumFactory.createEngineeringDatum(properties);
                        break;
                    }
                    case "parametric": {
                        datum = ServicesForMetadata.createParametricDatum(properties, datumFactory);
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)149, type));
                    }
                }
                returnValue = this.ensureSingleton((Object)datum, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Datum.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Datum.class, code);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BursaWolfParameters[] createBursaWolfParameters(PrimeMeridian meridian, Integer code) throws SQLException, FactoryException {
        if (code == 6326) {
            return null;
        }
        ArrayList<BursaWolfInfo> bwInfos = new ArrayList<BursaWolfInfo>();
        try (ResultSet result = this.executeQuery("BursaWolfParametersSet", "SELECT COORD_OP_CODE, COORD_OP_METHOD_CODE, TARGET_CRS_CODE, AREA_OF_USE_CODE FROM [Coordinate_Operation] WHERE DEPRECATED=0 AND TARGET_CRS_CODE = 4326 AND COORD_OP_METHOD_CODE >= 9603 AND COORD_OP_METHOD_CODE <= 9607 AND SOURCE_CRS_CODE IN (SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE DATUM_CODE = ?) ORDER BY TARGET_CRS_CODE, COORD_OP_ACCURACY, COORD_OP_CODE DESC", code);){
            while (result.next()) {
                BursaWolfInfo info = new BursaWolfInfo(this.getInteger(code, result, 1), this.getInteger(code, result, 2), this.getInteger(code, result, 3), this.getInteger(code, result, 4));
                if (info.target == code) continue;
                bwInfos.add(info);
            }
        }
        int size = bwInfos.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            Object[] codes = bwInfos.toArray(new BursaWolfInfo[size]);
            this.sort("Coordinate_Operation", codes);
            bwInfos.clear();
            BursaWolfInfo.filter(this.owner, (BursaWolfInfo[])codes, bwInfos);
            size = bwInfos.size();
        }
        BursaWolfParameters[] parameters = new BursaWolfParameters[size];
        Locale locale = this.getLocale();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            GeodeticDatum datum;
            BursaWolfInfo info = (BursaWolfInfo)bwInfos.get(i);
            this.ensureNoCycle(BursaWolfParameters.class, code);
            try {
                datum = this.owner.createGeodeticDatum(String.valueOf(info.target));
            }
            finally {
                this.endOfRecursivity(BursaWolfParameters.class, code);
            }
            if (!Utilities.equalsIgnoreMetadata(meridian, datum.getPrimeMeridian())) continue;
            BursaWolfParameters bwp = new BursaWolfParameters(datum, info.getDomainOfValidity(this.owner));
            try (ResultSet result = this.executeQuery("BursaWolfParameters", "SELECT PARAMETER_CODE, PARAMETER_VALUE, UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE COORD_OP_CODE = ? AND COORD_OP_METHOD_CODE = ?", info.operation, info.method);){
                while (result.next()) {
                    BursaWolfInfo.setBursaWolfParameter(bwp, this.getInteger(Integer.valueOf(info.operation), result, 1), this.getDouble(Integer.valueOf(info.operation), result, 2), this.owner.createUnit(this.getString(Integer.valueOf(info.operation), result, 3)), locale);
                }
            }
            if (info.isFrameRotation()) {
                bwp.reverseRotation();
            }
            parameters[count++] = bwp;
        }
        return ArraysExt.resize(parameters, count);
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        Ellipsoid returnValue = null;
        try (ResultSet result = this.executeQuery("Ellipsoid", "ELLIPSOID_CODE", "ELLIPSOID_NAME", "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS, DEPRECATED FROM [Ellipsoid] WHERE ELLIPSOID_CODE = ?", code);){
            while (result.next()) {
                Ellipsoid ellipsoid;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                double semiMajorAxis = this.getDouble((Comparable<?>)((Object)code), result, 3);
                double inverseFlattening = EPSGDataAccess.getOptionalDouble(result, 4);
                double semiMinorAxis = EPSGDataAccess.getOptionalDouble(result, 5);
                String unitCode = this.getString((Comparable<?>)((Object)code), result, 6);
                String remarks = EPSGDataAccess.getOptionalString(result, 7);
                boolean deprecated = this.getOptionalBoolean(result, 8);
                Unit<Length> unit = this.owner.createUnit(unitCode).asType(Length.class);
                Map<String, Object> properties = this.createProperties("Ellipsoid", name, epsg, remarks, deprecated);
                if (Double.isNaN(inverseFlattening)) {
                    if (Double.isNaN(semiMinorAxis)) {
                        String column = result.getMetaData().getColumnName(3);
                        throw new FactoryDataException(this.error().getString((short)117, code, column));
                    }
                    ellipsoid = this.owner.datumFactory.createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
                } else {
                    if (!Double.isNaN(semiMinorAxis)) {
                        LogRecord record = this.resources().getLogRecord(Level.WARNING, (short)1, "EPSG:" + code);
                        Logging.completeAndLog(LOGGER, EPSGDataAccess.class, "createEllipsoid", record);
                    }
                    ellipsoid = this.owner.datumFactory.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
                }
                returnValue = this.ensureSingleton((Object)ellipsoid, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Ellipsoid.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        PrimeMeridian returnValue = null;
        try (ResultSet result = this.executeQuery("Prime Meridian", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME", "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS, DEPRECATED FROM [Prime Meridian] WHERE PRIME_MERIDIAN_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                double longitude = this.getDouble((Comparable<?>)((Object)code), result, 3);
                String unitCode = this.getString((Comparable<?>)((Object)code), result, 4);
                String remarks = EPSGDataAccess.getOptionalString(result, 5);
                boolean deprecated = this.getOptionalBoolean(result, 6);
                Unit<Angle> unit = this.owner.createUnit(unitCode).asType(Angle.class);
                PrimeMeridian primeMeridian = this.owner.datumFactory.createPrimeMeridian(this.createProperties("Prime Meridian", name, epsg, remarks, deprecated), longitude, unit);
                returnValue = this.ensureSingleton((Object)primeMeridian, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(PrimeMeridian.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Extent createExtent(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        Extent returnValue = null;
        try (ResultSet result = this.executeQuery("Area", "AREA_CODE", "AREA_NAME", "SELECT AREA_OF_USE, AREA_SOUTH_BOUND_LAT, AREA_NORTH_BOUND_LAT, AREA_WEST_BOUND_LON, AREA_EAST_BOUND_LON FROM [Area] WHERE AREA_CODE = ?", code);){
            while (result.next()) {
                String description = EPSGDataAccess.getOptionalString(result, 1);
                double ymin = EPSGDataAccess.getOptionalDouble(result, 2);
                double ymax = EPSGDataAccess.getOptionalDouble(result, 3);
                double xmin = EPSGDataAccess.getOptionalDouble(result, 4);
                double xmax = EPSGDataAccess.getOptionalDouble(result, 5);
                DefaultGeographicBoundingBox bbox = null;
                if (!(Double.isNaN(ymin) && Double.isNaN(ymax) && Double.isNaN(xmin) && Double.isNaN(xmax))) {
                    if (ymin > ymax) {
                        double t = ymin;
                        ymin = ymax;
                        ymax = t;
                    }
                    bbox = new DefaultGeographicBoundingBox(xmin, xmax, ymin, ymax);
                }
                if (description == null && bbox == null) continue;
                DefaultExtent extent = new DefaultExtent(description, bbox, null, null);
                extent.transitionTo(ModifiableMetadata.State.FINAL);
                returnValue = this.ensureSingleton((Object)extent, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Extent.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Extent.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        CoordinateSystem returnValue = null;
        try (ResultSet result = this.executeQuery("Coordinate System", "COORD_SYS_CODE", "COORD_SYS_NAME", "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS, DEPRECATED FROM [Coordinate System] WHERE COORD_SYS_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String type = this.getString((Comparable<?>)((Object)code), result, 3);
                int dimension = this.getInteger((Comparable<?>)((Object)code), result, 4);
                String remarks = EPSGDataAccess.getOptionalString(result, 5);
                boolean deprecated = this.getOptionalBoolean(result, 6);
                CoordinateSystemAxis[] axes = this.createCoordinateSystemAxes(epsg, dimension);
                Map<String, Object> properties = this.createProperties("Coordinate System", name, epsg, remarks, deprecated);
                CSFactory csFactory = this.owner.csFactory;
                CoordinateSystem cs = null;
                switch (type.toLowerCase(Locale.US)) {
                    case "ellipsoidal": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createEllipsoidalCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createEllipsoidalCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "cartesian": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createCartesianCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createCartesianCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "spherical": {
                        switch (dimension) {
                            case 2: {
                                if (!(csFactory instanceof GeodeticObjectFactory)) break;
                                cs = ((GeodeticObjectFactory)csFactory).createSphericalCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createSphericalCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "vertical": 
                    case "gravity-related": {
                        switch (dimension) {
                            case 1: {
                                cs = csFactory.createVerticalCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "time": 
                    case "temporal": {
                        switch (dimension) {
                            case 1: {
                                cs = csFactory.createTimeCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "parametric": {
                        switch (dimension) {
                            case 1: {
                                cs = ServicesForMetadata.createParametricCS(properties, axes[0], csFactory);
                            }
                        }
                        break;
                    }
                    case "linear": {
                        switch (dimension) {
                            case 1: {
                                cs = csFactory.createLinearCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "polar": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createPolarCS(properties, axes[0], axes[1]);
                            }
                        }
                        break;
                    }
                    case "cylindrical": {
                        switch (dimension) {
                            case 3: {
                                cs = csFactory.createCylindricalCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "affine": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createAffineCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createAffineCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)149, type));
                    }
                }
                if (cs == null) {
                    throw new FactoryDataException(this.resources().getString((short)64, type));
                }
                returnValue = this.ensureSingleton((Object)cs, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateSystem.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code);
        }
        return returnValue;
    }

    private CoordinateSystemAxis[] createCoordinateSystemAxes(Integer cs, int dimension) throws SQLException, FactoryException {
        int i = 0;
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[dimension];
        try (ResultSet result = this.executeQuery("AxisOrder", "SELECT COORD_AXIS_CODE FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ? ORDER BY [ORDER]", cs);){
            while (result.next()) {
                String axis = this.getString(cs, result, 1);
                if (i < axes.length) {
                    axes[i] = this.owner.createCoordinateSystemAxis(axis);
                }
                ++i;
            }
        }
        if (i != axes.length) {
            throw new FactoryDataException(this.error().getString((short)80, axes.length, i));
        }
        return axes;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        CoordinateSystemAxis returnValue = null;
        try (ResultSet result = this.executeQuery("Coordinate Axis", "COORD_AXIS_CODE", null, "SELECT COORD_AXIS_CODE, COORD_AXIS_NAME_CODE, COORD_AXIS_ORIENTATION, COORD_AXIS_ABBREVIATION, UOM_CODE FROM [Coordinate Axis] WHERE COORD_AXIS_CODE = ?", code);){
            while (result.next()) {
                AxisDirection direction;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                Integer nameCode = this.getInteger((Comparable<?>)((Object)code), result, 2);
                String orientation = this.getString((Comparable<?>)((Object)code), result, 3);
                String abbreviation = this.getString((Comparable<?>)((Object)code), result, 4);
                String unit = this.getString((Comparable<?>)((Object)code), result, 5);
                try {
                    direction = CoordinateSystems.parseAxisDirection(orientation);
                }
                catch (IllegalArgumentException exception) {
                    throw new FactoryDataException(exception.getLocalizedMessage(), exception);
                }
                AxisName an = this.getAxisName(nameCode);
                CoordinateSystemAxis axis = this.owner.csFactory.createCoordinateSystemAxis(this.createProperties("Coordinate Axis", an.name, epsg, an.description, false), abbreviation, direction, this.owner.createUnit(unit));
                returnValue = this.ensureSingleton((Object)axis, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateSystemAxis.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code);
        }
        return returnValue;
    }

    private AxisName getAxisName(Integer code) throws FactoryException, SQLException {
        assert (Thread.holdsLock(this));
        AxisName returnValue = this.axisNames.get(code);
        if (returnValue == null) {
            try (ResultSet result = this.executeQuery("Coordinate Axis Name", "SELECT COORD_AXIS_NAME, DESCRIPTION, REMARKS FROM [Coordinate Axis Name] WHERE COORD_AXIS_NAME_CODE = ?", code);){
                while (result.next()) {
                    String name = this.getString(code, result, 1);
                    Object description = EPSGDataAccess.getOptionalString(result, 2);
                    String remarks = EPSGDataAccess.getOptionalString(result, 3);
                    if (description == null) {
                        description = remarks;
                    } else if (remarks != null) {
                        description = (String)description + System.lineSeparator() + remarks;
                    }
                    AxisName axis = new AxisName(name, (String)description);
                    returnValue = this.ensureSingleton(axis, returnValue, code);
                }
            }
            if (returnValue == null) {
                throw this.noSuchAuthorityCode(AxisName.class, String.valueOf(code));
            }
            this.axisNames.put(code, returnValue);
        }
        return returnValue;
    }

    @Override
    public synchronized Unit<?> createUnit(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        Unit returnValue = null;
        try (ResultSet result = this.executeQuery("Unit of Measure", "UOM_CODE", "UNIT_OF_MEAS_NAME", "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE, UNIT_OF_MEAS_NAME FROM [Unit of Measure] WHERE UOM_CODE = ?", code);){
            while (result.next()) {
                Unit<?> unit;
                int source = this.getInteger((Comparable<?>)((Object)code), result, 1);
                double b = EPSGDataAccess.getOptionalDouble(result, 2);
                double c = EPSGDataAccess.getOptionalDouble(result, 3);
                int target = this.getInteger((Comparable<?>)((Object)code), result, 4);
                if (source == target) {
                    boolean pb;
                    boolean bl = pb = b != 1.0;
                    if (pb || c != 1.0) {
                        throw new FactoryDataException(this.error().getString((short)67, pb ? "FACTOR_B" : "FACTOR_C", pb ? b : c));
                    }
                }
                if ((unit = Units.valueOfEPSG(source)) == null) {
                    Unit<?> base = Units.valueOfEPSG(target);
                    if (base != null && !Double.isNaN(b) && !Double.isNaN(c)) {
                        unit = Units.multiply(base, b, c);
                    } else {
                        try {
                            unit = Units.valueOf(this.getString((Comparable<?>)((Object)code), result, 5));
                        }
                        catch (MeasurementParseException e) {
                            throw new FactoryDataException(this.error().getString((short)150, code), e);
                        }
                    }
                }
                returnValue = this.ensureSingleton((Object)unit, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Unit.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Unit.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized ParameterDescriptor<?> createParameterDescriptor(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        ParameterDescriptor returnValue = null;
        try (ResultSet result = this.executeQuery("Coordinate_Operation Parameter", "PARAMETER_CODE", "PARAMETER_NAME", "SELECT PARAMETER_CODE, PARAMETER_NAME, DESCRIPTION, DEPRECATED FROM [Coordinate_Operation Parameter] WHERE PARAMETER_CODE = ?", code);){
            while (result.next()) {
                NumberRange valueDomain;
                Set<Unit<?>> units;
                Class type;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String description = EPSGDataAccess.getOptionalString(result, 3);
                boolean deprecated = this.getOptionalBoolean(result, 4);
                if (epsg != null && Arrays.binarySearch(EPSG_CODE_PARAMETERS, epsg) >= 0) {
                    type = Integer.class;
                    units = Set.of();
                } else {
                    type = Double.class;
                    try (ResultSet r = this.executeQuery("ParameterType", "SELECT PARAM_VALUE_FILE_REF FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) AND PARAM_VALUE_FILE_REF IS NOT NULL", epsg);){
                        while (r.next()) {
                            String element = EPSGDataAccess.getOptionalString(r, 1);
                            if (element == null || element.isEmpty()) continue;
                            type = String.class;
                            break;
                        }
                    }
                    units = new LinkedHashSet();
                    r = this.executeQuery("ParameterUnit", "SELECT UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) GROUP BY UOM_CODE ORDER BY COUNT(UOM_CODE) DESC", epsg);
                    try {
                        block28: while (r.next()) {
                            String c = EPSGDataAccess.getOptionalString(r, 1);
                            if (c == null) continue;
                            Unit<?> candidate = this.owner.createUnit(c);
                            for (Unit<?> e : units) {
                                if (!candidate.isCompatible(e)) continue;
                                continue block28;
                            }
                            units.add(candidate);
                        }
                    }
                    finally {
                        if (r != null) {
                            r.close();
                        }
                    }
                }
                SignReversalComment isReversible = null;
                try (ResultSet r = this.executeQuery("ParameterSign", "SELECT DISTINCT PARAM_SIGN_REVERSAL FROM [Coordinate_Operation Parameter Usage] WHERE (PARAMETER_CODE = ?)", epsg);){
                    if (r.next()) {
                        Boolean b;
                        if (this.translator.useBoolean()) {
                            b = r.getBoolean(1);
                            if (r.wasNull()) {
                                b = null;
                            }
                        } else {
                            b = SQLUtilities.parseBoolean(r.getString(1));
                        }
                        if (b != null) {
                            isReversible = b != false ? SignReversalComment.OPPOSITE : SignReversalComment.SAME;
                        }
                    }
                }
                switch (units.size()) {
                    case 0: {
                        valueDomain = null;
                        break;
                    }
                    default: {
                        valueDomain = new EPSGParameterDomain(units);
                        break;
                    }
                    case 1: {
                        valueDomain = MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, CollectionsExt.first(units));
                    }
                }
                Map<String, Object> properties = this.createProperties("Coordinate_Operation Parameter", name, epsg, isReversible, deprecated);
                properties.put("description", description);
                DefaultParameterDescriptor<Object> descriptor = new DefaultParameterDescriptor<Object>(properties, 1, 1, type, valueDomain, null, null);
                returnValue = this.ensureSingleton((Object)descriptor, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    private ParameterDescriptor<?>[] createParameterDescriptors(Integer method) throws FactoryException, SQLException {
        ArrayList descriptors = new ArrayList();
        try (ResultSet result = this.executeQuery("Coordinate_Operation Parameter Usage", "SELECT PARAMETER_CODE FROM [Coordinate_Operation Parameter Usage] WHERE COORD_OP_METHOD_CODE = ? ORDER BY SORT_ORDER", method);){
            while (result.next()) {
                descriptors.add(this.owner.createParameterDescriptor(this.getString(method, result, 1)));
            }
        }
        return (ParameterDescriptor[])descriptors.toArray(ParameterDescriptor[]::new);
    }

    /*
     * Exception decompiling
     */
    private void fillParameterValues(Integer method, Integer operation, ParameterValueGroup parameters) throws FactoryException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP], 2[TRYBLOCK]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        OperationMethod returnValue = null;
        try (ResultSet result = this.executeQuery("Coordinate_Operation Method", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME", "SELECT COORD_OP_METHOD_CODE, COORD_OP_METHOD_NAME, REMARKS, DEPRECATED FROM [Coordinate_Operation Method] WHERE COORD_OP_METHOD_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String remarks = EPSGDataAccess.getOptionalString(result, 3);
                boolean deprecated = this.getOptionalBoolean(result, 4);
                GeneralParameterDescriptor[] descriptors = this.createParameterDescriptors(epsg);
                Map<String, Object> properties = this.createProperties("Coordinate_Operation Method", name, epsg, remarks, deprecated);
                DefaultOperationMethod method = new DefaultOperationMethod(properties, new DefaultParameterDescriptorGroup(properties, 1, 1, descriptors));
                returnValue = this.ensureSingleton((Object)method, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        CoordinateOperation returnValue = null;
        try (ResultSet result = this.executeQuery("Coordinate_Operation", "COORD_OP_CODE", "COORD_OP_NAME", "SELECT COORD_OP_CODE, COORD_OP_NAME, COORD_OP_TYPE, SOURCE_CRS_CODE, TARGET_CRS_CODE, COORD_OP_METHOD_CODE, COORD_TFM_VERSION, COORD_OP_ACCURACY, AREA_OF_USE_CODE, COORD_OP_SCOPE, REMARKS, DEPRECATED FROM [Coordinate_Operation] WHERE COORD_OP_CODE = ?", code);){
            while (result.next()) {
                CoordinateOperation operation;
                String targetCode;
                String sourceCode;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String type = this.getString((Comparable<?>)((Object)code), result, 3).toLowerCase(Locale.US);
                boolean isTransformation = type.equals("transformation");
                boolean isConversion = type.equals("conversion");
                boolean isConcatenated = type.equals("concatenated operation");
                if (isConversion) {
                    sourceCode = EPSGDataAccess.getOptionalString(result, 4);
                    targetCode = EPSGDataAccess.getOptionalString(result, 5);
                } else {
                    sourceCode = this.getString((Comparable<?>)((Object)code), result, 4);
                    targetCode = this.getString((Comparable<?>)((Object)code), result, 5);
                }
                Integer methodCode = isConcatenated ? EPSGDataAccess.getOptionalInteger(result, 6) : this.getInteger((Comparable<?>)((Object)code), result, 6);
                String version = EPSGDataAccess.getOptionalString(result, 7);
                double accuracy = EPSGDataAccess.getOptionalDouble(result, 8);
                String area = EPSGDataAccess.getOptionalString(result, 9);
                String scope = EPSGDataAccess.getOptionalString(result, 10);
                String remarks = EPSGDataAccess.getOptionalString(result, 11);
                boolean deprecated = this.getOptionalBoolean(result, 12);
                CoordinateReferenceSystem sourceCRS = sourceCode != null ? this.owner.createCoordinateReferenceSystem(sourceCode) : null;
                CoordinateReferenceSystem targetCRS = targetCode != null ? this.owner.createCoordinateReferenceSystem(targetCode) : null;
                boolean isDeferred = Semaphores.query(2);
                ParameterValueGroup parameters = null;
                OperationMethod method = null;
                if (methodCode != null && !isDeferred) {
                    method = this.owner.createOperationMethod(methodCode.toString());
                    parameters = method.getParameters().createValue();
                    this.fillParameterValues(methodCode, epsg, parameters);
                }
                Map<String, Object> opProperties = this.createProperties("Coordinate_Operation", name, epsg, area, scope, remarks, deprecated);
                opProperties.put("operationVersion", version);
                if (!Double.isNaN(accuracy)) {
                    opProperties.put("coordinateOperationAccuracy", TransformationAccuracy.create(accuracy));
                }
                CoordinateOperationFactory copFactory = this.owner.copFactory;
                if (isDeferred) {
                    operation = new DeferredCoordinateOperation(opProperties, sourceCRS, targetCRS, this.owner);
                } else if (isConversion && (sourceCRS == null || targetCRS == null)) {
                    operation = copFactory.createDefiningConversion(opProperties, method, parameters);
                } else {
                    Class<? extends SingleOperation> s;
                    if (isConcatenated) {
                        result.close();
                        opProperties = new HashMap<String, Object>(opProperties);
                        ArrayList<String> codes = new ArrayList<String>();
                        try (ResultSet cr = this.executeQuery("Coordinate_Operation Path", "SELECT SINGLE_OPERATION_CODE FROM [Coordinate_Operation Path] WHERE (CONCAT_OPERATION_CODE = ?) ORDER BY OP_PATH_STEP", epsg);){
                            while (cr.next()) {
                                codes.add(this.getString((Comparable<?>)((Object)code), cr, 1));
                            }
                        }
                        CoordinateOperation[] operations = new CoordinateOperation[codes.size()];
                        this.ensureNoCycle(CoordinateOperation.class, epsg);
                        try {
                            for (int i = 0; i < operations.length; ++i) {
                                operations[i] = this.owner.createCoordinateOperation((String)codes.get(i));
                            }
                        }
                        finally {
                            this.endOfRecursivity(CoordinateOperation.class, epsg);
                        }
                        CoordinateOperation i = copFactory.createConcatenatedOperation(opProperties, operations);
                        return i;
                    }
                    opProperties = new HashMap<String, Object>(opProperties);
                    MathTransformFactory mtFactory = this.owner.mtFactory;
                    MathTransform mt = ReferencingUtilities.createBaseToDerived(mtFactory, sourceCRS, parameters, targetCRS);
                    Class opType = isTransformation ? Transformation.class : (isConversion ? Conversion.class : SingleOperation.class);
                    OperationMethod provider = mtFactory.getLastMethodUsed();
                    if (provider instanceof DefaultOperationMethod && (s = ((DefaultOperationMethod)provider).getOperationType()) != null && opType.isAssignableFrom(s)) {
                        opType = s.asSubclass(SingleOperation.class);
                    }
                    opProperties.put("operationType", opType);
                    opProperties.put("parameters", parameters);
                    if (!(copFactory instanceof DefaultCoordinateOperationFactory)) {
                        throw new UnsupportedOperationException(this.error().getString((short)160, copFactory.getClass()));
                    }
                    operation = ((DefaultCoordinateOperationFactory)copFactory).createSingleOperation(opProperties, sourceCRS, targetCRS, null, method, mt);
                }
                returnValue = this.ensureSingleton((Object)operation, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                CoordinateOperation coordinateOperation = returnValue;
                return coordinateOperation;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateOperation.class, (Comparable<?>)((Object)code), exception);
        }
        if (returnValue != null) return returnValue;
        throw this.noSuchAuthorityCode(CoordinateOperation.class, code);
    }

    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        String label = sourceCRS + " \u21e8 " + targetCRS;
        CoordinateOperationSet set = new CoordinateOperationSet(this.owner);
        try {
            int[] pair = this.toPrimaryKeys(null, null, null, sourceCRS, targetCRS);
            boolean searchTransformations = false;
            do {
                String sql;
                String key;
                if (searchTransformations) {
                    key = "TransformationFromCRS";
                    sql = "SELECT COORD_OP_CODE FROM [Coordinate_Operation] AS CO JOIN [Area] ON AREA_OF_USE_CODE = AREA_CODE WHERE CO.DEPRECATED=0 AND SOURCE_CRS_CODE = ? AND TARGET_CRS_CODE = ? ORDER BY COORD_OP_ACCURACY ASC NULLS LAST,  (AREA_EAST_BOUND_LON - AREA_WEST_BOUND_LON + CASE WHEN AREA_EAST_BOUND_LON < AREA_WEST_BOUND_LON THEN 360 ELSE 0 END) * (AREA_NORTH_BOUND_LAT - AREA_SOUTH_BOUND_LAT) * COS(RADIANS(AREA_NORTH_BOUND_LAT + AREA_SOUTH_BOUND_LAT)/2) DESC";
                } else {
                    key = "ConversionFromCRS";
                    sql = "SELECT PROJECTION_CONV_CODE FROM [Coordinate Reference System] WHERE SOURCE_GEOGCRS_CODE = ? AND COORD_REF_SYS_CODE = ?";
                }
                Integer targetKey = searchTransformations ? null : Integer.valueOf(pair[1]);
                try (ResultSet result = this.executeQuery(key, sql, pair);){
                    while (result.next()) {
                        set.addAuthorityCode(this.getString((Comparable<?>)((Object)label), result, 1), targetKey);
                    }
                }
            } while (searchTransformations = !searchTransformations);
            Object[] codes = set.getAuthorityCodes();
            if (codes.length > 1 && this.sort("Coordinate_Operation", codes)) {
                set.setAuthorityCodes((String[])codes);
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateOperation.class, (Comparable<?>)((Object)label), exception);
        }
        if (!Semaphores.query(2)) {
            set.resolve(1);
        }
        return set;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        try {
            if (this.connection.isClosed()) {
                throw new FactoryException(this.error().getString((short)194));
            }
            return new EPSGCodeFinder(this);
        }
        catch (SQLException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
    }

    final boolean isProjection(Integer code) throws SQLException {
        Boolean projection = this.isProjection.get(code);
        if (projection == null) {
            try (ResultSet result = this.executeQuery("isProjection", "SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE PROJECTION_CONV_CODE = ? AND CAST(COORD_REF_SYS_KIND AS VARCHAR(80)) LIKE 'projected%'", code);){
                projection = result.next();
            }
            this.isProjection.put(code, projection);
        }
        return projection;
    }

    final synchronized boolean sort(String table, Object[] codes) throws SQLException, FactoryException {
        int iteration = 0;
        do {
            boolean changed = false;
            for (int i = 0; i < codes.length; ++i) {
                int code;
                try {
                    code = Integer.parseInt(codes[i].toString());
                }
                catch (NumberFormatException e) {
                    EPSGDataAccess.unexpectedException("sort", e);
                    continue;
                }
                try (ResultSet result = this.executeMetadataQuery("Supersession", "SELECT SUPERSEDED_BY FROM [Supersession] WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=? ORDER BY SUPERSESSION_YEAR DESC", table, code);){
                    while (result.next()) {
                        String replacement = result.getString(1);
                        if (replacement == null) continue;
                        for (int j = i + 1; j < codes.length; ++j) {
                            Object candidate = codes[j];
                            if (!replacement.equals(candidate.toString())) continue;
                            System.arraycopy(codes, i, codes, i + 1, j - i);
                            codes[i++] = candidate;
                            changed = true;
                        }
                    }
                    continue;
                }
            }
            if (changed) continue;
            return iteration != 0;
        } while (++iteration < 18);
        return true;
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> type, String code) {
        return new NoSuchAuthorityCodeException(this.resources().getString((short)49, "EPSG", type, code), "EPSG", code, code);
    }

    final FactoryException databaseFailure(Class<?> type, Comparable<?> code, SQLException cause) {
        return new FactoryException(this.error().getString((short)21, type, code), cause);
    }

    private Errors error() {
        return Errors.getResources(this.getLocale());
    }

    private Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    private static void unexpectedException(String method, Exception exception) {
        Logging.unexpectedException(LOGGER, EPSGDataAccess.class, method, exception);
    }

    final synchronized boolean canClose() {
        boolean can = true;
        if (!this.authorityCodes.isEmpty()) {
            System.gc();
            Iterator<CloseableReference> it = this.authorityCodes.values().iterator();
            while (it.hasNext()) {
                AuthorityCodes codes = (AuthorityCodes)it.next().get();
                if (codes == null) {
                    it.remove();
                    continue;
                }
                can = false;
            }
        }
        return can;
    }

    @Override
    public synchronized void close() throws FactoryException {
        SQLException exception = null;
        Iterator<PreparedStatement> ip = this.statements.values().iterator();
        while (ip.hasNext()) {
            try {
                ip.next().close();
            }
            catch (SQLException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            ip.remove();
        }
        Iterator<CloseableReference> it = this.authorityCodes.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (SQLException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            it.remove();
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            if (exception == null) {
                exception = e;
            }
            e.addSuppressed(exception);
        }
        if (exception != null) {
            throw new FactoryException(exception);
        }
    }
}

